/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import parquet.io.api.Converter;
import parquet.schema.GroupType;
import parquet.schema.Type;

public class HiveCollectionConverter
extends HiveGroupConverter {
    private final GroupType collectionType;
    private final ConverterParent parent;
    private final int index;
    private final Converter innerConverter;
    private final List<Writable> list = new ArrayList<Writable>();

    public static HiveGroupConverter forMap(GroupType mapType, ConverterParent parent, int index) {
        return new HiveCollectionConverter(mapType, parent, index, true);
    }

    public static HiveGroupConverter forList(GroupType listType, ConverterParent parent, int index) {
        return new HiveCollectionConverter(listType, parent, index, false);
    }

    private HiveCollectionConverter(GroupType collectionType, ConverterParent parent, int index, boolean isMap) {
        this.setMetadata(parent.getMetadata());
        this.collectionType = collectionType;
        this.parent = parent;
        this.index = index;
        Type repeatedType = collectionType.getType(0);
        this.innerConverter = isMap ? new KeyValueConverter(repeatedType.asGroupType(), this) : (HiveCollectionConverter.isElementType(repeatedType, collectionType.getName()) ? HiveCollectionConverter.getConverterFromDescription(repeatedType, 0, (ConverterParent)this) : new ElementConverter(repeatedType.asGroupType(), this));
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        Preconditions.checkArgument(fieldIndex == 0, "Invalid field index: " + fieldIndex);
        return this.innerConverter;
    }

    @Override
    public void start() {
        this.list.clear();
    }

    @Override
    public void end() {
        this.parent.set(this.index, (Writable)HiveCollectionConverter.wrapList(new ArrayWritable(Writable.class, this.list.toArray(new Writable[this.list.size()]))));
    }

    @Override
    public void set(int index, Writable value) {
        this.list.add(value);
    }

    private static boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() != 1) {
            return true;
        }
        if (repeatedType.getName().equals("array")) {
            return true;
        }
        return repeatedType.getName().equals(parentName + "_tuple");
    }

    private static class ElementConverter
    extends HiveGroupConverter {
        private final HiveGroupConverter parent;
        private final Converter elementConverter;
        private Writable element = null;

        public ElementConverter(GroupType repeatedType, HiveGroupConverter parent) {
            this.setMetadata(parent.getMetadata());
            this.parent = parent;
            this.elementConverter = ElementConverter.getConverterFromDescription(repeatedType.getType(0), 0, (ConverterParent)this);
        }

        @Override
        public void set(int index, Writable value) {
            this.element = value;
        }

        @Override
        public Converter getConverter(int i) {
            return this.elementConverter;
        }

        @Override
        public void start() {
            this.element = null;
        }

        @Override
        public void end() {
            this.parent.set(0, this.element);
        }
    }

    private static class KeyValueConverter
    extends HiveGroupConverter {
        private final HiveGroupConverter parent;
        private final Converter keyConverter;
        private final Converter valueConverter;
        private Writable[] keyValue = null;

        public KeyValueConverter(GroupType keyValueType, HiveGroupConverter parent) {
            this.setMetadata(parent.getMetadata());
            this.parent = parent;
            this.keyConverter = KeyValueConverter.getConverterFromDescription(keyValueType.getType(0), 0, (ConverterParent)this);
            this.valueConverter = KeyValueConverter.getConverterFromDescription(keyValueType.getType(1), 1, (ConverterParent)this);
        }

        @Override
        public void set(int fieldIndex, Writable value) {
            this.keyValue[fieldIndex] = value;
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            switch (fieldIndex) {
                case 0: {
                    return this.keyConverter;
                }
                case 1: {
                    return this.valueConverter;
                }
            }
            throw new IllegalArgumentException("Invalid field index for map key-value: " + fieldIndex);
        }

        @Override
        public void start() {
            this.keyValue = new Writable[2];
        }

        @Override
        public void end() {
            this.parent.set(0, (Writable)new ArrayWritable(Writable.class, this.keyValue));
        }
    }
}

