/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColMultiplyDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColMultiplyDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarMultiplyDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColMultiplyDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColMultiplyDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColMultiplyLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColMultiplyLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarMultiplyDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarMultiplyLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColMultiplyDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColMultiplyDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColMultiplyLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColMultiplyLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarMultiplyDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarMultiplyLongColumn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="*", value="a _FUNC_ b - Multiplies a by b")
@VectorizedExpressions(value={LongColMultiplyLongColumn.class, LongColMultiplyDoubleColumn.class, DoubleColMultiplyLongColumn.class, DoubleColMultiplyDoubleColumn.class, LongColMultiplyLongScalar.class, LongColMultiplyDoubleScalar.class, DoubleColMultiplyLongScalar.class, DoubleColMultiplyDoubleScalar.class, LongScalarMultiplyLongColumn.class, LongScalarMultiplyDoubleColumn.class, DoubleScalarMultiplyLongColumn.class, DoubleScalarMultiplyDoubleColumn.class, DecimalColMultiplyDecimalColumn.class, DecimalColMultiplyDecimalScalar.class, DecimalScalarMultiplyDecimalColumn.class})
public class GenericUDFOPMultiply
extends GenericUDFBaseNumeric {
    public GenericUDFOPMultiply() {
        this.opDisplayName = "*";
    }

    @Override
    protected ByteWritable evaluate(ByteWritable left, ByteWritable right) {
        this.byteWritable.set((byte)(left.get() * right.get()));
        return this.byteWritable;
    }

    @Override
    protected ShortWritable evaluate(ShortWritable left, ShortWritable right) {
        this.shortWritable.set((short)(left.get() * right.get()));
        return this.shortWritable;
    }

    @Override
    protected IntWritable evaluate(IntWritable left, IntWritable right) {
        this.intWritable.set(left.get() * right.get());
        return this.intWritable;
    }

    @Override
    protected LongWritable evaluate(LongWritable left, LongWritable right) {
        this.longWritable.set(left.get() * right.get());
        return this.longWritable;
    }

    @Override
    protected FloatWritable evaluate(FloatWritable left, FloatWritable right) {
        this.floatWritable.set(left.get() * right.get());
        return this.floatWritable;
    }

    @Override
    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        this.doubleWritable.set(left.get() * right.get());
        return this.doubleWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        HiveDecimal dec = left.multiply(right);
        if (dec == null) {
            return null;
        }
        this.decimalWritable.set(dec);
        return this.decimalWritable;
    }

    @Override
    protected DecimalTypeInfo deriveResultDecimalTypeInfo(int prec1, int scale1, int prec2, int scale2) {
        int scale = Math.min(38, scale1 + scale2);
        int prec = Math.min(38, prec1 + prec2 + 1);
        return TypeInfoFactory.getDecimalTypeInfo(prec, scale);
    }
}

