/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.io.WritableComparable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;

public abstract class CacheTran<KI extends WritableComparable, VI, KO extends WritableComparable, VO>
implements SparkTran<KI, VI, KO, VO> {
    private boolean caching = false;
    private JavaPairRDD<KO, VO> cachedRDD;

    protected CacheTran(boolean cache) {
        this.caching = cache;
    }

    @Override
    public JavaPairRDD<KO, VO> transform(JavaPairRDD<KI, VI> input) {
        if (this.caching) {
            if (this.cachedRDD == null) {
                this.cachedRDD = this.doTransform(input);
                this.cachedRDD.persist(StorageLevel.MEMORY_AND_DISK());
            }
            return this.cachedRDD;
        }
        return this.doTransform(input);
    }

    @Override
    public Boolean isCacheEnable() {
        return this.caching;
    }

    protected abstract JavaPairRDD<KO, VO> doTransform(JavaPairRDD<KI, VI> var1);
}

