/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.EOFException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hive.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDeserializeRow<T extends DeserializeRead> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorDeserializeRow.class);
    private T deserializeRead;
    private Reader<T>[] readersByValue;
    private Reader<T>[] readersByReference;
    private TypeInfo[] typeInfos;

    public VectorDeserializeRow(T deserializeRead) {
        this();
        this.deserializeRead = deserializeRead;
        this.typeInfos = deserializeRead.typeInfos();
    }

    private VectorDeserializeRow() {
    }

    private void addReader(int index, int outputColumn) throws HiveException {
        Reader readerByValue = null;
        AbstractBytesReader readerByReference = null;
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.typeInfos[index];
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case BOOLEAN: {
                readerByValue = new BooleanReader(outputColumn);
                break;
            }
            case BYTE: {
                readerByValue = new ByteReader(outputColumn);
                break;
            }
            case SHORT: {
                readerByValue = new ShortReader(outputColumn);
                break;
            }
            case INT: {
                readerByValue = new IntReader(outputColumn);
                break;
            }
            case LONG: {
                readerByValue = new LongReader(outputColumn);
                break;
            }
            case DATE: {
                readerByValue = new DateReader(outputColumn);
                break;
            }
            case TIMESTAMP: {
                readerByValue = new TimestampReader(outputColumn);
                break;
            }
            case FLOAT: {
                readerByValue = new FloatReader(outputColumn);
                break;
            }
            case DOUBLE: {
                readerByValue = new DoubleReader(outputColumn);
                break;
            }
            case STRING: {
                readerByValue = new StringReaderByValue(outputColumn);
                readerByReference = new StringReaderByReference(outputColumn);
                break;
            }
            case CHAR: {
                CharTypeInfo charTypeInfo = (CharTypeInfo)primitiveTypeInfo;
                readerByValue = new CharReaderByValue(charTypeInfo, outputColumn);
                readerByReference = new CharReaderByReference(charTypeInfo, outputColumn);
                break;
            }
            case VARCHAR: {
                VarcharTypeInfo varcharTypeInfo = (VarcharTypeInfo)primitiveTypeInfo;
                readerByValue = new VarcharReaderByValue(varcharTypeInfo, outputColumn);
                readerByReference = new VarcharReaderByReference(varcharTypeInfo, outputColumn);
                break;
            }
            case BINARY: {
                readerByValue = new BinaryReaderByValue(outputColumn);
                readerByReference = new BinaryReaderByReference(outputColumn);
                break;
            }
            case DECIMAL: {
                readerByValue = new HiveDecimalReader(outputColumn);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                readerByValue = new IntervalYearMonthReader(outputColumn);
                break;
            }
            case INTERVAL_DAY_TIME: {
                readerByValue = new IntervalDayTimeReader(outputColumn);
                break;
            }
            default: {
                throw new HiveException("Unexpected primitive type category " + (Object)((Object)primitiveCategory));
            }
        }
        this.readersByValue[index] = readerByValue;
        this.readersByReference[index] = readerByReference == null ? readerByValue : readerByReference;
    }

    public void init(int[] outputColumns) throws HiveException {
        this.readersByValue = new Reader[this.typeInfos.length];
        this.readersByReference = new Reader[this.typeInfos.length];
        for (int i = 0; i < this.typeInfos.length; ++i) {
            int outputColumn = outputColumns[i];
            this.addReader(i, outputColumn);
        }
    }

    public void init(List<Integer> outputColumns) throws HiveException {
        this.readersByValue = new Reader[this.typeInfos.length];
        this.readersByReference = new Reader[this.typeInfos.length];
        for (int i = 0; i < this.typeInfos.length; ++i) {
            int outputColumn = outputColumns.get(i);
            this.addReader(i, outputColumn);
        }
    }

    public void init(int startColumn) throws HiveException {
        this.readersByValue = new Reader[this.typeInfos.length];
        this.readersByReference = new Reader[this.typeInfos.length];
        for (int i = 0; i < this.typeInfos.length; ++i) {
            int outputColumn = startColumn + i;
            this.addReader(i, outputColumn);
        }
    }

    public void init() throws HiveException {
        this.init(0);
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.deserializeRead.set(bytes, offset, length);
    }

    public void deserializeByValue(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int i;
        try {
            for (i = 0; i < this.readersByValue.length; ++i) {
                this.readersByValue[i].apply(batch, batchIndex);
            }
        }
        catch (EOFException e) {
            this.throwMoreDetailedException(e, i);
        }
        this.deserializeRead.extraFieldsCheck();
    }

    public void deserializeByReference(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int i;
        try {
            for (i = 0; i < this.readersByReference.length; ++i) {
                this.readersByReference[i].apply(batch, batchIndex);
            }
        }
        catch (EOFException e) {
            this.throwMoreDetailedException(e, i);
        }
        this.deserializeRead.extraFieldsCheck();
    }

    private void throwMoreDetailedException(IOException e, int index) throws EOFException {
        StringBuilder sb = new StringBuilder();
        sb.append("Detail: \"" + e.toString() + "\" occured for field " + index + " of " + this.typeInfos.length + " fields (");
        for (int i = 0; i < this.typeInfos.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((PrimitiveTypeInfo)this.typeInfos[i]).getPrimitiveCategory().name());
        }
        sb.append(")");
        throw new EOFException(sb.toString());
    }

    private class HiveDecimalReader
    extends Reader<T> {
        private DeserializeRead.ReadDecimalResults readDecimalResults;

        HiveDecimalReader(int columnIndex) {
            super(columnIndex);
            this.readDecimalResults = VectorDeserializeRow.this.deserializeRead.createReadDecimalResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DecimalColumnVector colVector = (DecimalColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readHiveDecimal(this.readDecimalResults);
                HiveDecimal hiveDecimal = this.readDecimalResults.getHiveDecimal();
                colVector.vector[batchIndex].set(hiveDecimal);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class BinaryReaderByReference
    extends AbstractBytesReader {
        private DeserializeRead.ReadBinaryResults readBinaryResults;

        BinaryReaderByReference(int columnIndex) {
            super(columnIndex);
            this.readBinaryResults = VectorDeserializeRow.this.deserializeRead.createReadBinaryResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readBinary(this.readBinaryResults);
                colVector.setRef(batchIndex, this.readBinaryResults.bytes, this.readBinaryResults.start, this.readBinaryResults.length);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class BinaryReaderByValue
    extends AbstractBytesReader {
        private DeserializeRead.ReadBinaryResults readBinaryResults;

        BinaryReaderByValue(int columnIndex) {
            super(columnIndex);
            this.readBinaryResults = VectorDeserializeRow.this.deserializeRead.createReadBinaryResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readBinary(this.readBinaryResults);
                colVector.setVal(batchIndex, this.readBinaryResults.bytes, this.readBinaryResults.start, this.readBinaryResults.length);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class VarcharReaderByReference
    extends AbstractBytesReader {
        private DeserializeRead.ReadStringResults readStringResults;
        private VarcharTypeInfo varcharTypeInfo;

        VarcharReaderByReference(VarcharTypeInfo varcharTypeInfo, int columnIndex) {
            super(columnIndex);
            this.readStringResults = VectorDeserializeRow.this.deserializeRead.createReadStringResults();
            this.varcharTypeInfo = varcharTypeInfo;
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readString(this.readStringResults);
                int adjustedLength = StringExpr.truncate(this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length, this.varcharTypeInfo.getLength());
                colVector.setRef(batchIndex, this.readStringResults.bytes, this.readStringResults.start, adjustedLength);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class VarcharReaderByValue
    extends AbstractBytesReader {
        private DeserializeRead.ReadStringResults readStringResults;
        private VarcharTypeInfo varcharTypeInfo;

        VarcharReaderByValue(VarcharTypeInfo varcharTypeInfo, int columnIndex) {
            super(columnIndex);
            this.readStringResults = VectorDeserializeRow.this.deserializeRead.createReadStringResults();
            this.varcharTypeInfo = varcharTypeInfo;
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readString(this.readStringResults);
                int adjustedLength = StringExpr.truncate(this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length, this.varcharTypeInfo.getLength());
                colVector.setVal(batchIndex, this.readStringResults.bytes, this.readStringResults.start, adjustedLength);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class CharReaderByReference
    extends AbstractBytesReader {
        private DeserializeRead.ReadStringResults readStringResults;
        private CharTypeInfo charTypeInfo;

        CharReaderByReference(CharTypeInfo charTypeInfo, int columnIndex) {
            super(columnIndex);
            this.readStringResults = VectorDeserializeRow.this.deserializeRead.createReadStringResults();
            this.charTypeInfo = charTypeInfo;
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readString(this.readStringResults);
                int adjustedLength = StringExpr.rightTrimAndTruncate(this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length, this.charTypeInfo.getLength());
                colVector.setRef(batchIndex, this.readStringResults.bytes, this.readStringResults.start, adjustedLength);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class CharReaderByValue
    extends AbstractBytesReader {
        private DeserializeRead.ReadStringResults readStringResults;
        private CharTypeInfo charTypeInfo;

        CharReaderByValue(CharTypeInfo charTypeInfo, int columnIndex) {
            super(columnIndex);
            this.readStringResults = VectorDeserializeRow.this.deserializeRead.createReadStringResults();
            this.charTypeInfo = charTypeInfo;
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readString(this.readStringResults);
                int adjustedLength = StringExpr.rightTrimAndTruncate(this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length, this.charTypeInfo.getLength());
                colVector.setVal(batchIndex, this.readStringResults.bytes, this.readStringResults.start, adjustedLength);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class StringReaderByReference
    extends AbstractBytesReader {
        private DeserializeRead.ReadStringResults readStringResults;

        StringReaderByReference(int columnIndex) {
            super(columnIndex);
            this.readStringResults = VectorDeserializeRow.this.deserializeRead.createReadStringResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readString(this.readStringResults);
                colVector.setRef(batchIndex, this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class StringReaderByValue
    extends AbstractBytesReader {
        private DeserializeRead.ReadStringResults readStringResults;

        StringReaderByValue(int columnIndex) {
            super(columnIndex);
            this.readStringResults = VectorDeserializeRow.this.deserializeRead.createReadStringResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readString(this.readStringResults);
                colVector.setVal(batchIndex, this.readStringResults.bytes, this.readStringResults.start, this.readStringResults.length);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractBytesReader
    extends Reader<T> {
        AbstractBytesReader(int columnIndex) {
            super(columnIndex);
        }
    }

    private class DoubleReader
    extends AbstractDoubleReader {
        DoubleReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DoubleColumnVector colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                double value;
                colVector.vector[batchIndex] = value = VectorDeserializeRow.this.deserializeRead.readDouble();
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class FloatReader
    extends AbstractDoubleReader {
        FloatReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DoubleColumnVector colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                float value = VectorDeserializeRow.this.deserializeRead.readFloat();
                colVector.vector[batchIndex] = value;
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractDoubleReader
    extends Reader<T> {
        AbstractDoubleReader(int columnIndex) {
            super(columnIndex);
        }
    }

    private class IntervalDayTimeReader
    extends AbstractLongReader {
        DeserializeRead.ReadIntervalDayTimeResults readIntervalDayTimeResults;

        IntervalDayTimeReader(int columnIndex) {
            super(columnIndex);
            this.readIntervalDayTimeResults = VectorDeserializeRow.this.deserializeRead.createReadIntervalDayTimeResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readIntervalDayTime(this.readIntervalDayTimeResults);
                HiveIntervalDayTime hidt = this.readIntervalDayTimeResults.getHiveIntervalDayTime();
                colVector.vector[batchIndex] = DateUtils.getIntervalDayTimeTotalNanos(hidt);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class IntervalYearMonthReader
    extends AbstractLongReader {
        DeserializeRead.ReadIntervalYearMonthResults readIntervalYearMonthResults;

        IntervalYearMonthReader(int columnIndex) {
            super(columnIndex);
            this.readIntervalYearMonthResults = VectorDeserializeRow.this.deserializeRead.createReadIntervalYearMonthResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readIntervalYearMonth(this.readIntervalYearMonthResults);
                HiveIntervalYearMonth hiym = this.readIntervalYearMonthResults.getHiveIntervalYearMonth();
                colVector.vector[batchIndex] = hiym.getTotalMonths();
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class TimestampReader
    extends AbstractLongReader {
        DeserializeRead.ReadTimestampResults readTimestampResults;

        TimestampReader(int columnIndex) {
            super(columnIndex);
            this.readTimestampResults = VectorDeserializeRow.this.deserializeRead.createReadTimestampResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readTimestamp(this.readTimestampResults);
                Timestamp t = this.readTimestampResults.getTimestamp();
                colVector.vector[batchIndex] = TimestampUtils.getTimeNanoSec(t);
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class DateReader
    extends AbstractLongReader {
        DeserializeRead.ReadDateResults readDateResults;

        DateReader(int columnIndex) {
            super(columnIndex);
            this.readDateResults = VectorDeserializeRow.this.deserializeRead.createReadDateResults();
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                VectorDeserializeRow.this.deserializeRead.readDate(this.readDateResults);
                colVector.vector[batchIndex] = this.readDateResults.getDays();
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class LongReader
    extends AbstractLongReader {
        LongReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                long value;
                colVector.vector[batchIndex] = value = VectorDeserializeRow.this.deserializeRead.readLong();
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class IntReader
    extends AbstractLongReader {
        IntReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                int value = VectorDeserializeRow.this.deserializeRead.readInt();
                colVector.vector[batchIndex] = value;
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class ShortReader
    extends AbstractLongReader {
        ShortReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                short value = VectorDeserializeRow.this.deserializeRead.readShort();
                colVector.vector[batchIndex] = value;
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class ByteReader
    extends AbstractLongReader {
        ByteReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                byte value = VectorDeserializeRow.this.deserializeRead.readByte();
                colVector.vector[batchIndex] = value;
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private class BooleanReader
    extends AbstractLongReader {
        BooleanReader(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (VectorDeserializeRow.this.deserializeRead.readCheckNull()) {
                VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            } else {
                boolean value = VectorDeserializeRow.this.deserializeRead.readBoolean();
                colVector.vector[batchIndex] = value ? 1 : 0;
                colVector.isNull[batchIndex] = false;
            }
        }
    }

    private abstract class AbstractLongReader
    extends Reader<T> {
        AbstractLongReader(int columnIndex) {
            super(columnIndex);
        }
    }

    private abstract class Reader<R extends DeserializeRead> {
        protected int columnIndex;

        Reader(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        abstract void apply(VectorizedRowBatch var1, int var2) throws IOException;
    }
}

