/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class LongScalarLessLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private long value;
    private int outputColumn;

    public LongScalarLessLongColumn(long value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public LongScalarLessLongColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        boolean[] outNulls = outputColVector.isNull;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        outputColVector.noNulls = inputColVector.noNulls;
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                outputVector[0] = this.value < vector[0] ? 1L : 0L;
                outputColVector.isRepeating = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = this.value < vector[i] ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value - vector[i] >>> 63;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = this.value < vector[0] ? 1L : 0L;
                outNulls[0] = false;
            } else {
                outNulls[0] = true;
            }
            outputColVector.isRepeating = true;
        } else if (batch.selectedInUse) {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = this.value < vector[i] ? 1L : 0L;
            }
        } else {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int i = 0; i != n; ++i) {
                outputVector[i] = this.value - vector[i] >>> 63;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

