/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.plan.Explain;

public class JoinCondDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int left;
    private int right;
    private int type;
    private boolean preserved;

    public JoinCondDesc() {
    }

    public JoinCondDesc(int left, int right, int type) {
        this.left = left;
        this.right = right;
        this.type = type;
    }

    public JoinCondDesc(JoinCond condn) {
        this.left = condn.getLeft();
        this.right = condn.getRight();
        this.preserved = condn.getPreserved();
        switch (condn.getJoinType()) {
            case INNER: {
                this.type = 0;
                break;
            }
            case LEFTOUTER: {
                this.type = 1;
                break;
            }
            case RIGHTOUTER: {
                this.type = 2;
                break;
            }
            case FULLOUTER: {
                this.type = 3;
                break;
            }
            case UNIQUE: {
                this.type = 4;
                break;
            }
            case LEFTSEMI: {
                this.type = 5;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean getPreserved() {
        return this.preserved;
    }

    public void setPreserved(boolean preserved) {
        this.preserved = preserved;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Explain(explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getJoinCondString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 0: {
                sb.append("Inner Join ");
                break;
            }
            case 3: {
                sb.append("Outer Join ");
                break;
            }
            case 1: {
                sb.append("Left Outer Join");
                break;
            }
            case 2: {
                sb.append("Right Outer Join");
                break;
            }
            case 4: {
                sb.append("Unique Join");
                break;
            }
            case 5: {
                sb.append("Left Semi Join ");
                break;
            }
            default: {
                sb.append("Unknow Join ");
            }
        }
        sb.append(this.left);
        sb.append(" to ");
        sb.append(this.right);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinCondDesc)) {
            return false;
        }
        JoinCondDesc other = (JoinCondDesc)obj;
        return this.type == other.type && this.left == other.left && this.right == other.right && this.preserved == other.preserved;
    }
}

