/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="$SUM0", value="_FUNC_(x) - Returns the sum of a set of numbers, zero if empty")
public class GenericUDAFSumEmptyIsZero
extends GenericUDAFSum {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case LONG: {
                return new SumZeroIfEmpty();
            }
        }
        throw new UDFArgumentTypeException(0, "Only bigint type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class SumZeroIfEmpty
    extends GenericUDAFSum.GenericUDAFSumLong {
        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFSum.GenericUDAFSumLong.SumLongAgg myagg = (GenericUDAFSum.GenericUDAFSumLong.SumLongAgg)agg;
            this.result.set(myagg.sum);
            return this.result;
        }
    }
}

