/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.DirectDecompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.orc.impl.HadoopShims;

public class HadoopShimsCurrent
implements HadoopShims {
    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        switch (codec) {
            case ZLIB: {
                return new DirectDecompressWrapper((DirectDecompressor)new ZlibDecompressor.ZlibDirectDecompressor());
            }
            case ZLIB_NOHEADER: {
                return new DirectDecompressWrapper((DirectDecompressor)new ZlibDecompressor.ZlibDirectDecompressor(ZlibDecompressor.CompressionHeader.NO_HEADER, 0));
            }
            case SNAPPY: {
                return new DirectDecompressWrapper((DirectDecompressor)new SnappyDecompressor.SnappyDirectDecompressor());
            }
        }
        return null;
    }

    private static class DirectDecompressWrapper
    implements HadoopShims.DirectDecompressor {
        private final DirectDecompressor root;

        DirectDecompressWrapper(DirectDecompressor root) {
            this.root = root;
        }

        @Override
        public void decompress(ByteBuffer input, ByteBuffer output) throws IOException {
            this.root.decompress(input, output);
        }
    }
}

