/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.PostExecute;
import org.apache.hadoop.hive.ql.hooks.PreExecute;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.thrift.ThriftJDBCBinarySerDe;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements CommandProcessor {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private Runnable shutdownRunner = null;
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private final HiveConf conf;
    private final boolean isParallelEnabled;
    private DataInput resStream;
    private Context ctx;
    private DriverContext driverCxt;
    private QueryPlan plan;
    private Schema schema;
    private String errorMessage;
    private String SQLState;
    private Throwable downstreamError;
    private FetchTask fetchTask;
    List<HiveLock> hiveLocks = new ArrayList<HiveLock>();
    private Set<FileSinkDesc> acidSinks;
    private boolean acidInQuery;
    private int maxthreads;
    private int tryCount = Integer.MAX_VALUE;
    private boolean destroyed;
    private String userName;
    private String operationId;
    private final QueryDisplay queryDisplay = new QueryDisplay();
    private QueryState queryState;
    private static final ReentrantLock globalCompileLock = new ReentrantLock();

    private boolean checkConcurrency() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (!supportConcurrency) {
            LOG.info("Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        return true;
    }

    @Override
    public void init() {
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info("Returning cluster status: " + cs.toString());
        return cs;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info("No returning schema.");
                } else {
                    String tableName = "result";
                    List<FieldSchema> lst = null;
                    try {
                        lst = MetaStoreUtils.getFieldsFromDeserializer(tableName, td.getDeserializer(conf));
                    }
                    catch (Exception e) {
                        LOG.warn("Error getting schema: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info("Returning Hive schema: " + schema);
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List<FieldSchema> lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType(f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info("Returning Thrift schema: " + schema);
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public Driver() {
        this(new QueryState(SessionState.get() != null ? SessionState.get().getConf() : new HiveConf()), null);
    }

    public Driver(HiveConf conf) {
        this(new QueryState(conf), null);
    }

    public Driver(HiveConf conf, String userName) {
        this(new QueryState(conf), userName);
    }

    public Driver(QueryState queryState, String userName) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.isParallelEnabled = this.conf != null && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION);
        this.userName = userName;
    }

    public int compile(String command) {
        return this.compile(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String command, boolean resetTaskIds) {
        String explainOutput22;
        BaseSemanticAnalyzer sem;
        ASTNode tree;
        String queryId;
        PerfLogger perfLogger;
        block25: {
            perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(CLASS_NAME, "compile");
            String queryStr = command = new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(this.conf, command);
            try {
                queryStr = HookUtils.redactLogString(this.conf, command);
            }
            catch (Exception e) {
                LOG.warn("WARNING! Query command could not be redacted." + e);
            }
            if (this.ctx != null) {
                this.close();
            }
            if (resetTaskIds) {
                TaskFactory.resetId();
            }
            queryId = this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
            this.queryDisplay.setQueryStr(queryStr);
            this.queryDisplay.setQueryId(queryId);
            LOG.info("Compiling command(queryId=" + queryId + "): " + queryStr);
            SessionState.get().setupQueryCurrentTimestamp();
            try {
                final HiveTxnManager txnManager = SessionState.get().initTxnMgr(this.conf);
                ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
                this.shutdownRunner = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Driver.this.releaseLocksAndCommitOrRollback(false, txnManager);
                        }
                        catch (LockException e) {
                            LOG.warn("Exception when releasing locks in ShutdownHook for Driver: " + e.getMessage());
                        }
                    }
                };
                ShutdownHookManager.addShutdownHook(this.shutdownRunner, 0);
                this.ctx = new Context(this.conf);
                this.ctx.setTryCount(this.getTryCount());
                this.ctx.setCmd(command);
                this.ctx.setHDFSCleanup(true);
                perfLogger.PerfLogBegin(CLASS_NAME, "parse");
                ParseDriver pd = new ParseDriver();
                tree = pd.parse(command, this.ctx);
                tree = ParseUtils.findRootNonNullToken(tree);
                perfLogger.PerfLogEnd(CLASS_NAME, "parse");
                perfLogger.PerfLogBegin(CLASS_NAME, "semanticAnalyze");
                sem = SemanticAnalyzerFactory.get(this.queryState, tree);
                List<HiveSemanticAnalyzerHook> saHooks = this.getHooks(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, HiveSemanticAnalyzerHook.class);
                Hive.get().getMSC().flushCache();
                if (saHooks != null && !saHooks.isEmpty()) {
                    HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
                    hookCtx.setConf(this.conf);
                    hookCtx.setUserName(this.userName);
                    hookCtx.setIpAddress(SessionState.get().getUserIpAddress());
                    hookCtx.setCommand(command);
                    for (HiveSemanticAnalyzerHook hook : saHooks) {
                        tree = hook.preAnalyze(hookCtx, tree);
                    }
                    sem.analyze(tree, this.ctx);
                    hookCtx.update(sem);
                    for (HiveSemanticAnalyzerHook hook : saHooks) {
                        hook.postAnalyze(hookCtx, sem.getAllRootTasks());
                    }
                } else {
                    sem.analyze(tree, this.ctx);
                }
                this.acidSinks = sem.getAcidFileSinks();
                LOG.info("Semantic Analysis Completed");
                sem.validate();
                this.acidInQuery = sem.hasAcidInQuery();
                perfLogger.PerfLogEnd(CLASS_NAME, "semanticAnalyze");
                this.schema = Driver.getSchema(sem, this.conf);
                this.plan = new QueryPlan(queryStr, sem, perfLogger.getStartTime("Driver.run"), queryId, this.queryState.getHiveOperation(), this.schema);
                this.conf.setQueryString(queryStr);
                this.conf.set("mapreduce.workflow.id", "hive_" + queryId);
                this.conf.set("mapreduce.workflow.name", queryStr);
                if (this.plan.getFetchTask() != null) {
                    this.plan.getFetchTask().initialize(this.queryState, this.plan, null, this.ctx.getOpContext());
                }
                if (sem.skipAuthorization() || !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) break block25;
                try {
                    perfLogger.PerfLogBegin(CLASS_NAME, "doAuthorization");
                    Driver.doAuthorization(this.queryState.getHiveOperation(), sem, command);
                }
                catch (AuthorizationException authExp) {
                    console.printError("Authorization failed:" + authExp.getMessage() + ". Use SHOW GRANT to get more details.");
                    this.errorMessage = authExp.getMessage();
                    this.SQLState = "42000";
                    int n = 403;
                    double duration = (double)perfLogger.PerfLogEnd(CLASS_NAME, "compile") / 1000.0;
                    ImmutableMap<String, Long> compileHMSTimings = this.dumpMetaCallTimingWithoutEx("compilation");
                    this.queryDisplay.setHmsTimings(QueryDisplay.Phase.COMPILATION, compileHMSTimings);
                    LOG.info("Completed compiling command(queryId=" + queryId + "); Time taken: " + duration + " seconds");
                    return n;
                }
            }
            catch (Exception e) {
                ErrorMsg error = ErrorMsg.getErrorMsg(e.getMessage());
                this.errorMessage = "FAILED: " + e.getClass().getSimpleName();
                if (error != ErrorMsg.GENERIC_ERROR) {
                    this.errorMessage = this.errorMessage + " [Error " + error.getErrorCode() + "]:";
                }
                this.errorMessage = e instanceof IllegalArgumentException && e.getMessage() == null && e.getCause() != null ? this.errorMessage + " " + e.getCause().getMessage() : this.errorMessage + " " + e.getMessage();
                if (error == ErrorMsg.TXNMGR_NOT_ACID) {
                    this.errorMessage = this.errorMessage + ". Failed command: " + queryStr;
                }
                this.SQLState = error.getSQLState();
                this.downstreamError = e;
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                int n = error.getErrorCode();
                return n;
            }
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT) && (explainOutput22 = this.getExplainOutput(sem, this.plan, tree)) != null) {
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT)) {
                LOG.info("EXPLAIN output for queryid " + queryId + " : " + explainOutput22);
            }
            if (this.conf.isWebUiQueryInfoCacheEnabled()) {
                this.queryDisplay.setExplainPlan(explainOutput22);
            }
        }
        int explainOutput22 = 0;
        return explainOutput22;
        {
            finally {
                perfLogger.PerfLogEnd(CLASS_NAME, "doAuthorization");
            }
        }
        finally {
            double duration = (double)perfLogger.PerfLogEnd(CLASS_NAME, "compile") / 1000.0;
            ImmutableMap<String, Long> compileHMSTimings = this.dumpMetaCallTimingWithoutEx("compilation");
            this.queryDisplay.setHmsTimings(QueryDisplay.Phase.COMPILATION, compileHMSTimings);
            LOG.info("Completed compiling command(queryId=" + queryId + "); Time taken: " + duration + " seconds");
        }
    }

    private ImmutableMap<String, Long> dumpMetaCallTimingWithoutEx(String phase) {
        try {
            return Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn("Caught exception attempting to write metadata call information " + he, (Throwable)he);
            return null;
        }
    }

    private String getExplainOutput(BaseSemanticAnalyzer sem, QueryPlan plan, ASTNode astTree) throws IOException {
        String ret = null;
        ExplainTask task = new ExplainTask();
        task.initialize(this.queryState, plan, null, this.ctx.getOpContext());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            List<Task<?>> rootTasks = sem.getAllRootTasks();
            task.getJSONPlan(ps, rootTasks, sem.getFetchTask(), false, true, true);
            ret = baos.toString();
        }
        catch (Exception e) {
            LOG.warn("Exception generating explain output: " + e, (Throwable)e);
        }
        return ret;
    }

    public static void doAuthorization(HiveOperation op, BaseSemanticAnalyzer sem, String command) throws HiveException, AuthorizationException {
        ImportSemanticAnalyzer isa;
        SessionState ss = SessionState.get();
        Hive db = sem.getDb();
        HashSet<ReadEntity> additionalInputs = new HashSet<ReadEntity>();
        for (Entity entity : sem.getInputs()) {
            if (entity.getType() != Entity.Type.PARTITION) continue;
            additionalInputs.add(new ReadEntity(entity.getTable()));
        }
        HashSet<WriteEntity> additionalOutputs = new HashSet<WriteEntity>();
        for (Entity entity : sem.getOutputs()) {
            if (entity.getType() != Entity.Type.PARTITION) continue;
            additionalOutputs.add(new WriteEntity(entity.getTable(), WriteEntity.WriteType.DDL_NO_LOCK));
        }
        Sets.SetView<ReadEntity> setView = Sets.union(sem.getInputs(), additionalInputs);
        Sets.SetView<WriteEntity> setView2 = Sets.union(sem.getOutputs(), additionalOutputs);
        if (ss.isAuthorizationModeV2()) {
            ColumnAccessInfo colAccessInfo = sem.getColumnAccessInfo();
            Map<String, List<String>> selectTab2Cols = colAccessInfo != null ? colAccessInfo.getTableToColumnAccessMap() : null;
            Map<String, List<String>> updateTab2Cols = sem.getUpdateColumnAccessInfo() != null ? sem.getUpdateColumnAccessInfo().getTableToColumnAccessMap() : null;
            Driver.doAuthorizationV2(ss, op, setView, setView2, command, selectTab2Cols, updateTab2Cols);
            return;
        }
        if (op == null) {
            throw new HiveException("Operation should not be null");
        }
        HiveAuthorizationProvider authorizer = ss.getAuthorizer();
        if (op.equals((Object)HiveOperation.CREATEDATABASE)) {
            authorizer.authorize(op.getInputRequiredPrivileges(), op.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.IMPORT) && !(isa = (ImportSemanticAnalyzer)sem).existsTable()) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        }
        if (setView2 != null && setView2.size() > 0) {
            for (WriteEntity write : setView2) {
                Partition part;
                if (write.isDummy() || write.isPathType()) continue;
                if (write.getType() == Entity.Type.DATABASE) {
                    if (op.equals((Object)HiveOperation.IMPORT)) continue;
                    authorizer.authorize(write.getDatabase(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getType() == Entity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                    authorizer.authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getTable() == null) continue;
                authorizer.authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
            }
        }
        if (setView != null && setView.size() > 0) {
            HashMap<Table, List<String>> tab2Cols = new HashMap<Table, List<String>>();
            HashMap<Partition, List<String>> part2Cols = new HashMap<Partition, List<String>>();
            HashMap<String, Boolean> tableUsePartLevelAuth = new HashMap<String, Boolean>();
            for (ReadEntity read : setView) {
                boolean usePartLevelPriv;
                String tblName;
                if (read.isDummy() || read.isPathType() || read.getType() == Entity.Type.DATABASE) continue;
                Table tbl = read.getTable();
                if (read.getPartition() == null && (tbl == null || !tbl.isPartitioned()) || tableUsePartLevelAuth.get(tblName = tbl.getTableName()) != null) continue;
                boolean bl = usePartLevelPriv = tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"));
                if (usePartLevelPriv) {
                    tableUsePartLevelAuth.put(tblName, Boolean.TRUE);
                    continue;
                }
                tableUsePartLevelAuth.put(tblName, Boolean.FALSE);
            }
            Driver.getTablePartitionUsedColumns(op, sem, tab2Cols, part2Cols, tableUsePartLevelAuth);
            HashSet<String> tableAuthChecked = new HashSet<String>();
            for (ReadEntity read : setView) {
                Partition partition;
                if (read.isDummy() || read.isPathType() || !read.isDirect()) continue;
                if (read.getType() == Entity.Type.DATABASE) {
                    authorizer.authorize(read.getDatabase(), op.getInputRequiredPrivileges(), null);
                    continue;
                }
                Table tbl = read.getTable();
                if (tbl.isView() && sem instanceof SemanticAnalyzer) {
                    tab2Cols.put(tbl, sem.getColumnAccessInfo().getTableToColumnAccessMap().get(tbl.getCompleteName()));
                }
                if (read.getPartition() != null && Boolean.TRUE.equals(tableUsePartLevelAuth.get((tbl = (partition = read.getPartition()).getTable()).getTableName()))) {
                    List cols = (List)part2Cols.get(partition);
                    if (cols != null && cols.size() > 0) {
                        authorizer.authorize(partition.getTable(), partition, cols, op.getInputRequiredPrivileges(), null);
                        continue;
                    }
                    authorizer.authorize(partition, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                if (tbl == null || tableAuthChecked.contains(tbl.getTableName()) || Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) continue;
                List cols = (List)tab2Cols.get(tbl);
                if (cols != null && cols.size() > 0) {
                    authorizer.authorize(tbl, null, cols, op.getInputRequiredPrivileges(), null);
                } else {
                    authorizer.authorize(tbl, op.getInputRequiredPrivileges(), null);
                }
                tableAuthChecked.add(tbl.getTableName());
            }
        }
    }

    private static void getTablePartitionUsedColumns(HiveOperation op, BaseSemanticAnalyzer sem, Map<Table, List<String>> tab2Cols, Map<Partition, List<String>> part2Cols, Map<String, Boolean> tableUsePartLevelAuth) throws HiveException {
        if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
            SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
            ParseContext parseCtx = querySem.getParseContext();
            for (Map.Entry<String, TableScanOperator> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                TableScanOperator tableScanOp = topOpMap.getValue();
                if (tableScanOp.isInsideView()) continue;
                Table tbl = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
                List<Integer> neededColumnIds = tableScanOp.getNeededColumnIDs();
                List<FieldSchema> columns = tbl.getCols();
                ArrayList<String> cols = new ArrayList<String>();
                for (int i = 0; i < neededColumnIds.size(); ++i) {
                    cols.add(columns.get(neededColumnIds.get(i)).getName());
                }
                if (tbl.isPartitioned() && Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) {
                    String alias_id = topOpMap.getKey();
                    PrunedPartitionList partsList = PartitionPruner.prune(tableScanOp, parseCtx, alias_id);
                    Set<Partition> parts = partsList.getPartitions();
                    for (Partition part : parts) {
                        List<String> existingCols = part2Cols.get(part);
                        if (existingCols == null) {
                            existingCols = new ArrayList<String>();
                        }
                        existingCols.addAll(cols);
                        part2Cols.put(part, existingCols);
                    }
                    continue;
                }
                List<String> existingCols = tab2Cols.get(tbl);
                if (existingCols == null) {
                    existingCols = new ArrayList<String>();
                }
                existingCols.addAll(cols);
                tab2Cols.put(tbl, existingCols);
            }
        }
    }

    private static void doAuthorizationV2(SessionState ss, HiveOperation op, Set<ReadEntity> inputs, Set<WriteEntity> outputs, String command, Map<String, List<String>> tab2cols, Map<String, List<String>> updateTab2Cols) throws HiveException {
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        authzContextBuilder.setCommandString(command);
        HiveOperationType hiveOpType = Driver.getHiveOperationType(op);
        List<HivePrivilegeObject> inputsHObjs = Driver.getHivePrivObjects(inputs, tab2cols);
        List<HivePrivilegeObject> outputHObjs = Driver.getHivePrivObjects(outputs, updateTab2Cols);
        ss.getAuthorizerV2().checkPrivileges(hiveOpType, inputsHObjs, outputHObjs, authzContextBuilder.build());
    }

    private static List<HivePrivilegeObject> getHivePrivObjects(Set<? extends Entity> privObjects, Map<String, List<String>> tableName2Cols) {
        ArrayList<HivePrivilegeObject> hivePrivobjs = new ArrayList<HivePrivilegeObject>();
        if (privObjects == null) {
            return hivePrivobjs;
        }
        block7: for (Entity entity : privObjects) {
            HivePrivilegeObject.HivePrivilegeObjectType privObjType = AuthorizationUtils.getHivePrivilegeObjectType(entity.getType());
            if (entity.isDummy() || entity instanceof ReadEntity && !((ReadEntity)entity).isDirect() || entity instanceof WriteEntity && ((WriteEntity)entity).isTempURI()) continue;
            String dbname = null;
            String objName = null;
            List<String> partKeys = null;
            List<String> columns = null;
            switch (entity.getType()) {
                case DATABASE: {
                    dbname = entity.getDatabase().getName();
                    break;
                }
                case TABLE: {
                    dbname = entity.getTable().getDbName();
                    objName = entity.getTable().getTableName();
                    columns = tableName2Cols == null ? null : tableName2Cols.get(Table.getCompleteName(dbname, objName));
                    break;
                }
                case DFS_DIR: 
                case LOCAL_DIR: {
                    objName = entity.getD().toString();
                    break;
                }
                case FUNCTION: {
                    if (entity.getDatabase() != null) {
                        dbname = entity.getDatabase().getName();
                    }
                    objName = entity.getFunctionName();
                    break;
                }
                case DUMMYPARTITION: 
                case PARTITION: {
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected object type");
                }
            }
            HivePrivilegeObject.HivePrivObjectActionType actionType = AuthorizationUtils.getActionType(entity);
            HivePrivilegeObject hPrivObject = new HivePrivilegeObject(privObjType, dbname, objName, partKeys, columns, actionType, null);
            hivePrivobjs.add(hPrivObject);
        }
        return hivePrivobjs;
    }

    private static HiveOperationType getHiveOperationType(HiveOperation op) {
        return HiveOperationType.valueOf(op.name());
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    private void recordValidTxns() throws LockException {
        HiveTxnManager txnMgr = SessionState.get().getTxnMgr();
        ValidTxnList txns = txnMgr.getValidTxns();
        String txnStr = txns.toString();
        this.conf.set("hive.txn.valid.txns", txnStr);
        LOG.debug("Encoding valid txns info " + txnStr + " txnid:" + txnMgr.getCurrentTxnId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireLocksAndOpenTxn(boolean startTxnImplicitly) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        SessionState ss = SessionState.get();
        HiveTxnManager txnMgr = ss.getTxnMgr();
        if (startTxnImplicitly) assert (!txnMgr.getAutoCommit());
        try {
            String userFromUGI;
            try {
                userFromUGI = this.conf.getUser();
            }
            catch (IOException e) {
                this.errorMessage = "FAILED: Error in determining user while acquiring locks: " + e.getMessage();
                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                this.downstreamError = e;
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                int n = 10;
                perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
                return n;
            }
            boolean initiatingTransaction = false;
            boolean readOnlyQueryInAutoCommit = false;
            if (txnMgr.getAutoCommit() && this.haveAcidWrite() || this.plan.getOperation() == HiveOperation.START_TRANSACTION || !txnMgr.getAutoCommit() && startTxnImplicitly) {
                if (txnMgr.isTxnOpen()) {
                    throw new RuntimeException("Already have an open transaction txnid:" + txnMgr.getCurrentTxnId());
                }
                txnMgr.openTxn(userFromUGI);
                initiatingTransaction = true;
            } else {
                boolean bl = readOnlyQueryInAutoCommit = txnMgr.getAutoCommit() && this.plan.getOperation() == HiveOperation.QUERY && !this.haveAcidWrite();
            }
            if (this.haveAcidWrite()) {
                for (FileSinkDesc desc : this.acidSinks) {
                    desc.setTransactionId(txnMgr.getCurrentTxnId());
                    desc.setStatementId(txnMgr.getStatementId());
                }
            }
            txnMgr.acquireLocks(this.plan, this.ctx, userFromUGI);
            if (initiatingTransaction || readOnlyQueryInAutoCommit && this.acidInQuery) {
                this.recordValidTxns();
            }
            int n = 0;
            return n;
        }
        catch (LockException e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 10;
            return n;
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    private boolean haveAcidWrite() {
        return this.acidSinks != null && !this.acidSinks.isEmpty();
    }

    private void releaseLocksAndCommitOrRollback(boolean commit, HiveTxnManager txnManager) throws LockException {
        HiveTxnManager txnMgr;
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "releaseLocks");
        if (txnManager == null) {
            SessionState ss = SessionState.get();
            txnMgr = ss.getTxnMgr();
        } else {
            txnMgr = txnManager;
        }
        if (txnMgr.isTxnOpen()) {
            if (commit) {
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN)) {
                    txnMgr.rollbackTxn();
                } else {
                    txnMgr.commitTxn();
                }
            } else {
                txnMgr.rollbackTxn();
            }
        } else {
            if (this.ctx != null && this.ctx.getHiveLocks() != null) {
                this.hiveLocks.addAll(this.ctx.getHiveLocks());
            }
            txnMgr.releaseLocks(this.hiveLocks);
        }
        this.hiveLocks.clear();
        if (this.ctx != null) {
            this.ctx.setHiveLocks(null);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "releaseLocks");
    }

    private void releaseResources() {
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
        if (this.plan != null) {
            this.fetchTask = this.plan.getFetchTask();
            if (this.fetchTask != null) {
                this.fetchTask.setDriverContext(null);
                this.fetchTask.setQueryPlan(null);
            }
        }
        if (this.driverCxt != null) {
            this.driverCxt.shutdown();
            this.driverCxt = null;
        }
        this.plan = null;
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandNeedRetryException {
        return this.run(command, false);
    }

    public CommandProcessorResponse run() throws CommandNeedRetryException {
        return this.run(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse run(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        CommandProcessorResponse cpr;
        try {
            cpr = this.runInternal(command, alreadyCompiled);
        }
        finally {
            this.releaseResources();
        }
        if (cpr.getResponseCode() == 0) {
            return cpr;
        }
        SessionState ss = SessionState.get();
        if (ss == null) {
            return cpr;
        }
        MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
        if (!(mdf instanceof JsonMetaDataFormatter)) {
            return cpr;
        }
        try {
            if (this.downstreamError == null) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState);
                return cpr;
            }
            ErrorMsg canonicalErr = ErrorMsg.getErrorMsg(cpr.getResponseCode());
            if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState, null);
                return cpr;
            }
            if (this.downstreamError instanceof HiveException) {
                HiveException rc = (HiveException)this.downstreamError;
                mdf.error(ss.out, this.errorMessage, rc.getCanonicalErrorMsg().getErrorCode(), this.SQLState, rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? org.apache.hadoop.util.StringUtils.stringifyException((Throwable)rc) : null);
            } else {
                ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg(this.downstreamError.getMessage());
                mdf.error(ss.out, this.errorMessage, canonicalMsg.getErrorCode(), this.SQLState, org.apache.hadoop.util.StringUtils.stringifyException((Throwable)this.downstreamError));
            }
        }
        catch (HiveException ex) {
            console.printError("Unable to JSON-encode the error", org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
        }
        return cpr;
    }

    public CommandProcessorResponse compileAndRespond(String command) {
        return this.createProcessorResponse(this.compileInternal(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileInternal(String command) {
        int ret;
        ReentrantLock compileLock = this.tryAcquireCompileLock(this.isParallelEnabled, command);
        if (compileLock == null) {
            return ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode();
        }
        try {
            ret = this.compile(command);
        }
        finally {
            compileLock.unlock();
        }
        if (ret != 0) {
            try {
                this.releaseLocksAndCommitOrRollback(false, null);
            }
            catch (LockException e) {
                LOG.warn("Exception in releasing locks. " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
        }
        PerfLogger perfLogger = SessionState.getPerfLogger();
        this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.COMPILATION, perfLogger.getStartTimes());
        this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.COMPILATION, perfLogger.getEndTimes());
        return ret;
    }

    private ReentrantLock tryAcquireCompileLock(boolean isParallelEnabled, String command) {
        ReentrantLock compileLock;
        block6: {
            compileLock = isParallelEnabled ? SessionState.get().getCompileLock() : globalCompileLock;
            long maxCompileLockWaitTime = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, TimeUnit.SECONDS);
            if (maxCompileLockWaitTime > 0L) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Waiting to acquire compile lock: " + command);
                    }
                    if (!compileLock.tryLock(maxCompileLockWaitTime, TimeUnit.SECONDS)) {
                        this.errorMessage = ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg();
                        LOG.error(this.errorMessage + ": " + command);
                        return null;
                    }
                    break block6;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Interrupted Exception ignored", (Throwable)e);
                    }
                    return null;
                }
            }
            compileLock.lock();
        }
        LOG.debug("Acquired the compile lock");
        return compileLock;
    }

    private CommandProcessorResponse runInternal(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        int ret;
        List<HiveDriverRunHook> driverRunHooks;
        this.errorMessage = null;
        this.SQLState = null;
        this.downstreamError = null;
        HiveDriverRunHookContextImpl hookContext = new HiveDriverRunHookContextImpl(this.conf, command);
        try {
            driverRunHooks = this.getHooks(HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, HiveDriverRunHook.class);
            for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                driverRunHook.preDriverRun(hookContext);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return this.createProcessorResponse(12);
        }
        PerfLogger perfLogger = SessionState.getPerfLogger(true);
        perfLogger.PerfLogBegin(CLASS_NAME, "Driver.run");
        perfLogger.PerfLogBegin(CLASS_NAME, "TimeToSubmit");
        if (!alreadyCompiled) {
            int ret2 = this.compileInternal(command);
            if (ret2 != 0) {
                return this.createProcessorResponse(ret2);
            }
        } else {
            this.plan.setQueryStartTime(perfLogger.getStartTime("Driver.run"));
        }
        HiveTxnManager txnManager = SessionState.get().getTxnMgr();
        this.ctx.setHiveTxnManager(txnManager);
        boolean startTxnImplicitly = false;
        if (txnManager.isTxnOpen() && !this.plan.getOperation().isAllowedInTransaction()) {
            assert (!txnManager.getAutoCommit()) : "didn't expect AC=true";
            return this.rollback(new CommandProcessorResponse(12, ErrorMsg.OP_NOT_ALLOWED_IN_TXN, null, this.plan.getOperationName(), Long.toString(txnManager.getCurrentTxnId())));
        }
        if (!txnManager.isTxnOpen() && this.plan.getOperation().isRequiresOpenTransaction()) {
            return this.rollback(new CommandProcessorResponse(12, ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN, null, this.plan.getOperationName()));
        }
        if (!txnManager.isTxnOpen() && this.plan.getOperation() == HiveOperation.QUERY && !txnManager.getAutoCommit()) {
            startTxnImplicitly = true;
        }
        if (txnManager.getAutoCommit() && this.plan.getOperation() == HiveOperation.START_TRANSACTION) {
            return this.rollback(new CommandProcessorResponse(12, ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT, null, this.plan.getOperationName()));
        }
        if (this.plan.getOperation() == HiveOperation.SET_AUTOCOMMIT) {
            try {
                if (this.plan.getAutoCommitValue().booleanValue() && !txnManager.getAutoCommit()) {
                    this.releaseLocksAndCommitOrRollback(true, null);
                    txnManager.setAutoCommit(true);
                } else if (!this.plan.getAutoCommitValue().booleanValue() && txnManager.getAutoCommit()) {
                    txnManager.setAutoCommit(false);
                }
            }
            catch (LockException e) {
                return this.handleHiveException(e, 12);
            }
        }
        if (this.requiresLock() && (ret = this.acquireLocksAndOpenTxn(startTxnImplicitly)) != 0) {
            return this.rollback(this.createProcessorResponse(ret));
        }
        ret = this.execute();
        if (ret != 0) {
            return this.rollback(this.createProcessorResponse(ret));
        }
        try {
            if (txnManager.getAutoCommit() || this.plan.getOperation() == HiveOperation.COMMIT) {
                this.releaseLocksAndCommitOrRollback(true, null);
            } else if (this.plan.getOperation() == HiveOperation.ROLLBACK) {
                this.releaseLocksAndCommitOrRollback(false, null);
            }
        }
        catch (LockException e) {
            return this.handleHiveException(e, 12);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "Driver.run");
        this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.EXECUTION, perfLogger.getStartTimes());
        this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.EXECUTION, perfLogger.getEndTimes());
        try {
            for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                driverRunHook.postDriverRun(hookContext);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return this.createProcessorResponse(12);
        }
        return this.createProcessorResponse(ret);
    }

    private CommandProcessorResponse rollback(CommandProcessorResponse cpr) {
        try {
            this.releaseLocksAndCommitOrRollback(false, null);
        }
        catch (LockException e) {
            LOG.error("rollback() FAILED: " + cpr);
            this.handleHiveException(e, 12, "Additional info in hive.log at \"rollback() FAILED\"");
        }
        return cpr;
    }

    private CommandProcessorResponse handleHiveException(HiveException e, int ret) {
        return this.handleHiveException(e, ret, null);
    }

    private CommandProcessorResponse handleHiveException(HiveException e, int ret, String rootMsg) {
        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
        if (rootMsg != null) {
            this.errorMessage = this.errorMessage + "\n" + rootMsg;
        }
        this.SQLState = e.getCanonicalErrorMsg() != null ? e.getCanonicalErrorMsg().getSQLState() : ErrorMsg.findSQLState(e.getMessage());
        this.downstreamError = e;
        console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        return this.createProcessorResponse(ret);
    }

    private boolean requiresLock() {
        if (!this.checkConcurrency()) {
            return false;
        }
        if (this.isExplicitLockOperation()) {
            return false;
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        LinkedList<Task<? extends Serializable>> taskQueue = new LinkedList<Task<? extends Serializable>>();
        taskQueue.addAll(this.plan.getRootTasks());
        while (taskQueue.peek() != null) {
            Task tsk = (Task)taskQueue.remove();
            if (tsk.requireLock()) {
                return true;
            }
            if (tsk instanceof ConditionalTask) {
                taskQueue.addAll(((ConditionalTask)tsk).getListTasks());
            }
            if (tsk.getChildTasks() == null) continue;
            taskQueue.addAll(tsk.getChildTasks());
        }
        return false;
    }

    private boolean isExplicitLockOperation() {
        HiveOperation currentOpt = this.plan.getOperation();
        if (currentOpt != null) {
            switch (currentOpt) {
                case LOCKDB: 
                case UNLOCKDB: 
                case LOCKTABLE: 
                case UNLOCKTABLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private CommandProcessorResponse createProcessorResponse(int ret) {
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
        this.queryDisplay.setErrorMessage(this.errorMessage);
        return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState, this.downstreamError);
    }

    private List<Hook> getHooks(HiveConf.ConfVars hookConfVar) throws Exception {
        return this.getHooks(hookConfVar, Hook.class);
    }

    private <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, Class<T> clazz) throws Exception {
        try {
            return HookUtils.getHooks(this.conf, hookConfVar, clazz);
        }
        catch (ClassNotFoundException e) {
            console.printError(hookConfVar.varname + " Class not found:" + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws CommandNeedRetryException {
        String queryId;
        PerfLogger perfLogger;
        block40: {
            perfLogger = SessionState.getPerfLogger();
            perfLogger.PerfLogBegin(CLASS_NAME, "Driver.execute");
            boolean noName = StringUtils.isEmpty(this.conf.get("mapreduce.job.name"));
            int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
            queryId = this.plan.getQueryId();
            String queryStr = this.conf.getQueryString();
            this.maxthreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.EXECPARALLETHREADNUMBER);
            HookContext hookContext = null;
            try {
                LOG.info("Executing command(queryId=" + queryId + "): " + queryStr);
                Hive.get().clearMetaCallTiming();
                this.plan.setStarted();
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().startQuery(queryStr, this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                    SessionState.get().getHiveHistory().logPlanProgress(this.plan);
                }
                this.resStream = null;
                SessionState ss = SessionState.get();
                hookContext = new HookContext(this.plan, this.queryState, this.ctx.getPathToCS(), ss.getUserName(), ss.getUserIpAddress(), this.operationId);
                hookContext.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
                for (Hook peh : this.getHooks(HiveConf.ConfVars.PREEXECHOOKS)) {
                    if (peh instanceof ExecuteWithHookContext) {
                        perfLogger.PerfLogBegin(CLASS_NAME, "PreHook." + peh.getClass().getName());
                        ((ExecuteWithHookContext)peh).run(hookContext);
                        perfLogger.PerfLogEnd(CLASS_NAME, "PreHook." + peh.getClass().getName());
                        continue;
                    }
                    if (!(peh instanceof PreExecute)) continue;
                    perfLogger.PerfLogBegin(CLASS_NAME, "PreHook." + peh.getClass().getName());
                    ((PreExecute)peh).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), Utils.getUGI());
                    perfLogger.PerfLogEnd(CLASS_NAME, "PreHook." + peh.getClass().getName());
                }
                this.setQueryDisplays(this.plan.getRootTasks());
                int mrJobs = Utilities.getMRTasks(this.plan.getRootTasks()).size();
                int jobs = mrJobs + Utilities.getTezTasks(this.plan.getRootTasks()).size() + Utilities.getSparkTasks(this.plan.getRootTasks()).size();
                if (jobs > 0) {
                    this.logMrWarning(mrJobs);
                    console.printInfo("Query ID = " + this.plan.getQueryId());
                    console.printInfo("Total jobs = " + jobs);
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobs));
                    SessionState.get().getHiveHistory().setIdToTableMap(this.plan.getIdToTableNameMap());
                }
                String jobname = Utilities.abbreviate(queryStr, maxlen - 6);
                DriverContext driverCxt = new DriverContext(this.ctx);
                driverCxt.prepare(this.plan);
                this.ctx.setHDFSCleanup(true);
                this.driverCxt = driverCxt;
                SessionState.get().setMapRedStats(new LinkedHashMap<String, MapRedStats>());
                SessionState.get().setStackTraces(new HashMap<String, List<List<String>>>());
                SessionState.get().setLocalMapRedErrors(new HashMap<String, List<String>>());
                for (Task<? extends Serializable> tsk : this.plan.getRootTasks()) {
                    assert (tsk.getParentTasks() == null || tsk.getParentTasks().isEmpty());
                    driverCxt.addToRunnable(tsk);
                }
                perfLogger.PerfLogEnd(CLASS_NAME, "TimeToSubmit");
                perfLogger.PerfLogBegin(CLASS_NAME, "runTasks");
                while (!this.destroyed && driverCxt.isRunning()) {
                    TaskRunner runner;
                    Task<? extends Serializable> task;
                    while ((task = driverCxt.getRunnable(this.maxthreads)) != null && (runner = this.launchTask(task, queryId, noName, jobname, jobs, driverCxt)).isRunning()) {
                    }
                    TaskRunner tskRun = driverCxt.pollFinished();
                    if (tskRun == null) continue;
                    hookContext.addCompleteTask(tskRun);
                    this.queryDisplay.setTaskResult(tskRun.getTask().getId(), tskRun.getTaskResult());
                    Task<? extends Serializable> task2 = tskRun.getTask();
                    TaskResult result = tskRun.getTaskResult();
                    int exitVal = result.getExitVal();
                    if (exitVal != 0) {
                        if (task2.ifRetryCmdWhenFail()) {
                            driverCxt.shutdown();
                            this.ctx.restoreOriginalTracker();
                            throw new CommandNeedRetryException();
                        }
                        Task<Serializable> backupTask = task2.getAndInitBackupTask();
                        if (backupTask != null) {
                            this.setErrorMsgAndDetail(exitVal, result.getTaskError(), task2);
                            console.printError(this.errorMessage);
                            this.errorMessage = "ATTEMPT: Execute BackupTask: " + backupTask.getClass().getName();
                            console.printError(this.errorMessage);
                            if (!DriverContext.isLaunchable(backupTask)) continue;
                            driverCxt.addToRunnable(backupTask);
                            continue;
                        }
                        this.setErrorMsgAndDetail(exitVal, result.getTaskError(), task2);
                        this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage + Strings.nullToEmpty(task2.getDiagnosticsMessage()), result.getTaskError());
                        this.SQLState = "08S01";
                        console.printError(this.errorMessage);
                        driverCxt.shutdown();
                        this.ctx.restoreOriginalTracker();
                        int n = exitVal;
                        return n;
                    }
                    driverCxt.finished(tskRun);
                    if (SessionState.get() != null) {
                        SessionState.get().getHiveHistory().setTaskProperty(queryId, task2.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
                        SessionState.get().getHiveHistory().endTask(queryId, task2);
                    }
                    if (task2.getChildTasks() == null) continue;
                    for (Task<Serializable> child : task2.getChildTasks()) {
                        if (!DriverContext.isLaunchable(child)) continue;
                        driverCxt.addToRunnable(child);
                    }
                }
                perfLogger.PerfLogEnd(CLASS_NAME, "runTasks");
                this.ctx.restoreOriginalTracker();
                if (driverCxt.isShutdown()) {
                    this.SQLState = "HY008";
                    this.errorMessage = "FAILED: Operation cancelled";
                    this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage, null);
                    console.printError(this.errorMessage);
                    int task = 1000;
                    return task;
                }
                LinkedHashSet<WriteEntity> remOutputs = new LinkedHashSet<WriteEntity>();
                for (WriteEntity writeEntity : this.plan.getOutputs()) {
                    if (writeEntity.isComplete()) continue;
                    remOutputs.add(writeEntity);
                }
                for (WriteEntity writeEntity : remOutputs) {
                    this.plan.getOutputs().remove(writeEntity);
                }
                hookContext.setHookType(HookContext.HookType.POST_EXEC_HOOK);
                for (Hook hook : this.getHooks(HiveConf.ConfVars.POSTEXECHOOKS)) {
                    if (hook instanceof ExecuteWithHookContext) {
                        perfLogger.PerfLogBegin(CLASS_NAME, "PostHook." + hook.getClass().getName());
                        ((ExecuteWithHookContext)hook).run(hookContext);
                        perfLogger.PerfLogEnd(CLASS_NAME, "PostHook." + hook.getClass().getName());
                        continue;
                    }
                    if (!(hook instanceof PostExecute)) continue;
                    perfLogger.PerfLogBegin(CLASS_NAME, "PostHook." + hook.getClass().getName());
                    ((PostExecute)hook).run(SessionState.get(), this.plan.getInputs(), this.plan.getOutputs(), SessionState.get() != null ? SessionState.get().getLineageState().getLineageInfo() : null, Utils.getUGI());
                    perfLogger.PerfLogEnd(CLASS_NAME, "PostHook." + hook.getClass().getName());
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
                    SessionState.get().getHiveHistory().printRowCount(queryId);
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().endQuery(queryId);
                }
                if (!noName) break block40;
            }
            catch (CommandNeedRetryException e) {
                throw e;
            }
            catch (Exception e) {
                this.ctx.restoreOriginalTracker();
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
                }
                this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                if (hookContext != null) {
                    try {
                        this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage, e);
                    }
                    catch (Exception t) {
                        LOG.warn("Failed to invoke failure hook", (Throwable)t);
                    }
                }
                this.SQLState = "08S01";
                this.downstreamError = e;
                console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                int n = 12;
                return n;
            }
            finally {
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().endQuery(queryId);
                }
                if (noName) {
                    this.conf.set("mapreduce.job.name", "");
                }
                double duration = (double)perfLogger.PerfLogEnd(CLASS_NAME, "Driver.execute") / 1000.0;
                ImmutableMap<String, Long> executionHMSTimings = this.dumpMetaCallTimingWithoutEx("execution");
                this.queryDisplay.setHmsTimings(QueryDisplay.Phase.EXECUTION, executionHMSTimings);
                Map<String, MapRedStats> stats = SessionState.get().getMapRedStats();
                if (stats != null && !stats.isEmpty()) {
                    long totalCpu = 0L;
                    console.printInfo("MapReduce Jobs Launched: ");
                    for (Map.Entry<String, MapRedStats> entry : stats.entrySet()) {
                        console.printInfo("Stage-" + entry.getKey() + ": " + entry.getValue());
                        totalCpu += entry.getValue().getCpuMSec();
                    }
                    console.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
                }
                LOG.info("Completed executing command(queryId=" + queryId + "); Time taken: " + duration + " seconds");
            }
            this.conf.set("mapreduce.job.name", "");
        }
        double duration = (double)perfLogger.PerfLogEnd(CLASS_NAME, "Driver.execute") / 1000.0;
        ImmutableMap<String, Long> executionHMSTimings = this.dumpMetaCallTimingWithoutEx("execution");
        this.queryDisplay.setHmsTimings(QueryDisplay.Phase.EXECUTION, executionHMSTimings);
        Map<String, MapRedStats> stats = SessionState.get().getMapRedStats();
        if (stats != null && !stats.isEmpty()) {
            long totalCpu = 0L;
            console.printInfo("MapReduce Jobs Launched: ");
            for (Map.Entry entry : stats.entrySet()) {
                console.printInfo("Stage-" + (String)entry.getKey() + ": " + entry.getValue());
                totalCpu += ((MapRedStats)entry.getValue()).getCpuMSec();
            }
            console.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
        }
        LOG.info("Completed executing command(queryId=" + queryId + "); Time taken: " + duration + " seconds");
        this.releasePlan(this.plan);
        if (console != null) {
            console.printInfo("OK");
        }
        return 0;
    }

    private synchronized void releasePlan(QueryPlan plan) {
        if (plan != null) {
            plan.setDone();
            if (SessionState.get() != null) {
                try {
                    SessionState.get().getHiveHistory().logPlanProgress(plan);
                }
                catch (Exception e) {
                    LOG.warn("Could not log query plan progress", (Throwable)e);
                }
            }
        }
    }

    private void setQueryDisplays(List<Task<? extends Serializable>> tasks) {
        if (tasks != null) {
            for (Task<? extends Serializable> task : tasks) {
                task.setQueryDisplay(this.queryDisplay);
                this.setQueryDisplays(task.getDependentTasks());
            }
        }
    }

    private void logMrWarning(int mrJobs) {
        if (mrJobs <= 0 || !"mr".equals(HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            return;
        }
        String warning = HiveConf.generateMrDeprecationWarning();
        LOG.warn(warning);
        warning = "WARNING: " + warning;
        console.printInfo(warning);
        OperationLog ol = OperationLog.getCurrentOperationLog();
        if (ol != null) {
            ol.writeOperationLog(OperationLog.LoggingLevel.EXECUTION, warning + "\n");
        }
    }

    private void setErrorMsgAndDetail(int exitVal, Throwable downstreamError, Task tsk) {
        this.downstreamError = downstreamError;
        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
        if (downstreamError != null) {
            this.errorMessage = this.errorMessage + ". " + downstreamError.getMessage();
        } else {
            ErrorMsg em = ErrorMsg.getErrorMsg(exitVal);
            if (em != null) {
                this.errorMessage = this.errorMessage + ". " + em.getMsg();
            }
        }
    }

    private void invokeFailureHooks(PerfLogger perfLogger, HookContext hookContext, String errorMessage, Throwable exception) throws Exception {
        hookContext.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
        hookContext.setErrorMessage(errorMessage);
        hookContext.setException(exception);
        for (Hook ofh : this.getHooks(HiveConf.ConfVars.ONFAILUREHOOKS)) {
            perfLogger.PerfLogBegin(CLASS_NAME, "FailureHook." + ofh.getClass().getName());
            ((ExecuteWithHookContext)ofh).run(hookContext);
            perfLogger.PerfLogEnd(CLASS_NAME, "FailureHook." + ofh.getClass().getName());
        }
    }

    private TaskRunner launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, String jobname, int jobs, DriverContext cxt) throws HiveException {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.set("mapreduce.job.name", jobname + "(" + tsk.getId() + ")");
            }
            this.conf.set("mapreduce.workflow.node.name", tsk.getId());
            Utilities.setWorkflowAdjacencies(this.conf, this.plan);
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.queryState, this.plan, cxt, this.ctx.getOpContext());
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        cxt.launching(tskRun);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting task [" + tsk + "] in parallel");
            }
            tskRun.setOperationLog(OperationLog.getCurrentOperationLog());
            tskRun.start();
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting task [" + tsk + "] in serial mode");
            }
            tskRun.runSequential();
        }
        return tskRun;
    }

    public boolean isFetchingTable() {
        return this.fetchTask != null;
    }

    public boolean getResults(List res) throws IOException, CommandNeedRetryException {
        if (this.destroyed) {
            throw new IOException("FAILED: Operation cancelled");
        }
        if (this.isFetchingTable()) {
            if (((FetchWork)this.fetchTask.getWork()).isHiveServerQuery() && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS) && this.fetchTask.getTblDesc().getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName())) {
                this.maxRows = 1;
            }
            this.fetchTask.setMaxRows(this.maxRows);
            return this.fetchTask.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getLength() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getLength(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
                row = null;
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public void resetFetch() throws IOException {
        if (this.isFetchingTable()) {
            try {
                this.fetchTask.clearFetch();
            }
            catch (Exception e) {
                throw new IOException("Error closing the current fetch task", e);
            }
            this.fetchTask.initialize(this.queryState, null, null, this.ctx.getOpContext());
        } else {
            this.ctx.resetStream();
            this.resStream = null;
        }
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public int close() {
        try {
            try {
                this.releaseResources();
            }
            catch (Exception e) {
                LOG.info("Exception while releasing resources", (Throwable)e);
            }
            if (this.fetchTask != null) {
                try {
                    this.fetchTask.clearFetch();
                }
                catch (Exception e) {
                    LOG.debug(" Exception while clearing the Fetch task ", (Throwable)e);
                }
                this.fetchTask = null;
            }
            if (this.ctx != null) {
                this.ctx.clear();
                if (this.ctx.getHiveLocks() != null) {
                    this.hiveLocks.addAll(this.ctx.getHiveLocks());
                    this.ctx.setHiveLocks(null);
                }
                this.ctx = null;
            }
            if (null != this.resStream) {
                try {
                    ((FSDataInputStream)this.resStream).close();
                }
                catch (Exception e) {
                    LOG.debug(" Exception while closing the resStream ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            console.printError("FAILED: Hive Internal Error: " + Utilities.getNameMessage(e) + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 13;
        }
        return 0;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (!this.hiveLocks.isEmpty()) {
            try {
                this.releaseLocksAndCommitOrRollback(false, null);
            }
            catch (LockException e) {
                LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
            }
        }
        ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    public QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    public void setOperationId(String opId) {
        this.operationId = opId;
    }
}

