/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueContainer {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueContainer.class);
    @VisibleForTesting
    static final int IN_MEMORY_NUM_ROWS = 1024;
    private ObjectPair<HiveKey, BytesWritable>[] readBuffer = new ObjectPair[1024];
    private boolean readBufferUsed = false;
    private int rowsInReadBuffer = 0;
    private int readCursor = 0;
    private int rowsOnDisk = 0;
    private File parentDir;
    private File tmpFile;
    private Input input;
    private Output output;

    public KeyValueContainer(String spillLocalDirs) {
        for (int i = 0; i < 1024; ++i) {
            this.readBuffer[i] = new ObjectPair();
        }
        try {
            this.setupOutput(spillLocalDirs);
        }
        catch (IOException | HiveException e) {
            throw new RuntimeException("Failed to create temporary output file on disk", e);
        }
    }

    private void setupOutput(String spillLocalDirs) throws IOException, HiveException {
        FileOutputStream fos = null;
        try {
            if (this.parentDir == null) {
                this.parentDir = FileUtils.createLocalDirsTempFile(spillLocalDirs, "key-value-container", "", true);
                this.parentDir.deleteOnExit();
            }
            if (this.tmpFile == null || this.input != null) {
                this.tmpFile = File.createTempFile("KeyValueContainer", ".tmp", this.parentDir);
                LOG.info("KeyValueContainer created temp file " + this.tmpFile.getAbsolutePath());
                this.tmpFile.deleteOnExit();
            }
            fos = new FileOutputStream(this.tmpFile);
            this.output = new Output(fos);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        finally {
            if (this.output == null && fos != null) {
                fos.close();
            }
        }
    }

    private BytesWritable readValue(Input input) {
        return new BytesWritable(input.readBytes(input.readInt()));
    }

    private void writeValue(Output output, BytesWritable bytesWritable) {
        int size = bytesWritable.getLength();
        output.writeInt(size);
        output.writeBytes(bytesWritable.getBytes(), 0, size);
    }

    private HiveKey readHiveKey(Input input) {
        HiveKey hiveKey = new HiveKey(input.readBytes(input.readInt()), input.readInt());
        hiveKey.setDistKeyLength(input.readInt());
        return hiveKey;
    }

    private void writeHiveKey(Output output, HiveKey hiveKey) {
        int size = hiveKey.getLength();
        output.writeInt(size);
        output.writeBytes(hiveKey.getBytes(), 0, size);
        output.writeInt(0);
        output.writeInt(hiveKey.getDistKeyLength());
    }

    public void add(HiveKey key, BytesWritable value) {
        this.writeHiveKey(this.output, key);
        this.writeValue(this.output, value);
        ++this.rowsOnDisk;
    }

    public void clear() {
        this.rowsOnDisk = 0;
        this.rowsInReadBuffer = 0;
        this.readCursor = 0;
        this.readBufferUsed = false;
        if (this.parentDir != null) {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.input = null;
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                this.output = null;
            }
            try {
                FileUtil.fullyDelete((File)this.parentDir);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.parentDir = null;
            this.tmpFile = null;
        }
    }

    public boolean hasNext() {
        return this.readBufferUsed || this.rowsOnDisk > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPair<HiveKey, BytesWritable> next() {
        Preconditions.checkState(this.hasNext());
        if (!this.readBufferUsed) {
            try {
                if (this.input == null && this.output != null) {
                    this.output.close();
                    this.output = null;
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(this.tmpFile);
                        this.input = new Input(fis);
                    }
                    finally {
                        if (this.input == null && fis != null) {
                            fis.close();
                        }
                    }
                }
                if (this.input != null) {
                    this.rowsInReadBuffer = this.rowsOnDisk >= 1024 ? 1024 : this.rowsOnDisk;
                    for (int i = 0; i < this.rowsInReadBuffer; ++i) {
                        ObjectPair<HiveKey, BytesWritable> pair = this.readBuffer[i];
                        pair.setFirst(this.readHiveKey(this.input));
                        pair.setSecond(this.readValue(this.input));
                    }
                    if (this.input.eof()) {
                        this.input.close();
                        this.input = null;
                    }
                    this.readBufferUsed = true;
                    this.readCursor = 0;
                    this.rowsOnDisk -= this.rowsInReadBuffer;
                }
            }
            catch (Exception e) {
                this.clear();
                throw new RuntimeException("Failed to load key/value pairs from disk", e);
            }
        }
        ObjectPair<HiveKey, BytesWritable> row = this.readBuffer[this.readCursor];
        if (++this.readCursor >= this.rowsInReadBuffer) {
            this.readBufferUsed = false;
            this.rowsInReadBuffer = 0;
            this.readCursor = 0;
        }
        return row;
    }

    public int numRowsInReadBuffer() {
        return this.rowsInReadBuffer;
    }

    public int size() {
        return this.rowsInReadBuffer + this.rowsOnDisk;
    }
}

