/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.spark.client.JobHandle;
import org.apache.spark.JobExecutionStatus;

public class RemoteSparkJobMonitor
extends SparkJobMonitor {
    private RemoteSparkJobStatus sparkJobStatus;
    private final HiveConf hiveConf;

    public RemoteSparkJobMonitor(HiveConf hiveConf, RemoteSparkJobStatus sparkJobStatus) {
        super(hiveConf);
        this.sparkJobStatus = sparkJobStatus;
        this.hiveConf = hiveConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int startMonitor() {
        int rc;
        block15: {
            boolean running = false;
            boolean done = false;
            rc = 0;
            Map<String, SparkStageProgress> lastProgressMap = null;
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkRunJob");
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkSubmitToRunning");
            long startTime = System.currentTimeMillis();
            try {
                while (true) {
                    try {
                        do {
                            JobHandle.State state = this.sparkJobStatus.getRemoteJobState();
                            if (LOG.isDebugEnabled()) {
                                console.printInfo("state = " + (Object)((Object)state));
                            }
                            switch (state) {
                                case SENT: 
                                case QUEUED: {
                                    long timeCount = (System.currentTimeMillis() - startTime) / 1000L;
                                    if (timeCount <= this.monitorTimeoutInteval) break;
                                    console.printError("Job hasn't been submitted after " + timeCount + "s." + " Aborting it.\nPossible reasons include network issues, " + "errors in remote driver or the cluster has no available resources, etc.\n" + "Please check YARN or Spark driver's logs for further information.");
                                    console.printError("Status: " + (Object)((Object)state));
                                    running = false;
                                    done = true;
                                    rc = 2;
                                    break;
                                }
                                case STARTED: {
                                    JobExecutionStatus sparkJobState = this.sparkJobStatus.getState();
                                    if (sparkJobState != JobExecutionStatus.RUNNING) break;
                                    Map<String, SparkStageProgress> progressMap = this.sparkJobStatus.getSparkStageProgress();
                                    if (!running) {
                                        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkSubmitToRunning");
                                        this.printAppInfo();
                                        console.printInfo("\nQuery Hive on Spark job[" + this.sparkJobStatus.getJobId() + "] stages:");
                                        for (int stageId : this.sparkJobStatus.getStageIds()) {
                                            console.printInfo(Integer.toString(stageId));
                                        }
                                        console.printInfo("\nStatus: Running (Hive on Spark job[" + this.sparkJobStatus.getJobId() + "])");
                                        running = true;
                                        console.printInfo("Job Progress Format\nCurrentTime StageId_StageAttemptId: SucceededTasksCount(+RunningTasksCount-FailedTasksCount)/TotalTasksCount [StageCost]");
                                    }
                                    this.printStatus(progressMap, lastProgressMap);
                                    lastProgressMap = progressMap;
                                    break;
                                }
                                case SUCCEEDED: {
                                    Map<String, SparkStageProgress> progressMap = this.sparkJobStatus.getSparkStageProgress();
                                    this.printStatus(progressMap, lastProgressMap);
                                    lastProgressMap = progressMap;
                                    double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                                    console.printInfo("Status: Finished successfully in " + String.format("%.2f seconds", duration));
                                    running = false;
                                    done = true;
                                    break;
                                }
                                case FAILED: {
                                    console.printError("Status: Failed");
                                    running = false;
                                    done = true;
                                    rc = 3;
                                    break;
                                }
                            }
                            if (done) continue;
                            Thread.sleep(1000L);
                        } while (!done);
                    }
                    catch (Exception e) {
                        String msg = " with exception '" + Utilities.getNameMessage(e) + "'";
                        msg = "Failed to monitor Job[ " + this.sparkJobStatus.getJobId() + "]" + msg;
                        LOG.error(msg, (Throwable)e);
                        console.printError(msg, "\n" + StringUtils.stringifyException((Throwable)e));
                        rc = 1;
                        if (!(done = true)) continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (done) break block15;
                throw throwable;
            }
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkRunJob");
        return rc;
    }

    private void printAppInfo() {
        String appID;
        String sparkMaster = this.hiveConf.get("spark.master");
        if (sparkMaster != null && sparkMaster.startsWith("yarn") && (appID = this.sparkJobStatus.getAppID()) != null) {
            console.printInfo("Running with YARN Application = " + appID);
            console.printInfo("Kill Command = " + HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.YARNBIN) + " application -kill " + appID);
        }
    }
}

