/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.Metastore;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileFormatProxy
implements FileFormatProxy {
    private static final Logger LOG = LoggerFactory.getLogger(OrcFileFormatProxy.class);

    @Override
    public Metastore.SplitInfos applySargToMetadata(SearchArgument sarg, ByteBuffer fileMetadata) throws IOException {
        ReaderImpl.FooterInfo fi = ReaderImpl.extractMetaInfoFromFooter(fileMetadata, null);
        OrcProto.Footer footer = fi.getFooter();
        int stripeCount = footer.getStripesCount();
        boolean[] result = OrcInputFormat.pickStripesViaTranslatedSarg(sarg, fi.getFileMetaInfo().getWriterVersion(), footer.getTypesList(), fi.getMetadata(), stripeCount);
        Metastore.SplitInfos.Builder sb = Metastore.SplitInfos.newBuilder();
        List<StripeInformation> stripes = fi.getStripes();
        boolean isEliminated = true;
        for (int i = 0; i < result.length; ++i) {
            if (result != null && !result[i]) continue;
            isEliminated = false;
            StripeInformation si = stripes.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug("PPD is adding a split " + i + ": " + si.getOffset() + ", " + si.getLength());
            }
            sb.addInfos(Metastore.SplitInfo.newBuilder().setIndex(i).setOffset(si.getOffset()).setLength(si.getLength()));
        }
        return isEliminated ? null : sb.build();
    }

    @Override
    public ByteBuffer[] getAddedColumnsToCache() {
        return null;
    }

    @Override
    public ByteBuffer[][] getAddedValuesToCache(List<ByteBuffer> metadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getMetadataToCache(FileSystem fs, Path path, ByteBuffer[] addedVals) throws IOException {
        return OrcFile.createReader(fs, path).getSerializedFileFooter();
    }
}

