/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.truncate;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.Throttle;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateMapper;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class ColumnTruncateTask
extends Task<ColumnTruncateWork>
implements Serializable,
HadoopJobExecHook {
    private static final long serialVersionUID = 1L;
    protected transient JobConf job;
    protected HadoopJobExecHelper jobExecHelper;
    boolean success = true;

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, driverContext, opContext);
        this.job = new JobConf((Configuration)this.conf, ColumnTruncateTask.class);
        this.jobExecHelper = new HadoopJobExecHelper(queryState, this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int execute(DriverContext driverContext) {
        HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, BucketizedHiveInputFormat.class.getName());
        this.success = true;
        HiveFileFormatUtils.prepareJobOutput(this.job);
        this.job.setOutputFormat(HiveOutputFormatImpl.class);
        this.job.setMapperClass(((ColumnTruncateWork)this.work).getMapperClass());
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        try {
            if (ctx == null) {
                ctx = new Context((Configuration)this.job);
                ctxCreated = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.console.printError("Error launching map-reduce job", "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 5;
        }
        this.job.setMapOutputKeyClass(NullWritable.class);
        this.job.setMapOutputValueClass(NullWritable.class);
        if (((ColumnTruncateWork)this.work).getNumMapTasks() != null) {
            this.job.setNumMapTasks(((ColumnTruncateWork)this.work).getNumMapTasks().intValue());
        }
        this.job.setNumReduceTasks(0);
        if (((ColumnTruncateWork)this.work).getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZE, ((ColumnTruncateWork)this.work).getMinSplitSize());
        }
        if (((ColumnTruncateWork)this.work).getInputformat() != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, ((ColumnTruncateWork)this.work).getInputformat());
        }
        String inpFormat = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT);
        LOG.info("Using " + inpFormat);
        try {
            this.job.setInputFormat(JavaUtils.loadClass(inpFormat));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Path outputPath = ((ColumnTruncateWork)this.work).getOutputDir();
        Path tempOutPath = Utilities.toTempPath(outputPath);
        try {
            FileSystem fs = tempOutPath.getFileSystem((Configuration)this.job);
            if (!fs.exists(tempOutPath)) {
                fs.mkdirs(tempOutPath);
            }
        }
        catch (IOException e) {
            this.console.printError("Can't make path " + outputPath + " : " + e.getMessage());
            return 6;
        }
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(NullWritable.class);
        int returnVal = 0;
        RunningJob rj = null;
        boolean noName = StringUtils.isEmpty(this.job.get("mapreduce.job.name"));
        String jobName = null;
        if (noName && this.getQueryPlan() != null) {
            int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
            jobName = Utilities.abbreviate(this.getQueryPlan().getQueryStr(), maxlen - 6);
        }
        if (noName) {
            this.job.set("mapreduce.job.name", jobName != null ? jobName : "JOB" + Utilities.randGen.nextInt());
        }
        this.addInputPaths(this.job, (ColumnTruncateWork)this.work);
        MapredWork mrWork = new MapredWork();
        mrWork.setMapWork((MapWork)this.work);
        Utilities.setMapRedWork((Configuration)this.job, mrWork, ctx.getMRTmpPath());
        String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
        }
        JobClient jc = new JobClient(this.job);
        String addedJars = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR);
        if (!addedJars.isEmpty()) {
            this.job.set("tmpjars", addedJars);
        }
        Throttle.checkJobTracker(this.job, LOG);
        rj = jc.submitJob(this.job);
        returnVal = this.jobExecHelper.progress(rj, jc, ctx);
        this.success = returnVal == 0;
        try {
            if (ctxCreated) {
                ctx.clear();
            }
            if (rj != null) {
                if (returnVal != 0) {
                    rj.killJob();
                }
                this.jobID = rj.getID().toString();
            }
            ColumnTruncateMapper.jobClose(outputPath, this.success, this.job, this.console, ((ColumnTruncateWork)this.work).getDynPartCtx(), null);
        }
        catch (Exception e) {
            LOG.warn("Failed while cleaning up ", (Throwable)e);
        }
        finally {
            HadoopJobExecHelper.runningJobs.remove(rj);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                String mesg = " with exception '" + Utilities.getNameMessage(e) + "'";
                mesg = rj != null ? "Ended Job = " + rj.getJobID() + mesg : "Job Submission failed" + mesg;
                this.console.printError(mesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                this.success = false;
                returnVal = 1;
            }
            catch (Throwable throwable) {
                try {
                    if (ctxCreated) {
                        ctx.clear();
                    }
                    if (rj != null) {
                        if (returnVal != 0) {
                            rj.killJob();
                        }
                        this.jobID = rj.getID().toString();
                    }
                    ColumnTruncateMapper.jobClose(outputPath, this.success, this.job, this.console, ((ColumnTruncateWork)this.work).getDynPartCtx(), null);
                }
                catch (Exception e2) {
                    LOG.warn("Failed while cleaning up ", (Throwable)e2);
                }
                finally {
                    HadoopJobExecHelper.runningJobs.remove(rj);
                }
                throw throwable;
            }
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null) {
                    if (returnVal != 0) {
                        rj.killJob();
                    }
                    this.jobID = rj.getID().toString();
                }
                ColumnTruncateMapper.jobClose(outputPath, this.success, this.job, this.console, ((ColumnTruncateWork)this.work).getDynPartCtx(), null);
            }
            catch (Exception e3) {
                LOG.warn("Failed while cleaning up ", (Throwable)e3);
            }
            finally {
                HadoopJobExecHelper.runningJobs.remove(rj);
            }
        }
        return returnVal;
    }

    private void addInputPaths(JobConf job, ColumnTruncateWork work) {
        FileInputFormat.addInputPath((JobConf)job, (Path)work.getInputDir());
    }

    @Override
    public String getName() {
        return "RCFile ColumnTruncate";
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        return false;
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
    }
}

