/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdPredicates;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;

public class HiveRelMdPredicates
extends RelMdPredicates {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.PREDICATES.method, (Object)((Object)new HiveRelMdPredicates()));
    private static final List<RexNode> EMPTY_LIST = ImmutableList.of();

    public RelOptPredicateList getPredicates(Project project, RelMetadataQuery mq) {
        RelNode child = project.getInput();
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelOptPredicateList childInfo = mq.getPulledUpPredicates(child);
        ArrayList<RexNode> projectPullUpPredicates = new ArrayList<RexNode>();
        HashMultimap inpIndxToOutIndxMap = HashMultimap.create();
        ImmutableBitSet.Builder columnsMappedBuilder = ImmutableBitSet.builder();
        Mapping m = Mappings.create((MappingType)MappingType.PARTIAL_FUNCTION, (int)child.getRowType().getFieldCount(), (int)project.getRowType().getFieldCount());
        for (Ord o : Ord.zip((List)project.getProjects())) {
            if (!(o.e instanceof RexInputRef)) continue;
            int sIdx = ((RexInputRef)o.e).getIndex();
            m.set(sIdx, o.i);
            inpIndxToOutIndxMap.put((Object)sIdx, (Object)o.i);
            columnsMappedBuilder.set(sIdx);
        }
        ImmutableBitSet columnsMapped = columnsMappedBuilder.build();
        for (RexNode r : childInfo.pulledUpPredicates) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits((RexNode)r);
            if (!columnsMapped.contains(rCols)) continue;
            r = (RexNode)r.accept((RexVisitor)new RexPermuteInputsShuttle((Mappings.TargetMapping)m, new RelNode[]{child}));
            projectPullUpPredicates.add(r);
        }
        for (Ord expr : Ord.zip((List)project.getProjects())) {
            if (RexLiteral.isNullLiteral((RexNode)((RexNode)expr.e))) {
                projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{rexBuilder.makeInputRef((RelNode)project, expr.i)}));
                continue;
            }
            if (expr.e instanceof RexLiteral) {
                RexLiteral literal = (RexLiteral)expr.e;
                projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef((RelNode)project, expr.i), literal}));
                continue;
            }
            if (!(expr.e instanceof RexCall) || !HiveCalciteUtil.isDeterministicFuncOnLiterals((RexNode)expr.e)) continue;
            projectPullUpPredicates.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeInputRef((RelNode)project, expr.i), (RexNode)expr.e}));
        }
        return RelOptPredicateList.of(projectPullUpPredicates);
    }

    public RelOptPredicateList getPredicates(Union union, RelMetadataQuery mq) {
        RexBuilder rB = union.getCluster().getRexBuilder();
        LinkedHashMap finalPreds = new LinkedHashMap();
        LinkedHashMap<String, Object> finalResidualPreds = new LinkedHashMap<String, Object>();
        for (int i = 0; i < union.getInputs().size(); ++i) {
            RelNode input = (RelNode)union.getInputs().get(i);
            RelOptPredicateList info = mq.getPulledUpPredicates(input);
            if (info.pulledUpPredicates.isEmpty()) {
                return RelOptPredicateList.EMPTY;
            }
            LinkedHashMap<String, RexNode> preds = new LinkedHashMap<String, RexNode>();
            for (RexNode pred : info.pulledUpPredicates) {
                String predString = pred.toString();
                if (i == 0) {
                    preds.put(predString, pred);
                    continue;
                }
                if (finalPreds.containsKey(predString)) {
                    preds.put(predString, pred);
                    continue;
                }
                finalResidualPreds.put(predString, pred);
            }
            for (Map.Entry e : finalPreds.entrySet()) {
                if (preds.containsKey(e.getKey())) continue;
                finalResidualPreds.put((String)e.getKey(), e.getValue());
            }
            finalPreds = preds;
        }
        ArrayList preds = new ArrayList(finalPreds.values());
        RexNode disjPred = RexUtil.composeDisjunction((RexBuilder)rB, finalResidualPreds.values(), (boolean)true);
        if (disjPred != null) {
            preds.add(disjPred);
        }
        return RelOptPredicateList.of(preds);
    }
}

