/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierForASTConv;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ASTConverter.class);
    private final RelNode root;
    private final HiveAST hiveAST;
    private RelNode from;
    private Filter where;
    private Aggregate groupBy;
    private Filter having;
    private Project select;
    private Sort orderLimit;
    private Schema schema;
    private long derivedTableCount;

    ASTConverter(RelNode root, long dtCounterInitVal) {
        this.root = root;
        this.hiveAST = new HiveAST();
        this.derivedTableCount = dtCounterInitVal;
    }

    public static ASTNode convert(RelNode relNode, List<FieldSchema> resultSchema) throws CalciteSemanticException {
        RelNode root = PlanModifierForASTConv.convertOpTree(relNode, resultSchema);
        ASTConverter c = new ASTConverter(root, 0L);
        return c.convert();
    }

    private ASTNode convert() throws CalciteSemanticException {
        ASTBuilder b;
        ASTNode cond;
        new QBVisitor().go(this.root);
        QueryBlockInfo qb = this.convertSource(this.from);
        this.schema = qb.schema;
        this.hiveAST.from = ASTBuilder.construct(748, "TOK_FROM").add(qb.ast).node();
        if (this.where != null) {
            cond = (ASTNode)this.where.getCondition().accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema));
            this.hiveAST.where = ASTBuilder.where(cond);
        }
        if (this.groupBy != null) {
            boolean groupingSetsExpression = false;
            if (this.groupBy.indicator) {
                Aggregate.Group aggregateType = Aggregate.Group.induce((ImmutableBitSet)this.groupBy.getGroupSet(), (List)this.groupBy.getGroupSets());
                if (aggregateType == Aggregate.Group.ROLLUP) {
                    b = ASTBuilder.construct(876, "TOK_ROLLUP_GROUPBY");
                } else if (aggregateType == Aggregate.Group.CUBE) {
                    b = ASTBuilder.construct(711, "TOK_CUBE_GROUPBY");
                } else {
                    b = ASTBuilder.construct(760, "TOK_GROUPING_SETS");
                    groupingSetsExpression = true;
                }
            } else {
                b = ASTBuilder.construct(759, "TOK_GROUPBY");
            }
            Iterator i$ = this.groupBy.getGroupSet().iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                RexInputRef iRef = new RexInputRef(i, this.groupBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                b.add((ASTNode)iRef.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema)));
            }
            if (groupingSetsExpression) {
                for (ImmutableBitSet groupSet : this.groupBy.getGroupSets()) {
                    ASTBuilder expression = ASTBuilder.construct(761, "TOK_GROUPING_SETS_EXPRESSION");
                    Iterator i$2 = groupSet.iterator();
                    while (i$2.hasNext()) {
                        int i = (Integer)i$2.next();
                        RexInputRef iRef = new RexInputRef(i, this.groupBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                        expression.add((ASTNode)iRef.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema)));
                    }
                    b.add(expression);
                }
            }
            if (!this.groupBy.getGroupSet().isEmpty()) {
                this.hiveAST.groupBy = b.node();
            }
            this.schema = new Schema(this.schema, this.groupBy);
        }
        if (this.having != null) {
            cond = (ASTNode)this.having.getCondition().accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema));
            this.hiveAST.having = ASTBuilder.having(cond);
        }
        b = ASTBuilder.construct(878, "TOK_SELECT");
        if (this.select.getChildExps().isEmpty()) {
            RexLiteral r = this.select.getCluster().getRexBuilder().makeExactLiteral(new BigDecimal(1));
            ASTNode selectExpr = ASTBuilder.selectExpr(ASTBuilder.literal(r), "1");
            b.add(selectExpr);
        } else {
            int i = 0;
            for (RexNode r : this.select.getChildExps()) {
                if (RexUtil.isNull((RexNode)r) && r.getType().getSqlTypeName() != SqlTypeName.NULL) {
                    r = this.select.getCluster().getRexBuilder().makeAbstractCast(r.getType(), r);
                }
                ASTNode expr = (ASTNode)r.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema, r instanceof RexLiteral));
                String alias = (String)this.select.getRowType().getFieldNames().get(i++);
                ASTNode selectExpr = ASTBuilder.selectExpr(expr, alias);
                b.add(selectExpr);
            }
        }
        this.hiveAST.select = b.node();
        this.convertOrderLimitToASTNode((HiveSortLimit)this.orderLimit);
        return this.hiveAST.getAST();
    }

    private void convertOrderLimitToASTNode(HiveSortLimit order) {
        if (order != null) {
            HiveSortLimit hiveSortLimit = order;
            if (!hiveSortLimit.getCollation().getFieldCollations().isEmpty()) {
                ASTNode orderAst = ASTBuilder.createAST(835, "TOK_ORDERBY");
                this.schema = new Schema(hiveSortLimit);
                Map<Integer, RexNode> obRefToCallMap = hiveSortLimit.getInputRefToCallMap();
                for (RelFieldCollation c : hiveSortLimit.getCollation().getFieldCollations()) {
                    ASTNode astCol;
                    ASTNode nullDirectionAST;
                    ASTNode directionAST;
                    ASTNode aSTNode = directionAST = c.getDirection() == RelFieldCollation.Direction.ASCENDING ? ASTBuilder.createAST(955, "TOK_TABSORTCOLNAMEASC") : ASTBuilder.createAST(956, "TOK_TABSORTCOLNAMEDESC");
                    if (c.nullDirection == RelFieldCollation.NullDirection.FIRST) {
                        nullDirectionAST = ASTBuilder.createAST(812, "TOK_NULLS_FIRST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else if (c.nullDirection == RelFieldCollation.NullDirection.LAST) {
                        nullDirectionAST = ASTBuilder.createAST(813, "TOK_NULLS_LAST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else if (c.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                        nullDirectionAST = ASTBuilder.createAST(812, "TOK_NULLS_FIRST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else {
                        nullDirectionAST = ASTBuilder.createAST(813, "TOK_NULLS_LAST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    }
                    RexNode obExpr = null;
                    if (obRefToCallMap != null) {
                        obExpr = obRefToCallMap.get(c.getFieldIndex());
                    }
                    if (obExpr != null) {
                        astCol = (ASTNode)obExpr.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema));
                    } else {
                        ColumnInfo cI = (ColumnInfo)this.schema.get(c.getFieldIndex());
                        astCol = ASTBuilder.unqualifiedName(cI.column);
                    }
                    nullDirectionAST.addChild((Tree)astCol);
                    orderAst.addChild((Tree)directionAST);
                }
                this.hiveAST.order = orderAst;
            }
            RexNode offsetExpr = hiveSortLimit.getOffsetExpr();
            RexNode fetchExpr = hiveSortLimit.getFetchExpr();
            if (fetchExpr != null) {
                Object offset = offsetExpr == null ? new Integer(0) : ((RexLiteral)offsetExpr).getValue2();
                Object fetch = ((RexLiteral)fetchExpr).getValue2();
                this.hiveAST.limit = ASTBuilder.limit(offset, fetch);
            }
        }
    }

    private Schema getRowSchema(String tblAlias) {
        return new Schema(this.select, tblAlias);
    }

    private QueryBlockInfo convertSource(RelNode r) throws CalciteSemanticException {
        ASTNode ast;
        Schema s;
        if (r instanceof TableScan) {
            TableScan f = (TableScan)r;
            s = new Schema(f);
            ast = ASTBuilder.table(f);
        } else if (r instanceof Join) {
            Join join = (Join)r;
            QueryBlockInfo left = this.convertSource(join.getLeft());
            QueryBlockInfo right = this.convertSource(join.getRight());
            s = new Schema(left.schema, right.schema);
            ASTNode cond = (ASTNode)join.getCondition().accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(s));
            boolean semiJoin = join instanceof SemiJoin;
            if (join.getRight() instanceof Join) {
                JoinRelType type = join.getJoinType() == JoinRelType.LEFT ? JoinRelType.RIGHT : (join.getJoinType() == JoinRelType.RIGHT ? JoinRelType.LEFT : join.getJoinType());
                ast = ASTBuilder.join(right.ast, left.ast, type, cond, semiJoin);
            } else {
                ast = ASTBuilder.join(left.ast, right.ast, join.getJoinType(), cond, semiJoin);
            }
            if (semiJoin) {
                s = left.schema;
            }
        } else if (r instanceof Union) {
            RelNode leftInput = ((Union)r).getInput(0);
            RelNode rightInput = ((Union)r).getInput(1);
            ASTConverter leftConv = new ASTConverter(leftInput, this.derivedTableCount);
            ASTConverter rightConv = new ASTConverter(rightInput, this.derivedTableCount);
            ASTNode leftAST = leftConv.convert();
            ASTNode rightAST = rightConv.convert();
            ASTNode unionAST = this.getUnionAllAST(leftAST, rightAST);
            String sqAlias = this.nextAlias();
            ast = ASTBuilder.subQuery(unionAST, sqAlias);
            s = new Schema((Union)r, sqAlias);
        } else {
            ASTConverter src = new ASTConverter(r, this.derivedTableCount);
            ASTNode srcAST = src.convert();
            String sqAlias = this.nextAlias();
            s = src.getRowSchema(sqAlias);
            ast = ASTBuilder.subQuery(srcAST, sqAlias);
        }
        return new QueryBlockInfo(s, ast);
    }

    private String nextAlias() {
        String tabAlias = String.format("$hdt$_%d", this.derivedTableCount);
        ++this.derivedTableCount;
        return tabAlias;
    }

    public ASTNode getUnionAllAST(ASTNode leftAST, ASTNode rightAST) {
        ASTNode unionTokAST = ASTBuilder.construct(970, "TOK_UNIONALL").add(leftAST).add(rightAST).node();
        return unionTokAST;
    }

    public static boolean isFlat(RexCall call) {
        SqlOperator op;
        boolean flat = false;
        if (call.operands != null && call.operands.size() > 2 && ((op = call.getOperator()).getKind() == SqlKind.AND || op.getKind() == SqlKind.OR)) {
            flat = true;
        }
        return flat;
    }

    static class HiveAST {
        ASTNode from;
        ASTNode where;
        ASTNode groupBy;
        ASTNode having;
        ASTNode select;
        ASTNode order;
        ASTNode limit;

        HiveAST() {
        }

        public ASTNode getAST() {
            ASTBuilder b = ASTBuilder.construct(860, "TOK_QUERY").add(this.from).add(ASTBuilder.construct(772, "TOK_INSERT").add(ASTBuilder.destNode()).add(this.select).add(this.where).add(this.groupBy).add(this.having).add(this.order).add(this.limit));
            return b.node();
        }
    }

    static class ColumnInfo {
        String table;
        String column;
        ASTNode agg;

        ColumnInfo(String table, String column) {
            this.table = table;
            this.column = column;
        }

        ColumnInfo(String table, ASTNode agg) {
            this.table = table;
            this.agg = agg;
        }

        ColumnInfo(String alias, ColumnInfo srcCol) {
            this.table = alias;
            this.column = srcCol.column;
            this.agg = srcCol.agg;
        }
    }

    static class Schema
    extends ArrayList<ColumnInfo> {
        private static final long serialVersionUID = 1L;

        Schema(TableScan scan) {
            String tabName = ((HiveTableScan)scan).getTableAlias();
            for (RelDataTypeField field : scan.getRowType().getFieldList()) {
                this.add(new ColumnInfo(tabName, field.getName()));
            }
        }

        Schema(Project select, String alias) {
            for (RelDataTypeField field : select.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(Union unionRel, String alias) {
            for (RelDataTypeField field : unionRel.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(Schema left, Schema right) {
            for (ColumnInfo cI : Iterables.concat(left, right)) {
                this.add(cI);
            }
        }

        Schema(Schema src, Aggregate gBy) {
            ColumnInfo cI;
            int i;
            Iterator i$ = gBy.getGroupSet().iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                cI = (ColumnInfo)src.get(i);
                this.add(cI);
            }
            if (gBy.indicator) {
                i$ = gBy.getGroupSet().iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    cI = (ColumnInfo)src.get(i);
                    this.add(cI);
                }
            }
            List aggs = gBy.getAggCallList();
            for (AggregateCall agg : aggs) {
                if (agg.getAggregation() == HiveGroupingID.INSTANCE) {
                    this.add(new ColumnInfo(null, VirtualColumn.GROUPINGID.getName()));
                    continue;
                }
                int argCount = agg.getArgList().size();
                ASTBuilder b = agg.isDistinct() ? ASTBuilder.construct(751, "TOK_FUNCTIONDI") : (argCount == 0 ? ASTBuilder.construct(752, "TOK_FUNCTIONSTAR") : ASTBuilder.construct(750, "TOK_FUNCTION"));
                b.add(26, agg.getAggregation().getName());
                Iterator i$2 = agg.getArgList().iterator();
                while (i$2.hasNext()) {
                    int i2 = (Integer)i$2.next();
                    RexInputRef iRef = new RexInputRef(i2, gBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                    b.add((ASTNode)iRef.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(src)));
                }
                this.add(new ColumnInfo(null, b.node()));
            }
        }

        public Schema(HiveSortLimit order) {
            Project select = (Project)order.getInput();
            for (String projName : select.getRowType().getFieldNames()) {
                this.add(new ColumnInfo(null, projName));
            }
        }

        public Schema(String tabAlias, List<RelDataTypeField> fieldList) {
            for (RelDataTypeField field : fieldList) {
                this.add(new ColumnInfo(tabAlias, field.getName()));
            }
        }
    }

    static class QueryBlockInfo {
        Schema schema;
        ASTNode ast;

        public QueryBlockInfo(Schema schema, ASTNode ast) {
            this.schema = schema;
            this.ast = ast;
        }
    }

    static class RexVisitor
    extends RexVisitorImpl<ASTNode> {
        private final Schema schema;
        private final boolean useTypeQualInLiteral;

        protected RexVisitor(Schema schema) {
            this(schema, false);
        }

        protected RexVisitor(Schema schema, boolean useTypeQualInLiteral) {
            super(true);
            this.schema = schema;
            this.useTypeQualInLiteral = useTypeQualInLiteral;
        }

        public ASTNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return ASTBuilder.construct(17, ".").add((ASTNode)super.visitFieldAccess(fieldAccess)).add(26, fieldAccess.getField().getName()).node();
        }

        public ASTNode visitInputRef(RexInputRef inputRef) {
            ColumnInfo cI = (ColumnInfo)this.schema.get(inputRef.getIndex());
            if (cI.agg != null) {
                return (ASTNode)ParseDriver.adaptor.dupTree((Object)cI.agg);
            }
            if (cI.table == null || cI.table.isEmpty()) {
                return ASTBuilder.unqualifiedName(cI.column);
            }
            return ASTBuilder.qualifiedName(cI.table, cI.column);
        }

        public ASTNode visitLiteral(RexLiteral literal) {
            return ASTBuilder.literal(literal, this.useTypeQualInLiteral);
        }

        private ASTNode getPSpecAST(RexWindow window) {
            ASTNode pSpecAst = null;
            ASTNode dByAst = null;
            if (window.partitionKeys != null && !window.partitionKeys.isEmpty()) {
                dByAst = ASTBuilder.createAST(729, "TOK_DISTRIBUTEBY");
                for (RexNode pk : window.partitionKeys) {
                    ASTNode astCol = (ASTNode)pk.accept((org.apache.calcite.rex.RexVisitor)this);
                    dByAst.addChild((Tree)astCol);
                }
            }
            ASTNode oByAst = null;
            if (window.orderKeys != null && !window.orderKeys.isEmpty()) {
                oByAst = ASTBuilder.createAST(835, "TOK_ORDERBY");
                for (RexFieldCollation ok : window.orderKeys) {
                    ASTNode nullDirectionAST;
                    ASTNode directionAST;
                    ASTNode aSTNode = directionAST = ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? ASTBuilder.createAST(955, "TOK_TABSORTCOLNAMEASC") : ASTBuilder.createAST(956, "TOK_TABSORTCOLNAMEDESC");
                    if (((ImmutableSet)ok.right).contains(SqlKind.NULLS_FIRST)) {
                        nullDirectionAST = ASTBuilder.createAST(812, "TOK_NULLS_FIRST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else if (((ImmutableSet)ok.right).contains(SqlKind.NULLS_LAST)) {
                        nullDirectionAST = ASTBuilder.createAST(813, "TOK_NULLS_LAST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else if (ok.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                        nullDirectionAST = ASTBuilder.createAST(812, "TOK_NULLS_FIRST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else {
                        nullDirectionAST = ASTBuilder.createAST(813, "TOK_NULLS_LAST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    }
                    ASTNode astCol = (ASTNode)((RexNode)ok.left).accept((org.apache.calcite.rex.RexVisitor)this);
                    nullDirectionAST.addChild((Tree)astCol);
                    oByAst.addChild((Tree)directionAST);
                }
            }
            if (dByAst != null || oByAst != null) {
                pSpecAst = ASTBuilder.createAST(837, "TOK_PARTITIONINGSPEC");
                if (dByAst != null) {
                    pSpecAst.addChild((Tree)dByAst);
                }
                if (oByAst != null) {
                    pSpecAst.addChild((Tree)oByAst);
                }
            }
            return pSpecAst;
        }

        private ASTNode getWindowBound(RexWindowBound wb) {
            ASTNode wbAST = null;
            if (wb.isCurrentRow()) {
                wbAST = ASTBuilder.createAST(74, "CURRENT");
            } else {
                wbAST = wb.isPreceding() ? ASTBuilder.createAST(208, "PRECEDING") : ASTBuilder.createAST(119, "FOLLOWING");
                if (wb.isUnbounded()) {
                    wbAST.addChild((Tree)ASTBuilder.createAST(284, "UNBOUNDED"));
                } else {
                    ASTNode offset = (ASTNode)wb.getOffset().accept((org.apache.calcite.rex.RexVisitor)this);
                    wbAST.addChild((Tree)offset);
                }
            }
            return wbAST;
        }

        private ASTNode getWindowRangeAST(RexWindow window) {
            ASTNode wRangeAst = null;
            ASTNode startAST = null;
            RexWindowBound ub = window.getUpperBound();
            if (ub != null) {
                startAST = this.getWindowBound(ub);
            }
            ASTNode endAST = null;
            RexWindowBound lb = window.getLowerBound();
            if (lb != null) {
                endAST = this.getWindowBound(lb);
            }
            if (startAST != null || endAST != null) {
                wRangeAst = window.isRows() ? ASTBuilder.createAST(990, "TOK_WINDOWRANGE") : ASTBuilder.createAST(992, "TOK_WINDOWVALUES");
                if (startAST != null) {
                    wRangeAst.addChild((Tree)startAST);
                }
                if (endAST != null) {
                    wRangeAst.addChild((Tree)endAST);
                }
            }
            return wRangeAst;
        }

        public ASTNode visitOver(RexOver over) {
            if (!this.deep) {
                return null;
            }
            ASTNode wUDAFAst = this.visitCall((RexCall)over);
            ASTNode wSpec = ASTBuilder.createAST(991, "TOK_WINDOWSPEC");
            wUDAFAst.addChild((Tree)wSpec);
            RexWindow window = over.getWindow();
            ASTNode wPSpecAst = this.getPSpecAST(window);
            ASTNode wRangeAst = this.getWindowRangeAST(window);
            if (wPSpecAst != null) {
                wSpec.addChild((Tree)wPSpecAst);
            }
            if (wRangeAst != null) {
                wSpec.addChild((Tree)wRangeAst);
            }
            return wUDAFAst;
        }

        public ASTNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            SqlOperator op = call.getOperator();
            LinkedList<ASTNode> astNodeLst = new LinkedList<ASTNode>();
            if (op.kind == SqlKind.CAST) {
                SqlFunctionConverter.HiveToken ht = TypeConverter.hiveToken(call.getType());
                ASTBuilder astBldr = ASTBuilder.construct(ht.type, ht.text);
                if (ht.args != null) {
                    for (String castArg : ht.args) {
                        astBldr.add(26, castArg);
                    }
                }
                astNodeLst.add(astBldr.node());
            }
            for (RexNode operand : call.operands) {
                astNodeLst.add((ASTNode)operand.accept((org.apache.calcite.rex.RexVisitor)this));
            }
            if (ASTConverter.isFlat(call)) {
                return SqlFunctionConverter.buildAST(op, astNodeLst, 0);
            }
            return SqlFunctionConverter.buildAST(op, astNodeLst);
        }
    }

    class QBVisitor
    extends RelVisitor {
        QBVisitor() {
        }

        public void handle(Filter filter) {
            RelNode child = filter.getInput();
            if (child instanceof Aggregate && !((Aggregate)child).getGroupSet().isEmpty()) {
                ASTConverter.this.having = filter;
            } else {
                ASTConverter.this.where = filter;
            }
        }

        public void handle(Project project) {
            if (ASTConverter.this.select == null) {
                ASTConverter.this.select = project;
            } else {
                ASTConverter.this.from = (RelNode)project;
            }
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof TableScan) {
                ASTConverter.this.from = node;
            } else if (node instanceof Filter) {
                this.handle((Filter)node);
            } else if (node instanceof Project) {
                this.handle((Project)node);
            } else if (node instanceof Join) {
                ASTConverter.this.from = node;
            } else if (node instanceof Union) {
                ASTConverter.this.from = node;
            } else if (node instanceof Aggregate) {
                ASTConverter.this.groupBy = (Aggregate)node;
            } else if (node instanceof Sort) {
                if (ASTConverter.this.select != null) {
                    ASTConverter.this.from = node;
                } else {
                    ASTConverter.this.orderLimit = (Sort)node;
                }
            }
            if (ASTConverter.this.from == null) {
                node.childrenAccept((RelVisitor)this);
            }
        }
    }
}

