/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable.fast;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.InputByteBuffer;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BinarySortableDeserializeRead
extends DeserializeRead {
    public static final Logger LOG = LoggerFactory.getLogger((String)BinarySortableDeserializeRead.class.getName());
    private boolean[] columnSortOrderIsDesc;
    private int fieldIndex;
    private int fieldCount;
    private int start;
    private byte[] tempTimestampBytes;
    private Text tempText;
    private byte[] tempDecimalBuffer;
    private boolean readBeyondConfiguredFieldsWarned;
    private boolean readBeyondBufferRangeWarned;
    private boolean bufferRangeHasExtraDataWarned;
    private InputByteBuffer inputByteBuffer = new InputByteBuffer();

    public BinarySortableDeserializeRead(PrimitiveTypeInfo[] primitiveTypeInfos) {
        this(primitiveTypeInfos, null);
    }

    public BinarySortableDeserializeRead(TypeInfo[] typeInfos, boolean[] columnSortOrderIsDesc) {
        super(typeInfos);
        this.fieldCount = typeInfos.length;
        if (columnSortOrderIsDesc != null) {
            this.columnSortOrderIsDesc = columnSortOrderIsDesc;
        } else {
            this.columnSortOrderIsDesc = new boolean[typeInfos.length];
            Arrays.fill(this.columnSortOrderIsDesc, false);
        }
        this.inputByteBuffer = new InputByteBuffer();
        this.readBeyondConfiguredFieldsWarned = false;
        this.readBeyondBufferRangeWarned = false;
        this.bufferRangeHasExtraDataWarned = false;
    }

    private BinarySortableDeserializeRead() {
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.fieldIndex = -1;
        this.inputByteBuffer.reset(bytes, offset, offset + length);
        this.start = offset;
    }

    @Override
    public boolean readCheckNull() throws IOException {
        ++this.fieldIndex;
        if (this.fieldIndex >= this.fieldCount) {
            if (!this.readBeyondConfiguredFieldsWarned) {
                this.doReadBeyondConfiguredFieldsWarned();
            }
            return true;
        }
        if (this.inputByteBuffer.isEof()) {
            if (!this.readBeyondBufferRangeWarned) {
                this.doReadBeyondBufferRangeWarned();
            }
            return true;
        }
        byte isNullByte = this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.fieldIndex]);
        if (isNullByte == 0) {
            return true;
        }
        boolean isNull = false;
        switch (this.primitiveCategories[this.fieldIndex]) {
            case BOOLEAN: {
                this.currentBoolean = this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.fieldIndex]) == 2;
                break;
            }
            case BYTE: {
                this.currentByte = (byte)(this.inputByteBuffer.read(this.columnSortOrderIsDesc[this.fieldIndex]) ^ 0x80);
                break;
            }
            case SHORT: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                this.currentShort = (short)v;
                break;
            }
            case INT: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentInt = v;
                break;
            }
            case LONG: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                long v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 7; ++i) {
                    v = (v << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentLong = v;
                break;
            }
            case DATE: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentDateWritable.set(v);
                break;
            }
            case TIMESTAMP: {
                if (this.tempTimestampBytes == null) {
                    this.tempTimestampBytes = new byte[11];
                }
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                for (int i = 0; i < this.tempTimestampBytes.length; ++i) {
                    this.tempTimestampBytes[i] = this.inputByteBuffer.read(invert);
                }
                this.currentTimestampWritable.setBinarySortable(this.tempTimestampBytes, 0);
                break;
            }
            case FLOAT: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                int v = 0;
                for (int i = 0; i < 4; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                v = (v & Integer.MIN_VALUE) == 0 ? (v ^= 0xFFFFFFFF) : (v ^= Integer.MIN_VALUE);
                this.currentFloat = Float.intBitsToFloat(v);
                break;
            }
            case DOUBLE: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                long v = 0L;
                for (int i = 0; i < 8; ++i) {
                    v = (v << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
                }
                v = (v & Long.MIN_VALUE) == 0L ? (v ^= 0xFFFFFFFFFFFFFFFFL) : (v ^= Long.MIN_VALUE);
                this.currentDouble = Double.longBitsToDouble(v);
                break;
            }
            case BINARY: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (this.tempText == null) {
                    this.tempText = new Text();
                }
                BinarySortableSerDe.deserializeText(this.inputByteBuffer, this.columnSortOrderIsDesc[this.fieldIndex], this.tempText);
                this.currentBytes = this.tempText.getBytes();
                this.currentBytesStart = 0;
                this.currentBytesLength = this.tempText.getLength();
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                int v = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    v = (v << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentHiveIntervalYearMonthWritable.set(v);
                break;
            }
            case INTERVAL_DAY_TIME: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                long totalSecs = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 7; ++i) {
                    totalSecs = (totalSecs << 8) + (long)(this.inputByteBuffer.read(invert) & 0xFF);
                }
                int nanos = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    nanos = (nanos << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                this.currentHiveIntervalDayTimeWritable.set(totalSecs, nanos);
                break;
            }
            case DECIMAL: {
                boolean invert = this.columnSortOrderIsDesc[this.fieldIndex];
                int b = this.inputByteBuffer.read(invert) - 1;
                assert (b == 1 || b == -1 || b == 0);
                boolean positive = b != -1;
                int factor = this.inputByteBuffer.read(invert) ^ 0x80;
                for (int i = 0; i < 3; ++i) {
                    factor = (factor << 8) + (this.inputByteBuffer.read(invert) & 0xFF);
                }
                if (!positive) {
                    factor = -factor;
                }
                int start = this.inputByteBuffer.tell();
                int length = 0;
                while (true) {
                    b = this.inputByteBuffer.read(positive ? invert : !invert);
                    assert (b != 1);
                    if (b == 0) break;
                    ++length;
                }
                if (this.tempDecimalBuffer == null || this.tempDecimalBuffer.length < length) {
                    this.tempDecimalBuffer = new byte[length];
                }
                this.inputByteBuffer.seek(start);
                for (int i = 0; i < length; ++i) {
                    this.tempDecimalBuffer[i] = this.inputByteBuffer.read(positive ? invert : !invert);
                }
                this.inputByteBuffer.read(positive ? invert : !invert);
                String digits = new String(this.tempDecimalBuffer, 0, length, BinarySortableSerDe.decimalCharSet);
                BigInteger bi = new BigInteger(digits);
                HiveDecimal bd = HiveDecimal.create(bi).scaleByPowerOfTen(factor - length);
                if (!positive) {
                    bd = bd.negate();
                }
                this.currentHiveDecimalWritable.set(bd);
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.typeInfos[this.fieldIndex];
                int precision = decimalTypeInfo.getPrecision();
                int scale = decimalTypeInfo.getScale();
                HiveDecimal decimal = this.currentHiveDecimalWritable.getHiveDecimal(precision, scale);
                if (decimal == null) {
                    isNull = true;
                    break;
                }
                this.currentHiveDecimalWritable.set(decimal);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected primitive type category " + (Object)((Object)this.primitiveCategories[this.fieldIndex]));
            }
        }
        if (this.columnsToInclude != null && !this.columnsToInclude[this.fieldIndex]) {
            isNull = true;
        }
        return isNull;
    }

    @Override
    public void extraFieldsCheck() {
        if (!this.inputByteBuffer.isEof() && !this.bufferRangeHasExtraDataWarned) {
            int length = this.inputByteBuffer.getEnd() - this.start;
            int remaining = this.inputByteBuffer.getEnd() - this.inputByteBuffer.tell();
            LOG.info("Not all fields were read in the buffer range! Buffer range " + this.start + " for length " + length + " but " + remaining + " bytes remain. " + "(total buffer length " + this.inputByteBuffer.getData().length + ")" + "  Ignoring similar problems.");
            this.bufferRangeHasExtraDataWarned = true;
        }
    }

    @Override
    public boolean readBeyondConfiguredFieldsWarned() {
        return this.readBeyondConfiguredFieldsWarned;
    }

    @Override
    public boolean readBeyondBufferRangeWarned() {
        return this.readBeyondBufferRangeWarned;
    }

    @Override
    public boolean bufferRangeHasExtraDataWarned() {
        return this.bufferRangeHasExtraDataWarned;
    }

    private void doReadBeyondConfiguredFieldsWarned() {
        LOG.info("Reading beyond configured fields! Configured " + this.fieldCount + " fields but " + " reading more (NULLs returned).  Ignoring similar problems.");
        this.readBeyondConfiguredFieldsWarned = true;
    }

    private void doReadBeyondBufferRangeWarned() {
        int length = this.inputByteBuffer.tell() - this.start;
        LOG.info("Reading beyond buffer range! Buffer range " + this.start + " for length " + length + " but reading more... " + "(total buffer length " + this.inputByteBuffer.getData().length + ")" + "  Ignoring similar problems.");
        this.readBeyondBufferRangeWarned = true;
    }
}

