/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;

@Description(name="var_samp", value="_FUNC_(x) - Returns the sample variance of a set of numbers (vectorized, decimal)")
public class VectorUDAFVarSampDecimal
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient LongWritable resultCount;
    private transient DoubleWritable resultSum;
    private transient DoubleWritable resultVariance;
    private transient Object[] partialResult = new Object[3];
    private transient ObjectInspector soi;

    public VectorUDAFVarSampDecimal(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFVarSampDecimal() {
        this.resultCount = new LongWritable();
        this.resultSum = new DoubleWritable();
        this.resultVariance = new DoubleWritable();
        this.partialResult[0] = this.resultCount;
        this.partialResult[1] = this.resultSum;
        this.partialResult[2] = this.resultVariance;
        this.initPartialResultInspector();
    }

    private void initPartialResultInspector() {
        ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
        foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        ArrayList<String> fname = new ArrayList<String>();
        fname.add("count");
        fname.add("sum");
        fname.add("variance");
        this.soi = ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        HiveDecimalWritable[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                this.iterateRepeatingNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], inputVector.scale, batchSize);
            }
        } else if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable value, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    private void iterateSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            int i = selected[j];
            if (isNull[i]) continue;
            HiveDecimalWritable value = vector[i];
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    private void iterateSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            HiveDecimalWritable value = vector[selected[i]];
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    private void iterateNoSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            HiveDecimalWritable value = vector[i];
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    private void iterateNoSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            HiveDecimalWritable value = vector[i];
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        HiveDecimalWritable[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls) {
                this.iterateRepeatingNoNulls(myagg, vector[0], inputVector.scale, batchSize);
            }
        } else if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, inputVector.scale, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, inputVector.scale, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, inputVector.scale, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, inputVector.scale, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNulls(Aggregation myagg, HiveDecimalWritable value, short scale, int batchSize) {
        myagg.updateValueWithCheckAndInit(value, scale);
        for (int i = 1; i < batchSize; ++i) {
            myagg.updateValueNoCheck(value, scale);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            HiveDecimalWritable value = vector[i];
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.init();
        }
        HiveDecimalWritable value = vector[selected[0]];
        myagg.updateValueWithCheckAndInit(value, scale);
        for (int i = 1; i < batchSize; ++i) {
            value = vector[selected[i]];
            myagg.updateValueNoCheck(value, scale);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            HiveDecimalWritable value = vector[i];
            myagg.updateValueWithCheckAndInit(value, scale);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize) {
        if (myagg.isNull) {
            myagg.init();
        }
        HiveDecimalWritable value = vector[0];
        myagg.updateValueWithCheckAndInit(value, scale);
        for (int i = 1; i < batchSize; ++i) {
            value = vector[i];
            myagg.updateValueNoCheck(value, scale);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        assert (0L < myagg.count);
        this.resultCount.set(myagg.count);
        this.resultSum.set(myagg.sum);
        this.resultVariance.set(myagg.variance);
        return this.partialResult;
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.soi;
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2() * 3 + model.primitive1(), model.memoryAlign());
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient long count;
        private transient double variance;
        private transient boolean isNull = true;

        public void init() {
            this.isNull = false;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }

        public void updateValueWithCheckAndInit(HiveDecimalWritable value, short scale) {
            if (this.isNull) {
                this.init();
            }
            double dval = value.getHiveDecimal().doubleValue();
            this.sum += dval;
            ++this.count;
            if (this.count > 1L) {
                double t = (double)this.count * dval - this.sum;
                this.variance += t * t / ((double)this.count * (double)(this.count - 1L));
            }
        }

        public void updateValueNoCheck(HiveDecimalWritable value, short scale) {
            double dval = value.getHiveDecimal().doubleValue();
            this.sum += dval;
            ++this.count;
            double t = (double)this.count * dval - this.sum;
            this.variance += t * t / ((double)this.count * (double)(this.count - 1L));
        }
    }
}

