/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;

public class ColumnAccessInfo {
    private final Map<String, Set<String>> tableToColumnAccessMap = new LinkedHashMap<String, Set<String>>();

    public void add(String table, String col) {
        Set<String> tableColumns = this.tableToColumnAccessMap.get(table);
        if (tableColumns == null) {
            tableColumns = new LinkedHashSet<String>();
            this.tableToColumnAccessMap.put(table, tableColumns);
        }
        tableColumns.add(col);
    }

    public Map<String, List<String>> getTableToColumnAccessMap() {
        LinkedHashMap<String, List<String>> mapping = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, Set<String>> entry : this.tableToColumnAccessMap.entrySet()) {
            ArrayList sortedCols = new ArrayList(entry.getValue());
            Collections.sort(sortedCols);
            mapping.put(entry.getKey(), sortedCols);
        }
        return mapping;
    }

    public void stripVirtualColumn(VirtualColumn vc) {
        block0: for (Map.Entry<String, Set<String>> e : this.tableToColumnAccessMap.entrySet()) {
            for (String columnName : e.getValue()) {
                if (!vc.getName().equalsIgnoreCase(columnName)) continue;
                e.getValue().remove(columnName);
                continue block0;
            }
        }
    }
}

