/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HouseKeeperService;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.TestTxnCommands2;
import org.apache.hadoop.hive.ql.lockmgr.TestDbTxnManager2;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.AcidHouseKeeperService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnCommands {
    private static final Logger LOG = LoggerFactory.getLogger(TestTxnCommands.class);
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestTxnCommands.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private static final String TEST_WAREHOUSE_DIR = TEST_DATA_DIR + "/warehouse";
    private static int BUCKET_COUNT = 2;
    @Rule
    public TestName testName = new TestName();
    private HiveConf hiveConf;
    private Driver d;

    @Before
    public void setUp() throws Exception {
        this.hiveConf = new HiveConf(this.getClass());
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, TEST_WAREHOUSE_DIR);
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, true);
        TxnDbUtil.setConfValues((HiveConf)this.hiveConf);
        TxnDbUtil.prepDb((HiveConf)this.hiveConf);
        File f = new File(TEST_WAREHOUSE_DIR);
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(TEST_WAREHOUSE_DIR).mkdirs()) {
            throw new RuntimeException("Could not create " + TEST_WAREHOUSE_DIR);
        }
        SessionState.start((SessionState)new SessionState(this.hiveConf));
        this.d = new Driver(this.hiveConf);
        this.d.setMaxRows(10000);
        this.dropTables();
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.ACIDTBLPART) + "(a int, b int) partitioned by (p string) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL2) + "(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("create temporary  table " + (Object)((Object)Table.ACIDTBL2) + "(a int, b int, c int) clustered by (c) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
    }

    private void dropTables() throws Exception {
        for (Table t : Table.values()) {
            this.runStatementOnDriver("drop table if exists " + (Object)((Object)t));
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                this.runStatementOnDriver("set autocommit true");
                this.dropTables();
                this.d.destroy();
                this.d.close();
                this.d = null;
            }
        }
        finally {
            TxnDbUtil.cleanDb((HiveConf)this.hiveConf);
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
    }

    @Test
    public void testInsertOverwrite() throws Exception {
        this.runStatementOnDriver("insert overwrite table " + (Object)((Object)Table.NONACIDORCTBL) + " select a,b from " + (Object)((Object)Table.NONACIDORCTBL2));
        this.runStatementOnDriver("create table " + (Object)((Object)Table.NONACIDORCTBL2) + "3(a int, b int) clustered by (a) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='false')");
    }

    @Ignore(value="not needed but useful for testing")
    @Test
    public void testNonAcidInsert() throws Exception {
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(1,2)");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + "(a,b) values(2,3)");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.NONACIDORCTBL));
    }

    private void dumpBucketData(Table table, long txnId, int stmtId, int bucketNum) throws Exception {
    }

    private void dumpTableData(Table table, long txnId, int stmtId) throws Exception {
        for (int bucketNum = 0; bucketNum < BUCKET_COUNT; ++bucketNum) {
            this.dumpBucketData(table, txnId, stmtId, bucketNum);
        }
    }

    @Test
    public void testSimpleAcidInsert() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs0);
        this.runStatementOnDriver("COMMIT WORK");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 0);
        this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("COMMIT");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Data didn't match inside tx (rs0)", allData, rs1);
    }

    @Test
    public void testErrors() throws Exception {
        this.runStatementOnDriver("set autocommit true");
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("start transaction");
        Assert.assertEquals((String)("Error didn't match: " + cpr), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("start transaction");
        CommandProcessorResponse cpr2 = this.runStatementOnDriverNegative("create table foo(x int, y int)");
        Assert.assertEquals((String)"Expected DDL to fail in an open txn", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)cpr2.getErrorCode());
        this.runStatementOnDriver("set autocommit true");
        CommandProcessorResponse cpr3 = this.runStatementOnDriverNegative("update " + (Object)((Object)Table.ACIDTBL) + " set a = 1 where b != 1");
        Assert.assertEquals((String)"Expected update of bucket column to fail", (Object)"FAILED: SemanticException [Error 10302]: Updating values of bucketing columns is not supported.  Column a.", (Object)cpr3.getErrorMessage());
        cpr3 = this.runStatementOnDriverNegative("commit work");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        cpr3 = this.runStatementOnDriverNegative("rollback work");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        this.runStatementOnDriver("set autocommit false");
        cpr3 = this.runStatementOnDriverNegative("commit");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        cpr3 = this.runStatementOnDriverNegative("rollback");
        Assert.assertEquals((String)("Error didn't match: " + cpr3), (long)ErrorMsg.OP_NOT_ALLOWED_IN_AUTOCOMMIT.getErrorCode(), (long)cpr.getErrorCode());
        this.runStatementOnDriver("start transaction");
        cpr3 = this.runStatementOnDriverNegative("start transaction");
        Assert.assertEquals((String)"Expected start transaction to fail", (long)ErrorMsg.OP_NOT_ALLOWED_IN_TXN.getErrorCode(), (long)cpr3.getErrorCode());
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("set autocommit true");
        rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
    }

    @Test
    public void testReadMyOwnInsert() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs = this.runStatementOnDriver("select * from " + (Object)((Object)Table.ACIDTBL));
        Assert.assertEquals((String)("Expected empty " + (Object)((Object)Table.ACIDTBL)), (long)0L, (long)rs.size());
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("START TRANSACTION");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("rollback work");
        Assert.assertEquals((String)"Can't see write after commit", (long)1L, (long)rs1.size());
    }

    @Test
    public void testImplicitRollback() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Can't see my own write", (long)1L, (long)rs0.size());
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("select * from no_such_table");
        Assert.assertEquals((String)"Txn didn't fail?", (Object)"FAILED: SemanticException [Error 10001]: Line 1:14 Table not found 'no_such_table'", (Object)cpr.getErrorMessage());
        this.runStatementOnDriver("start transaction");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        this.runStatementOnDriver("commit");
        Assert.assertEquals((String)"Didn't rollback as expected", (long)0L, (long)rs1.size());
    }

    @Test
    public void testExplicitRollback() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) values(1,2)");
        this.runStatementOnDriver("ROLLBACK");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Rollback didn't rollback", (long)0L, (long)rs.size());
    }

    @Test
    public void testMultipleInserts() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match before commit rs", allData, rs);
        this.runStatementOnDriver("commit");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 1L, 1);
        this.runStatementOnDriver("set autocommit true");
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match after commit rs1", allData, rs1);
    }

    @Test
    public void testDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 4");
        int[][] updatedData2 = new int[][]{{1, 2}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testUpdateOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", this.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData), rs4);
    }

    @Test
    public void testUpdateDeleteOfInserts() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        int[][] rows2 = new int[][]{{5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows2));
        List<String> rs1 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        List<String> allData = this.stringifyValues(rows1);
        allData.addAll(this.stringifyValues(rows2));
        Assert.assertEquals((String)"Content didn't match rs1", allData, rs1);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b = 1 where b != 1");
        int[][] updatedData = new int[][]{{1, 1}, {3, 1}, {5, 1}, {7, 1}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after update", this.stringifyValues(updatedData), rs2);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a = 7 and b = 1");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 2);
        this.dumpTableData(Table.ACIDTBL, 2L, 4);
        int[][] updatedData2 = new int[][]{{1, 1}, {3, 1}, {5, 1}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData2), rs3);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData2), rs4);
    }

    @Test
    public void testMultipleDelete() throws Exception {
        int[][] rows1 = new int[][]{{1, 2}, {3, 4}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(rows1));
        List<String> rs0 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Content didn't match rs0", this.stringifyValues(rows1), rs0);
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("START TRANSACTION");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 8");
        int[][] updatedData2 = new int[][]{{1, 2}, {3, 4}, {5, 6}};
        List<String> rs2 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData2), rs2);
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where b = 4");
        int[][] updatedData3 = new int[][]{{1, 2}, {5, 6}};
        List<String> rs3 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after delete2", this.stringifyValues(updatedData3), rs3);
        this.runStatementOnDriver("update " + (Object)((Object)Table.ACIDTBL) + " set b=3");
        this.dumpTableData(Table.ACIDTBL, 1L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 0);
        this.dumpTableData(Table.ACIDTBL, 2L, 2);
        this.dumpTableData(Table.ACIDTBL, 2L, 4);
        List<String> rs5 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData4 = new int[][]{{1, 3}, {5, 3}};
        Assert.assertEquals((String)"Wrong data after delete", this.stringifyValues(updatedData4), rs5);
        this.runStatementOnDriver("commit");
        this.runStatementOnDriver("set autocommit true");
        List<String> rs4 = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        Assert.assertEquals((String)"Wrong data after commit", this.stringifyValues(updatedData4), rs4);
    }

    @Test
    public void testDeleteIn() throws Exception {
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a IN (SELECT A.a from " + (Object)((Object)Table.ACIDTBL) + "  A)");
        int[][] tableData = new int[][]{{1, 2}, {3, 2}, {5, 2}, {1, 3}, {3, 3}, {5, 3}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) " + this.makeValuesClause(tableData));
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL2) + "(a,b,c) values(1,7,17),(3,7,17)");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a in(select a from " + (Object)((Object)Table.ACIDTBL2) + ")");
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + "(a,b) select a,b from " + (Object)((Object)Table.ACIDTBL2));
        List<String> rs = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] updatedData = new int[][]{{1, 7}, {3, 7}, {5, 2}, {5, 3}};
        Assert.assertEquals((String)"Bulk update failed", this.stringifyValues(updatedData), rs);
    }

    @Test
    public void testTimeOutReaper() throws Exception {
        this.runStatementOnDriver("set autocommit false");
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("delete from " + (Object)((Object)Table.ACIDTBL) + " where a = 5");
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TIMEDOUT_TXN_REAPER_START, 0L, TimeUnit.SECONDS);
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 2L, TimeUnit.MILLISECONDS);
        AcidHouseKeeperService houseKeeperService = new AcidHouseKeeperService();
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)houseKeeperService, this.hiveConf);
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("delete from " + (Object)((Object)Table.ACIDTBL) + " where a = 5");
        Assert.assertTrue((String)("Actual: " + cpr.getErrorMessage()), (boolean)cpr.getErrorMessage().contains("Transaction manager has aborted the transaction txnid:1"));
        this.hiveConf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 1L, TimeUnit.SECONDS);
        this.runStatementOnDriver("start transaction");
        this.runStatementOnDriver("select count(*) from " + (Object)((Object)Table.ACIDTBL) + " where a = 17");
        TestTxnCommands.pause(750);
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.hiveConf);
        GetOpenTxnsInfoResponse txnsInfoResponse = txnHandler.getOpenTxnsInfo();
        Assert.assertEquals((long)2L, (long)txnsInfoResponse.getOpen_txns().size());
        TxnInfo txnInfo = null;
        for (TxnInfo ti : txnsInfoResponse.getOpen_txns()) {
            if (ti.getState() != TxnState.OPEN) continue;
            txnInfo = ti;
            break;
        }
        Assert.assertNotNull(txnInfo);
        Assert.assertEquals((long)2L, (long)txnInfo.getId());
        Assert.assertEquals((Object)TxnState.OPEN, (Object)txnInfo.getState());
        String s = TxnDbUtil.queryToString((HiveConf)this.hiveConf, (String)("select TXN_STARTED, TXN_LAST_HEARTBEAT from TXNS where TXN_ID = " + txnInfo.getId()), (boolean)false);
        String[] vals = s.split("\\s+");
        Assert.assertEquals((String)"Didn't get expected timestamps", (long)2L, (long)vals.length);
        long lastHeartbeat = Long.parseLong(vals[1]);
        Assert.assertNotEquals((String)"Didn't see heartbeat happen", (long)Long.parseLong(vals[0]), (long)lastHeartbeat);
        ShowLocksResponse slr = txnHandler.showLocks(new ShowLocksRequest());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", Table.ACIDTBL.name, null, slr.getLocks());
        TestTxnCommands.pause(750);
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)houseKeeperService, this.hiveConf);
        TestTxnCommands.pause(750);
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)("Unexpected lock count: " + slr), (long)1L, (long)slr.getLocks().size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", Table.ACIDTBL.name, null, slr.getLocks());
        TestTxnCommands.pause(750);
        TestTxnCommands2.runHouseKeeperService((HouseKeeperService)houseKeeperService, this.hiveConf);
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)("Unexpected lock count: " + slr), (long)1L, (long)slr.getLocks().size());
        TestDbTxnManager2.checkLock(LockType.SHARED_READ, LockState.ACQUIRED, "default", Table.ACIDTBL.name, null, slr.getLocks());
        s = TxnDbUtil.queryToString((HiveConf)this.hiveConf, (String)("select TXN_STARTED, TXN_LAST_HEARTBEAT from TXNS where TXN_ID = " + txnInfo.getId()), (boolean)false);
        vals = s.split("\\s+");
        Assert.assertEquals((String)"Didn't get expected timestamps", (long)2L, (long)vals.length);
        Assert.assertTrue((String)("Heartbeat didn't progress: (old,new) (" + lastHeartbeat + "," + vals[1] + ")"), (lastHeartbeat < Long.parseLong(vals[1]) ? 1 : 0) != 0);
        this.runStatementOnDriver("rollback");
        slr = txnHandler.showLocks(new ShowLocksRequest());
        Assert.assertEquals((String)"Unexpected lock count", (long)0L, (long)slr.getLocks().size());
    }

    private static void pause(int timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<String> stringifyValues(int[][] rowsIn) {
        assert (rowsIn.length > 0);
        int[][] rows = (int[][])rowsIn.clone();
        Arrays.sort(rows, new RowComp());
        ArrayList<String> rs = new ArrayList<String>();
        for (int[] row : rows) {
            assert (row.length > 0);
            StringBuilder sb = new StringBuilder();
            for (int value : row) {
                sb.append(value).append("\t");
            }
            sb.setLength(sb.length() - 1);
            rs.add(sb.toString());
        }
        return rs;
    }

    private String makeValuesClause(int[][] rows) {
        assert (rows.length > 0);
        StringBuilder sb = new StringBuilder("values");
        for (int[] row : rows) {
            assert (row.length > 0);
            if (row.length > 1) {
                sb.append("(");
            }
            for (int value : row) {
                sb.append(value).append(",");
            }
            sb.setLength(sb.length() - 1);
            if (row.length > 1) {
                sb.append(")");
            }
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private List<String> runStatementOnDriver(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            throw new RuntimeException(stmt + " failed: " + cpr);
        }
        ArrayList<String> rs = new ArrayList<String>();
        this.d.getResults(rs);
        return rs;
    }

    private CommandProcessorResponse runStatementOnDriverNegative(String stmt) throws Exception {
        CommandProcessorResponse cpr = this.d.run(stmt);
        if (cpr.getResponseCode() != 0) {
            return cpr;
        }
        throw new RuntimeException("Didn't get expected failure!");
    }

    @Test
    public void exchangePartition() throws Exception {
        this.runStatementOnDriver("create database ex1");
        this.runStatementOnDriver("create database ex2");
        this.runStatementOnDriver("CREATE TABLE ex1.exchange_part_test1 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("CREATE TABLE ex2.exchange_part_test2 (f1 string) PARTITIONED BY (ds STRING)");
        this.runStatementOnDriver("ALTER TABLE ex2.exchange_part_test2 ADD PARTITION (ds='2013-04-05')");
        this.runStatementOnDriver("ALTER TABLE ex1.exchange_part_test1 EXCHANGE PARTITION (ds='2013-04-05') WITH TABLE ex2.exchange_part_test2");
    }

    @Test
    public void testMergeNegative() throws Exception {
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("MERGE INTO " + (Object)((Object)Table.ACIDTBL) + " target USING " + (Object)((Object)Table.NONACIDORCTBL) + " source\nON target.a = source.a \nWHEN MATCHED THEN UPDATE set b = 1 \nWHEN MATCHED THEN DELETE \nWHEN NOT MATCHED AND a < 1 THEN INSERT VALUES(1,2)");
        Assert.assertEquals((Object)ErrorMsg.MERGE_PREDIACTE_REQUIRED, (Object)((HiveException)cpr.getException()).getCanonicalErrorMsg());
    }

    @Test
    public void testMergeNegative2() throws Exception {
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("MERGE INTO " + (Object)((Object)Table.ACIDTBL) + " target USING " + (Object)((Object)Table.NONACIDORCTBL) + "\n source ON target.pk = source.pk \nWHEN MATCHED THEN UPDATE set b = 1 \nWHEN MATCHED THEN UPDATE set b=a");
        Assert.assertEquals((Object)ErrorMsg.MERGE_TOO_MANY_UPDATE, (Object)((HiveException)cpr.getException()).getCanonicalErrorMsg());
    }

    @Test
    public void testQuotedIdentifier() throws Exception {
        String target = "`aci/d_u/ami`";
        String src = "`src/name`";
        this.runStatementOnDriver("drop table if exists " + target);
        this.runStatementOnDriver("drop table if exists " + src);
        this.runStatementOnDriver("create table " + target + "(i int,`d?*de e` decimal(5,2),vc varchar(128)) clustered by (i) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + src + "(gh int, j decimal(5,2), k varchar(128))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah' \nwhen not matched then insert values(1,2.1,'baz')");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah',  `d?*de e` = current_timestamp()  \nwhen not matched then insert values(1,2.1, concat('baz', current_timestamp()))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='blah' \nwhen not matched then insert values(1,2.1,'a\\b')");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=gh \nwhen matched and i > 5 then delete \nwhen matched then update set vc='\u2206\u220b'\nwhen not matched then insert values(`a/b`.gh,`a/b`.j,'c\\t')");
    }

    @Test
    public void testQuotedIdentifier2() throws Exception {
        String target = "`aci/d_u/ami`";
        String src = "`src/name`";
        this.runStatementOnDriver("drop table if exists " + target);
        this.runStatementOnDriver("drop table if exists " + src);
        this.runStatementOnDriver("create table " + target + "(i int,`d?*de e` decimal(5,2),vc varchar(128)) clustered by (i) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("create table " + src + "(`g/h` int, j decimal(5,2), k varchar(128))");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=`g/h`\nwhen matched and `g/h` > 5 then delete \nwhen matched and `g/h` < 0 then update set vc='\u2206\u220b', `d?*de e` =  `d?*de e` * j + 1\nwhen not matched and `d?*de e` <> 0 then insert values(`a/b`.`g/h`,`a/b`.j,`a/b`.k)");
        this.runStatementOnDriver("merge into " + target + " as `d/8` using " + src + " as `a/b` on i=`g/h`\nwhen matched and `g/h` > 5 then delete\n when matched and `g/h` < 0 then update set vc='\u2206\u220b'  , `d?*de e` =  `d?*de e` * j + 1  \n when not matched and `d?*de e` <> 0 then insert values(`a/b`.`g/h`,`a/b`.j,`a/b`.k)");
    }

    @Test
    public void testMergeType2SCD01() throws Exception {
        this.runStatementOnDriver("drop table if exists target");
        this.runStatementOnDriver("drop table if exists source");
        this.runStatementOnDriver("drop table if exists splitTable");
        this.runStatementOnDriver("create table splitTable(op int)");
        this.runStatementOnDriver("insert into splitTable values (0),(1)");
        this.runStatementOnDriver("create table source (key int, data int)");
        this.runStatementOnDriver("create table target (key int, data int, cur int) clustered by (key) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{1, 5, 1}, {2, 6, 1}, {1, 18, 0}};
        this.runStatementOnDriver("insert into target " + this.makeValuesClause(targetVals));
        int[][] sourceVals = new int[][]{{1, 7}, {3, 8}};
        this.runStatementOnDriver("insert into source " + this.makeValuesClause(sourceVals));
        String curMatch = "select s.*, case when t.cur is null then 0 else 1 end m from source s left outer join (select * from target where target.cur=1) t on s.key=t.key";
        String teeCurMatch = "select curMatch.*, case when splitTable.op is null or splitTable.op = 0 then 0 else 1 end `o/p\\n` from (" + curMatch + ") curMatch left outer join splitTable on curMatch.m=1";
        String stmt = "merge into target t using (" + teeCurMatch + ") s on t.key=s.key and t.cur=1 and s.`o/p\\n`=1 when matched then update set cur=0 when not matched then insert values(s.key,s.data,1)";
        this.runStatementOnDriver(stmt);
        int[][] resultVals = new int[][]{{1, 5, 0}, {1, 7, 1}, {1, 18, 0}, {2, 6, 1}, {3, 8, 1}};
        List<String> r = this.runStatementOnDriver("select * from target order by key,data,cur");
        Assert.assertEquals(this.stringifyValues(resultVals), r);
    }

    @Test
    public void testMergeType2SCD02() throws Exception {
        this.runStatementOnDriver("drop table if exists target");
        this.runStatementOnDriver("drop table if exists source");
        this.runStatementOnDriver("create table source (key int, data int)");
        this.runStatementOnDriver("create table target (key int, data int, cur int) clustered by (key) into " + BUCKET_COUNT + " buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        int[][] targetVals = new int[][]{{1, 5, 1}, {2, 6, 1}, {1, 18, 0}};
        this.runStatementOnDriver("insert into target " + this.makeValuesClause(targetVals));
        int[][] sourceVals = new int[][]{{1, 7}, {3, 8}};
        this.runStatementOnDriver("insert into source " + this.makeValuesClause(sourceVals));
        String baseSrc = "select source.*, 0 c from source union all select source.*, 1 c from source inner join target on source.key=target.key where target.cur=1";
        String stmt = "merge into target t using (" + baseSrc + ") s on t.key=s.key and t.cur=s.c and t.cur=1 when matched then update set cur=0 when not matched then insert values(s.key,s.data,1)";
        this.runStatementOnDriver(stmt);
        int[][] resultVals = new int[][]{{1, 5, 0}, {1, 7, 1}, {1, 18, 0}, {2, 6, 1}, {3, 8, 1}};
        List<String> r = this.runStatementOnDriver("select * from target order by key,data,cur");
        Assert.assertEquals(this.stringifyValues(resultVals), r);
    }

    @Test
    public void testMergeOnTezEdges() throws Exception {
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as t using " + (Object)((Object)Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED AND s.a > 8 THEN DELETE WHEN MATCHED THEN UPDATE SET b = 7 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "tez");
        hc.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        List<String> explain = this.runStatementOnDriver("explain " + query);
        StringBuilder sb = new StringBuilder();
        for (String s : explain) {
            sb.append(s).append('\n');
        }
        LOG.info("Explain1: " + sb);
        for (int i = 0; i < explain.size(); ++i) {
            if (!explain.get(i).contains("Edges:")) continue;
            Assert.assertTrue((String)("At i+1=" + (i + 1) + explain.get(i + 1)), (boolean)explain.get(i + 1).contains("Reducer 2 <- Map 1 (SIMPLE_EDGE), Map 7 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 2) + explain.get(i + 2)), (boolean)explain.get(i + 2).contains("Reducer 3 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 3) + explain.get(i + 3)), (boolean)explain.get(i + 3).contains("Reducer 4 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 4) + explain.get(i + 4)), (boolean)explain.get(i + 4).contains("Reducer 5 <- Reducer 2 (SIMPLE_EDGE)"));
            Assert.assertTrue((String)("At i+1=" + (i + 5) + explain.get(i + 5)), (boolean)explain.get(i + 5).contains("Reducer 6 <- Reducer 2 (CUSTOM_SIMPLE_EDGE)"));
            break;
        }
    }

    @Test
    public void testMergeUpdateDelete() throws Exception {
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as t using " + (Object)((Object)Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN MATCHED and t.a > 3 and t.a < 5 THEN DELETE WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(this.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeUpdateDeleteNoCardCheck() throws Exception {
        this.d.destroy();
        HiveConf hc = new HiveConf(this.hiveConf);
        hc.setBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK, false);
        this.d = new Driver(hc);
        this.d.setMaxRows(10000);
        int[][] baseValsOdd = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(baseValsOdd));
        int[][] vals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(vals));
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as t using " + (Object)((Object)Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN MATCHED and t.a > 3 and t.a < 5 THEN DELETE ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{2, 0}, {5, 6}, {7, 8}};
        Assert.assertEquals(this.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeDeleteUpdate() throws Exception {
        int[][] sourceVals = new int[][]{{2, 2}, {4, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(sourceVals));
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(targetVals));
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as t using " + (Object)((Object)Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriver(query);
        List<String> r = this.runStatementOnDriver("select a,b from " + (Object)((Object)Table.ACIDTBL) + " order by a,b");
        int[][] rExpected = new int[][]{{5, 6}, {7, 8}, {11, 11}};
        Assert.assertEquals(this.stringifyValues(rExpected), r);
    }

    @Test
    public void testMergeCardinalityViolation() throws Exception {
        int[][] sourceVals = new int[][]{{2, 2}, {2, 44}, {5, 5}, {11, 11}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.NONACIDORCTBL) + " " + this.makeValuesClause(sourceVals));
        int[][] targetVals = new int[][]{{2, 1}, {4, 3}, {5, 6}, {7, 8}};
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBL) + " " + this.makeValuesClause(targetVals));
        String query = "merge into " + (Object)((Object)Table.ACIDTBL) + " as t using " + (Object)((Object)Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b) ";
        this.runStatementOnDriverNegative(query);
        this.runStatementOnDriver("insert into " + (Object)((Object)Table.ACIDTBLPART) + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1'),(4,4,'p2')");
        query = "merge into " + (Object)((Object)Table.ACIDTBLPART) + " as t using " + (Object)((Object)Table.NONACIDORCTBL) + " s ON t.a = s.a WHEN MATCHED and s.a < 5 THEN DELETE WHEN MATCHED AND s.a < 3 THEN update set b = 0 WHEN NOT MATCHED THEN INSERT VALUES(s.a, s.b, 'p1') ";
        this.runStatementOnDriverNegative(query);
    }

    @Test
    public void testSetClauseFakeColumn() throws Exception {
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("MERGE INTO " + (Object)((Object)Table.ACIDTBL) + " target USING " + (Object)((Object)Table.NONACIDORCTBL) + "\n source ON target.a = source.a \nWHEN MATCHED THEN UPDATE set t = 1");
        Assert.assertEquals((Object)ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, (Object)((HiveException)cpr.getException()).getCanonicalErrorMsg());
        cpr = this.runStatementOnDriverNegative("update " + (Object)((Object)Table.ACIDTBL) + " set t = 1");
        Assert.assertEquals((Object)ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, (Object)((HiveException)cpr.getException()).getCanonicalErrorMsg());
    }

    @Test
    public void testBadOnClause() throws Exception {
        CommandProcessorResponse cpr = this.runStatementOnDriverNegative("merge into " + (Object)((Object)Table.ACIDTBL) + " trgt using (select * from " + (Object)((Object)Table.NONACIDORCTBL) + "src) sub on sub.a = target.a when not matched then insert values (sub.a,sub.b)");
        Assert.assertTrue((String)("Error didn't match: " + cpr), (boolean)cpr.getErrorMessage().contains("No columns from target table 'trgt' found in ON clause '`sub`.`a` = `target`.`a`' of MERGE statement."));
    }

    @Test
    public void testCompactionBlocking() throws Exception {
        Timer cancelCompact = new Timer("CancelCompactionTimer", false);
        final Thread threadToInterrupt = Thread.currentThread();
        cancelCompact.schedule(new TimerTask(){

            @Override
            public void run() {
                threadToInterrupt.interrupt();
            }
        }, 5000L);
        long start = System.currentTimeMillis();
        this.runStatementOnDriver("alter table " + (Object)((Object)TestTxnCommands2.Table.ACIDTBL) + " compact 'major' AND WAIT");
        Assert.assertTrue((System.currentTimeMillis() > start + 2L ? 1 : 0) != 0);
    }

    @Test
    public void testMergeCase() throws Exception {
        this.runStatementOnDriver("create table merge_test (c1 integer, c2 integer, c3 integer) CLUSTERED BY (c1) into 2 buckets stored as orc tblproperties(\"transactional\"=\"true\")");
        this.runStatementOnDriver("create table if not exists e011_02 (c1 float, c2 double, c3 float)");
        this.runStatementOnDriver("merge into merge_test using e011_02 on (merge_test.c1 = e011_02.c1) when not matched then insert values (case when e011_02.c1 > 0 then e011_02.c1 + 1 else e011_02.c1 end, e011_02.c2 + e011_02.c3, coalesce(e011_02.c3, 1))");
    }

    private static final class RowComp
    implements Comparator<int[]> {
        private RowComp() {
        }

        @Override
        public int compare(int[] row1, int[] row2) {
            assert (row1 != null && row2 != null && row1.length == row2.length);
            for (int i = 0; i < row1.length; ++i) {
                int comp = Integer.compare(row1[i], row2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private static enum Table {
        ACIDTBL("acidTbl"),
        ACIDTBLPART("acidTblPart"),
        ACIDTBL2("acidTbl2"),
        NONACIDORCTBL("nonAcidOrcTbl"),
        NONACIDORCTBL2("nonAcidOrcTbl2");

        private final String name;

        public String toString() {
            return this.name;
        }

        private Table(String name) {
            this.name = name;
        }
    }
}

