/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleDeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.fast.LazySimpleSerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class TestVectorSerDeRow
extends TestCase {
    void deserializeAndVerify(ByteStream.Output output, DeserializeRead deserializeRead, VectorRandomRowSource source, Object[] expectedRow) throws HiveException, IOException {
        deserializeRead.set(output.getData(), 0, output.getLength());
        PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories = source.primitiveCategories();
        block21: for (int i = 0; i < primitiveCategories.length; ++i) {
            Object expected = expectedRow[i];
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveCategories[i];
            PrimitiveTypeInfo primitiveTypeInfo = source.primitiveTypeInfos()[i];
            if (!deserializeRead.readNextField()) {
                throw new HiveException("Unexpected NULL when reading primitiveCategory " + primitiveCategory + " expected (" + expected.getClass().getName() + ", " + expected.toString() + ")  deserializeRead " + deserializeRead.getClass().getName());
            }
            switch (primitiveCategory) {
                case BOOLEAN: {
                    Object value = deserializeRead.currentBoolean;
                    DateWritable expectedWritable = (BooleanWritable)expected;
                    if (((Boolean)value).equals(expectedWritable.get())) continue block21;
                    TestCase.fail((String)("Boolean field mismatch (expected " + expected + " found " + value + ")"));
                    continue block21;
                }
                case BYTE: {
                    Object value = deserializeRead.currentByte;
                    DateWritable expectedWritable = (ByteWritable)expected;
                    if (((Byte)value).equals(expectedWritable.get())) continue block21;
                    TestCase.fail((String)("Byte field mismatch (expected " + (Integer)expected + " found " + (Byte)value + ")"));
                    continue block21;
                }
                case SHORT: {
                    Object value = deserializeRead.currentShort;
                    DateWritable expectedWritable = (ShortWritable)expected;
                    if (((Short)value).equals(expectedWritable.get())) continue block21;
                    TestCase.fail((String)("Short field mismatch (expected " + expected + " found " + value + ")"));
                    continue block21;
                }
                case INT: {
                    Object value = deserializeRead.currentInt;
                    DateWritable expectedWritable = (IntWritable)expected;
                    if (((Integer)value).equals(expectedWritable.get())) continue block21;
                    TestCase.fail((String)("Int field mismatch (expected " + expected + " found " + value + ")"));
                    continue block21;
                }
                case LONG: {
                    Object value = deserializeRead.currentLong;
                    DateWritable expectedWritable = (LongWritable)expected;
                    if (((Long)value).equals(expectedWritable.get())) continue block21;
                    TestCase.fail((String)("Long field mismatch (expected " + expected + " found " + value + ")"));
                    continue block21;
                }
                case DATE: {
                    Object value = deserializeRead.currentDateWritable;
                    DateWritable expectedWritable = (DateWritable)expected;
                    if (value.equals((Object)expectedWritable)) continue block21;
                    TestCase.fail((String)("Date field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                    continue block21;
                }
                case FLOAT: {
                    Object value = Float.valueOf(deserializeRead.currentFloat);
                    DateWritable expectedWritable = (FloatWritable)expected;
                    if (((Float)value).equals(Float.valueOf(expectedWritable.get()))) continue block21;
                    TestCase.fail((String)("Float field mismatch (expected " + expected + " found " + value + ")"));
                    continue block21;
                }
                case DOUBLE: {
                    Object value = deserializeRead.currentDouble;
                    DateWritable expectedWritable = (DoubleWritable)expected;
                    if (((Double)value).equals(expectedWritable.get())) continue block21;
                    TestCase.fail((String)("Double field mismatch (expected " + expected + " found " + value + ")"));
                    continue block21;
                }
                case STRING: 
                case CHAR: 
                case VARCHAR: 
                case BINARY: {
                    byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                    Text text = new Text(stringBytes);
                    String string = text.toString();
                    switch (primitiveCategory) {
                        case STRING: {
                            Text expectedWritable = (Text)expected;
                            if (string.equals(expectedWritable.toString())) continue block21;
                            TestCase.fail((String)("String field mismatch (expected '" + expectedWritable.toString() + "' found '" + string + "')"));
                            continue block21;
                        }
                        case CHAR: {
                            HiveChar hiveChar = new HiveChar(string, ((CharTypeInfo)primitiveTypeInfo).getLength());
                            HiveCharWritable expectedWritable = (HiveCharWritable)expected;
                            if (hiveChar.equals((Object)expectedWritable.getHiveChar())) continue block21;
                            TestCase.fail((String)("Char field mismatch (expected '" + expectedWritable.getHiveChar() + "' found '" + hiveChar + "')"));
                            continue block21;
                        }
                        case VARCHAR: {
                            HiveVarchar hiveVarchar = new HiveVarchar(string, ((VarcharTypeInfo)primitiveTypeInfo).getLength());
                            HiveVarcharWritable expectedWritable = (HiveVarcharWritable)expected;
                            if (hiveVarchar.equals((Object)expectedWritable.getHiveVarchar())) continue block21;
                            TestCase.fail((String)("Varchar field mismatch (expected '" + expectedWritable.getHiveVarchar() + "' found '" + hiveVarchar + "')"));
                            continue block21;
                        }
                        case BINARY: {
                            Text expectedWritable = (BytesWritable)expected;
                            if (stringBytes.length != expectedWritable.getLength()) {
                                TestCase.fail((String)("Byte Array field mismatch (expected " + expected + " found " + stringBytes + ")"));
                            }
                            byte[] expectedBytes = expectedWritable.getBytes();
                            for (int b = 0; b < stringBytes.length; ++b) {
                                if (stringBytes[b] == expectedBytes[b]) continue;
                                TestCase.fail((String)("Byte Array field mismatch (expected " + expected + " found " + stringBytes + ")"));
                            }
                            continue block21;
                        }
                        default: {
                            throw new HiveException("Unexpected primitive category " + primitiveCategory);
                        }
                    }
                }
                case DECIMAL: {
                    DateWritable expectedWritable;
                    Object value = deserializeRead.currentHiveDecimalWritable.getHiveDecimal();
                    if (value == null) {
                        TestCase.fail((String)"Decimal field evaluated to NULL");
                    }
                    if (value.equals((Object)(expectedWritable = (HiveDecimalWritable)expected).getHiveDecimal())) continue block21;
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                    int precision = decimalTypeInfo.getPrecision();
                    int scale = decimalTypeInfo.getScale();
                    TestCase.fail((String)("Decimal field mismatch (expected " + expectedWritable.getHiveDecimal() + " found " + value.toString() + ") precision " + precision + ", scale " + scale));
                    continue block21;
                }
                case TIMESTAMP: {
                    Object value = deserializeRead.currentTimestampWritable.getTimestamp();
                    DateWritable expectedWritable = (TimestampWritable)expected;
                    if (((Timestamp)value).equals(expectedWritable.getTimestamp())) continue block21;
                    TestCase.fail((String)("Timestamp field mismatch (expected " + expectedWritable.getTimestamp() + " found " + ((Timestamp)value).toString() + ")"));
                    continue block21;
                }
                case INTERVAL_YEAR_MONTH: {
                    Object value = deserializeRead.currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth();
                    DateWritable expectedWritable = (HiveIntervalYearMonthWritable)expected;
                    HiveIntervalYearMonth expectedValue = expectedWritable.getHiveIntervalYearMonth();
                    if (value.equals((Object)expectedValue)) continue block21;
                    TestCase.fail((String)("HiveIntervalYearMonth field mismatch (expected " + expectedValue + " found " + value.toString() + ")"));
                    continue block21;
                }
                case INTERVAL_DAY_TIME: {
                    Object value = deserializeRead.currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime();
                    DateWritable expectedWritable = (HiveIntervalDayTimeWritable)expected;
                    HiveIntervalYearMonth expectedValue = expectedWritable.getHiveIntervalDayTime();
                    if (value.equals((Object)expectedValue)) continue block21;
                    TestCase.fail((String)("HiveIntervalDayTime field mismatch (expected " + expectedValue + " found " + value.toString() + ")"));
                    continue block21;
                }
                default: {
                    throw new HiveException("Unexpected primitive category " + primitiveCategory);
                }
            }
        }
        TestCase.assertTrue((boolean)deserializeRead.isEndOfInputReached());
    }

    void serializeBatch(VectorizedRowBatch batch, VectorSerializeRow vectorSerializeRow, DeserializeRead deserializeRead, VectorRandomRowSource source, Object[][] randomRows, int firstRandomRowIndex) throws HiveException, IOException {
        ByteStream.Output output = new ByteStream.Output();
        for (int i = 0; i < batch.size; ++i) {
            output.reset();
            vectorSerializeRow.setOutput(output);
            vectorSerializeRow.serializeWrite(batch, i);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            byte[] bytes = output.getData();
            int length = output.getLength();
            char[] chars = new char[length];
            for (int c = 0; c < chars.length; ++c) {
                chars[c] = (char)(bytes[c] & 0xFF);
            }
            this.deserializeAndVerify(output, deserializeRead, source, expectedRow);
        }
    }

    void testVectorSerializeRow(Random r, SerializationType serializationType) throws HiveException, IOException, SerDeException {
        BinarySortableSerializeWrite serializeWrite;
        BinarySortableDeserializeRead deserializeRead;
        String[] emptyScratchTypeNames = new String[]{};
        VectorRandomRowSource source = new VectorRandomRowSource();
        source.init(r);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorAssignRow vectorAssignRow = new VectorAssignRow();
        vectorAssignRow.init(source.typeNames());
        int fieldCount = source.typeNames().size();
        switch (serializationType) {
            case BINARY_SORTABLE: {
                deserializeRead = new BinarySortableDeserializeRead(source.primitiveTypeInfos(), false);
                serializeWrite = new BinarySortableSerializeWrite(fieldCount);
                break;
            }
            case LAZY_BINARY: {
                deserializeRead = new LazyBinaryDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), false);
                serializeWrite = new LazyBinarySerializeWrite(fieldCount);
                break;
            }
            case LAZY_SIMPLE: {
                StructObjectInspector rowObjectInspector = source.rowStructObjectInspector();
                LazySerDeParameters lazySerDeParams = this.getSerDeParams(rowObjectInspector);
                byte separator = 9;
                deserializeRead = new LazySimpleDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), false, separator, lazySerDeParams);
                serializeWrite = new LazySimpleSerializeWrite(fieldCount, separator, lazySerDeParams);
                break;
            }
            default: {
                throw new Error("Unknown serialization type " + (Object)((Object)serializationType));
            }
        }
        VectorSerializeRow vectorSerializeRow = new VectorSerializeRow((SerializeWrite)serializeWrite);
        vectorSerializeRow.init(source.typeNames());
        Object[][] randomRows = source.randomRows(100000);
        int firstRandomRowIndex = 0;
        for (int i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            vectorAssignRow.assignRow(batch, batch.size, row);
            ++batch.size;
            if (batch.size != 1024) continue;
            this.serializeBatch(batch, vectorSerializeRow, (DeserializeRead)deserializeRead, source, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.serializeBatch(batch, vectorSerializeRow, (DeserializeRead)deserializeRead, source, randomRows, firstRandomRowIndex);
        }
    }

    void examineBatch(VectorizedRowBatch batch, VectorExtractRow vectorExtractRow, PrimitiveTypeInfo[] primitiveTypeInfos, Object[][] randomRows, int firstRandomRowIndex) {
        int rowSize = vectorExtractRow.getCount();
        Object[] row = new Object[rowSize];
        for (int i = 0; i < batch.size; ++i) {
            vectorExtractRow.extractRow(batch, i, row);
            Object[] expectedRow = randomRows[firstRandomRowIndex + i];
            for (int c = 0; c < rowSize; ++c) {
                Object rowObj = row[c];
                Object expectedObj = expectedRow[c];
                if (rowObj == null) {
                    TestVectorSerDeRow.fail((String)("Unexpected NULL from extractRow.  Expected class " + expectedObj.getClass().getName() + " value " + expectedObj.toString() + " batch index " + i + " firstRandomRowIndex " + firstRandomRowIndex));
                }
                if (rowObj.equals(expectedObj)) continue;
                TestVectorSerDeRow.fail((String)("Row " + (firstRandomRowIndex + i) + " and column " + c + " mismatch (" + primitiveTypeInfos[c].getPrimitiveCategory() + " actual value " + rowObj + " and expected value " + expectedObj + ")"));
            }
        }
    }

    private ByteStream.Output serializeRow(Object[] row, VectorRandomRowSource source, SerializeWrite serializeWrite) throws HiveException, IOException {
        ByteStream.Output output = new ByteStream.Output();
        serializeWrite.set(output);
        PrimitiveTypeInfo[] primitiveTypeInfos = source.primitiveTypeInfos();
        block18: for (int i = 0; i < primitiveTypeInfos.length; ++i) {
            Object object = row[i];
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfos[i].getPrimitiveCategory();
            switch (primitiveCategory) {
                case BOOLEAN: {
                    BooleanWritable expectedWritable = (BooleanWritable)object;
                    boolean value = expectedWritable.get();
                    serializeWrite.writeBoolean(value);
                    continue block18;
                }
                case BYTE: {
                    BooleanWritable expectedWritable = (ByteWritable)object;
                    byte value = expectedWritable.get();
                    serializeWrite.writeByte(value);
                    continue block18;
                }
                case SHORT: {
                    BooleanWritable expectedWritable = (ShortWritable)object;
                    short value = expectedWritable.get();
                    serializeWrite.writeShort(value);
                    continue block18;
                }
                case INT: {
                    BooleanWritable expectedWritable = (IntWritable)object;
                    int value = expectedWritable.get();
                    serializeWrite.writeInt(value);
                    continue block18;
                }
                case LONG: {
                    BooleanWritable expectedWritable = (LongWritable)object;
                    long value = expectedWritable.get();
                    serializeWrite.writeLong(value);
                    continue block18;
                }
                case DATE: {
                    BooleanWritable expectedWritable = (DateWritable)object;
                    Date value = expectedWritable.get();
                    serializeWrite.writeDate(value);
                    continue block18;
                }
                case FLOAT: {
                    BooleanWritable expectedWritable = (FloatWritable)object;
                    float value = expectedWritable.get();
                    serializeWrite.writeFloat(value);
                    continue block18;
                }
                case DOUBLE: {
                    BooleanWritable expectedWritable = (DoubleWritable)object;
                    double value = expectedWritable.get();
                    serializeWrite.writeDouble(value);
                    continue block18;
                }
                case STRING: {
                    Text text = (Text)object;
                    serializeWrite.writeString(text.getBytes(), 0, text.getLength());
                    continue block18;
                }
                case CHAR: {
                    BooleanWritable expectedWritable = (HiveCharWritable)object;
                    HiveChar value = expectedWritable.getHiveChar();
                    serializeWrite.writeHiveChar(value);
                    continue block18;
                }
                case VARCHAR: {
                    BooleanWritable expectedWritable = (HiveVarcharWritable)object;
                    HiveVarchar value = expectedWritable.getHiveVarchar();
                    serializeWrite.writeHiveVarchar(value);
                    continue block18;
                }
                case BINARY: {
                    BooleanWritable expectedWritable = (BytesWritable)object;
                    byte[] bytes = expectedWritable.getBytes();
                    int length = expectedWritable.getLength();
                    serializeWrite.writeBinary(bytes, 0, length);
                    continue block18;
                }
                case TIMESTAMP: {
                    BooleanWritable expectedWritable = (TimestampWritable)object;
                    Timestamp value = expectedWritable.getTimestamp();
                    serializeWrite.writeTimestamp(value);
                    continue block18;
                }
                case INTERVAL_YEAR_MONTH: {
                    BooleanWritable expectedWritable = (HiveIntervalYearMonthWritable)object;
                    HiveIntervalYearMonth value = expectedWritable.getHiveIntervalYearMonth();
                    serializeWrite.writeHiveIntervalYearMonth(value);
                    continue block18;
                }
                case INTERVAL_DAY_TIME: {
                    BooleanWritable expectedWritable = (HiveIntervalDayTimeWritable)object;
                    HiveIntervalDayTime value = expectedWritable.getHiveIntervalDayTime();
                    serializeWrite.writeHiveIntervalDayTime(value);
                    continue block18;
                }
                case DECIMAL: {
                    BooleanWritable expectedWritable = (HiveDecimalWritable)object;
                    HiveDecimal value = expectedWritable.getHiveDecimal();
                    serializeWrite.writeHiveDecimal(value, ((DecimalTypeInfo)primitiveTypeInfos[i]).scale());
                    continue block18;
                }
                default: {
                    throw new HiveException("Unexpected primitive category " + primitiveCategory);
                }
            }
        }
        return output;
    }

    private void addToProperties(Properties tbl, String fieldNames, String fieldTypes) {
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", fieldNames);
        tbl.setProperty("columns.types", fieldTypes);
        tbl.setProperty("serialization.null.format", "NULL");
    }

    private LazySerDeParameters getSerDeParams(StructObjectInspector rowObjectInspector) throws SerDeException {
        return this.getSerDeParams(new Configuration(), new Properties(), rowObjectInspector);
    }

    private LazySerDeParameters getSerDeParams(Configuration conf, Properties tbl, StructObjectInspector rowObjectInspector) throws SerDeException {
        String fieldNames = ObjectInspectorUtils.getFieldNames((StructObjectInspector)rowObjectInspector);
        String fieldTypes = ObjectInspectorUtils.getFieldTypes((StructObjectInspector)rowObjectInspector);
        this.addToProperties(tbl, fieldNames, fieldTypes);
        return new LazySerDeParameters(conf, tbl, LazySimpleSerDe.class.getName());
    }

    void testVectorDeserializeRow(Random r, SerializationType serializationType, boolean alternate1, boolean alternate2, boolean useExternalBuffer) throws HiveException, IOException, SerDeException {
        int i;
        LazyBinarySerializeWrite serializeWrite;
        LazyBinaryDeserializeRead deserializeRead;
        String[] emptyScratchTypeNames = new String[]{};
        VectorRandomRowSource source = new VectorRandomRowSource();
        source.init(r);
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx();
        batchContext.init(source.rowStructObjectInspector(), emptyScratchTypeNames);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
        }
        PrimitiveTypeInfo[] primitiveTypeInfos = source.primitiveTypeInfos();
        int fieldCount = source.typeNames().size();
        switch (serializationType) {
            case BINARY_SORTABLE: {
                boolean useColumnSortOrderIsDesc = alternate1;
                if (!useColumnSortOrderIsDesc) {
                    deserializeRead = new BinarySortableDeserializeRead(source.primitiveTypeInfos(), useExternalBuffer);
                    serializeWrite = new BinarySortableSerializeWrite(fieldCount);
                } else {
                    boolean[] columnSortOrderIsDesc = new boolean[fieldCount];
                    for (int i2 = 0; i2 < fieldCount; ++i2) {
                        columnSortOrderIsDesc[i2] = r.nextBoolean();
                    }
                    deserializeRead = new BinarySortableDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), useExternalBuffer, columnSortOrderIsDesc);
                    byte[] columnNullMarker = new byte[fieldCount];
                    byte[] columnNotNullMarker = new byte[fieldCount];
                    for (i = 0; i < fieldCount; ++i) {
                        if (columnSortOrderIsDesc[i]) {
                            columnNullMarker[i] = 0;
                            columnNotNullMarker[i] = 1;
                            continue;
                        }
                        columnNullMarker[i] = 0;
                        columnNotNullMarker[i] = 1;
                    }
                    serializeWrite = new BinarySortableSerializeWrite(columnSortOrderIsDesc, columnNullMarker, columnNotNullMarker);
                }
                boolean useBinarySortableCharsNeedingEscape = alternate2;
                if (!useBinarySortableCharsNeedingEscape) break;
                source.addBinarySortableAlphabets();
                break;
            }
            case LAZY_BINARY: {
                deserializeRead = new LazyBinaryDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), useExternalBuffer);
                serializeWrite = new LazyBinarySerializeWrite(fieldCount);
                break;
            }
            case LAZY_SIMPLE: {
                StructObjectInspector rowObjectInspector = source.rowStructObjectInspector();
                Configuration conf = new Configuration();
                Properties tbl = new Properties();
                tbl.setProperty("field.delim", "\t");
                tbl.setProperty("line.delim", "\n");
                byte separator = 9;
                boolean useLazySimpleEscapes = alternate1;
                if (useLazySimpleEscapes) {
                    tbl.setProperty("quote.delim", "'");
                    String escapeString = "\\";
                    tbl.setProperty("escape.delim", escapeString);
                }
                LazySerDeParameters lazySerDeParams = this.getSerDeParams(conf, tbl, rowObjectInspector);
                if (useLazySimpleEscapes) {
                    String needsEscapeStr;
                    boolean[] needsEscape = lazySerDeParams.getNeedsEscape();
                    StringBuilder sb = new StringBuilder();
                    if (needsEscape[10]) {
                        sb.append('\n');
                    }
                    if (needsEscape[13]) {
                        sb.append('\r');
                    }
                    if ((needsEscapeStr = sb.toString()).length() > 0) {
                        source.addEscapables(needsEscapeStr);
                    }
                }
                deserializeRead = new LazySimpleDeserializeRead((TypeInfo[])source.primitiveTypeInfos(), useExternalBuffer, separator, lazySerDeParams);
                serializeWrite = new LazySimpleSerializeWrite(fieldCount, separator, lazySerDeParams);
                break;
            }
            default: {
                throw new Error("Unknown serialization type " + (Object)((Object)serializationType));
            }
        }
        VectorDeserializeRow vectorDeserializeRow = new VectorDeserializeRow((DeserializeRead)deserializeRead);
        vectorDeserializeRow.init();
        for (ColumnVector cv : batch.cols) {
            Arrays.fill(cv.isNull, true);
            cv.noNulls = false;
        }
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(source.typeNames());
        Object[][] randomRows = source.randomRows(100000);
        int firstRandomRowIndex = 0;
        for (i = 0; i < randomRows.length; ++i) {
            Object[] row = randomRows[i];
            ByteStream.Output output = this.serializeRow(row, source, (SerializeWrite)serializeWrite);
            vectorDeserializeRow.setBytes(output.getData(), 0, output.getLength());
            try {
                vectorDeserializeRow.deserialize(batch, batch.size);
            }
            catch (Exception e) {
                throw new HiveException("\nDeserializeRead details: " + vectorDeserializeRow.getDetailedReadPositionString(), (Throwable)e);
            }
            ++batch.size;
            if (batch.size != 1024) continue;
            this.examineBatch(batch, vectorExtractRow, primitiveTypeInfos, randomRows, firstRandomRowIndex);
            firstRandomRowIndex = i + 1;
            batch.reset();
        }
        if (batch.size > 0) {
            this.examineBatch(batch, vectorExtractRow, primitiveTypeInfos, randomRows, firstRandomRowIndex);
        }
    }

    public void testVectorBinarySortableSerializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorSerializeRow(r, SerializationType.BINARY_SORTABLE);
    }

    public void testVectorLazyBinarySerializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorSerializeRow(r, SerializationType.LAZY_BINARY);
    }

    public void testVectorLazySimpleSerializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorSerializeRow(r, SerializationType.LAZY_SIMPLE);
    }

    public void testVectorBinarySortableDeserializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, false, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, false, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, false, true);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, false, true);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, true, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, true, false);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, false, true, true);
        this.testVectorDeserializeRow(r, SerializationType.BINARY_SORTABLE, true, true, true);
    }

    public void testVectorLazyBinaryDeserializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_BINARY, false, false, false);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_BINARY, false, false, true);
    }

    public void testVectorLazySimpleDeserializeRow() throws Throwable {
        Random r = new Random(8732L);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, false, false, false);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, false, false, true);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, true, false, false);
        this.testVectorDeserializeRow(r, SerializationType.LAZY_SIMPLE, true, false, true);
    }

    public static enum SerializationType {
        NONE,
        BINARY_SORTABLE,
        LAZY_BINARY,
        LAZY_SIMPLE;

    }
}

