/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFHelloTest
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger(UDFHelloTest.class);
    private Text result = new Text();
    private static String greeting = "";
    private ObjectInspectorConverters.Converter[] converters;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        if (arg0.length != 1) {
            LOG.error("UDFHelloTest expects exactly 1 argument");
            throw new HiveException("UDFHelloTest expects exactly 1 argument");
        }
        if (arg0[0].get() == null) {
            LOG.warn("Empty input");
            return null;
        }
        Text data = (Text)this.converters[0].convert(arg0[0].get());
        String dataString = data.toString();
        this.result.set(greeting + dataString);
        return this.result;
    }

    public String getDisplayString(String[] arg0) {
        return "Hello...";
    }

    public void configure(MapredContext context) {
        greeting = "Hello ";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        this.converters = new ObjectInspectorConverters.Converter[arg0.length];
        for (int i = 0; i < arg0.length; ++i) {
            this.converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)arg0[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }
}

