/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastLongHashMultiSet
extends CommonFastHashTable {
    @Test
    public void testOneKey() throws Exception {
        random = new Random(458L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        long key = random.nextLong();
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify(map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify(map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify(map);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(8000L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify(map);
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(4000L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        long key1 = random.nextLong();
        map.testPutRow(key1);
        verifyTable.add(key1);
        verifyTable.verify(map);
        long key2 = ++key1;
        VectorMapJoinHashMultiSetResult hashMultiSetResult = map.createHashMultiSetResult();
        JoinUtil.JoinResult joinResult = map.contains(key2, hashMultiSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertEquals((long)hashMultiSetResult.count(), (long)0L);
        map.testPutRow(key2);
        verifyTable.add(key2);
        verifyTable.verify(map);
        long key3 = ++key2;
        hashMultiSetResult = map.createHashMultiSetResult();
        joinResult = map.contains(key3, hashMultiSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertEquals((long)hashMultiSetResult.count(), (long)0L);
    }

    @Test
    public void testFullMap() throws Exception {
        long anotherKey;
        random = new Random(25000L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 1.0f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        for (int i = 0; i < 8; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify(map);
        while (verifyTable.contains(anotherKey = random.nextLong())) {
        }
        VectorMapJoinHashMultiSetResult hashMultiSetResult = map.createHashMultiSetResult();
        JoinUtil.JoinResult joinResult = map.contains(anotherKey, hashMultiSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(30000L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 1, 1.0E-7f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        for (int i = 0; i < 18; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify(map);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastLongHashMultiSet map, CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = new byte[TestVectorMapJoinFastLongHashMultiSet.generateLargeCount() - 1];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                long key;
                while (verifyTable.contains(key = random.nextLong())) {
                }
                map.testPutRow(key);
                verifyTable.add(key);
                verifyTable.verify(map);
            } else {
                long randomExistingKey = verifyTable.addRandomExisting(value, random);
                map.testPutRow(randomExistingKey);
            }
            verifyTable.verify(map);
        }
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(333L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(790L);
        VectorMapJoinFastLongHashMultiSet map = new VectorMapJoinFastLongHashMultiSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 512, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastLongHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastLongHashMultiSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }
}

