/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.MetricsQueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContextImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMetricsQueryLifeTimeHook {
    private MetricsQueryLifeTimeHook hook;
    private QueryLifeTimeHookContext ctx;
    private MetricRegistry metricRegistry;

    @Before
    public void before() throws Exception {
        HiveConf conf = new HiveConf();
        conf.set("fs.defaultFS", "local");
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_CLASS, CodahaleMetrics.class.getCanonicalName());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, MetricsReporting.JSON_FILE.name() + "," + MetricsReporting.JMX.name());
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, "100000s");
        MetricsFactory.init((HiveConf)conf);
        this.metricRegistry = ((CodahaleMetrics)MetricsFactory.getInstance()).getMetricRegistry();
        this.hook = new MetricsQueryLifeTimeHook();
        this.ctx = new QueryLifeTimeHookContextImpl();
    }

    @Test
    public void testCompilationQueryMetric() {
        Timer timer = (Timer)this.metricRegistry.getTimers().get("hs2_compiling_queries");
        Counter counter = (Counter)this.metricRegistry.getCounters().get("active_calls_hs2_compiling_queries");
        Assert.assertThat((Object)timer, (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)counter, (Matcher)CoreMatchers.nullValue());
        this.hook.beforeCompile(this.ctx);
        timer = (Timer)this.metricRegistry.getTimers().get("hs2_compiling_queries");
        counter = (Counter)this.metricRegistry.getCounters().get("active_calls_hs2_compiling_queries");
        Assert.assertThat((Object)timer.getCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertThat((Object)counter.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
        this.hook.afterCompile(this.ctx, false);
        timer = (Timer)this.metricRegistry.getTimers().get("hs2_compiling_queries");
        counter = (Counter)this.metricRegistry.getCounters().get("active_calls_hs2_compiling_queries");
        Assert.assertThat((Object)timer.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)counter.getCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testExecutionQueryMetric() {
        Timer timer = (Timer)this.metricRegistry.getTimers().get("hs2_executing_queries");
        Counter counter = (Counter)this.metricRegistry.getCounters().get("active_calls_hs2_executing_queries");
        Assert.assertThat((Object)timer, (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)counter, (Matcher)CoreMatchers.nullValue());
        this.hook.beforeExecution(this.ctx);
        timer = (Timer)this.metricRegistry.getTimers().get("hs2_executing_queries");
        counter = (Counter)this.metricRegistry.getCounters().get("active_calls_hs2_executing_queries");
        Assert.assertThat((Object)timer.getCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertThat((Object)counter.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
        this.hook.afterExecution(this.ctx, false);
        timer = (Timer)this.metricRegistry.getTimers().get("hs2_executing_queries");
        counter = (Counter)this.metricRegistry.getCounters().get("active_calls_hs2_executing_queries");
        Assert.assertThat((Object)timer.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)counter.getCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void testNoErrorOnDisabledMetrics() throws Exception {
        MetricsFactory.close();
        MetricsQueryLifeTimeHook emptyhook = new MetricsQueryLifeTimeHook();
        Assert.assertThat((Object)MetricsFactory.getInstance(), (Matcher)CoreMatchers.nullValue());
        emptyhook.beforeCompile(this.ctx);
        emptyhook.afterCompile(this.ctx, false);
        emptyhook.beforeExecution(this.ctx);
        emptyhook.afterExecution(this.ctx, false);
    }
}

