/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.index.IndexResult;
import org.apache.hadoop.hive.ql.index.MockIndexResult;
import org.apache.hadoop.hive.ql.index.MockInputFile;
import org.apache.hadoop.hive.ql.index.SplitFilter;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.junit.Assert;

public final class SplitFilterTestCase {
    public static final long DEFAULT_SPLIT_SIZE = 0x100000L;
    public static final long SMALL_SPLIT_SIZE = 500L;
    private final Set<HiveInputFormat.HiveInputSplit> allSplits;
    private final Set<HiveInputFormat.HiveInputSplit> selectedSplits;
    private final Set<HiveInputFormat.HiveInputSplit> expectedSplits;
    private final long maxInputSize;

    private SplitFilterTestCase(Iterable<HiveInputFormat.HiveInputSplit> allSplits, Iterable<HiveInputFormat.HiveInputSplit> selectedSplits, Iterable<HiveInputFormat.HiveInputSplit> expectedSplits, long maxInputSize) {
        this.allSplits = ImmutableSet.copyOf(allSplits);
        this.selectedSplits = ImmutableSet.copyOf(selectedSplits);
        this.expectedSplits = ImmutableSet.copyOf(expectedSplits);
        this.maxInputSize = maxInputSize;
    }

    private HiveInputFormat.HiveInputSplit[] toArray(Collection<HiveInputFormat.HiveInputSplit> splits) {
        return splits.toArray(new HiveInputFormat.HiveInputSplit[splits.size()]);
    }

    public void executeAndValidate() throws IOException {
        SplitFilter filter = new SplitFilter((IndexResult)new MockIndexResult(this.selectedSplits), this.maxInputSize);
        List actualSplits = filter.filter(this.toArray(this.allSplits));
        this.assertSplits(this.expectedSplits, actualSplits);
    }

    private void assertSplits(Collection<HiveInputFormat.HiveInputSplit> expectedSplits, Collection<HiveInputFormat.HiveInputSplit> actualSplits) {
        SplitFilter.HiveInputSplitComparator hiveInputSplitComparator = new SplitFilter.HiveInputSplitComparator();
        ArrayList<HiveInputFormat.HiveInputSplit> sortedExpectedSplits = new ArrayList<HiveInputFormat.HiveInputSplit>(expectedSplits);
        Collections.sort(sortedExpectedSplits, hiveInputSplitComparator);
        ArrayList<HiveInputFormat.HiveInputSplit> sortedActualSplits = new ArrayList<HiveInputFormat.HiveInputSplit>(actualSplits);
        Collections.sort(sortedActualSplits, hiveInputSplitComparator);
        Assert.assertEquals((String)"Number of selected splits.", (long)sortedExpectedSplits.size(), (long)sortedActualSplits.size());
        for (int i = 0; i < sortedExpectedSplits.size(); ++i) {
            HiveInputFormat.HiveInputSplit expectedSplit = (HiveInputFormat.HiveInputSplit)sortedExpectedSplits.get(i);
            HiveInputFormat.HiveInputSplit actualSplit = (HiveInputFormat.HiveInputSplit)sortedActualSplits.get(i);
            String splitName = "Split #" + i;
            Assert.assertEquals((String)(splitName + " path."), (Object)expectedSplit.getPath(), (Object)actualSplit.getPath());
            Assert.assertEquals((String)(splitName + " start."), (long)expectedSplit.getStart(), (long)actualSplit.getStart());
            Assert.assertEquals((String)(splitName + " length."), (long)expectedSplit.getLength(), (long)actualSplit.getLength());
        }
    }

    public static MaxInputSizeStep builder() {
        return new SplitFilterTestCaseBuilder();
    }

    private static final class SplitFilterTestCaseBuilder
    implements MaxInputSizeStep,
    InputFilesStep,
    ExpectedSplitsStep,
    BuildStep {
        private long maxInputSize = Long.MAX_VALUE;
        private List<MockInputFile> inputFiles;
        private List<HiveInputFormat.HiveInputSplit> expectedSplits;

        private SplitFilterTestCaseBuilder() {
        }

        @Override
        public InputFilesStep maxInputSize(long maxInputSize) {
            this.maxInputSize = maxInputSize;
            return this;
        }

        @Override
        public ExpectedSplitsStep inputFiles(MockInputFile ... inputFiles) {
            this.inputFiles = Arrays.asList(inputFiles);
            return this;
        }

        @Override
        public BuildStep expectedSplits(HiveInputFormat.HiveInputSplit ... expectedSplits) {
            this.expectedSplits = Arrays.asList(expectedSplits);
            return this;
        }

        @Override
        public SplitFilterTestCase build() {
            ArrayList<HiveInputFormat.HiveInputSplit> allSplits = new ArrayList<HiveInputFormat.HiveInputSplit>();
            ArrayList<HiveInputFormat.HiveInputSplit> selectedSplits = new ArrayList<HiveInputFormat.HiveInputSplit>();
            HashSet<String> seenPaths = new HashSet<String>();
            for (MockInputFile inputFile : this.inputFiles) {
                if (seenPaths.add(inputFile.getPath())) {
                    allSplits.addAll(inputFile.getSplits());
                    selectedSplits.addAll(inputFile.getSelectedSplits());
                    continue;
                }
                Assert.fail((String)String.format("Cannot add 2 input files with the same path to a test case. The duplicated path is '%s'.", inputFile.getPath()));
            }
            return new SplitFilterTestCase(allSplits, selectedSplits, this.expectedSplits, this.maxInputSize);
        }
    }

    public static interface BuildStep {
        public SplitFilterTestCase build();
    }

    public static interface ExpectedSplitsStep {
        public BuildStep expectedSplits(HiveInputFormat.HiveInputSplit ... var1);
    }

    public static interface InputFilesStep {
        public ExpectedSplitsStep inputFiles(MockInputFile ... var1);
    }

    public static interface MaxInputSizeStep
    extends InputFilesStep {
        public InputFilesStep maxInputSize(long var1);
    }
}

