/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class TestCombineHiveInputFormat
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAvoidSplitCombination() throws Exception {
        Configuration conf = new Configuration();
        JobConf job = new JobConf(conf);
        TableDesc tblDesc = Utilities.defaultTd;
        tblDesc.setInputFileFormatClass(TestSkipCombineInputFormat.class);
        PartitionDesc partDesc = new PartitionDesc(tblDesc, null);
        LinkedHashMap<Path, PartitionDesc> pt = new LinkedHashMap<Path, PartitionDesc>();
        pt.put(new Path("/tmp/testfolder1"), partDesc);
        pt.put(new Path("/tmp/testfolder2"), partDesc);
        MapredWork mrwork = new MapredWork();
        mrwork.getMapWork().setPathToPartitionInfo(pt);
        Path mapWorkPath = new Path("/tmp/" + System.getProperty("user.name"), "hive");
        Utilities.setMapRedWork((Configuration)conf, (MapredWork)mrwork, (Path)mapWorkPath);
        try {
            Path[] paths = new Path[]{new Path("/tmp/testfolder1"), new Path("/tmp/testfolder2")};
            CombineHiveInputFormat combineInputFormat = (CombineHiveInputFormat)ReflectionUtils.newInstance(CombineHiveInputFormat.class, (Configuration)conf);
            combineInputFormat.pathToPartitionInfo = Utilities.getMapWork((Configuration)conf).getPathToPartitionInfo();
            Set results = combineInputFormat.getNonCombinablePathIndices(job, paths, 2);
            TestCombineHiveInputFormat.assertEquals((String)"Should have both path indices in the results set", (int)2, (int)results.size());
        }
        finally {
            FileSystem.get((Configuration)conf).delete(mapWorkPath, true);
        }
    }

    public static class TestSkipCombineInputFormat
    extends FileInputFormat
    implements CombineHiveInputFormat.AvoidSplitCombination {
        public RecordReader getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            return null;
        }

        public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
            return true;
        }
    }
}

