/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;

public class TestHiveFileFormatUtils
extends TestCase {
    public void testGetPartitionDescFromPathRecursively() throws IOException {
        PartitionDesc partDesc_3 = new PartitionDesc();
        PartitionDesc partDesc_4 = new PartitionDesc();
        PartitionDesc partDesc_5 = new PartitionDesc();
        PartitionDesc partDesc_6 = new PartitionDesc();
        HashMap<Path, PartitionDesc> pathToPartitionInfo = new HashMap<Path, PartitionDesc>();
        pathToPartitionInfo.put(new Path("file:///tbl/par1/part2/part3"), partDesc_3);
        pathToPartitionInfo.put(new Path("/tbl/par1/part2/part4"), partDesc_4);
        pathToPartitionInfo.put(new Path("/tbl/par1/part2/part5/"), partDesc_5);
        pathToPartitionInfo.put(new Path("hdfs:///tbl/par1/part2/part6/"), partDesc_6);
        PartitionDesc ret = null;
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("file:///tbl/par1/part2/part3"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"file:///tbl/par1/part2/part3 not found.", (Object)partDesc_3, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("/tbl/par1/part2/part3"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"/tbl/par1/part2/part3 not found.", (Object)partDesc_3, (Object)ret);
        boolean exception = false;
        try {
            ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("hdfs:///tbl/par1/part2/part3"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        }
        catch (IOException e) {
            exception = true;
        }
        TestHiveFileFormatUtils.assertEquals((String)"hdfs:///tbl/par1/part2/part3 should return null", (boolean)true, (boolean)exception);
        exception = false;
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("file:///tbl/par1/part2/part4"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"file:///tbl/par1/part2/part4 not found.", (Object)partDesc_4, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("/tbl/par1/part2/part4"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"/tbl/par1/part2/part4 not found.", (Object)partDesc_4, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("hdfs:///tbl/par1/part2/part4"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"hdfs:///tbl/par1/part2/part4 should  not found", (Object)partDesc_4, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("file:///tbl/par1/part2/part5"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"file:///tbl/par1/part2/part5 not found.", (Object)partDesc_5, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("/tbl/par1/part2/part5"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"/tbl/par1/part2/part5 not found.", (Object)partDesc_5, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("hdfs:///tbl/par1/part2/part5"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"hdfs:///tbl/par1/part2/part5 not found", (Object)partDesc_5, (Object)ret);
        try {
            ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("file:///tbl/par1/part2/part6"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        }
        catch (IOException e) {
            exception = true;
        }
        TestHiveFileFormatUtils.assertEquals((String)"file:///tbl/par1/part2/part6 should return null", (boolean)true, (boolean)exception);
        exception = false;
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("/tbl/par1/part2/part6"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"/tbl/par1/part2/part6 not found.", (Object)partDesc_6, (Object)ret);
        ret = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, (Path)new Path("hdfs:///tbl/par1/part2/part6"), (Map)IOPrepareCache.get().allocatePartitionDescMap());
        TestHiveFileFormatUtils.assertEquals((String)"hdfs:///tbl/par1/part2/part6 not found.", (Object)partDesc_6, (Object)ret);
    }
}

