/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.HiveTestUtils;
import org.apache.orc.BinaryColumnStatistics;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.StripeInformation;
import org.apache.orc.StripeStatistics;
import org.apache.orc.TypeDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestOrcFile {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem fs;
    Path testFilePath;
    private final boolean zeroCopy;
    @Rule
    public TestName testCaseName = new TestName();

    private static InnerStruct inner(int i, String s) {
        return new InnerStruct(i, s);
    }

    private static Map<Text, InnerStruct> map(InnerStruct ... items) {
        HashMap<Text, InnerStruct> result = new HashMap<Text, InnerStruct>();
        for (InnerStruct i : items) {
            result.put(new Text(i.string1), i);
        }
        return result;
    }

    private static List<InnerStruct> list(InnerStruct ... items) {
        ArrayList<InnerStruct> result = new ArrayList<InnerStruct>();
        result.addAll(Arrays.asList(items));
        return result;
    }

    private static BytesWritable bytes(int ... items) {
        BytesWritable result = new BytesWritable();
        result.setSize(items.length);
        for (int i = 0; i < items.length; ++i) {
            result.getBytes()[i] = (byte)items[i];
        }
        return result;
    }

    private static ByteBuffer byteBuf(int ... items) {
        ByteBuffer result = ByteBuffer.allocate(items.length);
        for (int item : items) {
            result.put((byte)item);
        }
        result.flip();
        return result;
    }

    @Parameterized.Parameters
    public static Collection<Boolean[]> data() {
        return Arrays.asList({false}, {true});
    }

    public TestOrcFile(Boolean zcr) {
        this.zeroCopy = zcr;
    }

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        if (this.zeroCopy) {
            this.conf.setBoolean(OrcConf.USE_ZEROCOPY.getHiveConfName(), this.zeroCopy);
        }
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    @Test
    public void testReadFormat_0_11() throws Exception {
        Path oldFilePath = new Path(HiveTestUtils.getFileFromClasspath((String)"orc-file-11-format.orc"));
        Reader reader = OrcFile.createReader((Path)oldFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
        int stripeCount = 0;
        int rowCount = 0;
        long currentOffset = -1L;
        for (StripeInformation stripe : reader.getStripes()) {
            ++stripeCount;
            rowCount = (int)((long)rowCount + stripe.getNumberOfRows());
            if (currentOffset < 0L) {
                currentOffset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
                continue;
            }
            junit.framework.Assert.assertEquals((long)currentOffset, (long)stripe.getOffset());
            currentOffset += stripe.getIndexLength() + stripe.getDataLength() + stripe.getFooterLength();
        }
        junit.framework.Assert.assertEquals((long)reader.getNumberOfRows(), (long)rowCount);
        junit.framework.Assert.assertEquals((int)2, (int)stripeCount);
        ColumnStatistics[] stats = reader.getStatistics();
        junit.framework.Assert.assertEquals((long)7500L, (long)stats[1].getNumberOfValues());
        junit.framework.Assert.assertEquals((long)3750L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
        junit.framework.Assert.assertEquals((long)3750L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
        junit.framework.Assert.assertEquals((String)"count: 7500 hasNull: true true: 3750", (String)stats[1].toString());
        junit.framework.Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
        junit.framework.Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
        junit.framework.Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
        junit.framework.Assert.assertEquals((long)11520000L, (long)((IntegerColumnStatistics)stats[3]).getSum());
        junit.framework.Assert.assertEquals((String)"count: 7500 hasNull: true min: 1024 max: 2048 sum: 11520000", (String)stats[3].toString());
        junit.framework.Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMaximum());
        junit.framework.Assert.assertEquals((long)Long.MAX_VALUE, (long)((IntegerColumnStatistics)stats[5]).getMinimum());
        junit.framework.Assert.assertEquals((boolean)false, (boolean)((IntegerColumnStatistics)stats[5]).isSumDefined());
        junit.framework.Assert.assertEquals((String)"count: 7500 hasNull: true min: 9223372036854775807 max: 9223372036854775807", (String)stats[5].toString());
        junit.framework.Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
        junit.framework.Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
        junit.framework.Assert.assertEquals((double)-75000.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
        junit.framework.Assert.assertEquals((String)"count: 7500 hasNull: true min: -15.0 max: -5.0 sum: -75000.0", (String)stats[7].toString());
        junit.framework.Assert.assertEquals((String)"count: 7500 hasNull: true min: bye max: hi sum: 0", (String)stats[9].toString());
        StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
        junit.framework.Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
        junit.framework.Assert.assertEquals((String)"struct<boolean1:boolean,byte1:tinyint,short1:smallint,int1:int,long1:bigint,float1:float,double1:double,bytes1:binary,string1:string,middle:struct<list:array<struct<int1:int,string1:string>>>,list:array<struct<int1:int,string1:string>>,map:map<string,struct<int1:int,string1:string>>,ts:timestamp,decimal1:decimal(38,18)>", (String)readerInspector.getTypeName());
        List fields = readerInspector.getAllStructFieldRefs();
        BooleanObjectInspector bo = (BooleanObjectInspector)readerInspector.getStructFieldRef("boolean1").getFieldObjectInspector();
        ByteObjectInspector by = (ByteObjectInspector)readerInspector.getStructFieldRef("byte1").getFieldObjectInspector();
        ShortObjectInspector sh = (ShortObjectInspector)readerInspector.getStructFieldRef("short1").getFieldObjectInspector();
        IntObjectInspector in = (IntObjectInspector)readerInspector.getStructFieldRef("int1").getFieldObjectInspector();
        LongObjectInspector lo = (LongObjectInspector)readerInspector.getStructFieldRef("long1").getFieldObjectInspector();
        FloatObjectInspector fl = (FloatObjectInspector)readerInspector.getStructFieldRef("float1").getFieldObjectInspector();
        DoubleObjectInspector dbl = (DoubleObjectInspector)readerInspector.getStructFieldRef("double1").getFieldObjectInspector();
        BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
        StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
        StructObjectInspector mid = (StructObjectInspector)readerInspector.getStructFieldRef("middle").getFieldObjectInspector();
        List midFields = mid.getAllStructFieldRefs();
        ListObjectInspector midli = (ListObjectInspector)((StructField)midFields.get(0)).getFieldObjectInspector();
        StructObjectInspector inner = (StructObjectInspector)midli.getListElementObjectInspector();
        List inFields = inner.getAllStructFieldRefs();
        ListObjectInspector li = (ListObjectInspector)readerInspector.getStructFieldRef("list").getFieldObjectInspector();
        MapObjectInspector ma = (MapObjectInspector)readerInspector.getStructFieldRef("map").getFieldObjectInspector();
        TimestampObjectInspector tso = (TimestampObjectInspector)readerInspector.getStructFieldRef("ts").getFieldObjectInspector();
        HiveDecimalObjectInspector dco = (HiveDecimalObjectInspector)readerInspector.getStructFieldRef("decimal1").getFieldObjectInspector();
        StringObjectInspector mk = (StringObjectInspector)ma.getMapKeyObjectInspector();
        RecordReader rows = reader.rows();
        Object row = rows.next(null);
        junit.framework.Assert.assertNotNull((Object)row);
        junit.framework.Assert.assertEquals((boolean)false, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        junit.framework.Assert.assertEquals((int)1, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        junit.framework.Assert.assertEquals((int)1024, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
        junit.framework.Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
        junit.framework.Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
        junit.framework.Assert.assertEquals((double)1.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
        junit.framework.Assert.assertEquals((double)-15.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
        junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
        junit.framework.Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
        List midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
        junit.framework.Assert.assertNotNull((Object)midRow);
        junit.framework.Assert.assertEquals((int)2, (int)midRow.size());
        junit.framework.Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
        junit.framework.Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
        List list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
        junit.framework.Assert.assertEquals((int)2, (int)list.size());
        junit.framework.Assert.assertEquals((int)3, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"good", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
        junit.framework.Assert.assertEquals((int)4, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"bad", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
        Map map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
        junit.framework.Assert.assertEquals((int)0, (int)map.size());
        junit.framework.Assert.assertEquals((Object)Timestamp.valueOf("2000-03-12 15:00:00"), (Object)tso.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(12))));
        junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"12345678.6547456"), (Object)dco.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(13))));
        junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
        rows.seekToRow(7499L);
        row = rows.next(null);
        junit.framework.Assert.assertEquals((boolean)true, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
        junit.framework.Assert.assertEquals((int)100, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
        junit.framework.Assert.assertEquals((int)2048, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
        junit.framework.Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
        junit.framework.Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
        junit.framework.Assert.assertEquals((double)2.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
        junit.framework.Assert.assertEquals((double)-5.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
        junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(new int[0]), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
        junit.framework.Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
        midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
        junit.framework.Assert.assertNotNull((Object)midRow);
        junit.framework.Assert.assertEquals((int)2, (int)midRow.size());
        junit.framework.Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
        junit.framework.Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
        list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
        junit.framework.Assert.assertEquals((int)3, (int)list.size());
        junit.framework.Assert.assertEquals((int)100000000, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"cat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
        junit.framework.Assert.assertEquals((int)-100000, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"in", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
        junit.framework.Assert.assertEquals((int)1234, (int)in.get(inner.getStructFieldData(list.get(2), (StructField)inFields.get(0))));
        junit.framework.Assert.assertEquals((String)"hat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(2), (StructField)inFields.get(1))));
        map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
        junit.framework.Assert.assertEquals((int)2, (int)map.size());
        boolean[] found = new boolean[2];
        for (Object key : map.keySet()) {
            String str = mk.getPrimitiveJavaObject(key);
            if (str.equals("chani")) {
                junit.framework.Assert.assertEquals((boolean)false, (boolean)found[0]);
                junit.framework.Assert.assertEquals((int)5, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                junit.framework.Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                found[0] = true;
                continue;
            }
            if (str.equals("mauddib")) {
                junit.framework.Assert.assertEquals((boolean)false, (boolean)found[1]);
                junit.framework.Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                junit.framework.Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                found[1] = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown key " + str);
        }
        junit.framework.Assert.assertEquals((boolean)true, (boolean)found[0]);
        junit.framework.Assert.assertEquals((boolean)true, (boolean)found[1]);
        junit.framework.Assert.assertEquals((Object)Timestamp.valueOf("2000-03-12 15:00:01"), (Object)tso.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(12))));
        junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"12345678.6547457"), (Object)dco.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(13))));
        junit.framework.Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
        rows.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestamp() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Timestamp.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).version(OrcFile.Version.V_0_11));
            ArrayList tslist = Lists.newArrayList();
            tslist.add(Timestamp.valueOf("2037-01-01 00:00:00.000999"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00.000000222"));
            tslist.add(Timestamp.valueOf("1999-01-01 00:00:00.999999999"));
            tslist.add(Timestamp.valueOf("1995-01-01 00:00:00.688888888"));
            tslist.add(Timestamp.valueOf("2002-01-01 00:00:00.1"));
            tslist.add(Timestamp.valueOf("2010-03-02 00:00:00.000009001"));
            tslist.add(Timestamp.valueOf("2005-01-01 00:00:00.000002229"));
            tslist.add(Timestamp.valueOf("2006-01-01 00:00:00.900203003"));
            tslist.add(Timestamp.valueOf("2003-01-01 00:00:00.800000007"));
            tslist.add(Timestamp.valueOf("1996-08-02 00:00:00.723100809"));
            tslist.add(Timestamp.valueOf("1998-11-02 00:00:00.857340643"));
            tslist.add(Timestamp.valueOf("2008-10-02 00:00:00"));
            for (Timestamp ts : tslist) {
                writer.addRow((Object)ts);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Timestamp tlistTimestamp;
                Object row = rows.next(null);
                if ((tlistTimestamp = (Timestamp)tslist.get(idx++)).getNanos() == ((TimestampWritable)row).getNanos()) continue;
                junit.framework.Assert.assertTrue((boolean)false);
            }
            junit.framework.Assert.assertEquals((int)0, (int)writer.getSchema().getMaximumId());
            boolean[] expected = new boolean[]{false};
            boolean[] included = OrcUtils.includeColumns((String)"", (TypeDescription)writer.getSchema());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHiveDecimalAllNulls() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(DecimalStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            writer.addRow((Object)new DecimalStruct(new HiveDecimalWritable("1.463040009E9".getBytes(), 8)));
            writer.addRow((Object)new DecimalStruct(null));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            List fields = readerInspector.getAllStructFieldRefs();
            HiveDecimalObjectInspector doi = (HiveDecimalObjectInspector)readerInspector.getStructFieldRef("dec").getFieldObjectInspector();
            RecordReader rows = reader.rows();
            while (rows.hasNext()) {
                Object row = rows.next(null);
                junit.framework.Assert.assertEquals(null, (Object)doi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            }
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)2L, (long)stats[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)0L, (long)stats[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)stats[1].hasNull());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHiveDecimalIsNullReset() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(DecimalStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            for (int i = 0; i < 1000; ++i) {
                writer.addRow((Object)new DecimalStruct(null));
            }
            writer.addRow((Object)new DecimalStruct(new HiveDecimalWritable("1.00")));
            writer.addRow((Object)new DecimalStruct(new HiveDecimalWritable("2.00")));
            writer.addRow((Object)new DecimalStruct(new HiveDecimalWritable("3.00")));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            List fields = readerInspector.getAllStructFieldRefs();
            HiveDecimalObjectInspector doi = (HiveDecimalObjectInspector)readerInspector.getStructFieldRef("dec").getFieldObjectInspector();
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                if (idx < 1000) {
                    junit.framework.Assert.assertEquals(null, (Object)doi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
                }
                if (idx == 1000) {
                    junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(1L), (Object)doi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
                }
                if (idx == 1001) {
                    junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(2L), (Object)doi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
                }
                if (idx == 10002) {
                    junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(3L), (Object)doi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
                }
                ++idx;
            }
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)1003L, (long)stats[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)3L, (long)stats[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((Object)HiveDecimal.create((int)3), (Object)((DecimalColumnStatistics)stats[1]).getMaximum());
            junit.framework.Assert.assertEquals((Object)HiveDecimal.create((int)1), (Object)((DecimalColumnStatistics)stats[1]).getMinimum());
            junit.framework.Assert.assertEquals((Object)HiveDecimal.create((int)6), (Object)((DecimalColumnStatistics)stats[1]).getSum());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)stats[1].hasNull());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStringAndBinaryStatistics() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(SimpleStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            writer.addRow((Object)new SimpleStruct(TestOrcFile.bytes(0, 1, 2, 3, 4), "foo"));
            writer.addRow((Object)new SimpleStruct(TestOrcFile.bytes(0, 1, 2, 3), "bar"));
            writer.addRow((Object)new SimpleStruct(TestOrcFile.bytes(0, 1, 2, 3, 4, 5), null));
            writer.addRow((Object)new SimpleStruct(null, "hi"));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            TypeDescription schema = writer.getSchema();
            junit.framework.Assert.assertEquals((int)2, (int)schema.getMaximumId());
            boolean[] expected = new boolean[]{false, false, true};
            boolean[] included = OrcUtils.includeColumns((String)"string1", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, false, false};
            included = OrcUtils.includeColumns((String)"", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, false, false};
            included = OrcUtils.includeColumns(null, (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)4L, (long)stats[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((String)"count: 4 hasNull: false", (String)stats[0].toString());
            junit.framework.Assert.assertEquals((long)3L, (long)stats[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)15L, (long)((BinaryColumnStatistics)stats[1]).getSum());
            junit.framework.Assert.assertEquals((String)"count: 3 hasNull: true sum: 15", (String)stats[1].toString());
            junit.framework.Assert.assertEquals((long)3L, (long)stats[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((String)"bar", (String)((StringColumnStatistics)stats[2]).getMinimum());
            junit.framework.Assert.assertEquals((String)"hi", (String)((StringColumnStatistics)stats[2]).getMaximum());
            junit.framework.Assert.assertEquals((long)8L, (long)((StringColumnStatistics)stats[2]).getSum());
            junit.framework.Assert.assertEquals((String)"count: 3 hasNull: true min: bar max: hi sum: 8", (String)stats[2].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            junit.framework.Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            junit.framework.Assert.assertEquals((String)"struct<bytes1:binary,string1:string>", (String)readerInspector.getTypeName());
            List fields = readerInspector.getAllStructFieldRefs();
            BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
            StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
            RecordReader rows = reader.rows();
            Object row = rows.next(null);
            junit.framework.Assert.assertNotNull((Object)row);
            junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            junit.framework.Assert.assertEquals((String)"foo", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(0, 1, 2, 3), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            junit.framework.Assert.assertEquals((String)"bar", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(0, 1, 2, 3, 4, 5), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            junit.framework.Assert.assertNull((Object)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            junit.framework.Assert.assertNull((Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            junit.framework.Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStripeLevelStats() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).batchSize(1000));
            for (int i = 0; i < 11000; ++i) {
                if (i >= 5000) {
                    if (i >= 10000) {
                        writer.addRow((Object)new InnerStruct(3, "three"));
                        continue;
                    }
                    writer.addRow((Object)new InnerStruct(2, "two"));
                    continue;
                }
                writer.addRow((Object)new InnerStruct(1, "one"));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            TypeDescription schema = writer.getSchema();
            junit.framework.Assert.assertEquals((int)2, (int)schema.getMaximumId());
            boolean[] expected = new boolean[]{false, true, false};
            boolean[] included = OrcUtils.includeColumns((String)"int1", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            List stats = reader.getStripeStatistics();
            int numStripes = stats.size();
            junit.framework.Assert.assertEquals((int)3, (int)numStripes);
            StripeStatistics ss1 = (StripeStatistics)stats.get(0);
            StripeStatistics ss2 = (StripeStatistics)stats.get(1);
            StripeStatistics ss3 = (StripeStatistics)stats.get(2);
            junit.framework.Assert.assertEquals((long)5000L, (long)ss1.getColumnStatistics()[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)5000L, (long)ss2.getColumnStatistics()[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)1000L, (long)ss3.getColumnStatistics()[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)5000L, (long)ss1.getColumnStatistics()[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)5000L, (long)ss2.getColumnStatistics()[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)1000L, (long)ss3.getColumnStatistics()[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)1L, (long)((IntegerColumnStatistics)ss1.getColumnStatistics()[1]).getMinimum());
            junit.framework.Assert.assertEquals((long)2L, (long)((IntegerColumnStatistics)ss2.getColumnStatistics()[1]).getMinimum());
            junit.framework.Assert.assertEquals((long)3L, (long)((IntegerColumnStatistics)ss3.getColumnStatistics()[1]).getMinimum());
            junit.framework.Assert.assertEquals((long)1L, (long)((IntegerColumnStatistics)ss1.getColumnStatistics()[1]).getMaximum());
            junit.framework.Assert.assertEquals((long)2L, (long)((IntegerColumnStatistics)ss2.getColumnStatistics()[1]).getMaximum());
            junit.framework.Assert.assertEquals((long)3L, (long)((IntegerColumnStatistics)ss3.getColumnStatistics()[1]).getMaximum());
            junit.framework.Assert.assertEquals((long)5000L, (long)((IntegerColumnStatistics)ss1.getColumnStatistics()[1]).getSum());
            junit.framework.Assert.assertEquals((long)10000L, (long)((IntegerColumnStatistics)ss2.getColumnStatistics()[1]).getSum());
            junit.framework.Assert.assertEquals((long)3000L, (long)((IntegerColumnStatistics)ss3.getColumnStatistics()[1]).getSum());
            junit.framework.Assert.assertEquals((long)5000L, (long)ss1.getColumnStatistics()[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)5000L, (long)ss2.getColumnStatistics()[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)1000L, (long)ss3.getColumnStatistics()[2].getNumberOfValues());
            junit.framework.Assert.assertEquals((String)"one", (String)((StringColumnStatistics)ss1.getColumnStatistics()[2]).getMinimum());
            junit.framework.Assert.assertEquals((String)"two", (String)((StringColumnStatistics)ss2.getColumnStatistics()[2]).getMinimum());
            junit.framework.Assert.assertEquals((String)"three", (String)((StringColumnStatistics)ss3.getColumnStatistics()[2]).getMinimum());
            junit.framework.Assert.assertEquals((String)"one", (String)((StringColumnStatistics)ss1.getColumnStatistics()[2]).getMaximum());
            junit.framework.Assert.assertEquals((String)"two", (String)((StringColumnStatistics)ss2.getColumnStatistics()[2]).getMaximum());
            junit.framework.Assert.assertEquals((String)"three", (String)((StringColumnStatistics)ss3.getColumnStatistics()[2]).getMaximum());
            junit.framework.Assert.assertEquals((long)15000L, (long)((StringColumnStatistics)ss1.getColumnStatistics()[2]).getSum());
            junit.framework.Assert.assertEquals((long)15000L, (long)((StringColumnStatistics)ss2.getColumnStatistics()[2]).getSum());
            junit.framework.Assert.assertEquals((long)5000L, (long)((StringColumnStatistics)ss3.getColumnStatistics()[2]).getSum());
            RecordReaderImpl recordReader = (RecordReaderImpl)reader.rows();
            OrcProto.RowIndex[] index = recordReader.readRowIndex(0, null, null).getRowGroupIndex();
            junit.framework.Assert.assertEquals((int)3, (int)index.length);
            List items = index[1].getEntryList();
            junit.framework.Assert.assertEquals((int)1, (int)items.size());
            junit.framework.Assert.assertEquals((int)3, (int)((OrcProto.RowIndexEntry)items.get(0)).getPositionsCount());
            junit.framework.Assert.assertEquals((long)0L, (long)((OrcProto.RowIndexEntry)items.get(0)).getPositions(0));
            junit.framework.Assert.assertEquals((long)0L, (long)((OrcProto.RowIndexEntry)items.get(0)).getPositions(1));
            junit.framework.Assert.assertEquals((long)0L, (long)((OrcProto.RowIndexEntry)items.get(0)).getPositions(2));
            junit.framework.Assert.assertEquals((long)1L, (long)((OrcProto.RowIndexEntry)items.get(0)).getStatistics().getIntStatistics().getMinimum());
            index = recordReader.readRowIndex(1, null, null).getRowGroupIndex();
            junit.framework.Assert.assertEquals((int)3, (int)index.length);
            items = index[1].getEntryList();
            junit.framework.Assert.assertEquals((long)2L, (long)((OrcProto.RowIndexEntry)items.get(0)).getStatistics().getIntStatistics().getMaximum());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000));
            writer.addRow((Object)new BigRow(false, (byte)1, (short)1024, 65536, Long.MAX_VALUE, Float.valueOf(1.0f), -15.0, TestOrcFile.bytes(0, 1, 2, 3, 4), "hi", new MiddleStruct(TestOrcFile.inner(1, "bye"), TestOrcFile.inner(2, "sigh")), TestOrcFile.list(TestOrcFile.inner(3, "good"), TestOrcFile.inner(4, "bad")), TestOrcFile.map(new InnerStruct[0])));
            writer.addRow((Object)new BigRow(true, (byte)100, (short)2048, 65536, Long.MAX_VALUE, Float.valueOf(2.0f), -5.0, TestOrcFile.bytes(new int[0]), "bye", new MiddleStruct(TestOrcFile.inner(1, "bye"), TestOrcFile.inner(2, "sigh")), TestOrcFile.list(TestOrcFile.inner(100000000, "cat"), TestOrcFile.inner(-100000, "in"), TestOrcFile.inner(1234, "hat")), TestOrcFile.map(TestOrcFile.inner(5, "chani"), TestOrcFile.inner(1, "mauddib"))));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            TypeDescription schema = writer.getSchema();
            junit.framework.Assert.assertEquals((int)23, (int)schema.getMaximumId());
            boolean[] expected = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
            boolean[] included = OrcUtils.includeColumns((String)"", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true};
            included = OrcUtils.includeColumns((String)"boolean1,string1,middle,map", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true};
            included = OrcUtils.includeColumns((String)"boolean1,string1,middle,map", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
            included = OrcUtils.includeColumns((String)"boolean1,byte1,short1,int1,long1,float1,double1,bytes1,string1,middle,list,map", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((long)2L, (long)stats[1].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getFalseCount());
            junit.framework.Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)stats[1]).getTrueCount());
            junit.framework.Assert.assertEquals((String)"count: 2 hasNull: false true: 1", (String)stats[1].toString());
            junit.framework.Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)stats[3]).getMaximum());
            junit.framework.Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)stats[3]).getMinimum());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)((IntegerColumnStatistics)stats[3]).isSumDefined());
            junit.framework.Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)stats[3]).getSum());
            junit.framework.Assert.assertEquals((String)"count: 2 hasNull: false min: 1024 max: 2048 sum: 3072", (String)stats[3].toString());
            StripeStatistics ss = (StripeStatistics)reader.getStripeStatistics().get(0);
            junit.framework.Assert.assertEquals((long)2L, (long)ss.getColumnStatistics()[0].getNumberOfValues());
            junit.framework.Assert.assertEquals((long)1L, (long)((BooleanColumnStatistics)ss.getColumnStatistics()[1]).getTrueCount());
            junit.framework.Assert.assertEquals((long)1024L, (long)((IntegerColumnStatistics)ss.getColumnStatistics()[3]).getMinimum());
            junit.framework.Assert.assertEquals((long)2048L, (long)((IntegerColumnStatistics)ss.getColumnStatistics()[3]).getMaximum());
            junit.framework.Assert.assertEquals((long)3072L, (long)((IntegerColumnStatistics)ss.getColumnStatistics()[3]).getSum());
            junit.framework.Assert.assertEquals((Object)-15.0, (Object)((DoubleColumnStatistics)stats[7]).getMinimum());
            junit.framework.Assert.assertEquals((Object)-5.0, (Object)((DoubleColumnStatistics)stats[7]).getMaximum());
            junit.framework.Assert.assertEquals((double)-20.0, (double)((DoubleColumnStatistics)stats[7]).getSum(), (double)1.0E-5);
            junit.framework.Assert.assertEquals((String)"count: 2 hasNull: false min: -15.0 max: -5.0 sum: -20.0", (String)stats[7].toString());
            junit.framework.Assert.assertEquals((String)"count: 2 hasNull: false min: bye max: hi sum: 5", (String)stats[9].toString());
            StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
            junit.framework.Assert.assertEquals((Object)ObjectInspector.Category.STRUCT, (Object)readerInspector.getCategory());
            junit.framework.Assert.assertEquals((String)"struct<boolean1:boolean,byte1:tinyint,short1:smallint,int1:int,long1:bigint,float1:float,double1:double,bytes1:binary,string1:string,middle:struct<list:array<struct<int1:int,string1:string>>>,list:array<struct<int1:int,string1:string>>,map:map<string,struct<int1:int,string1:string>>>", (String)readerInspector.getTypeName());
            List fields = readerInspector.getAllStructFieldRefs();
            BooleanObjectInspector bo = (BooleanObjectInspector)readerInspector.getStructFieldRef("boolean1").getFieldObjectInspector();
            ByteObjectInspector by = (ByteObjectInspector)readerInspector.getStructFieldRef("byte1").getFieldObjectInspector();
            ShortObjectInspector sh = (ShortObjectInspector)readerInspector.getStructFieldRef("short1").getFieldObjectInspector();
            IntObjectInspector in = (IntObjectInspector)readerInspector.getStructFieldRef("int1").getFieldObjectInspector();
            LongObjectInspector lo = (LongObjectInspector)readerInspector.getStructFieldRef("long1").getFieldObjectInspector();
            FloatObjectInspector fl = (FloatObjectInspector)readerInspector.getStructFieldRef("float1").getFieldObjectInspector();
            DoubleObjectInspector dbl = (DoubleObjectInspector)readerInspector.getStructFieldRef("double1").getFieldObjectInspector();
            BinaryObjectInspector bi = (BinaryObjectInspector)readerInspector.getStructFieldRef("bytes1").getFieldObjectInspector();
            StringObjectInspector st = (StringObjectInspector)readerInspector.getStructFieldRef("string1").getFieldObjectInspector();
            StructObjectInspector mid = (StructObjectInspector)readerInspector.getStructFieldRef("middle").getFieldObjectInspector();
            List midFields = mid.getAllStructFieldRefs();
            ListObjectInspector midli = (ListObjectInspector)((StructField)midFields.get(0)).getFieldObjectInspector();
            StructObjectInspector inner = (StructObjectInspector)midli.getListElementObjectInspector();
            List inFields = inner.getAllStructFieldRefs();
            ListObjectInspector li = (ListObjectInspector)readerInspector.getStructFieldRef("list").getFieldObjectInspector();
            MapObjectInspector ma = (MapObjectInspector)readerInspector.getStructFieldRef("map").getFieldObjectInspector();
            StringObjectInspector mk = (StringObjectInspector)ma.getMapKeyObjectInspector();
            RecordReader rows = reader.rows();
            Object row = rows.next(null);
            junit.framework.Assert.assertNotNull((Object)row);
            junit.framework.Assert.assertEquals((boolean)false, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            junit.framework.Assert.assertEquals((int)1, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            junit.framework.Assert.assertEquals((int)1024, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
            junit.framework.Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
            junit.framework.Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
            junit.framework.Assert.assertEquals((double)1.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
            junit.framework.Assert.assertEquals((double)-15.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
            junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(0, 1, 2, 3, 4), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
            junit.framework.Assert.assertEquals((String)"hi", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
            List midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
            junit.framework.Assert.assertNotNull((Object)midRow);
            junit.framework.Assert.assertEquals((int)2, (int)midRow.size());
            junit.framework.Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
            junit.framework.Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
            List list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
            junit.framework.Assert.assertEquals((int)2, (int)list.size());
            junit.framework.Assert.assertEquals((int)3, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"good", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
            junit.framework.Assert.assertEquals((int)4, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"bad", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
            Map map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
            junit.framework.Assert.assertEquals((int)0, (int)map.size());
            junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = rows.next(row);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)bo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(0))));
            junit.framework.Assert.assertEquals((int)100, (int)by.get(readerInspector.getStructFieldData(row, (StructField)fields.get(1))));
            junit.framework.Assert.assertEquals((int)2048, (int)sh.get(readerInspector.getStructFieldData(row, (StructField)fields.get(2))));
            junit.framework.Assert.assertEquals((int)65536, (int)in.get(readerInspector.getStructFieldData(row, (StructField)fields.get(3))));
            junit.framework.Assert.assertEquals((long)Long.MAX_VALUE, (long)lo.get(readerInspector.getStructFieldData(row, (StructField)fields.get(4))));
            junit.framework.Assert.assertEquals((double)2.0, (double)fl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(5))), (double)1.0E-5);
            junit.framework.Assert.assertEquals((double)-5.0, (double)dbl.get(readerInspector.getStructFieldData(row, (StructField)fields.get(6))), (double)1.0E-5);
            junit.framework.Assert.assertEquals((Object)TestOrcFile.bytes(new int[0]), (Object)bi.getPrimitiveWritableObject(readerInspector.getStructFieldData(row, (StructField)fields.get(7))));
            junit.framework.Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(readerInspector.getStructFieldData(row, (StructField)fields.get(8))));
            midRow = midli.getList(mid.getStructFieldData(readerInspector.getStructFieldData(row, (StructField)fields.get(9)), (StructField)midFields.get(0)));
            junit.framework.Assert.assertNotNull((Object)midRow);
            junit.framework.Assert.assertEquals((int)2, (int)midRow.size());
            junit.framework.Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"bye", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(0), (StructField)inFields.get(1))));
            junit.framework.Assert.assertEquals((int)2, (int)in.get(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"sigh", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(midRow.get(1), (StructField)inFields.get(1))));
            list = li.getList(readerInspector.getStructFieldData(row, (StructField)fields.get(10)));
            junit.framework.Assert.assertEquals((int)3, (int)list.size());
            junit.framework.Assert.assertEquals((int)100000000, (int)in.get(inner.getStructFieldData(list.get(0), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"cat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(0), (StructField)inFields.get(1))));
            junit.framework.Assert.assertEquals((int)-100000, (int)in.get(inner.getStructFieldData(list.get(1), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"in", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(1), (StructField)inFields.get(1))));
            junit.framework.Assert.assertEquals((int)1234, (int)in.get(inner.getStructFieldData(list.get(2), (StructField)inFields.get(0))));
            junit.framework.Assert.assertEquals((String)"hat", (String)st.getPrimitiveJavaObject(inner.getStructFieldData(list.get(2), (StructField)inFields.get(1))));
            map = ma.getMap(readerInspector.getStructFieldData(row, (StructField)fields.get(11)));
            junit.framework.Assert.assertEquals((int)2, (int)map.size());
            boolean[] found = new boolean[2];
            for (Object key : map.keySet()) {
                String str = mk.getPrimitiveJavaObject(key);
                if (str.equals("chani")) {
                    junit.framework.Assert.assertEquals((boolean)false, (boolean)found[0]);
                    junit.framework.Assert.assertEquals((int)5, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                    junit.framework.Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                    found[0] = true;
                    continue;
                }
                if (str.equals("mauddib")) {
                    junit.framework.Assert.assertEquals((boolean)false, (boolean)found[1]);
                    junit.framework.Assert.assertEquals((int)1, (int)in.get(inner.getStructFieldData(map.get(key), (StructField)inFields.get(0))));
                    junit.framework.Assert.assertEquals((String)str, (String)st.getPrimitiveJavaObject(inner.getStructFieldData(map.get(key), (StructField)inFields.get(1))));
                    found[1] = true;
                    continue;
                }
                throw new IllegalArgumentException("Unknown key " + str);
            }
            junit.framework.Assert.assertEquals((boolean)true, (boolean)found[0]);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)found[1]);
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void columnProjection() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100).rowIndexStride(1000));
            Random r1 = new Random(1L);
            Random r2 = new Random(2L);
            int minInt = 0;
            int maxInt = 0;
            String minStr = null;
            String maxStr = null;
            for (int i = 0; i < 21000; ++i) {
                int x = r1.nextInt();
                String y = Long.toHexString(r2.nextLong());
                if (i == 0 || x < minInt) {
                    minInt = x;
                }
                if (i == 0 || x > maxInt) {
                    maxInt = x;
                }
                if (i == 0 || y.compareTo(minStr) < 0) {
                    minStr = y;
                }
                if (i == 0 || y.compareTo(maxStr) > 0) {
                    maxStr = y;
                }
                writer.addRow((Object)TestOrcFile.inner(x, y));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            ColumnStatistics[] stats = reader.getStatistics();
            junit.framework.Assert.assertEquals((int)3, (int)stats.length);
            for (ColumnStatistics s : stats) {
                junit.framework.Assert.assertEquals((long)21000L, (long)s.getNumberOfValues());
                if (s instanceof IntegerColumnStatistics) {
                    junit.framework.Assert.assertEquals((long)minInt, (long)((IntegerColumnStatistics)s).getMinimum());
                    junit.framework.Assert.assertEquals((long)maxInt, (long)((IntegerColumnStatistics)s).getMaximum());
                    continue;
                }
                if (!(s instanceof StringColumnStatistics)) continue;
                junit.framework.Assert.assertEquals((String)maxStr, (String)((StringColumnStatistics)s).getMaximum());
                junit.framework.Assert.assertEquals((String)minStr, (String)((StringColumnStatistics)s).getMinimum());
            }
            List types = reader.getTypes();
            junit.framework.Assert.assertEquals((int)3, (int)types.size());
            junit.framework.Assert.assertEquals((Object)OrcProto.Type.Kind.STRUCT, (Object)((OrcProto.Type)types.get(0)).getKind());
            junit.framework.Assert.assertEquals((int)2, (int)((OrcProto.Type)types.get(0)).getSubtypesCount());
            junit.framework.Assert.assertEquals((int)1, (int)((OrcProto.Type)types.get(0)).getSubtypes(0));
            junit.framework.Assert.assertEquals((int)2, (int)((OrcProto.Type)types.get(0)).getSubtypes(1));
            junit.framework.Assert.assertEquals((Object)OrcProto.Type.Kind.INT, (Object)((OrcProto.Type)types.get(1)).getKind());
            junit.framework.Assert.assertEquals((int)0, (int)((OrcProto.Type)types.get(1)).getSubtypesCount());
            junit.framework.Assert.assertEquals((Object)OrcProto.Type.Kind.STRING, (Object)((OrcProto.Type)types.get(2)).getKind());
            junit.framework.Assert.assertEquals((int)0, (int)((OrcProto.Type)types.get(2)).getSubtypesCount());
            RecordReader rows1 = reader.rows(new boolean[]{true, true, false});
            RecordReader rows2 = reader.rows(new boolean[]{true, false, true});
            r1 = new Random(1L);
            r2 = new Random(2L);
            OrcStruct row1 = null;
            OrcStruct row2 = null;
            for (int i = 0; i < 21000; ++i) {
                junit.framework.Assert.assertEquals((boolean)true, (boolean)rows1.hasNext());
                junit.framework.Assert.assertEquals((boolean)true, (boolean)rows2.hasNext());
                row1 = (OrcStruct)rows1.next(row1);
                row2 = (OrcStruct)rows2.next(row2);
                junit.framework.Assert.assertEquals((int)r1.nextInt(), (int)((IntWritable)row1.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((String)Long.toHexString(r2.nextLong()), (String)row2.getFieldValue(1).toString());
            }
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows1.hasNext());
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows2.hasNext());
            rows1.close();
            rows2.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyFile() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            junit.framework.Assert.assertEquals((boolean)false, (boolean)reader.rows().hasNext());
            junit.framework.Assert.assertEquals((Object)CompressionKind.NONE, (Object)reader.getCompression());
            junit.framework.Assert.assertEquals((long)0L, (long)reader.getNumberOfRows());
            junit.framework.Assert.assertEquals((int)0, (int)reader.getCompressionSize());
            junit.framework.Assert.assertEquals((boolean)false, (boolean)reader.getMetadataKeys().iterator().hasNext());
            junit.framework.Assert.assertEquals((long)3L, (long)reader.getContentLength());
            junit.framework.Assert.assertEquals((boolean)false, (boolean)reader.getStripes().iterator().hasNext());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void metaData() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(1000L).compress(CompressionKind.NONE).bufferSize(100));
            writer.addUserMetadata("my.meta", TestOrcFile.byteBuf(1, 2, 3, 4, 5, 6, 7, -1, -2, 127, -128));
            writer.addUserMetadata("clobber", TestOrcFile.byteBuf(1, 2, 3));
            writer.addUserMetadata("clobber", TestOrcFile.byteBuf(4, 3, 2, 1));
            ByteBuffer bigBuf = ByteBuffer.allocate(40000);
            Random random = new Random(0L);
            random.nextBytes(bigBuf.array());
            writer.addUserMetadata("big", bigBuf);
            bigBuf.position(0);
            writer.addRow((Object)new BigRow(true, (byte)127, (short)1024, 42, 0xA80000000L, Float.valueOf(3.1415f), -2.713, null, null, null, null, null));
            writer.addUserMetadata("clobber", TestOrcFile.byteBuf(5, 7, 11, 13, 17, 19));
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            junit.framework.Assert.assertEquals((Object)TestOrcFile.byteBuf(5, 7, 11, 13, 17, 19), (Object)reader.getMetadataValue("clobber"));
            junit.framework.Assert.assertEquals((Object)TestOrcFile.byteBuf(1, 2, 3, 4, 5, 6, 7, -1, -2, 127, -128), (Object)reader.getMetadataValue("my.meta"));
            junit.framework.Assert.assertEquals((Object)bigBuf, (Object)reader.getMetadataValue("big"));
            try {
                reader.getMetadataValue("unknown");
                junit.framework.Assert.assertTrue((boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            int i = 0;
            for (String key : reader.getMetadataKeys()) {
                if ("my.meta".equals(key) || "clobber".equals(key) || "big".equals(key)) {
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("unknown key " + key);
            }
            junit.framework.Assert.assertEquals((int)3, (int)i);
            int numStripes = reader.getStripeStatistics().size();
            junit.framework.Assert.assertEquals((int)1, (int)numStripes);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrcDateFile(Path file, int minYear, int maxYear) throws IOException {
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addFieldNames("time").addFieldNames("date").addSubtypes(1).addSubtypes(2).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.TIMESTAMP).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.DATE).build());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = OrcStruct.createObjectInspector((int)0, types);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)file, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(100000L).bufferSize(10000).blockPadding(false));
            OrcStruct row = new OrcStruct(2);
            for (int year = minYear; year < maxYear; ++year) {
                for (int ms = 1000; ms < 2000; ++ms) {
                    row.setFieldValue(0, (Object)new TimestampWritable(Timestamp.valueOf(year + "-05-05 12:34:56." + ms)));
                    row.setFieldValue(1, (Object)new DateWritable(new Date(year - 1900, 11, 25)));
                    writer.addRow((Object)row);
                }
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)file, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf));
            RecordReader rows = reader.rows();
            for (int year = minYear; year < maxYear; ++year) {
                for (int ms = 1000; ms < 2000; ++ms) {
                    row = (OrcStruct)rows.next((Object)row);
                    junit.framework.Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf(year + "-05-05 12:34:56." + ms)), (Object)row.getFieldValue(0));
                    junit.framework.Assert.assertEquals((Object)new DateWritable(new Date(year - 1900, 11, 25)), (Object)row.getFieldValue(1));
                }
            }
            return;
        }
    }

    @Test
    public void testDate1900() throws Exception {
        this.createOrcDateFile(this.testFilePath, 1900, 1970);
    }

    @Test
    public void testDate2038() throws Exception {
        this.createOrcDateFile(this.testFilePath, 2038, 2250);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnionAndTimestamp() throws Exception {
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRUCT).addFieldNames("time").addFieldNames("union").addFieldNames("decimal").addSubtypes(1).addSubtypes(2).addSubtypes(5).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.TIMESTAMP).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.UNION).addSubtypes(3).addSubtypes(4).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.INT).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.STRING).build());
        types.add(OrcProto.Type.newBuilder().setKind(OrcProto.Type.Kind.DECIMAL).build());
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            ObjectInspector inspector = OrcStruct.createObjectInspector((int)0, types);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            HiveDecimal maxValue = HiveDecimal.create((String)"10000000000000000000");
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(1000L).compress(CompressionKind.NONE).batchSize(1000).bufferSize(100).blockPadding(false));
            OrcStruct row = new OrcStruct(3);
            OrcUnion union = new OrcUnion();
            row.setFieldValue(1, (Object)union);
            row.setFieldValue(0, (Object)new TimestampWritable(Timestamp.valueOf("2000-03-12 15:00:00")));
            HiveDecimal value = HiveDecimal.create((String)"12345678.6547456");
            row.setFieldValue(2, (Object)new HiveDecimalWritable(value));
            union.set((byte)0, (Object)new IntWritable(42));
            writer.addRow((Object)row);
            row.setFieldValue(0, (Object)new TimestampWritable(Timestamp.valueOf("2000-03-20 12:00:00.123456789")));
            union.set((byte)1, (Object)new Text("hello"));
            value = HiveDecimal.create((String)"-5643.234");
            row.setFieldValue(2, (Object)new HiveDecimalWritable(value));
            writer.addRow((Object)row);
            row.setFieldValue(0, null);
            row.setFieldValue(1, null);
            row.setFieldValue(2, null);
            writer.addRow((Object)row);
            row.setFieldValue(1, (Object)union);
            union.set((byte)0, null);
            writer.addRow((Object)row);
            union.set((byte)1, null);
            writer.addRow((Object)row);
            union.set((byte)0, (Object)new IntWritable(200000));
            row.setFieldValue(0, (Object)new TimestampWritable(Timestamp.valueOf("1970-01-01 00:00:00")));
            value = HiveDecimal.create((String)"10000000000000000000");
            row.setFieldValue(2, (Object)new HiveDecimalWritable(value));
            writer.addRow((Object)row);
            Random rand = new Random(42L);
            for (i2 = 1970; i2 < 2038; ++i2) {
                row.setFieldValue(0, (Object)new TimestampWritable(Timestamp.valueOf(i2 + "-05-05 12:34:56." + i2)));
                if ((i2 & 1) == 0) {
                    union.set((byte)0, (Object)new IntWritable(i2 * i2));
                } else {
                    union.set((byte)1, (Object)new Text(Integer.toString(i2 * i2)));
                }
                value = HiveDecimal.create((BigInteger)new BigInteger(64, rand), (int)rand.nextInt(18));
                row.setFieldValue(2, (Object)new HiveDecimalWritable(value));
                if (maxValue.compareTo(value) < 0) {
                    maxValue = value;
                }
                writer.addRow((Object)row);
            }
            row.setFieldValue(0, null);
            union.set((byte)0, (Object)new IntWritable(1732050807));
            row.setFieldValue(2, null);
            for (i2 = 0; i2 < 5000; ++i2) {
                writer.addRow((Object)row);
            }
            union.set((byte)0, (Object)new IntWritable(0));
            writer.addRow((Object)row);
            union.set((byte)0, (Object)new IntWritable(10));
            writer.addRow((Object)row);
            union.set((byte)0, (Object)new IntWritable(138));
            writer.addRow((Object)row);
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            TypeDescription schema = writer.getSchema();
            junit.framework.Assert.assertEquals((int)5, (int)schema.getMaximumId());
            boolean[] expected = new boolean[]{false, false, false, false, false, false};
            boolean[] included = OrcUtils.includeColumns((String)"", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, true, false, false, false, true};
            included = OrcUtils.includeColumns((String)"time,decimal", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            expected = new boolean[]{false, false, true, true, true, false};
            included = OrcUtils.includeColumns((String)"union", (TypeDescription)schema);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)Arrays.equals(expected, included));
            junit.framework.Assert.assertEquals((boolean)false, (boolean)reader.getMetadataKeys().iterator().hasNext());
            junit.framework.Assert.assertEquals((long)5077L, (long)reader.getNumberOfRows());
            DecimalColumnStatistics stats = (DecimalColumnStatistics)reader.getStatistics()[5];
            junit.framework.Assert.assertEquals((long)71L, (long)stats.getNumberOfValues());
            junit.framework.Assert.assertEquals((Object)HiveDecimal.create((String)"-5643.234"), (Object)stats.getMinimum());
            junit.framework.Assert.assertEquals((Object)maxValue, (Object)stats.getMaximum());
            int stripeCount = 0;
            int rowCount = 0;
            long currentOffset = -1L;
            for (StripeInformation stripe : reader.getStripes()) {
                ++stripeCount;
                rowCount = (int)((long)rowCount + stripe.getNumberOfRows());
                if (currentOffset < 0L) {
                    currentOffset = stripe.getOffset() + stripe.getLength();
                    continue;
                }
                junit.framework.Assert.assertEquals((long)currentOffset, (long)stripe.getOffset());
                currentOffset += stripe.getLength();
            }
            junit.framework.Assert.assertEquals((long)reader.getNumberOfRows(), (long)rowCount);
            junit.framework.Assert.assertEquals((int)2, (int)stripeCount);
            junit.framework.Assert.assertEquals((long)reader.getContentLength(), (long)currentOffset);
            RecordReader rows = reader.rows();
            junit.framework.Assert.assertEquals((long)0L, (long)rows.getRowNumber());
            junit.framework.Assert.assertEquals((double)0.0, (double)rows.getProgress(), (double)1.0E-6);
            junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
            row = (OrcStruct)rows.next(null);
            junit.framework.Assert.assertEquals((long)1L, (long)rows.getRowNumber());
            inspector = reader.getObjectInspector();
            junit.framework.Assert.assertEquals((String)"struct<time:timestamp,union:uniontype<int,string>,decimal:decimal(38,18)>", (String)inspector.getTypeName());
            junit.framework.Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("2000-03-12 15:00:00")), (Object)row.getFieldValue(0));
            union = (OrcUnion)row.getFieldValue(1);
            junit.framework.Assert.assertEquals((int)0, (int)union.getTag());
            junit.framework.Assert.assertEquals((Object)new IntWritable(42), (Object)union.getObject());
            junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"12345678.6547456")), (Object)row.getFieldValue(2));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals((long)2L, (long)rows.getRowNumber());
            junit.framework.Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("2000-03-20 12:00:00.123456789")), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((int)1, (int)union.getTag());
            junit.framework.Assert.assertEquals((Object)new Text("hello"), (Object)union.getObject());
            junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-5643.234")), (Object)row.getFieldValue(2));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(1));
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(2));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(0));
            union = (OrcUnion)row.getFieldValue(1);
            junit.framework.Assert.assertEquals((int)0, (int)union.getTag());
            junit.framework.Assert.assertEquals(null, (Object)union.getObject());
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(2));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((int)1, (int)union.getTag());
            junit.framework.Assert.assertEquals(null, (Object)union.getObject());
            junit.framework.Assert.assertEquals(null, (Object)row.getFieldValue(2));
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("1970-01-01 00:00:00")), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((Object)new IntWritable(200000), (Object)union.getObject());
            junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"10000000000000000000")), (Object)row.getFieldValue(2));
            rand = new Random(42L);
            for (i = 1970; i < 2038; ++i) {
                row = (OrcStruct)rows.next((Object)row);
                junit.framework.Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf(i + "-05-05 12:34:56." + i)), (Object)row.getFieldValue(0));
                if ((i & 1) == 0) {
                    junit.framework.Assert.assertEquals((int)0, (int)union.getTag());
                    junit.framework.Assert.assertEquals((Object)new IntWritable(i * i), (Object)union.getObject());
                } else {
                    junit.framework.Assert.assertEquals((int)1, (int)union.getTag());
                    junit.framework.Assert.assertEquals((Object)new Text(Integer.toString(i * i)), (Object)union.getObject());
                }
                junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((BigInteger)new BigInteger(64, rand), (int)rand.nextInt(18))), (Object)row.getFieldValue(2));
            }
            for (i = 0; i < 5000; ++i) {
                row = (OrcStruct)rows.next((Object)row);
                junit.framework.Assert.assertEquals((Object)new IntWritable(1732050807), (Object)union.getObject());
            }
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals((Object)new IntWritable(0), (Object)union.getObject());
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals((Object)new IntWritable(10), (Object)union.getObject());
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals((Object)new IntWritable(138), (Object)union.getObject());
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            junit.framework.Assert.assertEquals((double)1.0, (double)rows.getProgress(), (double)1.0E-5);
            junit.framework.Assert.assertEquals((long)reader.getNumberOfRows(), (long)rows.getRowNumber());
            rows.seekToRow(1L);
            row = (OrcStruct)rows.next((Object)row);
            junit.framework.Assert.assertEquals((Object)new TimestampWritable(Timestamp.valueOf("2000-03-20 12:00:00.123456789")), (Object)row.getFieldValue(0));
            junit.framework.Assert.assertEquals((int)1, (int)union.getTag());
            junit.framework.Assert.assertEquals((Object)new Text("hello"), (Object)union.getObject());
            junit.framework.Assert.assertEquals((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-5643.234")), (Object)row.getFieldValue(2));
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnappy() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(1000L).compress(CompressionKind.SNAPPY).bufferSize(100));
            Random rand = new Random(12L);
            for (int i = 0; i < 10000; ++i) {
                writer.addRow((Object)new InnerStruct(rand.nextInt(), Integer.toHexString(rand.nextInt())));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            rand = new Random(12L);
            OrcStruct row = null;
            for (int i = 0; i < 10000; ++i) {
                junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
                row = (OrcStruct)rows.next(row);
                junit.framework.Assert.assertEquals((int)rand.nextInt(), (int)((IntWritable)row.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((String)Integer.toHexString(rand.nextInt()), (String)row.getFieldValue(1).toString());
            }
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithoutIndex() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(5000L).compress(CompressionKind.SNAPPY).bufferSize(1000).rowIndexStride(0));
            Random rand = new Random(24L);
            for (int i = 0; i < 10000; ++i) {
                InnerStruct row = new InnerStruct(rand.nextInt(), Integer.toBinaryString(rand.nextInt()));
                for (int j = 0; j < 5; ++j) {
                    writer.addRow((Object)row);
                }
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            junit.framework.Assert.assertEquals((long)50000L, (long)reader.getNumberOfRows());
            junit.framework.Assert.assertEquals((int)0, (int)reader.getRowIndexStride());
            StripeInformation stripe = (StripeInformation)reader.getStripes().iterator().next();
            junit.framework.Assert.assertEquals((boolean)true, (stripe.getDataLength() != 0L ? 1 : 0) != 0);
            junit.framework.Assert.assertEquals((long)0L, (long)stripe.getIndexLength());
            RecordReader rows = reader.rows();
            rand = new Random(24L);
            OrcStruct row = null;
            for (int i = 0; i < 10000; ++i) {
                int intVal = rand.nextInt();
                String strVal = Integer.toBinaryString(rand.nextInt());
                for (int j = 0; j < 5; ++j) {
                    junit.framework.Assert.assertEquals((boolean)true, (boolean)rows.hasNext());
                    row = (OrcStruct)rows.next(row);
                    junit.framework.Assert.assertEquals((int)intVal, (int)((IntWritable)row.getFieldValue(0)).get());
                    junit.framework.Assert.assertEquals((String)strVal, (String)row.getFieldValue(1).toString());
                }
            }
            junit.framework.Assert.assertEquals((boolean)false, (boolean)rows.hasNext());
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeek() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(200000L).bufferSize(65536).rowIndexStride(1000));
            Random rand = new Random(42L);
            int COUNT = 32768;
            long[] intValues = new long[32768];
            double[] doubleValues = new double[32768];
            String[] stringValues = new String[32768];
            BytesWritable[] byteValues = new BytesWritable[32768];
            String[] words = new String[128];
            for (i = 0; i < words.length; ++i) {
                words[i] = Integer.toHexString(rand.nextInt());
            }
            for (i = 0; i < 16384; ++i) {
                intValues[2 * i] = rand.nextLong();
                intValues[2 * i + 1] = intValues[2 * i];
                stringValues[2 * i] = words[rand.nextInt(words.length)];
                stringValues[2 * i + 1] = stringValues[2 * i];
            }
            for (i = 0; i < 32768; ++i) {
                doubleValues[i] = rand.nextDouble();
                byte[] buf = new byte[20];
                rand.nextBytes(buf);
                byteValues[i] = new BytesWritable(buf);
            }
            for (i = 0; i < 32768; ++i) {
                writer.addRow((Object)this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, i));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            junit.framework.Assert.assertEquals((long)32768L, (long)reader.getNumberOfRows());
            RecordReader rows = reader.rows();
            OrcStruct row = null;
            for (int i2 = Short.MAX_VALUE; i2 >= 0; --i2) {
                if (i2 % 32768 == Short.MAX_VALUE) {
                    rows.seekToRow((long)(i2 - Short.MAX_VALUE));
                }
                rows.seekToRow((long)i2);
                row = (OrcStruct)rows.next(row);
                BigRow expected = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, i2);
                junit.framework.Assert.assertEquals((boolean)expected.boolean1, (boolean)((BooleanWritable)row.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((byte)expected.byte1, (byte)((ByteWritable)row.getFieldValue(1)).get());
                junit.framework.Assert.assertEquals((short)expected.short1, (short)((ShortWritable)row.getFieldValue(2)).get());
                junit.framework.Assert.assertEquals((int)expected.int1, (int)((IntWritable)row.getFieldValue(3)).get());
                junit.framework.Assert.assertEquals((long)expected.long1, (long)((LongWritable)row.getFieldValue(4)).get());
                junit.framework.Assert.assertEquals((double)expected.float1.floatValue(), (double)((FloatWritable)row.getFieldValue(5)).get(), (double)1.0E-4);
                junit.framework.Assert.assertEquals((double)expected.double1, (double)((DoubleWritable)row.getFieldValue(6)).get(), (double)1.0E-4);
                junit.framework.Assert.assertEquals((Object)expected.bytes1, (Object)row.getFieldValue(7));
                junit.framework.Assert.assertEquals((Object)expected.string1, (Object)row.getFieldValue(8));
                List<InnerStruct> expectedList = expected.middle.list;
                List actualList = (List)((OrcStruct)row.getFieldValue(9)).getFieldValue(0);
                this.compareList(expectedList, actualList);
                this.compareList(expected.list, (List)row.getFieldValue(10));
            }
            rows.close();
            Iterator stripeIterator = reader.getStripes().iterator();
            long offsetOfStripe2 = 0L;
            long offsetOfStripe4 = 0L;
            long lastRowOfStripe2 = 0L;
            for (int i3 = 0; i3 < 5; ++i3) {
                StripeInformation stripe = (StripeInformation)stripeIterator.next();
                if (i3 < 2) {
                    lastRowOfStripe2 += stripe.getNumberOfRows();
                    continue;
                }
                if (i3 == 2) {
                    offsetOfStripe2 = stripe.getOffset();
                    lastRowOfStripe2 += stripe.getNumberOfRows() - 1L;
                    continue;
                }
                if (i3 != 4) continue;
                offsetOfStripe4 = stripe.getOffset();
            }
            boolean[] columns = new boolean[reader.getStatistics().length];
            columns[5] = true;
            columns[9] = true;
            rows = reader.rowsOptions(new Reader.Options().range(offsetOfStripe2, offsetOfStripe4 - offsetOfStripe2).include(columns));
            rows.seekToRow(lastRowOfStripe2);
            for (int i4 = 0; i4 < 2; ++i4) {
                row = (OrcStruct)rows.next((Object)row);
                BigRow expected = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, (int)(lastRowOfStripe2 + (long)i4));
                junit.framework.Assert.assertEquals((long)expected.long1, (long)((LongWritable)row.getFieldValue(4)).get());
                junit.framework.Assert.assertEquals((Object)expected.string1, (Object)row.getFieldValue(8));
            }
            rows.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroCopySeek() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).stripeSize(200000L).bufferSize(65536).rowIndexStride(1000));
            Random rand = new Random(42L);
            int COUNT = 32768;
            long[] intValues = new long[32768];
            double[] doubleValues = new double[32768];
            String[] stringValues = new String[32768];
            BytesWritable[] byteValues = new BytesWritable[32768];
            String[] words = new String[128];
            for (i = 0; i < words.length; ++i) {
                words[i] = Integer.toHexString(rand.nextInt());
            }
            for (i = 0; i < 16384; ++i) {
                intValues[2 * i] = rand.nextLong();
                intValues[2 * i + 1] = intValues[2 * i];
                stringValues[2 * i] = words[rand.nextInt(words.length)];
                stringValues[2 * i + 1] = stringValues[2 * i];
            }
            for (i = 0; i < 32768; ++i) {
                doubleValues[i] = rand.nextDouble();
                byte[] buf = new byte[20];
                rand.nextBytes(buf);
                byteValues[i] = new BytesWritable(buf);
            }
            for (i = 0; i < 32768; ++i) {
                writer.addRow((Object)this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, i));
            }
            writer.close();
            writer = null;
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            junit.framework.Assert.assertEquals((long)32768L, (long)reader.getNumberOfRows());
            Configuration conf = new Configuration();
            conf.setBoolean(OrcConf.USE_ZEROCOPY.getHiveConfName(), true);
            RecordReader rows = reader.rows();
            OrcStruct row = null;
            for (int i2 = Short.MAX_VALUE; i2 >= 0; --i2) {
                if (i2 % 32768 == Short.MAX_VALUE) {
                    rows.seekToRow((long)(i2 - Short.MAX_VALUE));
                }
                rows.seekToRow((long)i2);
                row = (OrcStruct)rows.next(row);
                BigRow expected = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, i2);
                junit.framework.Assert.assertEquals((boolean)expected.boolean1, (boolean)((BooleanWritable)row.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((byte)expected.byte1, (byte)((ByteWritable)row.getFieldValue(1)).get());
                junit.framework.Assert.assertEquals((short)expected.short1, (short)((ShortWritable)row.getFieldValue(2)).get());
                junit.framework.Assert.assertEquals((int)expected.int1, (int)((IntWritable)row.getFieldValue(3)).get());
                junit.framework.Assert.assertEquals((long)expected.long1, (long)((LongWritable)row.getFieldValue(4)).get());
                junit.framework.Assert.assertEquals((double)expected.float1.floatValue(), (double)((FloatWritable)row.getFieldValue(5)).get(), (double)1.0E-4);
                junit.framework.Assert.assertEquals((double)expected.double1, (double)((DoubleWritable)row.getFieldValue(6)).get(), (double)1.0E-4);
                junit.framework.Assert.assertEquals((Object)expected.bytes1, (Object)row.getFieldValue(7));
                junit.framework.Assert.assertEquals((Object)expected.string1, (Object)row.getFieldValue(8));
                List<InnerStruct> expectedList = expected.middle.list;
                List actualList = (List)((OrcStruct)row.getFieldValue(9)).getFieldValue(0);
                this.compareList(expectedList, actualList);
                this.compareList(expected.list, (List)row.getFieldValue(10));
            }
            rows.close();
            Iterator stripeIterator = reader.getStripes().iterator();
            long offsetOfStripe2 = 0L;
            long offsetOfStripe4 = 0L;
            long lastRowOfStripe2 = 0L;
            for (int i3 = 0; i3 < 5; ++i3) {
                StripeInformation stripe = (StripeInformation)stripeIterator.next();
                if (i3 < 2) {
                    lastRowOfStripe2 += stripe.getNumberOfRows();
                    continue;
                }
                if (i3 == 2) {
                    offsetOfStripe2 = stripe.getOffset();
                    lastRowOfStripe2 += stripe.getNumberOfRows() - 1L;
                    continue;
                }
                if (i3 != 4) continue;
                offsetOfStripe4 = stripe.getOffset();
            }
            boolean[] columns = new boolean[reader.getStatistics().length];
            columns[5] = true;
            columns[9] = true;
            rows = reader.rowsOptions(new Reader.Options().range(offsetOfStripe2, offsetOfStripe4 - offsetOfStripe2).include(columns));
            rows.seekToRow(lastRowOfStripe2);
            for (int i4 = 0; i4 < 2; ++i4) {
                row = (OrcStruct)rows.next((Object)row);
                BigRow expected = this.createRandomRow(intValues, doubleValues, stringValues, byteValues, words, (int)(lastRowOfStripe2 + (long)i4));
                junit.framework.Assert.assertEquals((long)expected.long1, (long)((LongWritable)row.getFieldValue(4)).get());
                junit.framework.Assert.assertEquals((Object)expected.string1, (Object)row.getFieldValue(8));
            }
            rows.close();
            return;
        }
    }

    private void compareInner(InnerStruct expect, OrcStruct actual) throws Exception {
        if (expect == null || actual == null) {
            junit.framework.Assert.assertEquals(null, (Object)expect);
            junit.framework.Assert.assertEquals(null, (Object)actual);
        } else {
            junit.framework.Assert.assertEquals((int)expect.int1, (int)((IntWritable)actual.getFieldValue(0)).get());
            junit.framework.Assert.assertEquals((Object)expect.string1, (Object)actual.getFieldValue(1));
        }
    }

    private void compareList(List<InnerStruct> expect, List<OrcStruct> actual) throws Exception {
        junit.framework.Assert.assertEquals((int)expect.size(), (int)actual.size());
        for (int j = 0; j < expect.size(); ++j) {
            this.compareInner(expect.get(j), actual.get(j));
        }
    }

    private BigRow createRandomRow(long[] intValues, double[] doubleValues, String[] stringValues, BytesWritable[] byteValues, String[] words, int i) {
        InnerStruct inner = new InnerStruct((int)intValues[i], stringValues[i]);
        InnerStruct inner2 = new InnerStruct((int)(intValues[i] >> 32), words[i % words.length] + "-x");
        return new BigRow((intValues[i] & 1L) == 0L, (byte)intValues[i], (short)intValues[i], (int)intValues[i], intValues[i], Float.valueOf((float)doubleValues[i]), doubleValues[i], byteValues[i], stringValues[i], new MiddleStruct(inner, inner2), TestOrcFile.list(new InnerStruct[0]), TestOrcFile.map(inner, inner2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryManagementV11() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MyMemoryManager memory = new MyMemoryManager(this.conf, 10000L, 0.1);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).stripeSize(50000L).bufferSize(100).rowIndexStride(0).memory((MemoryManager)memory).batchSize(100).version(OrcFile.Version.V_0_11));
            junit.framework.Assert.assertEquals((Object)this.testFilePath, (Object)memory.path);
            for (int i = 0; i < 2500; ++i) {
                writer.addRow((Object)new InnerStruct(i * 300, Integer.toHexString(10 * i)));
            }
            writer.close();
            junit.framework.Assert.assertEquals(null, (Object)memory.path);
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            int i = 0;
            for (StripeInformation stripe : reader.getStripes()) {
                junit.framework.Assert.assertTrue((String)("stripe " + ++i + " is too long at " + stripe.getDataLength()), (stripe.getDataLength() < 5000L ? 1 : 0) != 0);
            }
            junit.framework.Assert.assertEquals((int)25, (int)i);
            junit.framework.Assert.assertEquals((long)2500L, (long)reader.getNumberOfRows());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryManagementV12() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            MyMemoryManager memory = new MyMemoryManager(this.conf, 10000L, 0.1);
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.NONE).stripeSize(50000L).bufferSize(100).rowIndexStride(0).memory((MemoryManager)memory).batchSize(100).version(OrcFile.Version.V_0_12));
            junit.framework.Assert.assertEquals((Object)this.testFilePath, (Object)memory.path);
            for (int i = 0; i < 2500; ++i) {
                writer.addRow((Object)new InnerStruct(i * 300, Integer.toHexString(10 * i)));
            }
            writer.close();
            junit.framework.Assert.assertEquals(null, (Object)memory.path);
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            int i = 0;
            for (StripeInformation stripe : reader.getStripes()) {
                junit.framework.Assert.assertTrue((String)("stripe " + ++i + " is too long at " + stripe.getDataLength()), (stripe.getDataLength() < 5000L ? 1 : 0) != 0);
            }
            junit.framework.Assert.assertEquals((int)3, (int)i);
            junit.framework.Assert.assertEquals((long)2500L, (long)reader.getNumberOfRows());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPredicatePushdown() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(InnerStruct.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)400000L, (CompressionKind)CompressionKind.NONE, (int)500, (int)1000);
            for (int i2 = 0; i2 < 3500; ++i2) {
                writer.addRow((Object)new InnerStruct(i2 * 300, Integer.toHexString(10 * i2)));
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            junit.framework.Assert.assertEquals((long)3500L, (long)reader.getNumberOfRows());
            SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().startNot().lessThan("int1", PredicateLeaf.Type.LONG, (Object)300000L).end().lessThan("int1", PredicateLeaf.Type.LONG, (Object)600000L).end().build();
            RecordReader rows = reader.rowsOptions(new Reader.Options().range(0L, Long.MAX_VALUE).include(new boolean[]{true, true, true}).searchArgument(sarg, new String[]{null, "int1", "string1"}));
            junit.framework.Assert.assertEquals((long)0L, (long)rows.getRowNumber());
            OrcStruct row = null;
            for (i = 1000; i < 2000; ++i) {
                junit.framework.Assert.assertTrue((boolean)rows.hasNext());
                junit.framework.Assert.assertEquals((long)i, (long)rows.getRowNumber());
                row = (OrcStruct)rows.next(row);
                junit.framework.Assert.assertEquals((int)(300 * i), (int)((IntWritable)row.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((String)Integer.toHexString(10 * i), (String)row.getFieldValue(1).toString());
            }
            junit.framework.Assert.assertTrue((!rows.hasNext() ? 1 : 0) != 0);
            junit.framework.Assert.assertEquals((long)3500L, (long)rows.getRowNumber());
            sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("int1", PredicateLeaf.Type.LONG, (Object)0L).end().build();
            rows = reader.rowsOptions(new Reader.Options().range(0L, Long.MAX_VALUE).include(new boolean[]{true, true, true}).searchArgument(sarg, new String[]{null, "int1", "string1"}));
            junit.framework.Assert.assertTrue((!rows.hasNext() ? 1 : 0) != 0);
            sarg = SearchArgumentFactory.newBuilder().startOr().lessThan("int1", PredicateLeaf.Type.LONG, (Object)30000L).startNot().lessThan("int1", PredicateLeaf.Type.LONG, (Object)1020000L).end().end().build();
            rows = reader.rowsOptions(new Reader.Options().range(0L, Long.MAX_VALUE).include(new boolean[]{true, true, true}).searchArgument(sarg, new String[]{null, "int1", "string1"}));
            row = null;
            for (i = 0; i < 1000; ++i) {
                junit.framework.Assert.assertTrue((boolean)rows.hasNext());
                junit.framework.Assert.assertEquals((long)i, (long)rows.getRowNumber());
                row = (OrcStruct)rows.next((Object)row);
                junit.framework.Assert.assertEquals((int)(300 * i), (int)((IntWritable)row.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((String)Integer.toHexString(10 * i), (String)row.getFieldValue(1).toString());
            }
            for (i = 3000; i < 3500; ++i) {
                junit.framework.Assert.assertTrue((boolean)rows.hasNext());
                junit.framework.Assert.assertEquals((long)i, (long)rows.getRowNumber());
                row = (OrcStruct)rows.next((Object)row);
                junit.framework.Assert.assertEquals((int)(300 * i), (int)((IntWritable)row.getFieldValue(0)).get());
                junit.framework.Assert.assertEquals((String)Integer.toHexString(10 * i), (String)row.getFieldValue(1).toString());
            }
            junit.framework.Assert.assertTrue((!rows.hasNext() ? 1 : 0) != 0);
            junit.framework.Assert.assertEquals((long)3500L, (long)rows.getRowNumber());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBitPack64Large() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(Long.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int size = 1080832;
            long[] inp = new long[size];
            Random rand = new Random(1234L);
            for (int i = 0; i < size; ++i) {
                inp[i] = rand.nextLong();
            }
            ArrayList input = Lists.newArrayList((Iterable)Longs.asList((long[])inp));
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector).compress(CompressionKind.ZLIB));
            for (Long l : input) {
                writer.addRow((Object)l);
            }
            writer.close();
            Reader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs));
            RecordReader rows = reader.rows();
            int idx = 0;
            while (rows.hasNext()) {
                Object row = rows.next(null);
                Assert.assertEquals((long)((Long)input.get(idx++)), (long)((LongWritable)row).get());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListExpansion() throws Exception {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyList.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)this.testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).inspector(inspector));
            MyList row = new MyList();
            row.list.add(1);
            row.list.add(2);
            row.list.add(3);
            writer.addRow((Object)row);
            row.list.clear();
            writer.addRow((Object)row);
            row.list.add(11);
            row.list.add(12);
            writer.addRow((Object)row);
            row.list = null;
            writer.addRow((Object)row);
            row.list = new ArrayList<Integer>();
            row.list.add(21);
            row.list.add(22);
            row.list.add(23);
            row.list.add(24);
            writer.addRow((Object)row);
            writer.close();
            RecordReader reader = OrcFile.createReader((Path)this.testFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf)).rows();
            junit.framework.Assert.assertEquals((boolean)true, (boolean)reader.hasNext());
            OrcStruct orcrow = (OrcStruct)reader.next(null);
            junit.framework.Assert.assertEquals((int)3, (int)((List)orcrow.getFieldValue(0)).size());
            orcrow = (OrcStruct)reader.next((Object)row);
            junit.framework.Assert.assertEquals((int)0, (int)((List)orcrow.getFieldValue(0)).size());
            orcrow = (OrcStruct)reader.next((Object)row);
            junit.framework.Assert.assertEquals((int)2, (int)((List)orcrow.getFieldValue(0)).size());
            junit.framework.Assert.assertEquals(null, (Object)((OrcStruct)reader.next((Object)row)).getFieldValue(0));
            orcrow = (OrcStruct)reader.next((Object)row);
            junit.framework.Assert.assertEquals((int)4, (int)((List)orcrow.getFieldValue(0)).size());
            junit.framework.Assert.assertEquals((boolean)false, (boolean)reader.hasNext());
            reader.close();
            return;
        }
    }

    static class MyList {
        List<Integer> list = new ArrayList<Integer>();

        MyList() {
        }
    }

    private static class MyMemoryManager
    implements MemoryManager {
        final long totalSpace;
        double rate;
        Path path = null;
        long lastAllocation = 0L;
        int rows = 0;
        MemoryManager.Callback callback;

        MyMemoryManager(Configuration conf, long totalSpace, double rate) {
            this.totalSpace = totalSpace;
            this.rate = rate;
        }

        public void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback) {
            this.path = path;
            this.lastAllocation = requestedAllocation;
            this.callback = callback;
        }

        public synchronized void removeWriter(Path path) {
            this.path = null;
            this.lastAllocation = 0L;
        }

        public void addedRow(int count) throws IOException {
            this.rows += count;
            if (this.rows >= 100) {
                this.callback.checkMemory(this.rate);
                this.rows = 0;
            }
        }
    }

    public static class BigRow {
        Boolean boolean1;
        Byte byte1;
        Short short1;
        Integer int1;
        Long long1;
        Float float1;
        Double double1;
        BytesWritable bytes1;
        Text string1;
        MiddleStruct middle;
        List<InnerStruct> list = new ArrayList<InnerStruct>();
        Map<Text, InnerStruct> map = new HashMap<Text, InnerStruct>();

        BigRow(Boolean b1, Byte b2, Short s1, Integer i1, Long l1, Float f1, Double d1, BytesWritable b3, String s2, MiddleStruct m1, List<InnerStruct> l2, Map<Text, InnerStruct> m2) {
            this.boolean1 = b1;
            this.byte1 = b2;
            this.short1 = s1;
            this.int1 = i1;
            this.long1 = l1;
            this.float1 = f1;
            this.double1 = d1;
            this.bytes1 = b3;
            this.string1 = s2 == null ? null : new Text(s2);
            this.middle = m1;
            this.list = l2;
            this.map = m2;
        }
    }

    public static class MiddleStruct {
        List<InnerStruct> list = new ArrayList<InnerStruct>();

        MiddleStruct(InnerStruct ... items) {
            this.list.clear();
            this.list.addAll(Arrays.asList(items));
        }
    }

    public static class InnerStruct {
        int int1;
        Text string1 = new Text();

        InnerStruct(int int1, String string1) {
            this.int1 = int1;
            this.string1.set(string1);
        }
    }

    public static class SimpleStruct {
        BytesWritable bytes1;
        Text string1;

        SimpleStruct(BytesWritable b1, String s1) {
            this.bytes1 = b1;
            this.string1 = s1 == null ? null : new Text(s1);
        }
    }

    public static class DecimalStruct {
        HiveDecimalWritable dec;

        DecimalStruct(HiveDecimalWritable hdw) {
            this.dec = hdw;
        }
    }
}

