/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.impl.OrcAcidUtils;
import org.apache.orc.tools.FileDump;
import org.junit.Assert;
import org.junit.Test;

public class TestOrcRecordUpdater {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));

    @Test
    public void testAccessors() throws Exception {
        OrcStruct event = new OrcStruct(6);
        event.setFieldValue(0, (Object)new IntWritable(0));
        event.setFieldValue(4, (Object)new LongWritable(100L));
        event.setFieldValue(1, (Object)new LongWritable(50L));
        event.setFieldValue(2, (Object)new IntWritable(200));
        event.setFieldValue(3, (Object)new LongWritable(300L));
        Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
        Assert.assertEquals((long)50L, (long)OrcRecordUpdater.getOriginalTransaction((OrcStruct)event));
        Assert.assertEquals((long)100L, (long)OrcRecordUpdater.getCurrentTransaction((OrcStruct)event));
        Assert.assertEquals((long)200L, (long)OrcRecordUpdater.getBucket((OrcStruct)event));
        Assert.assertEquals((long)300L, (long)OrcRecordUpdater.getRowId((OrcStruct)event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriter() throws Exception {
        Path root = new Path(this.workDir, "testWriter");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).filesystem(fs).bucket(10).writingBase(false).minimumTransactionId(10L).maximumTransactionId(19L).inspector(inspector).reporter(Reporter.NULL).finalDestination(root);
            OrcRecordUpdater updater = new OrcRecordUpdater(root, options);
            updater.insert(11L, (Object)new MyRow("first"));
            updater.insert(11L, (Object)new MyRow("second"));
            updater.insert(11L, (Object)new MyRow("third"));
            updater.flush();
            updater.insert(12L, (Object)new MyRow("fourth"));
            updater.insert(12L, (Object)new MyRow("fifth"));
            updater.flush();
            Assert.assertEquals((long)5L, (long)updater.getStats().getRowCount());
            Path bucketPath = AcidUtils.createFilename((Path)root, (AcidOutputFormat.Options)options);
            Path sidePath = OrcAcidUtils.getSideFile((Path)bucketPath);
            FSDataInputStream side = fs.open(sidePath);
            long len = side.readLong();
            Reader reader = OrcFile.createReader((Path)bucketPath, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(conf).filesystem(fs).maxLength(len));
            Assert.assertEquals((long)3L, (long)reader.getNumberOfRows());
            len = side.readLong();
            side.close();
            reader = OrcFile.createReader((Path)bucketPath, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(conf).filesystem(fs).maxLength(len));
            Assert.assertEquals((long)5L, (long)reader.getNumberOfRows());
            RecordReader rows = reader.rows();
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            OrcStruct row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)row));
            Assert.assertEquals((long)11L, (long)OrcRecordUpdater.getCurrentTransaction((OrcStruct)row));
            Assert.assertEquals((long)11L, (long)OrcRecordUpdater.getOriginalTransaction((OrcStruct)row));
            Assert.assertEquals((long)10L, (long)OrcRecordUpdater.getBucket((OrcStruct)row));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertEquals((Object)"first", (Object)OrcRecordUpdater.getRow((OrcStruct)row).getFieldValue(0).toString());
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertEquals((long)10L, (long)OrcRecordUpdater.getBucket((OrcStruct)row));
            Assert.assertEquals((Object)"second", (Object)OrcRecordUpdater.getRow((OrcStruct)row).getFieldValue(0).toString());
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertEquals((long)10L, (long)OrcRecordUpdater.getBucket((OrcStruct)row));
            Assert.assertEquals((Object)"third", (Object)OrcRecordUpdater.getRow((OrcStruct)row).getFieldValue(0).toString());
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)12L, (long)OrcRecordUpdater.getCurrentTransaction((OrcStruct)row));
            Assert.assertEquals((long)12L, (long)OrcRecordUpdater.getOriginalTransaction((OrcStruct)row));
            Assert.assertEquals((long)10L, (long)OrcRecordUpdater.getBucket((OrcStruct)row));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertEquals((Object)"fourth", (Object)OrcRecordUpdater.getRow((OrcStruct)row).getFieldValue(0).toString());
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertEquals((Object)"fifth", (Object)OrcRecordUpdater.getRow((OrcStruct)row).getFieldValue(0).toString());
            Assert.assertEquals((Object)false, (Object)rows.hasNext());
            updater.insert(20L, (Object)new MyRow("sixth"));
            updater.close(false);
            reader = OrcFile.createReader((Path)bucketPath, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(conf).filesystem(fs));
            Assert.assertEquals((long)6L, (long)reader.getNumberOfRows());
            Assert.assertEquals((long)6L, (long)updater.getStats().getRowCount());
            Assert.assertEquals((Object)false, (Object)fs.exists(sidePath));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriterTblProperties() throws Exception {
        Path root = new Path(this.workDir, "testWriterTblProperties");
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            Properties tblProps = new Properties();
            tblProps.setProperty("orc.compress", "SNAPPY");
            tblProps.setProperty("orc.compress.size", "8192");
            HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORC_BASE_DELTA_RATIO, (int)4);
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).filesystem(fs).bucket(10).writingBase(false).minimumTransactionId(10L).maximumTransactionId(19L).inspector(inspector).reporter(Reporter.NULL).finalDestination(root).tableProperties(tblProps);
            OrcRecordUpdater updater = new OrcRecordUpdater(root, options);
            updater.insert(11L, (Object)new MyRow("first"));
            updater.insert(11L, (Object)new MyRow("second"));
            updater.insert(11L, (Object)new MyRow("third"));
            updater.flush();
            updater.insert(12L, (Object)new MyRow("fourth"));
            updater.insert(12L, (Object)new MyRow("fifth"));
            updater.flush();
            PrintStream origOut = System.out;
            ByteArrayOutputStream myOut = new ByteArrayOutputStream();
            System.setOut(new PrintStream(myOut));
            FileDump.main((String[])new String[]{root.toUri().toString()});
            System.out.flush();
            String outDump = new String(myOut.toByteArray());
            Assert.assertEquals((Object)true, (Object)outDump.contains("Compression: SNAPPY"));
            Assert.assertEquals((Object)true, (Object)outDump.contains("Compression size: 2048"));
            System.setOut(origOut);
            updater.close(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdates() throws Exception {
        Path root = new Path(this.workDir, "testUpdates");
        Configuration conf = new Configuration();
        FileSystem fs = root.getFileSystem(conf);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            int bucket = 20;
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).filesystem(fs).bucket(bucket).writingBase(false).minimumTransactionId(100L).maximumTransactionId(100L).inspector(inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(root);
            OrcRecordUpdater updater = new OrcRecordUpdater(root, options);
            updater.update(100L, (Object)new MyRow("update", 30L, 10L, bucket));
            updater.delete(100L, (Object)new MyRow("", 60L, 40L, bucket));
            Assert.assertEquals((long)-1L, (long)updater.getStats().getRowCount());
            updater.close(false);
            Path bucketPath = AcidUtils.createFilename((Path)root, (AcidOutputFormat.Options)options);
            Reader reader = OrcFile.createReader((Path)bucketPath, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(conf).filesystem(fs));
            Assert.assertEquals((long)2L, (long)reader.getNumberOfRows());
            RecordReader rows = reader.rows();
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            OrcStruct row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)1L, (long)OrcRecordUpdater.getOperation((OrcStruct)row));
            Assert.assertEquals((long)100L, (long)OrcRecordUpdater.getCurrentTransaction((OrcStruct)row));
            Assert.assertEquals((long)10L, (long)OrcRecordUpdater.getOriginalTransaction((OrcStruct)row));
            Assert.assertEquals((long)20L, (long)OrcRecordUpdater.getBucket((OrcStruct)row));
            Assert.assertEquals((long)30L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertEquals((Object)"update", (Object)OrcRecordUpdater.getRow((OrcStruct)row).getFieldValue(0).toString());
            Assert.assertEquals((Object)true, (Object)rows.hasNext());
            row = (OrcStruct)rows.next(null);
            Assert.assertEquals((long)100L, (long)OrcRecordUpdater.getCurrentTransaction((OrcStruct)row));
            Assert.assertEquals((long)40L, (long)OrcRecordUpdater.getOriginalTransaction((OrcStruct)row));
            Assert.assertEquals((long)20L, (long)OrcRecordUpdater.getBucket((OrcStruct)row));
            Assert.assertEquals((long)60L, (long)OrcRecordUpdater.getRowId((OrcStruct)row));
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)row));
            Assert.assertEquals((Object)false, (Object)rows.hasNext());
            return;
        }
    }

    static class MyRow {
        Text field;
        RecordIdentifier ROW__ID;

        MyRow(String val) {
            this.field = new Text(val);
            this.ROW__ID = null;
        }

        MyRow(String val, long rowId, long origTxn, int bucket) {
            this.field = new Text(val);
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }
    }
}

