/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.filemeta.OrcFileMetadataHandler;
import org.apache.hadoop.hive.metastore.hbase.MetadataStore;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.ExternalCache;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionExpressionForMetastore;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOrcSplitElimination {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    JobConf conf;
    FileSystem fs;
    Path testFilePath;
    Path testFilePath2;
    @Rule
    public TestName testCaseName = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestOrcSplitElimination.class);

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new JobConf();
        this.conf.set("columns", "userid,string1,subtype,decimal1,ts");
        this.conf.set("columns.types", "bigint,string,double,decimal,timestamp");
        this.conf.set("hive.io.file.read.all.columns", "false");
        this.conf.set("hive.io.file.readcolumn.ids", "0,2");
        this.conf.set("hive.io.file.readcolumn.names", "userid,subtype");
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.testFilePath2 = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".2.orc");
        this.fs.delete(this.testFilePath, false);
        this.fs.delete(this.testFilePath2, false);
    }

    @Test
    public void testSplitEliminationSmallMaxSplit() throws Exception {
        ObjectInspector inspector = this.createIO();
        Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
        this.writeData(writer);
        writer.close();
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)1000L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)5000L);
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
        ArrayList childExpr = Lists.newArrayList();
        this.createTestSarg(inspector, (GenericUDF)udf, childExpr);
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)5L, (long)splits.length);
        ExprNodeConstantDesc con = new ExprNodeConstantDesc((Object)1);
        childExpr.set(1, con);
        ExprNodeGenericFuncDesc en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        String sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)0L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)2);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)5);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)13);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)3L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)29);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)4L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)70);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)5L, (long)splits.length);
    }

    @Test
    public void testSplitEliminationLargeMaxSplit() throws Exception {
        ObjectInspector inspector = this.createIO();
        Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
        this.writeData(writer);
        writer.close();
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)1000L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)150000L);
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
        ArrayList childExpr = Lists.newArrayList();
        this.createTestSarg(inspector, (GenericUDF)udf, childExpr);
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        ExprNodeConstantDesc con = new ExprNodeConstantDesc((Object)0);
        childExpr.set(1, con);
        ExprNodeGenericFuncDesc en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        String sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)0L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)2);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)5);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)13);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)29);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)70);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
    }

    @Test
    public void testSplitEliminationComplexExpr() throws Exception {
        ObjectInspector inspector = this.createIO();
        Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)this.testFilePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
        this.writeData(writer);
        writer.close();
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMINSPLITSIZE, (long)1000L);
        HiveConf.setLongVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE, (long)150000L);
        OrcInputFormat in = new OrcInputFormat();
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)this.testFilePath.toString());
        GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
        ArrayList childExpr = Lists.newArrayList();
        ExprNodeColumnDesc col = new ExprNodeColumnDesc(Long.class, "userid", "T", false);
        ExprNodeConstantDesc con = new ExprNodeConstantDesc((Object)100);
        childExpr.add(col);
        childExpr.add(con);
        ExprNodeGenericFuncDesc en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        GenericUDFOPEqualOrLessThan udf1 = new GenericUDFOPEqualOrLessThan();
        ArrayList childExpr1 = Lists.newArrayList();
        ExprNodeColumnDesc col1 = new ExprNodeColumnDesc(Double.class, "subtype", "T", false);
        ExprNodeConstantDesc con1 = new ExprNodeConstantDesc((Object)1000.0);
        childExpr1.add(col1);
        childExpr1.add(con1);
        ExprNodeGenericFuncDesc en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
        GenericUDFOPAnd udf2 = new GenericUDFOPAnd();
        ArrayList childExpr2 = Lists.newArrayList();
        childExpr2.add(en);
        childExpr2.add(en1);
        ExprNodeGenericFuncDesc en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
        String sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        InputSplit[] splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)2);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        con1 = new ExprNodeConstantDesc((Object)0.0);
        childExpr1.set(1, con1);
        en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
        childExpr2.set(0, en);
        childExpr2.set(1, en1);
        en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)0L, (long)splits.length);
        con = new ExprNodeConstantDesc((Object)2);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        con1 = new ExprNodeConstantDesc((Object)1.0);
        childExpr1.set(1, con1);
        en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
        childExpr2.set(0, en);
        childExpr2.set(1, en1);
        en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        udf = new GenericUDFOPEqual();
        con = new ExprNodeConstantDesc((Object)13);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        con1 = new ExprNodeConstantDesc((Object)80.0);
        childExpr1.set(1, con1);
        en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
        childExpr2.set(0, en);
        childExpr2.set(1, en1);
        en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)2L, (long)splits.length);
        udf = new GenericUDFOPEqual();
        con = new ExprNodeConstantDesc((Object)13);
        childExpr.set(1, con);
        en = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr);
        udf1 = new GenericUDFOPEqual();
        con1 = new ExprNodeConstantDesc((Object)80.0);
        childExpr1.set(1, con1);
        en1 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf1, (List)childExpr1);
        childExpr2.set(0, en);
        childExpr2.set(1, en1);
        en2 = new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf2, (List)childExpr2);
        sargStr = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)en2);
        this.conf.set("hive.io.filter.expr.serialized", sargStr);
        splits = in.getSplits(this.conf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
    }

    @Ignore(value="External cache has been turned off for now")
    @Test
    public void testExternalFooterCache() throws Exception {
        this.testFooterExternalCacheImpl(false);
    }

    @Ignore(value="External cache has been turned off for now")
    @Test
    public void testExternalFooterCachePpd() throws Exception {
        this.testFooterExternalCacheImpl(true);
    }

    private void testFooterExternalCacheImpl(boolean isPpd) throws IOException {
        ObjectInspector inspector = this.createIO();
        this.writeFile(inspector, this.testFilePath);
        this.writeFile(inspector, this.testFilePath2);
        GenericUDFOPEqualOrLessThan udf = new GenericUDFOPEqualOrLessThan();
        ArrayList childExpr = Lists.newArrayList();
        this.createTestSarg(inspector, (GenericUDF)udf, childExpr);
        this.setupExternalCacheConfig(isPpd, this.testFilePath + "," + this.testFilePath2);
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_ENABLED.varname, false);
        OrcInputFormatForTest.clearLocalCache();
        OrcInputFormat in0 = new OrcInputFormat();
        InputSplit[] originals = in0.getSplits(this.conf, -1);
        Assert.assertEquals((long)10L, (long)originals.length);
        HashSet<FsWithHash> originalHs = new HashSet<FsWithHash>();
        for (InputSplit original : originals) {
            originalHs.add(new FsWithHash((FileSplit)original));
        }
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_ENABLED.varname, true);
        OrcInputFormatForTest in = new OrcInputFormatForTest();
        OrcInputFormatForTest.clearLocalCache();
        OrcInputFormatForTest.caches.resetCounts();
        OrcInputFormatForTest.caches.cache.clear();
        InputSplit[] splits = in.getSplits(this.conf, -1);
        AtomicInteger[] atomicIntegerArray = new AtomicInteger[5];
        atomicIntegerArray[0] = OrcInputFormatForTest.caches.putCount;
        AtomicInteger atomicInteger = isPpd ? OrcInputFormatForTest.caches.getByExprCount : (atomicIntegerArray[1] = OrcInputFormatForTest.caches.getCount);
        AtomicInteger atomicInteger2 = isPpd ? OrcInputFormatForTest.caches.getHitByExprCount : (atomicIntegerArray[2] = OrcInputFormatForTest.caches.getHitCount);
        AtomicInteger atomicInteger3 = isPpd ? OrcInputFormatForTest.caches.getCount : (atomicIntegerArray[3] = OrcInputFormatForTest.caches.getByExprCount);
        atomicIntegerArray[4] = isPpd ? OrcInputFormatForTest.caches.getHitCount : OrcInputFormatForTest.caches.getHitByExprCount;
        AtomicInteger[] counts = atomicIntegerArray;
        this.verifySplits(originalHs, splits);
        this.verifyCallCounts(counts, 2, 2, 0);
        Assert.assertEquals((long)2L, (long)OrcInputFormatForTest.caches.cache.size());
        OrcInputFormatForTest.clearLocalCache();
        OrcInputFormatForTest.caches.resetCounts();
        splits = in.getSplits(this.conf, -1);
        this.verifySplits(originalHs, splits);
        this.verifyCallCounts(counts, 0, 2, 2);
        OrcInputFormatForTest.clearLocalCache();
        OrcInputFormatForTest.caches.resetCounts();
        childExpr.set(1, new ExprNodeConstantDesc((Object)5));
        this.conf.set("hive.io.filter.expr.serialized", SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)new ExprNodeGenericFuncDesc(inspector, (GenericUDF)udf, (List)childExpr)));
        splits = in.getSplits(this.conf, -1);
        InputSplit[] filtered = new InputSplit[]{originals[0], originals[4], originals[5], originals[9]};
        originalHs = new HashSet();
        for (InputSplit original : filtered) {
            originalHs.add(new FsWithHash((FileSplit)original));
        }
        this.verifySplits(originalHs, splits);
        this.verifyCallCounts(counts, 0, 2, 2);
        OrcInputFormatForTest.clearLocalCache();
        OrcInputFormatForTest.caches.resetCounts();
        Map.Entry e = OrcInputFormatForTest.caches.cache.entrySet().iterator().next();
        Long key = (Long)e.getKey();
        byte[] someData = new byte[8];
        ByteBuffer toCorrupt = ((MockExternalCaches.MockItem)e.getValue()).data;
        System.arraycopy(toCorrupt.array(), toCorrupt.arrayOffset(), someData, 0, someData.length);
        toCorrupt.putLong(0, 0L);
        splits = in.getSplits(this.conf, -1);
        this.verifySplits(originalHs, splits);
        if (!isPpd) {
            ByteBuffer restored = ((MockExternalCaches.MockItem)((MockExternalCaches)OrcInputFormatForTest.caches).cache.get((Object)key)).data;
            byte[] newData = new byte[someData.length];
            System.arraycopy(restored.array(), restored.arrayOffset(), newData, 0, newData.length);
            Assert.assertArrayEquals((byte[])someData, (byte[])newData);
        }
    }

    private void verifyCallCounts(AtomicInteger[] counts, int puts, int gets, int hits) {
        Assert.assertEquals((String)"puts", (long)puts, (long)counts[0].get());
        Assert.assertEquals((String)"gets", (long)gets, (long)counts[1].get());
        Assert.assertEquals((String)"hits", (long)hits, (long)counts[2].get());
        Assert.assertEquals((String)"unused1", (long)0L, (long)counts[3].get());
        Assert.assertEquals((String)"unused2", (long)0L, (long)counts[4].get());
    }

    private void verifySplits(HashSet<FsWithHash> originalHs, InputSplit[] splits) {
        if (originalHs.size() != splits.length) {
            String s = "Expected [";
            for (FsWithHash fwh : originalHs) {
                s = s + TestOrcSplitElimination.toString(fwh.fs) + ", ";
            }
            s = s + "], actual [";
            for (InputSplit fs : splits) {
                s = s + TestOrcSplitElimination.toString((FileSplit)fs) + ", ";
            }
            Assert.fail((String)(s + "]"));
        }
        for (int i = 0; i < splits.length; ++i) {
            FileSplit fs = (FileSplit)splits[i];
            if (originalHs.contains(new FsWithHash((FileSplit)splits[i]))) continue;
            String s = " in [";
            for (FsWithHash fwh : originalHs) {
                s = s + TestOrcSplitElimination.toString(fwh.fs) + ", ";
            }
            Assert.fail((String)("Cannot find " + TestOrcSplitElimination.toString(fs) + s));
        }
    }

    private static String toString(FileSplit fs) {
        return "{" + fs.getPath() + ", " + fs.getStart() + ", " + fs.getLength() + "}";
    }

    private void setupExternalCacheConfig(boolean isPpd, String paths) {
        FileInputFormat.setInputPaths((JobConf)this.conf, (String)paths);
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "ETL");
        this.conf.setLong(HiveConf.ConfVars.MAPREDMINSPLITSIZE.varname, 1000L);
        this.conf.setLong(HiveConf.ConfVars.MAPREDMAXSPLITSIZE.varname, 5000L);
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_PPD.varname, isPpd);
        this.conf.setBoolean(HiveConf.ConfVars.HIVEOPTINDEXFILTER.varname, isPpd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectInspector createIO() {
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ObjectInspectorFactory.getReflectionObjectInspector(AllTypesRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        }
    }

    private void writeFile(ObjectInspector inspector, Path filePath) throws IOException {
        Writer writer = OrcFile.createWriter((FileSystem)this.fs, (Path)filePath, (Configuration)this.conf, (ObjectInspector)inspector, (long)100000L, (CompressionKind)CompressionKind.NONE, (int)10000, (int)10000);
        this.writeData(writer);
        writer.close();
    }

    private void createTestSarg(ObjectInspector inspector, GenericUDF udf, List<ExprNodeDesc> childExpr) {
        childExpr.add((ExprNodeDesc)new ExprNodeColumnDesc(Long.class, "userid", "T", false));
        childExpr.add((ExprNodeDesc)new ExprNodeConstantDesc((Object)100));
        this.conf.set("hive.io.filter.expr.serialized", SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)new ExprNodeGenericFuncDesc(inspector, udf, childExpr)));
    }

    private void writeData(Writer writer) throws IOException {
        for (int i = 0; i < 25000; ++i) {
            if (i == 0) {
                writer.addRow((Object)new AllTypesRow(2L, "foo", 0.8, HiveDecimal.create((String)"1.2"), new Timestamp(0L)));
                continue;
            }
            if (i == 5000) {
                writer.addRow((Object)new AllTypesRow(13L, "bar", 80.0, HiveDecimal.create((String)"2.2"), new Timestamp(5000L)));
                continue;
            }
            if (i == 10000) {
                writer.addRow((Object)new AllTypesRow(29L, "cat", 8.0, HiveDecimal.create((String)"3.3"), new Timestamp(10000L)));
                continue;
            }
            if (i == 15000) {
                writer.addRow((Object)new AllTypesRow(70L, "dog", 1.8, HiveDecimal.create((String)"4.4"), new Timestamp(15000L)));
                continue;
            }
            if (i == 20000) {
                writer.addRow((Object)new AllTypesRow(5L, "eat", 0.8, HiveDecimal.create((String)"5.5"), new Timestamp(20000L)));
                continue;
            }
            writer.addRow((Object)new AllTypesRow(100L, "zebra", 8.0, HiveDecimal.create((String)"0.0"), new Timestamp(250000L)));
        }
    }

    private static final class FsWithHash {
        private FileSplit fs;

        public FsWithHash(FileSplit fs) {
            this.fs = fs;
        }

        public int hashCode() {
            if (this.fs == null) {
                return 0;
            }
            int prime = 31;
            int result = 31 + this.fs.getPath().hashCode();
            result = 31 * result + Long.valueOf(this.fs.getStart()).hashCode();
            return 31 * result + Long.valueOf(this.fs.getLength()).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FsWithHash)) {
                return false;
            }
            FsWithHash other = (FsWithHash)obj;
            if (this.fs == null != (other.fs == null)) {
                return false;
            }
            if (this.fs == null && other.fs == null) {
                return true;
            }
            return this.fs.getStart() == other.fs.getStart() && this.fs.getLength() == other.fs.getLength() && this.fs.getPath().equals((Object)other.fs.getPath());
        }
    }

    private static class MockExternalCaches
    implements ExternalCache.ExternalFooterCachesByConf,
    ExternalCache.ExternalFooterCachesByConf.Cache,
    MetadataStore {
        private final Map<Long, MockItem> cache = new ConcurrentHashMap<Long, MockItem>();
        private final OrcFileMetadataHandler handler = new OrcFileMetadataHandler();
        private final AtomicInteger putCount = new AtomicInteger(0);
        private final AtomicInteger getCount = new AtomicInteger(0);
        private final AtomicInteger getHitCount = new AtomicInteger(0);
        private final AtomicInteger getByExprCount = new AtomicInteger(0);
        private final AtomicInteger getHitByExprCount = new AtomicInteger();

        private MockExternalCaches() {
        }

        public void resetCounts() {
            this.getByExprCount.set(0);
            this.getCount.set(0);
            this.putCount.set(0);
            this.getHitCount.set(0);
            this.getHitByExprCount.set(0);
        }

        public ExternalCache.ExternalFooterCachesByConf.Cache getCache(HiveConf conf) throws IOException {
            this.handler.configure((Configuration)conf, (PartitionExpressionProxy)new PartitionExpressionForMetastore(), (MetadataStore)this);
            return this;
        }

        public Iterator<Map.Entry<Long, MetadataPpdResult>> getFileMetadataByExpr(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws HiveException {
            this.getByExprCount.incrementAndGet();
            ByteBuffer[] metadatas = new ByteBuffer[fileIds.size()];
            ByteBuffer[] ppdResults = new ByteBuffer[fileIds.size()];
            boolean[] eliminated = new boolean[fileIds.size()];
            try {
                byte[] bb = new byte[sarg.remaining()];
                System.arraycopy(sarg.array(), sarg.arrayOffset(), bb, 0, sarg.remaining());
                this.handler.getFileMetadataByExpr(fileIds, bb, metadatas, ppdResults, eliminated);
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
            HashMap<Long, MetadataPpdResult> result = new HashMap<Long, MetadataPpdResult>();
            for (int i = 0; i < metadatas.length; ++i) {
                long fileId = fileIds.get(i);
                ByteBuffer metadata = metadatas[i];
                if (metadata == null) continue;
                this.getHitByExprCount.incrementAndGet();
                metadata = eliminated[i] ? null : metadata;
                MetadataPpdResult mpr = new MetadataPpdResult();
                ByteBuffer bitset = eliminated[i] ? null : ppdResults[i];
                mpr.setMetadata(doGetFooters ? metadata : null);
                mpr.setIncludeBitset(bitset);
                result.put(fileId, mpr);
            }
            return result.entrySet().iterator();
        }

        public void clearFileMetadata(List<Long> fileIds) throws HiveException {
            for (Long id : fileIds) {
                this.cache.remove(id);
            }
        }

        public Iterator<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws HiveException {
            this.getCount.incrementAndGet();
            HashMap<Long, ByteBuffer> result = new HashMap<Long, ByteBuffer>();
            for (Long id : fileIds) {
                MockItem mi = this.cache.get(id);
                if (mi == null) continue;
                this.getHitCount.incrementAndGet();
                result.put(id, mi.data);
            }
            return result.entrySet().iterator();
        }

        public void putFileMetadata(ArrayList<Long> fileIds, ArrayList<ByteBuffer> values) throws HiveException {
            this.putCount.incrementAndGet();
            ByteBuffer[] addedCols = this.handler.createAddedCols();
            ByteBuffer[][] addedVals = null;
            if (addedCols != null) {
                addedVals = this.handler.createAddedColVals(values);
            }
            try {
                this.storeFileMetadata(fileIds, values, addedCols, addedVals);
            }
            catch (IOException | InterruptedException e) {
                throw new HiveException((Throwable)e);
            }
        }

        public void getFileMetadata(List<Long> fileIds, ByteBuffer[] result) throws IOException {
            for (int i = 0; i < fileIds.size(); ++i) {
                MockItem mi = this.cache.get(fileIds.get(i));
                result[i] = mi == null ? null : mi.data;
            }
        }

        public void storeFileMetadata(List<Long> fileIds, List<ByteBuffer> metadataBuffers, ByteBuffer[] addedCols, ByteBuffer[][] addedVals) throws IOException, InterruptedException {
            for (int i = 0; i < fileIds.size(); ++i) {
                ByteBuffer value = metadataBuffers != null ? metadataBuffers.get(i) : null;
                ByteBuffer[] av = addedVals == null ? null : addedVals[i];
                this.storeFileMetadata(fileIds.get(i), value, addedCols, av);
            }
        }

        public void storeFileMetadata(long fileId, ByteBuffer metadata, ByteBuffer[] addedCols, ByteBuffer[] addedVals) throws IOException, InterruptedException {
            if (metadata == null) {
                this.cache.remove(metadata);
                return;
            }
            MockItem mi = new MockItem();
            mi.data = metadata;
            if (addedVals != null) {
                mi.extraCols = addedCols;
                mi.extraData = addedVals;
            }
            this.cache.put(fileId, mi);
        }

        private static class MockItem {
            ByteBuffer data;
            ByteBuffer[] extraCols;
            ByteBuffer[] extraData;

            private MockItem() {
            }

            public String toString() {
                return (this.data == null ? 0 : this.data.remaining()) + " bytes" + (this.extraCols == null ? "" : "; " + this.extraCols.length + " extras");
            }
        }
    }

    private static class OrcInputFormatForTest
    extends OrcInputFormat {
        static MockExternalCaches caches = new MockExternalCaches();

        private OrcInputFormatForTest() {
        }

        public static void clearLocalCache() {
            OrcInputFormat.Context.clearLocalCache();
        }

        protected ExternalCache.ExternalFooterCachesByConf createExternalCaches() {
            return caches;
        }
    }

    public static class AllTypesRow {
        Long userid;
        Text string1;
        Double subtype;
        HiveDecimal decimal1;
        Timestamp ts;

        AllTypesRow(Long uid, String s1, Double d1, HiveDecimal decimal, Timestamp ts) {
            this.userid = uid;
            this.string1 = new Text(s1);
            this.subtype = d1;
            this.decimal1 = decimal;
            this.ts = ts;
        }
    }
}

