/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedParquetRecordReader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;

public class VectorizedColumnReaderTestBase {
    protected static final int nElements = 2500;
    protected static final int UNIQUE_NUM = 10;
    protected static final int NULL_FREQUENCY = 13;
    protected static final Configuration conf = new Configuration();
    protected static final Path file = new Path("target/test/TestParquetVectorReader/testParquetFile");
    protected static final MessageType schema = MessageTypeParser.parseMessageType((String)"message hive_schema { required int32 int32_field; required int64 int64_field; required int96 int96_field; required int32 date_field; required double double_field; required float float_field; required boolean boolean_field; required fixed_len_byte_array(3) flba_field; optional fixed_len_byte_array(1) some_null_field; optional fixed_len_byte_array(1) all_null_field; required binary binary_field; optional binary binary_field_some_null; required binary value (DECIMAL(5,2)); required group struct_field {  required int32 a;\n  required double b;\n}\noptional group nested_struct_field {  optional group nsf {    optional int32 c;\n    optional int32 d;\n  }\n  optional double e;\n}\noptional group struct_field_some_null {  optional int32 f;\n  optional double g;\n}\noptional group map_field (MAP) {\n  repeated group map (MAP_KEY_VALUE) {\n    required binary key;\n    optional binary value;\n  }\n}\noptional group array_list (LIST) {\n  repeated group bag {\n    optional int32 array_element;\n  }\n}\n} ");

    protected static void removeFile() throws IOException {
        FileSystem fs = file.getFileSystem(conf);
        if (fs.exists(file)) {
            fs.delete(file, true);
        }
    }

    protected static ParquetWriter<Group> initWriterFromFile() throws IOException {
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        return new ParquetWriter(file, (WriteSupport)new GroupWriteSupport(), CompressionCodecName.GZIP, 0x100000, 1024, 0x100000, true, false, ParquetProperties.WriterVersion.PARQUET_1_0, conf);
    }

    protected static int getIntValue(boolean isDictionaryEncoding, int index) {
        return isDictionaryEncoding ? index % 10 : index;
    }

    protected static double getDoubleValue(boolean isDictionaryEncoding, int index) {
        return isDictionaryEncoding ? (double)(index % 10) : (double)index;
    }

    protected static long getLongValue(boolean isDictionaryEncoding, int index) {
        return isDictionaryEncoding ? 2L * (long)index % 10L : 2L * (long)index;
    }

    protected static float getFloatValue(boolean isDictionaryEncoding, int index) {
        return (float)(isDictionaryEncoding ? (double)(index % 10) * 2.0 : (double)index * 2.0);
    }

    protected static boolean getBooleanValue(float index) {
        return index % 2.0f == 0.0f;
    }

    protected static String getTimestampStr(int index) {
        String s = String.valueOf(index);
        int l = 4 - s.length();
        for (int i = 0; i < l; ++i) {
            s = "0" + s;
        }
        return "99999999" + s;
    }

    protected static HiveDecimal getDecimal(boolean isDictionaryEncoding, int index) {
        int decimalVal = index % 100;
        String decimalStr = decimalVal < 10 ? "0" + String.valueOf(decimalVal) : String.valueOf(decimalVal);
        int intVal = isDictionaryEncoding ? index % 10 : index / 100;
        String d = String.valueOf(intVal) + decimalStr;
        BigInteger bi = new BigInteger(d);
        BigDecimal bd = new BigDecimal(bi);
        return HiveDecimal.create((BigDecimal)bd);
    }

    protected static Binary getTimestamp(boolean isDictionaryEncoding, int index) {
        String s = isDictionaryEncoding ? VectorizedColumnReaderTestBase.getTimestampStr(index % 10) : VectorizedColumnReaderTestBase.getTimestampStr(index);
        return Binary.fromReusedByteArray((byte[])s.getBytes());
    }

    protected static String getStr(boolean isDictionaryEncoding, int index) {
        String v = "";
        for (int binaryLen = isDictionaryEncoding ? index % 10 : index; binaryLen > 0; binaryLen /= 26) {
            char t = (char)(97 + binaryLen % 26);
            v = t + v;
        }
        return v;
    }

    protected static Binary getBinaryValue(boolean isDictionaryEncoding, int index) {
        return Binary.fromString((String)VectorizedColumnReaderTestBase.getStr(isDictionaryEncoding, index));
    }

    protected static boolean isNull(int index) {
        return index % 13 == 0;
    }

    protected VectorizedParquetRecordReader createParquetReader(String schemaString, Configuration conf) throws IOException, InterruptedException, HiveException {
        conf.set("parquet.read.schema", schemaString);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)true);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN, (String)"//tmp");
        Job vectorJob = new Job(conf, "read vector");
        ParquetInputFormat.setInputPaths((Job)vectorJob, (Path[])new Path[]{file});
        ParquetInputFormat parquetInputFormat = new ParquetInputFormat(GroupReadSupport.class);
        InputSplit split = (InputSplit)parquetInputFormat.getSplits((JobContext)vectorJob).get(0);
        this.initialVectorizedRowBatchCtx(conf);
        return new VectorizedParquetRecordReader(split, new JobConf(conf));
    }

    protected static void writeData(ParquetWriter<Group> writer, boolean isDictionaryEncoding) throws IOException {
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        for (int i = 0; i < 2500; ++i) {
            boolean isNull = VectorizedColumnReaderTestBase.isNull(i);
            int intVal = VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, i);
            long longVal = VectorizedColumnReaderTestBase.getLongValue(isDictionaryEncoding, i);
            Binary timeStamp = VectorizedColumnReaderTestBase.getTimestamp(isDictionaryEncoding, i);
            HiveDecimal decimalVal = VectorizedColumnReaderTestBase.getDecimal(isDictionaryEncoding, i).setScale(2);
            double doubleVal = VectorizedColumnReaderTestBase.getDoubleValue(isDictionaryEncoding, i);
            float floatVal = VectorizedColumnReaderTestBase.getFloatValue(isDictionaryEncoding, i);
            boolean booleanVal = VectorizedColumnReaderTestBase.getBooleanValue(i);
            Binary binary = VectorizedColumnReaderTestBase.getBinaryValue(isDictionaryEncoding, i);
            Group group = f.newGroup().append("int32_field", intVal).append("int64_field", longVal).append("int96_field", timeStamp).append("double_field", doubleVal).append("float_field", floatVal).append("boolean_field", booleanVal).append("flba_field", "abc").append("date_field", intVal);
            if (!isNull) {
                group.append("some_null_field", "x");
            }
            group.append("binary_field", binary);
            if (!isNull) {
                group.append("binary_field_some_null", binary);
            }
            HiveDecimalWritable w = new HiveDecimalWritable(decimalVal);
            group.append("value", Binary.fromConstantByteArray((byte[])w.getInternalStorage()));
            group.addGroup("struct_field").append("a", intVal).append("b", doubleVal);
            Group g = group.addGroup("nested_struct_field");
            g.addGroup("nsf").append("c", intVal).append("d", intVal);
            g.append("e", doubleVal);
            Group some_null_g = group.addGroup("struct_field_some_null");
            if (i % 2 != 0) {
                some_null_g.append("f", intVal);
            }
            if (i % 3 != 0) {
                some_null_g.append("g", doubleVal);
            }
            Group mapGroup = group.addGroup("map_field");
            if (i % 13 != 1) {
                mapGroup.addGroup("map").append("key", binary).append("value", "abc");
            } else {
                mapGroup.addGroup("map").append("key", binary);
            }
            Group arrayGroup = group.addGroup("array_list");
            for (int j = 0; j < i % 4; ++j) {
                arrayGroup.addGroup("bag").append("array_element", intVal);
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    protected void initialVectorizedRowBatchCtx(Configuration conf) throws HiveException {
        MapWork mapWork = new MapWork();
        VectorizedRowBatchCtx rbCtx = new VectorizedRowBatchCtx();
        rbCtx.init(this.createStructObjectInspector(conf), new String[0]);
        mapWork.setVectorMode(true);
        mapWork.setVectorizedRowBatchCtx(rbCtx);
        Utilities.setMapWork((Configuration)conf, (MapWork)mapWork);
    }

    private StructObjectInspector createStructObjectInspector(Configuration conf) {
        String columnNames = conf.get("columns");
        List columnNamesList = DataWritableReadSupport.getColumnNames((String)columnNames);
        String columnTypes = conf.get("columns.types");
        List columnTypesList = DataWritableReadSupport.getColumnTypes((String)columnTypes);
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo((List)columnNamesList, (List)columnTypesList);
        return new ArrayWritableObjectInspector((StructTypeInfo)rowTypeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void intRead(boolean isDictionaryEncoding) throws InterruptedException, HiveException, IOException {
        Configuration conf = new Configuration();
        conf.set("columns", "int32_field");
        conf.set("columns.types", "int");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required int32 int32_field;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                LongColumnVector vector = (LongColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Failed at " + c), (long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)vector.vector[i]);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void longRead(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "int64_field");
        conf.set("columns.types", "bigint");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required int64 int64_field;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                LongColumnVector vector = (LongColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Failed at " + c), (long)VectorizedColumnReaderTestBase.getLongValue(isDictionaryEncoding, c), (long)vector.vector[i]);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dateRead(boolean isDictionaryEncoding) throws InterruptedException, HiveException, IOException {
        Configuration conf = new Configuration();
        conf.set("columns", "date_field");
        conf.set("columns.types", "date");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required int date_field;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                LongColumnVector vector = (LongColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Failed at " + c), (long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)vector.vector[i]);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doubleRead(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "double_field");
        conf.set("columns.types", "double");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required double double_field;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                DoubleColumnVector vector = (DoubleColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Failed at " + c), (double)VectorizedColumnReaderTestBase.getDoubleValue(isDictionaryEncoding, c), (double)vector.vector[i], (double)0.0);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void floatRead(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "float_field");
        conf.set("columns.types", "float");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required float float_field;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                DoubleColumnVector vector = (DoubleColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Failed at " + c), (double)VectorizedColumnReaderTestBase.getFloatValue(isDictionaryEncoding, c), (double)vector.vector[i], (double)0.0);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void booleanRead() throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "boolean_field");
        conf.set("columns.types", "boolean");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required boolean boolean_field;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                LongColumnVector vector = (LongColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Failed at " + c), (long)(VectorizedColumnReaderTestBase.getBooleanValue(c) ? 1 : 0), (long)vector.vector[i]);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void binaryRead(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "binary_field_some_null");
        conf.set("columns.types", "string");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message test { required binary binary_field_some_null;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        int c = 0;
        try {
            while (reader.next(NullWritable.get(), previous)) {
                BytesColumnVector vector = (BytesColumnVector)previous.cols[0];
                boolean noNull = true;
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Null assert failed at " + c), (Object)VectorizedColumnReaderTestBase.isNull(c), (Object)vector.isNull[i]);
                    if (!vector.isNull[i]) {
                        String actual = new String(ArrayUtils.subarray((byte[])vector.vector[i], (int)vector.start[i], (int)(vector.start[i] + vector.length[i])));
                        Assert.assertEquals((String)("failed at " + c), (Object)VectorizedColumnReaderTestBase.getStr(isDictionaryEncoding, c), (Object)actual);
                        continue;
                    }
                    noNull = false;
                }
                Assert.assertEquals((String)("No Null check failed at " + c), (Object)noNull, (Object)vector.noNulls);
                TestCase.assertFalse((boolean)vector.isRepeating);
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void structRead(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "struct_field");
        conf.set("columns.types", "struct<a:int,b:double>");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        String schema = "message hive_schema {\ngroup struct_field {\n  optional int32 a;\n  optional double b;\n}\n}\n";
        VectorizedParquetRecordReader reader = this.createParquetReader(schema, conf);
        VectorizedRowBatch previous = reader.createValue();
        int c = 0;
        try {
            while (reader.next(NullWritable.get(), previous)) {
                StructColumnVector vector = (StructColumnVector)previous.cols[0];
                LongColumnVector cv = (LongColumnVector)vector.fields[0];
                DoubleColumnVector dv = (DoubleColumnVector)vector.fields[1];
                for (int i = 0; i < cv.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)cv.vector[i]);
                    Assert.assertEquals((double)VectorizedColumnReaderTestBase.getDoubleValue(isDictionaryEncoding, c), (double)dv.vector[i], (double)0.0);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                    TestCase.assertFalse((boolean)vector.isRepeating);
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nestedStructRead0(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "nested_struct_field");
        conf.set("columns.types", "struct<nsf:struct<c:int,d:int>,e:double>");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        String schema = "message hive_schema {\ngroup nested_struct_field {\n  optional group nsf {\n    optional int32 c;\n    optional int32 d;\n  }optional double e;\n}\n";
        VectorizedParquetRecordReader reader = this.createParquetReader(schema, conf);
        VectorizedRowBatch previous = reader.createValue();
        int c = 0;
        try {
            while (reader.next(NullWritable.get(), previous)) {
                StructColumnVector vector = (StructColumnVector)previous.cols[0];
                StructColumnVector sv = (StructColumnVector)vector.fields[0];
                LongColumnVector cv = (LongColumnVector)sv.fields[0];
                LongColumnVector dv = (LongColumnVector)sv.fields[1];
                DoubleColumnVector ev = (DoubleColumnVector)vector.fields[1];
                for (int i = 0; i < cv.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)cv.vector[i]);
                    Assert.assertEquals((long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)dv.vector[i]);
                    Assert.assertEquals((double)VectorizedColumnReaderTestBase.getDoubleValue(isDictionaryEncoding, c), (double)ev.vector[i], (double)0.0);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                    TestCase.assertFalse((boolean)vector.isRepeating);
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nestedStructRead1(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "nested_struct_field");
        conf.set("columns.types", "struct<nsf:struct<c:int>>");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        String schema = "message hive_schema {\ngroup nested_struct_field {\n  optional group nsf {\n    optional int32 c;\n  }}\n";
        VectorizedParquetRecordReader reader = this.createParquetReader(schema, conf);
        VectorizedRowBatch previous = reader.createValue();
        int c = 0;
        try {
            while (reader.next(NullWritable.get(), previous)) {
                StructColumnVector vector = (StructColumnVector)previous.cols[0];
                StructColumnVector sv = (StructColumnVector)vector.fields[0];
                LongColumnVector cv = (LongColumnVector)sv.fields[0];
                for (int i = 0; i < cv.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)cv.vector[i]);
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                    TestCase.assertFalse((boolean)vector.isRepeating);
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void structReadSomeNull(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "struct_field_some_null");
        conf.set("columns.types", "struct<f:int,g:double>");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        String schema = "message hive_schema {\ngroup struct_field_some_null {\n  optional int32 f;\n  optional double g;\n}\n";
        VectorizedParquetRecordReader reader = this.createParquetReader(schema, conf);
        VectorizedRowBatch previous = reader.createValue();
        int c = 0;
        try {
            while (reader.next(NullWritable.get(), previous)) {
                StructColumnVector sv = (StructColumnVector)previous.cols[0];
                LongColumnVector fv = (LongColumnVector)sv.fields[0];
                DoubleColumnVector gv = (DoubleColumnVector)sv.fields[1];
                for (int i = 0; i < fv.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((Object)(c % 2 == 0 ? 1 : 0), (Object)fv.isNull[i]);
                    Assert.assertEquals((Object)(c % 3 == 0 ? 1 : 0), (Object)gv.isNull[i]);
                    Assert.assertEquals((Object)(c % 6 == 0 ? 1 : 0), (Object)sv.isNull[i]);
                    if (!sv.isNull[i]) {
                        if (!fv.isNull[i]) {
                            Assert.assertEquals((long)VectorizedColumnReaderTestBase.getIntValue(isDictionaryEncoding, c), (long)fv.vector[i]);
                        }
                        if (!gv.isNull[i]) {
                            Assert.assertEquals((double)VectorizedColumnReaderTestBase.getDoubleValue(isDictionaryEncoding, c), (double)gv.vector[i], (double)0.0);
                        }
                    }
                    TestCase.assertFalse((boolean)fv.isRepeating);
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decimalRead(boolean isDictionaryEncoding) throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "value");
        conf.set("columns.types", "decimal(5,2)");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = this.createParquetReader("message hive_schema { required value (DECIMAL(5,2));}", conf);
        VectorizedRowBatch previous = reader.createValue();
        try {
            int c = 0;
            while (reader.next(NullWritable.get(), previous)) {
                DecimalColumnVector vector = (DecimalColumnVector)previous.cols[0];
                junit.framework.Assert.assertTrue((boolean)vector.noNulls);
                for (int i = 0; i < vector.vector.length && c != 2500; ++c, ++i) {
                    Assert.assertEquals((String)("Check failed at pos " + c), (Object)VectorizedColumnReaderTestBase.getDecimal(isDictionaryEncoding, c), (Object)vector.vector[i].getHiveDecimal());
                    TestCase.assertFalse((boolean)vector.isNull[i]);
                }
            }
            Assert.assertEquals((long)2500L, (long)c);
        }
        finally {
            reader.close();
        }
    }
}

