/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.orc.TestInputOutputFormat;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.junit.Test;

public class TestSearchArgumentImpl {
    private ExpressionTree not(ExpressionTree arg) {
        return new ExpressionTree(ExpressionTree.Operator.NOT, new ExpressionTree[]{arg});
    }

    private ExpressionTree and(ExpressionTree ... arg) {
        return new ExpressionTree(ExpressionTree.Operator.AND, arg);
    }

    private ExpressionTree or(ExpressionTree ... arg) {
        return new ExpressionTree(ExpressionTree.Operator.OR, arg);
    }

    private ExpressionTree leaf(int leaf) {
        return new ExpressionTree(leaf);
    }

    private ExpressionTree constant(SearchArgument.TruthValue val) {
        return new ExpressionTree(val);
    }

    public static PredicateLeaf createPredicateLeaf(PredicateLeaf.Operator operator, PredicateLeaf.Type type, String columnName, Object literal, List<Object> literalList) {
        return new SearchArgumentImpl.PredicateLeafImpl(operator, type, columnName, literal, literalList, null);
    }

    @Test
    public void testNotPushdown() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.leaf(1)).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.leaf(1))).toString());
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.not(this.leaf(1)))).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.not(this.not(this.leaf(1))))).toString());
        Assert.assertEquals((String)"(or leaf-1 (not leaf-2))", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.and(this.not(this.leaf(1)), this.leaf(2)))).toString());
        Assert.assertEquals((String)"(and (not leaf-1) leaf-2)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.or(this.leaf(1), this.not(this.leaf(2))))).toString());
        Assert.assertEquals((String)"(or (or (not leaf-1) leaf-2) leaf-3)", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.or(this.not(this.and(this.leaf(1), this.not(this.leaf(2)))), this.not(this.not(this.leaf(3))))).toString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES))).toString());
        Assert.assertEquals((String)"YES", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NO))).toString());
        Assert.assertEquals((String)"NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NULL))).toString());
        Assert.assertEquals((String)"YES_NO", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NO))).toString());
        Assert.assertEquals((String)"YES_NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.NO_NULL))).toString());
        Assert.assertEquals((String)"NO_NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NULL))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.pushDownNot((ExpressionTree)this.not(this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
    }

    @Test
    public void testFlatten() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.leaf(1)).toString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.constant(SearchArgument.TruthValue.NO)).toString());
        Assert.assertEquals((String)"(not (not leaf-1))", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.not(this.not(this.leaf(1)))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.leaf(1), this.leaf(2))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-2) leaf-3)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.or(this.leaf(1), this.leaf(2)), this.leaf(3))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.and(this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4)))).toString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.or(this.leaf(1), this.or(this.leaf(2), this.or(this.leaf(3), this.leaf(4))))).toString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.or(this.or(this.or(this.leaf(1), this.leaf(2)), this.leaf(3)), this.leaf(4))).toString());
        Assert.assertEquals((String)"(or leaf-1 leaf-2 leaf-3 leaf-4 leaf-5 leaf-6)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.or(this.or(this.leaf(1), this.or(this.leaf(2), this.leaf(3))), this.or(this.or(this.leaf(4), this.leaf(5)), this.leaf(6)))).toString());
        Assert.assertEquals((String)"(and (not leaf-1) leaf-2 (not leaf-3) leaf-4 (not leaf-5) leaf-6)", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.and(this.and(this.not(this.leaf(1)), this.and(this.leaf(2), this.not(this.leaf(3)))), this.and(this.and(this.leaf(4), this.not(this.leaf(5))), this.leaf(6)))).toString());
        Assert.assertEquals((String)"(not (and leaf-1 leaf-2 leaf-3))", (String)SearchArgumentImpl.BuilderImpl.flatten((ExpressionTree)this.not(this.and(this.leaf(1), this.and(this.leaf(2), this.leaf(3))))).toString());
    }

    @Test
    public void testFoldMaybe() throws Exception {
        Assert.assertEquals((String)"(and leaf-1)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.leaf(2))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.leaf(1), this.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.constant(SearchArgument.TruthValue.YES_NO_NULL), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.or(this.leaf(1), this.constant(SearchArgument.TruthValue.YES_NO_NULL))).toString());
        Assert.assertEquals((String)"(or leaf-1 (and leaf-2))", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.or(this.leaf(1), this.and(this.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL)))).toString());
        Assert.assertEquals((String)"(and leaf-1)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)this.and(this.or(this.leaf(2), this.constant(SearchArgument.TruthValue.YES_NO_NULL)), this.leaf(1))).toString());
        Assert.assertEquals((String)"(and leaf-100)", (String)SearchArgumentImpl.BuilderImpl.foldMaybe((ExpressionTree)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(this.leaf(100), this.or(this.and(this.leaf(0), this.leaf(1)), this.and(this.leaf(2), this.leaf(3)), this.and(this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.and(this.leaf(8), this.leaf(9)), this.and(this.leaf(10), this.leaf(11)), this.and(this.leaf(12), this.leaf(13)), this.and(this.leaf(14), this.leaf(15)), this.and(this.leaf(16), this.leaf(17)))))).toString());
    }

    @Test
    public void testCNF() throws Exception {
        Assert.assertEquals((String)"leaf-1", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.leaf(1)).toString());
        Assert.assertEquals((String)"NO", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.constant(SearchArgument.TruthValue.NO)).toString());
        Assert.assertEquals((String)"(not leaf-1)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.not(this.leaf(1))).toString());
        Assert.assertEquals((String)"(and leaf-1 leaf-2)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(this.leaf(1), this.leaf(2))).toString());
        Assert.assertEquals((String)"(or (not leaf-1) leaf-2)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.not(this.leaf(1)), this.leaf(2))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-2) (not leaf-3))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(this.or(this.leaf(1), this.leaf(2)), this.not(this.leaf(3)))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-3) (or leaf-2 leaf-3) (or leaf-1 leaf-4) (or leaf-2 leaf-4))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4)))).toString());
        Assert.assertEquals((String)"(and (or leaf-1 leaf-5) (or leaf-2 leaf-5) (or leaf-3 leaf-5) (or leaf-4 leaf-5) (or leaf-1 leaf-6) (or leaf-2 leaf-6) (or leaf-3 leaf-6) (or leaf-4 leaf-6))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(this.leaf(1), this.leaf(2), this.leaf(3), this.leaf(4)), this.and(this.leaf(5), this.leaf(6)))).toString());
        Assert.assertEquals((String)"(and (or leaf-5 leaf-6 (not leaf-7) leaf-1 leaf-3) (or leaf-5 leaf-6 (not leaf-7) leaf-2 leaf-3) (or leaf-5 leaf-6 (not leaf-7) leaf-1 leaf-4) (or leaf-5 leaf-6 (not leaf-7) leaf-2 leaf-4))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4)), this.or(this.leaf(5), this.leaf(6)), this.not(this.leaf(7)))).toString());
        Assert.assertEquals((String)"(and (or leaf-8 leaf-0 leaf-3 leaf-6) (or leaf-8 leaf-1 leaf-3 leaf-6) (or leaf-8 leaf-2 leaf-3 leaf-6) (or leaf-8 leaf-0 leaf-4 leaf-6) (or leaf-8 leaf-1 leaf-4 leaf-6) (or leaf-8 leaf-2 leaf-4 leaf-6) (or leaf-8 leaf-0 leaf-5 leaf-6) (or leaf-8 leaf-1 leaf-5 leaf-6) (or leaf-8 leaf-2 leaf-5 leaf-6) (or leaf-8 leaf-0 leaf-3 leaf-7) (or leaf-8 leaf-1 leaf-3 leaf-7) (or leaf-8 leaf-2 leaf-3 leaf-7) (or leaf-8 leaf-0 leaf-4 leaf-7) (or leaf-8 leaf-1 leaf-4 leaf-7) (or leaf-8 leaf-2 leaf-4 leaf-7) (or leaf-8 leaf-0 leaf-5 leaf-7) (or leaf-8 leaf-1 leaf-5 leaf-7) (or leaf-8 leaf-2 leaf-5 leaf-7))", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(this.leaf(0), this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.leaf(8))).toString());
        Assert.assertEquals((String)"YES_NO_NULL", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(this.leaf(0), this.leaf(1)), this.and(this.leaf(2), this.leaf(3)), this.and(this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.and(this.leaf(8), this.leaf(9)), this.and(this.leaf(10), this.leaf(11)), this.and(this.leaf(12), this.leaf(13)), this.and(this.leaf(14), this.leaf(15)), this.and(this.leaf(16), this.leaf(17)))).toString());
        Assert.assertEquals((String)"(and leaf-100 YES_NO_NULL)", (String)SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.and(this.leaf(100), this.or(this.and(this.leaf(0), this.leaf(1)), this.and(this.leaf(2), this.leaf(3)), this.and(this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.and(this.leaf(8), this.leaf(9)), this.and(this.leaf(10), this.leaf(11)), this.and(this.leaf(12), this.leaf(13)), this.and(this.leaf(14), this.leaf(15)), this.and(this.leaf(16), this.leaf(17))))).toString());
        TestSearchArgumentImpl.assertNoSharedNodes(SearchArgumentImpl.BuilderImpl.convertToCNF((ExpressionTree)this.or(this.and(this.leaf(0), this.leaf(1), this.leaf(2)), this.and(this.leaf(3), this.leaf(4), this.leaf(5)), this.and(this.leaf(6), this.leaf(7)), this.leaf(8))), Sets.newIdentityHashSet());
    }

    private static void assertNoSharedNodes(ExpressionTree tree, Set<ExpressionTree> seen) throws Exception {
        if (seen.contains(tree) && tree.getOperator() != ExpressionTree.Operator.LEAF) {
            Assert.assertTrue((String)("repeated node in expression " + tree), (boolean)false);
        }
        seen.add(tree);
        if (tree.getChildren() != null) {
            for (ExpressionTree child : tree.getChildren()) {
                TestSearchArgumentImpl.assertNoSharedNodes(child, seen);
            }
        }
    }

    @Test
    public void testBuilder() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)10L).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)"hi").equals("z", PredicateLeaf.Type.FLOAT, (Object)1.0).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 10), leaf-1 = (LESS_THAN_EQUALS y hi), leaf-2 = (EQUALS z 1.0), expr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toString());
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.LONG, (Object)10L, (Object)20L).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)"stinger").end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x), leaf-1 = (BETWEEN y 10 20), leaf-2 = (IN z 1 2 3), leaf-3 = (NULL_SAFE_EQUALS a stinger), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toString());
    }

    @Test
    public void testBuilderComplexTypes() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("1970-1-11")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 1970-01-11), leaf-1 = (LESS_THAN_EQUALS y hi        ), leaf-2 = (EQUALS z 1), expr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toString());
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x), leaf-1 = (BETWEEN y 10 20), leaf-2 = (IN z 1 2 3), leaf-3 = (NULL_SAFE_EQUALS a stinger), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toString());
    }

    @Test
    public void testBuilderComplexTypes2() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("2005-3-12")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 2005-03-12), leaf-1 = (LESS_THAN_EQUALS y hi        ), leaf-2 = (EQUALS z 1), expr = (and leaf-0 leaf-1 leaf-2)", (String)sarg.toString());
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        Assert.assertEquals((String)"leaf-0 = (IS_NULL x), leaf-1 = (BETWEEN y 10 20), leaf-2 = (IN z 1 2 3), leaf-3 = (NULL_SAFE_EQUALS a stinger), expr = (and (not leaf-0) (not leaf-1) (not leaf-2) (not leaf-3))", (String)sarg.toString());
    }

    @Test
    public void testBuilderFloat() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)22L).lessThan("x1", PredicateLeaf.Type.LONG, (Object)22L).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.FLOAT, (Object)new Double(0.22)).equals("z1", PredicateLeaf.Type.FLOAT, (Object)new Double(0.22)).end().build();
        Assert.assertEquals((String)"leaf-0 = (LESS_THAN x 22), leaf-1 = (LESS_THAN x1 22), leaf-2 = (LESS_THAN_EQUALS y hi        ), leaf-3 = (EQUALS z 0.22), leaf-4 = (EQUALS z1 0.22), expr = (and leaf-0 leaf-1 leaf-2 leaf-3 leaf-4)", (String)sarg.toString());
    }

    @Test
    public void testTimestampSerialization() throws Exception {
        Timestamp now = new Timestamp(new java.util.Date().getTime());
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.TIMESTAMP, (Object)now).end().build();
        String serializedSarg = TestInputOutputFormat.toKryo(sarg);
        SearchArgument sarg2 = ConvertAstToSearchArg.create((String)serializedSarg);
        Field literalField = SearchArgumentImpl.PredicateLeafImpl.class.getDeclaredField("literal");
        literalField.setAccessible(true);
        Assert.assertTrue((boolean)(literalField.get(sarg2.getLeaves().get(0)) instanceof java.util.Date));
        Timestamp ts = (Timestamp)((PredicateLeaf)sarg2.getLeaves().get(0)).getLiteral();
        Assert.assertEquals((Object)ts, (Object)now);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadLiteral() throws Exception {
        SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)"hi").end().build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadLiteralList() throws Exception {
        SearchArgumentFactory.newBuilder().startAnd().in("x", PredicateLeaf.Type.STRING, new Object[]{"hi", 23}).end().build();
    }
}

