/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.junit.Test;

public class TestGenMapRedUtilsUsePartitionColumnsNegative {
    @Test(expected=NullPointerException.class)
    public void testUsePartitionColumnsNoPartColNames() {
        Properties p = new Properties();
        GenMapRedUtils.usePartitionColumns((Properties)p, Arrays.asList("p1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUsePartitionColumnsNamesTypesMismatch() {
        Properties p = new Properties();
        p.setProperty("partition_columns", "p1/p2");
        p.setProperty("partition_columns.types", "t1");
        GenMapRedUtils.usePartitionColumns((Properties)p, Arrays.asList("p1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUsePartitionColumnsNoPartitionsToRetain() {
        Properties p = new Properties();
        p.setProperty("partition_columns", "p1");
        p.setProperty("partition_columns.types", "t1");
        GenMapRedUtils.usePartitionColumns((Properties)p, (List)Collections.EMPTY_LIST);
    }

    @Test(expected=RuntimeException.class)
    public void testUsePartitionColumnsWrongPartColName() {
        Properties p = new Properties();
        p.setProperty("partition_columns", "p1");
        p.setProperty("partition_columns.types", "t1");
        GenMapRedUtils.usePartitionColumns((Properties)p, Arrays.asList("p2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUsePartitionColumnsDuplicatePartColNameInArgument() {
        Properties p = new Properties();
        p.setProperty("partition_columns", "p1/p2");
        p.setProperty("partition_columns.types", "t1:t2");
        GenMapRedUtils.usePartitionColumns((Properties)p, Arrays.asList("p1", "p2", "p1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUsePartitionColumnsDuplicatePartColNameInConfiguration() {
        Properties p = new Properties();
        p.setProperty("partition_columns", "p1/p2/p1");
        p.setProperty("partition_columns.types", "t1:t2:t3");
        GenMapRedUtils.usePartitionColumns((Properties)p, Arrays.asList("p1"));
    }
}

