/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestColumnAccess {
    @BeforeClass
    public static void Setup() throws CommandNeedRetryException {
        Driver driver = TestColumnAccess.createDriver();
        int ret = driver.run("create table t1(id1 int, name1 string)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (int)0, (int)ret);
        ret = driver.run("create table t2(id2 int, id1 int, name2 string)").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (int)0, (int)ret);
        ret = driver.run("create view v1 as select * from t1").getResponseCode();
        Assert.assertEquals((String)"Checking command success", (int)0, (int)ret);
    }

    @AfterClass
    public static void Teardown() throws Exception {
        Driver driver = TestColumnAccess.createDriver();
        driver.run("drop table t1");
        driver.run("drop table t2");
        driver.run("drop view v1");
    }

    @Test
    public void testQueryTable1() throws ParseException {
        String query = "select * from t1";
        Driver driver = TestColumnAccess.createDriver();
        int rc = driver.compile(query);
        Assert.assertEquals((String)"Checking command success", (int)0, (int)rc);
        QueryPlan plan = driver.getPlan();
        ColumnAccessInfo columnAccessInfo = plan.getColumnAccessInfo();
        List<String> cols = (List<String>)columnAccessInfo.getTableToColumnAccessMap().get("default@t1");
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((int)2, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        Map<String, List<String>> tableColsMap = this.getColsFromReadEntity(plan.getInputs());
        cols = tableColsMap.get("default@t1");
        Assert.assertNotNull(cols);
        Assert.assertEquals((int)2, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
    }

    @Test
    public void testJoinTable1AndTable2() throws ParseException {
        String query = "select * from t1 join t2 on (t1.id1 = t2.id1)";
        Driver driver = TestColumnAccess.createDriver();
        int rc = driver.compile(query);
        Assert.assertEquals((String)"Checking command success", (int)0, (int)rc);
        QueryPlan plan = driver.getPlan();
        ColumnAccessInfo columnAccessInfo = plan.getColumnAccessInfo();
        List<String> cols = (List<String>)columnAccessInfo.getTableToColumnAccessMap().get("default@t1");
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((int)2, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        cols = (List)columnAccessInfo.getTableToColumnAccessMap().get("default@t2");
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((int)3, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id2"));
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        Map<String, List<String>> tableColsMap = this.getColsFromReadEntity(plan.getInputs());
        cols = tableColsMap.get("default@t1");
        Assert.assertNotNull(cols);
        Assert.assertEquals((int)2, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        cols = tableColsMap.get("default@t2");
        Assert.assertNotNull(cols);
        Assert.assertEquals((int)3, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id2"));
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
    }

    @Test
    public void testJoinView1AndTable2() throws ParseException {
        String query = "select * from v1 join t2 on (v1.id1 = t2.id1)";
        Driver driver = TestColumnAccess.createDriver();
        int rc = driver.compile(query);
        Assert.assertEquals((String)"Checking command success", (int)0, (int)rc);
        QueryPlan plan = driver.getPlan();
        ColumnAccessInfo columnAccessInfo = plan.getColumnAccessInfo();
        List<String> cols = (List<String>)columnAccessInfo.getTableToColumnAccessMap().get("default@t1");
        Assert.assertNull((Object)cols);
        cols = (List)columnAccessInfo.getTableToColumnAccessMap().get("default@v1");
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((int)2, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        cols = (List)columnAccessInfo.getTableToColumnAccessMap().get("default@t2");
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((int)3, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id2"));
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        Map<String, List<String>> tableColsMap = this.getColsFromReadEntity(plan.getInputs());
        cols = tableColsMap.get("default@t1");
        Assert.assertNull(cols);
        cols = tableColsMap.get("default@v1");
        Assert.assertNotNull(cols);
        Assert.assertEquals((int)2, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
        cols = tableColsMap.get("default@t2");
        Assert.assertNotNull(cols);
        Assert.assertEquals((int)3, (int)cols.size());
        Assert.assertNotNull((Object)cols.contains("id2"));
        Assert.assertNotNull((Object)cols.contains("id1"));
        Assert.assertNotNull((Object)cols.contains("name1"));
    }

    private Map<String, List<String>> getColsFromReadEntity(HashSet<ReadEntity> inputs) {
        HashMap<String, List<String>> tableColsMap = new HashMap<String, List<String>>();
        for (ReadEntity entity : inputs) {
            switch (entity.getType()) {
                case TABLE: {
                    if (entity.getAccessedColumns() == null || entity.getAccessedColumns().isEmpty()) break;
                    tableColsMap.put(entity.getTable().getCompleteName(), entity.getAccessedColumns());
                    break;
                }
                case PARTITION: {
                    if (entity.getAccessedColumns() == null || entity.getAccessedColumns().isEmpty()) break;
                    tableColsMap.put(entity.getPartition().getTable().getCompleteName(), entity.getAccessedColumns());
                    break;
                }
            }
        }
        return tableColsMap;
    }

    private static Driver createDriver() {
        HiveConf conf = new HiveConf(Driver.class);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS, true);
        SessionState.start((HiveConf)conf);
        Driver driver = new Driver(conf);
        driver.init();
        return driver;
    }
}

