/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.junit.Before;
import org.junit.Test;

public class TestMacroSemanticAnalyzer {
    private MacroSemanticAnalyzer analyzer;
    private QueryState queryState;
    private HiveConf conf;
    private Context context;

    @Before
    public void setup() throws Exception {
        this.queryState = new QueryState(null);
        this.conf = this.queryState.getConf();
        SessionState.start((HiveConf)this.conf);
        this.context = new Context((Configuration)this.conf);
        this.analyzer = new MacroSemanticAnalyzer(this.queryState);
    }

    private ASTNode parse(String command) throws Exception {
        return ParseUtils.parse((String)command);
    }

    private void analyze(ASTNode ast) throws Exception {
        this.analyzer.analyze(ast, this.context);
        List rootTasks = this.analyzer.getRootTasks();
        Assert.assertEquals((int)1, (int)rootTasks.size());
        for (Task task : rootTasks) {
            Assert.assertEquals((int)0, (int)task.executeTask());
        }
    }

    @Test
    public void testDropMacroDoesNotExist() throws Exception {
        this.analyze(this.parse("DROP TEMPORARY MACRO SOME_MACRO"));
    }

    @Test
    public void testDropMacroExistsDoNotIgnoreErrors() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.DROPIGNORESNONEXISTENT, false);
        FunctionRegistry.registerTemporaryUDF((String)"SOME_MACRO", GenericUDFMacro.class, (FunctionInfo.FunctionResource[])new FunctionInfo.FunctionResource[0]);
        this.analyze(this.parse("DROP TEMPORARY MACRO SOME_MACRO"));
    }

    @Test
    public void testDropMacro() throws Exception {
        FunctionRegistry.registerTemporaryUDF((String)"SOME_MACRO", GenericUDFMacro.class, (FunctionInfo.FunctionResource[])new FunctionInfo.FunctionResource[0]);
        this.analyze(this.parse("DROP TEMPORARY MACRO SOME_MACRO"));
    }

    @Test(expected=SemanticException.class)
    public void testDropMacroNonExistent() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.DROPIGNORESNONEXISTENT, false);
        this.analyze(this.parse("DROP TEMPORARY MACRO SOME_MACRO"));
    }

    @Test
    public void testDropMacroNonExistentWithIfExists() throws Exception {
        this.analyze(this.parse("DROP TEMPORARY MACRO IF EXISTS SOME_MACRO"));
    }

    @Test
    public void testDropMacroNonExistentWithIfExistsDoNotIgnoreNonExistent() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.DROPIGNORESNONEXISTENT, false);
        this.analyze(this.parse("DROP TEMPORARY MACRO IF EXISTS SOME_MACRO"));
    }

    @Test
    public void testZeroInputParamters() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO FIXED_NUMBER() 1"));
    }

    @Test
    public void testOneInputParamters() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO SIGMOID (x DOUBLE) 1.0 / (1.0 + EXP(-x))"));
    }

    @Test
    public void testTwoInputParamters() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO DUMB_ADD (x INT, y INT) x + y"));
    }

    @Test
    public void testThreeInputParamters() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO DUMB_ADD (x INT, y INT, z INT) x + y + z"));
    }

    @Test(expected=ParseException.class)
    public void testCannotUseReservedWordAsName() throws Exception {
        this.parse("CREATE TEMPORARY MACRO DOUBLE (x DOUBLE) 1.0 / (1.0 + EXP(-x))");
    }

    @Test(expected=ParseException.class)
    public void testNoBody() throws Exception {
        this.parse("CREATE TEMPORARY MACRO DUMB_MACRO()");
    }

    @Test(expected=SemanticException.class)
    public void testUnknownInputParameter() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO BAD_MACRO (x INT, y INT) x + y + z"));
    }

    @Test(expected=SemanticException.class)
    public void testOneUnusedParameterName() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO BAD_MACRO (x INT, y INT) x"));
    }

    @Test(expected=SemanticException.class)
    public void testTwoUnusedParameterNames() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO BAD_MACRO (x INT, y INT, z INT) x"));
    }

    @Test(expected=SemanticException.class)
    public void testTwoDuplicateParameterNames() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO BAD_MACRO (x INT, x INT) x + x"));
    }

    @Test(expected=SemanticException.class)
    public void testThreeDuplicateParameters() throws Exception {
        this.analyze(this.parse("CREATE TEMPORARY MACRO BAD_MACRO (x INT, x INT, x INT) x + x + x"));
    }
}

