/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParseDriver {
    ParseDriver parseDriver = new ParseDriver();

    @Test
    public void atFirstWarmup() throws Exception {
        this.parseDriver.parse("select 1");
    }

    @Test
    public void testParse() throws Exception {
        String selectStr = "select field1, field2, sum(field3+field4)";
        String whereStr = "field5=1 and field6 in ('a', 'b')";
        String havingStr = "sum(field7) > 11";
        ASTNode tree = this.parseDriver.parse(selectStr + " from table1 where " + whereStr + " group by field1, field2 having  " + havingStr);
        Assert.assertEquals((long)tree.getType(), (long)0L);
        Assert.assertEquals((long)tree.getChildCount(), (long)2L);
        ASTNode queryTree = (ASTNode)tree.getChild(0);
        Assert.assertEquals((long)tree.getChild(1).getType(), (long)-1L);
        Assert.assertEquals((long)queryTree.getChildCount(), (long)2L);
        ASTNode fromAST = (ASTNode)queryTree.getChild(0);
        ASTNode insertAST = (ASTNode)queryTree.getChild(1);
        Assert.assertEquals((long)fromAST.getType(), (long)761L);
        Assert.assertEquals((long)fromAST.getChildCount(), (long)1L);
        Assert.assertEquals((long)fromAST.getChild(0).getType(), (long)977L);
        Assert.assertEquals((long)fromAST.getChild(0).getChildCount(), (long)1L);
        Assert.assertEquals((long)fromAST.getChild(0).getChild(0).getType(), (long)976L);
        Assert.assertEquals((long)fromAST.getChild(0).getChild(0).getChildCount(), (long)1L);
        Assert.assertEquals((long)fromAST.getChild(0).getChild(0).getChild(0).getType(), (long)24L);
        Assert.assertEquals((Object)fromAST.getChild(0).getChild(0).getChild(0).getText(), (Object)"table1");
        Assert.assertEquals((long)insertAST.getChildCount(), (long)5L);
        Assert.assertEquals((long)insertAST.getChild(0).getType(), (long)734L);
        this.assertTree((ASTNode)insertAST.getChild(1), this.parseDriver.parseSelect(selectStr, null));
        Assert.assertEquals((long)insertAST.getChild(2).getType(), (long)1013L);
        this.assertTree((ASTNode)insertAST.getChild(2).getChild(0), this.parseDriver.parseExpression(whereStr));
        Assert.assertEquals((long)insertAST.getChild(3).getType(), (long)772L);
        Assert.assertEquals((long)insertAST.getChild(3).getChildCount(), (long)2L);
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((long)insertAST.getChild(3).getChild(i).getType(), (long)973L);
            Assert.assertEquals((long)insertAST.getChild(3).getChild(i).getChild(0).getType(), (long)24L);
            Assert.assertEquals((Object)insertAST.getChild(3).getChild(i).getChild(0).getText(), (Object)("field" + (i + 1)));
        }
        Assert.assertEquals((long)insertAST.getChild(4).getType(), (long)775L);
        Assert.assertEquals((long)insertAST.getChild(4).getChildCount(), (long)1L);
        this.assertTree((ASTNode)insertAST.getChild(4).getChild(0), this.parseDriver.parseExpression(havingStr));
    }

    @Test
    public void testParseSelect() throws Exception {
        ASTNode tree = this.parseDriver.parseSelect("select field1, field2, sum(field3+field4)", null);
        Assert.assertEquals((long)tree.getType(), (long)899L);
        Assert.assertEquals((long)tree.getChildCount(), (long)3L);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)((ASTNode)tree.getChild(i)).getType(), (long)901L);
        }
        this.assertTree((ASTNode)tree.getChild(0).getChild(0), this.parseDriver.parseExpression("field1"));
        this.assertTree((ASTNode)tree.getChild(1).getChild(0), this.parseDriver.parseExpression("field2"));
        this.assertTree((ASTNode)tree.getChild(2).getChild(0), this.parseDriver.parseExpression("sum(field3+field4)"));
    }

    @Test
    public void testParseExpression() throws Exception {
        ASTNode plusNode = this.parseDriver.parseExpression("field3 + field4");
        Assert.assertEquals((long)plusNode.getType(), (long)342L);
        Assert.assertEquals((long)plusNode.getChildCount(), (long)2L);
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((long)plusNode.getChild(i).getType(), (long)973L);
            Assert.assertEquals((long)plusNode.getChild(i).getChildCount(), (long)1L);
            Assert.assertEquals((long)plusNode.getChild(i).getChild(0).getType(), (long)24L);
            Assert.assertEquals((Object)plusNode.getChild(i).getChild(0).getText(), (Object)("field" + (i + 3)));
        }
        ASTNode sumNode = this.parseDriver.parseExpression("sum(field3 + field4)");
        Assert.assertEquals((long)sumNode.getType(), (long)763L);
        Assert.assertEquals((long)sumNode.getChildCount(), (long)2L);
        Assert.assertEquals((long)sumNode.getChild(0).getType(), (long)24L);
        Assert.assertEquals((Object)sumNode.getChild(0).getText(), (Object)"sum");
        this.assertTree((ASTNode)sumNode.getChild(1), plusNode);
        ASTNode tree = this.parseDriver.parseExpression("case when field1 = 1 then sum(field3 + field4) when field1 != 2 then sum(field3-field4) else sum(field3 * field4) end");
        Assert.assertEquals((long)tree.getChildCount(), (long)6L);
        Assert.assertEquals((long)tree.getChild(0).getType(), (long)322L);
        Assert.assertEquals((long)tree.getChild(1).getType(), (long)18L);
        this.assertTree((ASTNode)tree.getChild(2), sumNode);
        Assert.assertEquals((long)tree.getChild(3).getType(), (long)339L);
        this.assertTree((ASTNode)tree.getChild(4), this.parseDriver.parseExpression("sum(field3-field4)"));
        this.assertTree((ASTNode)tree.getChild(5), this.parseDriver.parseExpression("sum(field3*field4)"));
    }

    private void assertTree(ASTNode astNode1, ASTNode astNode2) {
        Assert.assertEquals((long)astNode1.getType(), (long)astNode2.getType());
        Assert.assertEquals((long)astNode1.getChildCount(), (long)astNode2.getChildCount());
        for (int i = 0; i < astNode1.getChildCount(); ++i) {
            this.assertTree((ASTNode)astNode1.getChild(i), (ASTNode)astNode2.getChild(i));
        }
    }

    @Test(timeout=1000L)
    public void testNestedFunctionCalls() throws Exception {
        this.parseDriver.parse("select greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,greatest(1,(greatest(1,greatest(1,2)))))))))))))))))))");
    }

    @Test(timeout=1000L)
    public void testHIVE18624() throws Exception {
        this.parseDriver.parse("EXPLAIN\nSELECT DISTINCT\n\n\n  IF(lower('a') <= lower('a')\n  ,'a'\n  ,IF(('a' IS NULL AND from_unixtime(UNIX_TIMESTAMP()) <= 'a')\n  ,'a'\n  ,IF(if('a' = 'a', TRUE, FALSE) = 1\n  ,'a'\n  ,IF(('a' = 1 and lower('a') NOT IN ('a', 'a')\n       and lower(if('a' = 'a','a','a')) <= lower('a'))\n      OR ('a' like 'a' OR 'a' like 'a')\n      OR 'a' in ('a','a')\n  ,'a'\n  ,IF(if(lower('a') in ('a', 'a') and 'a'='a', TRUE, FALSE) = 1\n  ,'a'\n  ,IF('a'='a' and unix_timestamp(if('a' = 'a',cast('a' as string),coalesce('a',cast('a' as string),from_unixtime(unix_timestamp())))) <= unix_timestamp(concat_ws('a',cast(lower('a') as string),'00:00:00')) + 9*3600\n  ,'a'\n\n  ,If(lower('a') <= lower('a')\n      and if(lower('a') in ('a', 'a') and 'a'<>'a', TRUE, FALSE) <> 1\n  ,'a'\n  ,IF('a'=1 AND 'a'=1\n  ,'a'\n  ,IF('a' = 1 and COALESCE(cast('a' as int),0) = 0\n  ,'a'\n  ,IF('a' = 'a'\n  ,'a'\n\n  ,If('a' = 'a' AND lower('a')>lower(if(lower('a')<1830,'a',cast(date_add('a',1) as timestamp)))\n  ,'a'\n\n\n\n  ,IF('a' = 1\n\n  ,IF('a' in ('a', 'a') and ((unix_timestamp('a')-unix_timestamp('a')) / 60) > 30 and 'a' = 1\n\n\n  ,'a', 'a')\n\n\n  ,IF(if('a' = 'a', FALSE, TRUE ) = 1 AND 'a' IS NULL\n  ,'a'\n  ,IF('a' = 1 and 'a'>0\n  , 'a'\n\n  ,IF('a' = 1 AND 'a' ='a'\n  ,'a'\n  ,IF('a' is not null and 'a' is not null and 'a' > 'a'\n  ,'a'\n  ,IF('a' = 1\n  ,'a'\n\n  ,IF('a' = 'a'\n  ,'a'\n\n  ,If('a' = 1\n  ,'a'\n  ,IF('a' = 1\n  ,'a'\n  ,IF('a' = 1\n  ,'a'\n\n  ,IF('a' ='a' and 'a' ='a' and cast(unix_timestamp('a') as  int) + 93600 < cast(unix_timestamp()  as int)\n  ,'a'\n  ,IF('a' = 'a'\n  ,'a'\n  ,IF('a' = 'a' and 'a' in ('a','a','a')\n  ,'a'\n  ,IF('a' = 'a'\n  ,'a','a'))\n      )))))))))))))))))))))))\nAS test_comp_exp");
    }

    @Test(timeout=10000L)
    public void testExoticSJSSubQuery() throws Exception {
        ExoticQueryBuilder eqb = new ExoticQueryBuilder();
        eqb.recursiveSJS(10);
        String q = eqb.getQuery();
        System.out.println(q);
        this.parseDriver.parse(q);
    }

    @Test
    public void testJoinResulInBraces() throws Exception {
        String q = "explain select a.key, b.value from( (select key from src)a join (select value from src)b on a.key=b.value)";
        System.out.println(q);
        ASTNode root = this.parseDriver.parse(q);
        System.out.println(root.dump());
    }

    @Test
    public void testFromSubqueryIsSetop() throws Exception {
        String q = "explain select key from ((select key from src) union (select key from src))subq ";
        System.out.println(q);
        ASTNode root = this.parseDriver.parse(q);
        System.out.println(root.dump());
    }

    static class ExoticQueryBuilder {
        StringBuilder sb = new StringBuilder();

        ExoticQueryBuilder() {
        }

        public void recursiveSJS(int depth) {
            this.sb.append("select ");
            this.addColumns(30);
            this.sb.append(" from \n");
            this.tablePart(depth);
            this.sb.append(" join \n");
            this.tablePart(depth);
            this.sb.append(" on ( ");
            this.wherePart(10);
            this.sb.append(" ) ");
            this.sb.append(" where ");
            this.wherePart(10);
        }

        private void tablePart(int depth) {
            if (depth == 0) {
                this.sb.append(" baseTable ");
            } else {
                this.sb.append("(");
                this.recursiveSJS(depth - 1);
                this.sb.append(") aa");
            }
        }

        private void wherePart(int num) {
            for (int i = 0; i < num - 1; ++i) {
                this.sb.append("x = ");
                this.sb.append(i);
                this.sb.append(" or ");
            }
            this.sb.append("x = -1");
        }

        private void addColumns(int num) {
            for (int i = 0; i < num - 1; ++i) {
                this.sb.append("c");
                this.sb.append(i);
                this.sb.append(" + 2*sqrt(11)+");
                this.sb.append(i);
                this.sb.append(",");
            }
            this.sb.append("cE");
        }

        public String getQuery() {
            return this.sb.toString();
        }
    }
}

