/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReplicationSemanticAnalyzer {
    static QueryState queryState;
    static HiveConf conf;
    static String defaultDB;
    static String tblName;
    static ArrayList<String> cols;
    ParseDriver pd;
    SemanticAnalyzer sA;

    @BeforeClass
    public static void initialize() throws HiveException {
        queryState = new QueryState(new HiveConf(SemanticAnalyzer.class));
        conf = queryState.getConf();
        conf.set("hive.security.authorization.manager", "");
        SessionState.start((HiveConf)conf);
        Hive hiveDb = Hive.get((HiveConf)conf);
        hiveDb.createTable(defaultDB + "." + tblName, cols, null, OrcInputFormat.class, OrcOutputFormat.class);
        Table t = hiveDb.getTable(tblName);
    }

    @AfterClass
    public static void teardown() throws HiveException {
    }

    @Test
    public void testReplDumpParse() throws Exception {
        ParseDriver pd = new ParseDriver();
        String fromEventId = "100";
        String toEventId = "200";
        String maxEventLimit = "50";
        String query = "repl dump " + defaultDB;
        ASTNode root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((Object)root.getText(), (Object)"TOK_REPL_DUMP");
        Assert.assertEquals((long)root.getChildCount(), (long)1L);
        ASTNode child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)defaultDB);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        query = "repl dump " + defaultDB + "." + tblName;
        root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((long)root.getChildCount(), (long)2L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)defaultDB);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)tblName);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        query = "repl dump " + defaultDB + "." + tblName + " from " + fromEventId;
        root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((long)root.getChildCount(), (long)3L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)defaultDB);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)tblName);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        root = (ASTNode)root.getChild(2);
        Assert.assertEquals((Object)root.getText(), (Object)"TOK_FROM");
        Assert.assertEquals((long)root.getChildCount(), (long)1L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)fromEventId);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        query = "repl dump " + defaultDB + "." + tblName + " from " + fromEventId + " to " + toEventId;
        root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((long)root.getChildCount(), (long)3L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)defaultDB);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)tblName);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        root = (ASTNode)root.getChild(2);
        Assert.assertEquals((Object)root.getText(), (Object)"TOK_FROM");
        Assert.assertEquals((long)root.getChildCount(), (long)3L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)fromEventId);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)"TOK_TO");
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(2);
        Assert.assertEquals((Object)child.getText(), (Object)toEventId);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        query = "repl dump " + defaultDB + "." + tblName + " from " + fromEventId + " to " + toEventId + " limit " + maxEventLimit;
        root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((long)root.getChildCount(), (long)3L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)defaultDB);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)tblName);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        root = (ASTNode)root.getChild(2);
        Assert.assertEquals((Object)root.getText(), (Object)"TOK_FROM");
        Assert.assertEquals((long)root.getChildCount(), (long)5L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)fromEventId);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)"TOK_TO");
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(2);
        Assert.assertEquals((Object)child.getText(), (Object)toEventId);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(3);
        Assert.assertEquals((Object)child.getText(), (Object)"TOK_LIMIT");
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(4);
        Assert.assertEquals((Object)child.getText(), (Object)maxEventLimit);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
    }

    @Test
    public void testReplLoadParse() throws Exception {
        ParseDriver pd = new ParseDriver();
        String replRoot = conf.getVar(HiveConf.ConfVars.REPLDIR);
        Path dumpRoot = new Path(replRoot, "next");
        System.out.println(replRoot);
        System.out.println(dumpRoot);
        String newDB = "default_bak";
        String query = "repl load  from '" + dumpRoot.toString() + "'";
        ASTNode root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((Object)root.getText(), (Object)"TOK_REPL_LOAD");
        Assert.assertEquals((long)root.getChildCount(), (long)1L);
        ASTNode child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)("'" + dumpRoot.toString() + "'"));
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        query = "repl load " + newDB + " from '" + dumpRoot.toString() + "'";
        root = (ASTNode)pd.parse(query).getChild(0);
        Assert.assertEquals((Object)root.getText(), (Object)"TOK_REPL_LOAD");
        Assert.assertEquals((long)root.getChildCount(), (long)2L);
        child = (ASTNode)root.getChild(0);
        Assert.assertEquals((Object)child.getText(), (Object)("'" + dumpRoot.toString() + "'"));
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
        child = (ASTNode)root.getChild(1);
        Assert.assertEquals((Object)child.getText(), (Object)newDB);
        Assert.assertEquals((long)child.getChildCount(), (long)0L);
    }

    public void testReplDumpAnalyze() throws Exception {
    }

    public void testReplLoadAnalyze() throws Exception {
        ParseDriver pd = new ParseDriver();
        String replRoot = conf.getVar(HiveConf.ConfVars.REPLDIR);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dumpRoot = new Path(replRoot, "next");
        System.out.println(replRoot);
        System.out.println(dumpRoot);
        String newDB = "default_bak";
        String query = "repl dump " + defaultDB;
        ASTNode root = (ASTNode)pd.parse(query).getChild(0);
        ReplicationSemanticAnalyzer rs = (ReplicationSemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)root);
        rs.analyze(root, new Context((Configuration)conf));
        query = "repl load  from '" + dumpRoot.toString() + "'";
        root = (ASTNode)pd.parse(query).getChild(0);
        rs = (ReplicationSemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)root);
        rs.analyze(root, new Context((Configuration)conf));
        List roots = rs.getRootTasks();
        Assert.assertEquals((long)1L, (long)roots.size());
        query = "repl load " + newDB + " from '" + dumpRoot.toString() + "'";
        root = (ASTNode)pd.parse(query).getChild(0);
        rs = (ReplicationSemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)root);
        rs.analyze(root, new Context((Configuration)conf));
        roots = rs.getRootTasks();
        Assert.assertEquals((long)1L, (long)roots.size());
    }

    @Test
    public void testReplStatusAnalyze() throws Exception {
        ParseDriver pd = new ParseDriver();
        String query = "repl status " + defaultDB;
        ASTNode root = (ASTNode)pd.parse(query).getChild(0);
        ReplicationSemanticAnalyzer rs = (ReplicationSemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)root);
        rs.analyze(root, new Context((Configuration)conf));
        FetchTask fetchTask = rs.getFetchTask();
        Assert.assertNotNull((Object)fetchTask);
    }

    static {
        defaultDB = "default";
        tblName = "testReplSA";
        cols = new ArrayList<String>(Arrays.asList("col1", "col2"));
    }
}

