/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSQL11ReservedKeyWordsNegative {
    private static HiveConf conf;
    private ParseDriver pd;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException, IOException {
        this.pd = new ParseDriver();
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = null;
        try {
            nd = this.pd.parse(query, new Context((Configuration)conf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testSQL11ReservedKeyWords_ALL() {
        try {
            this.parse("CREATE TABLE ALL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ALL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_ALTER() {
        try {
            this.parse("CREATE TABLE ALTER (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ALTER' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_ARRAY() {
        try {
            this.parse("CREATE TABLE ARRAY (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ARRAY' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_AS() {
        try {
            this.parse("CREATE TABLE AS (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'AS' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_AUTHORIZATION() {
        try {
            this.parse("CREATE TABLE AUTHORIZATION (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'AUTHORIZATION' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_BETWEEN() {
        try {
            this.parse("CREATE TABLE BETWEEN (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'BETWEEN' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_BIGINT() {
        try {
            this.parse("CREATE TABLE BIGINT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'BIGINT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_BINARY() {
        try {
            this.parse("CREATE TABLE BINARY (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'BINARY' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_BOOLEAN() {
        try {
            this.parse("CREATE TABLE BOOLEAN (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'BOOLEAN' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_BOTH() {
        try {
            this.parse("CREATE TABLE BOTH (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'BOTH' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_BY() {
        try {
            this.parse("CREATE TABLE BY (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'BY' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_CONSTRAINT() {
        try {
            this.parse("CREATE TABLE CONSTRAINT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'CONSTRAINT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_CREATE() {
        try {
            this.parse("CREATE TABLE CREATE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'CREATE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_CUBE() {
        try {
            this.parse("CREATE TABLE CUBE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'CUBE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_CURRENT_DATE() {
        try {
            this.parse("CREATE TABLE CURRENT_DATE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'CURRENT_DATE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_CURRENT_TIMESTAMP() {
        try {
            this.parse("CREATE TABLE CURRENT_TIMESTAMP (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'CURRENT_TIMESTAMP' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_CURSOR() {
        try {
            this.parse("CREATE TABLE CURSOR (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'CURSOR' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_DATE() {
        try {
            this.parse("CREATE TABLE DATE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'DATE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_DECIMAL() {
        try {
            this.parse("CREATE TABLE DECIMAL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'DECIMAL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_DELETE() {
        try {
            this.parse("CREATE TABLE DELETE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'DELETE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_DESCRIBE() {
        try {
            this.parse("CREATE TABLE DESCRIBE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'DESCRIBE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_DOUBLE() {
        try {
            this.parse("CREATE TABLE DOUBLE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'DOUBLE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_DROP() {
        try {
            this.parse("CREATE TABLE DROP (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'DROP' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_EXISTS() {
        try {
            this.parse("CREATE TABLE EXISTS (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'EXISTS' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_EXTERNAL() {
        try {
            this.parse("CREATE TABLE EXTERNAL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'EXTERNAL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_FALSE() {
        try {
            this.parse("CREATE TABLE FALSE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'FALSE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_FETCH() {
        try {
            this.parse("CREATE TABLE FETCH (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'FETCH' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_FLOAT() {
        try {
            this.parse("CREATE TABLE FLOAT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'FLOAT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_FOR() {
        try {
            this.parse("CREATE TABLE FOR (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'FOR' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_FOREIGN() {
        try {
            this.parse("CREATE TABLE FOREIGN (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'FOREIGN' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_FULL() {
        try {
            this.parse("CREATE TABLE FULL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'FULL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_GRANT() {
        try {
            this.parse("CREATE TABLE GRANT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'GRANT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_GROUP() {
        try {
            this.parse("CREATE TABLE GROUP (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'GROUP' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_GROUPING() {
        try {
            this.parse("CREATE TABLE GROUPING (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'GROUPING' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_IMPORT() {
        try {
            this.parse("CREATE TABLE IMPORT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'IMPORT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_IN() {
        try {
            this.parse("CREATE TABLE IN (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'IN' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_INNER() {
        try {
            this.parse("CREATE TABLE INNER (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'INNER' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_INSERT() {
        try {
            this.parse("CREATE TABLE INSERT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'INSERT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_INT() {
        try {
            this.parse("CREATE TABLE INT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'INT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_INTERSECT() {
        try {
            this.parse("CREATE TABLE INTERSECT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'INTERSECT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_INTO() {
        try {
            this.parse("CREATE TABLE INTO (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'INTO' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_IS() {
        try {
            this.parse("CREATE TABLE IS (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'IS' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_LATERAL() {
        try {
            this.parse("CREATE TABLE LATERAL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'LATERAL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_LEFT() {
        try {
            this.parse("CREATE TABLE LEFT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'LEFT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_LIKE() {
        try {
            this.parse("CREATE TABLE LIKE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'LIKE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_LOCAL() {
        try {
            this.parse("CREATE TABLE LOCAL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'LOCAL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_MINUS() {
        try {
            this.parse("CREATE TABLE MINUS (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'MINUS' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_NONE() {
        try {
            this.parse("CREATE TABLE NONE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'NONE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_NULL() {
        try {
            this.parse("CREATE TABLE NULL (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'NULL' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_OF() {
        try {
            this.parse("CREATE TABLE OF (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'OF' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_ORDER() {
        try {
            this.parse("CREATE TABLE ORDER (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ORDER' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_OUT() {
        try {
            this.parse("CREATE TABLE OUT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'OUT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_OUTER() {
        try {
            this.parse("CREATE TABLE OUTER (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'OUTER' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_PARTITION() {
        try {
            this.parse("CREATE TABLE PARTITION (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'PARTITION' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_PERCENT() {
        try {
            this.parse("CREATE TABLE PERCENT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'PERCENT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_PRECISION() {
        try {
            this.parse("CREATE TABLE PRECISION (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'PRECISION' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_PRIMARY() {
        try {
            this.parse("CREATE TABLE PRIMARY (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'PRIMARY' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_PROCEDURE() {
        try {
            this.parse("CREATE TABLE PROCEDURE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'PROCEDURE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_RANGE() {
        try {
            this.parse("CREATE TABLE RANGE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'RANGE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_READS() {
        try {
            this.parse("CREATE TABLE READS (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'READS' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_REFERENCES() {
        try {
            this.parse("CREATE TABLE REFERENCES (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'REFERENCES' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_REGEXP() {
        try {
            this.parse("CREATE TABLE REGEXP (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'REGEXP' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_REVOKE() {
        try {
            this.parse("CREATE TABLE REVOKE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'REVOKE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_RIGHT() {
        try {
            this.parse("CREATE TABLE RIGHT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'RIGHT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_RLIKE() {
        try {
            this.parse("CREATE TABLE RLIKE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'RLIKE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_ROLLUP() {
        try {
            this.parse("CREATE TABLE ROLLUP (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ROLLUP' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_ROW() {
        try {
            this.parse("CREATE TABLE ROW (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ROW' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_ROWS() {
        try {
            this.parse("CREATE TABLE ROWS (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'ROWS' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_SET() {
        try {
            this.parse("CREATE TABLE SET (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'SET' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_SMALLINT() {
        try {
            this.parse("CREATE TABLE SMALLINT (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'SMALLINT' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_TABLE() {
        try {
            this.parse("CREATE TABLE TABLE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'TABLE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_TIMESTAMP() {
        try {
            this.parse("CREATE TABLE TIMESTAMP (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'TIMESTAMP' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_TO() {
        try {
            this.parse("CREATE TABLE TO (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'TO' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_TRIGGER() {
        try {
            this.parse("CREATE TABLE TRIGGER (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'TRIGGER' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_TRUE() {
        try {
            this.parse("CREATE TABLE TRUE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'TRUE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_TRUNCATE() {
        try {
            this.parse("CREATE TABLE TRUNCATE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'TRUNCATE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_UNION() {
        try {
            this.parse("CREATE TABLE UNION (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'UNION' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_UPDATE() {
        try {
            this.parse("CREATE TABLE UPDATE (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'UPDATE' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_USER() {
        try {
            this.parse("CREATE TABLE USER (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'USER' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_USING() {
        try {
            this.parse("CREATE TABLE USING (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'USING' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_VALUES() {
        try {
            this.parse("CREATE TABLE VALUES (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'VALUES' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSQL11ReservedKeyWords_WITH() {
        try {
            this.parse("CREATE TABLE WITH (col STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:13 cannot recognize input near 'WITH' '(' 'col' in table name", (Object)ex.getMessage());
        }
    }
}

