/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUnpermittedCharsInColumnNameCreateTableNegative {
    private static HiveConf conf;
    private ParseDriver pd;

    @BeforeClass
    public static void initialize() {
        conf = new HiveConf(SemanticAnalyzer.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException, IOException {
        this.pd = new ParseDriver();
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = null;
        try {
            nd = this.pd.parse(query, new Context((Configuration)conf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testDotInCreateTable() {
        try {
            this.parse("CREATE TABLE testTable (`emp.no` STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:39 Failed to recognize predicate ')'. Failed rule: '[., :] can not be used in column name in create table statement.' in column specification", (Object)ex.getMessage());
        }
    }

    @Test
    public void testColonInCreateTable() {
        try {
            this.parse("CREATE TABLE testTable (`emp:no` STRING)");
            Assert.assertFalse((String)"Expected ParseException", (boolean)true);
        }
        catch (ParseException ex) {
            Assert.assertEquals((String)"Failure didn't match.", (Object)"line 1:39 Failed to recognize predicate ')'. Failed rule: '[., :] can not be used in column name in create table statement.' in column specification", (Object)ex.getMessage());
        }
    }
}

