/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAddResource {
    private static final String TEST_JAR_DIR = System.getProperty("test.tmp.dir", ".") + File.pathSeparator;
    private HiveConf conf;
    private SessionState.ResourceType t;

    @Before
    public void setup() throws IOException {
        this.conf = new HiveConf();
        this.t = SessionState.ResourceType.JAR;
        for (int i = 1; i <= 5; ++i) {
            BufferedWriter output = null;
            String dataFile = TEST_JAR_DIR + "testjar" + i + ".jar";
            File file = new File(dataFile);
            output = new BufferedWriter(new FileWriter(file));
            output.write("sample");
            ((Writer)output).close();
        }
    }

    @Test
    public void testSanity() throws URISyntaxException, IOException {
        SessionState.start((HiveConf)this.conf);
        SessionState ss = (SessionState)Mockito.spy((Object)SessionState.get());
        String query = "testQuery";
        LinkedList<URI> list = new LinkedList<URI>();
        LinkedList<String> addList = new LinkedList<String>();
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar1.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar2.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar5.jar"));
        Mockito.when((Object)ss.resolveAndDownload(query, false)).thenReturn(list);
        addList.add(query);
        ss.add_resources(this.t, addList);
        Set dependencies = ss.list_resource(this.t, null);
        LinkedList<URI> actual = new LinkedList<URI>();
        for (String dependency : dependencies) {
            actual.add(TestAddResource.createURI(dependency));
        }
        Collections.sort(list);
        Collections.sort(actual);
        Assert.assertEquals(list, actual);
        ss.close();
    }

    @Test
    public void testDuplicateAdds() throws URISyntaxException, IOException {
        SessionState.start((HiveConf)this.conf);
        SessionState ss = (SessionState)Mockito.spy((Object)SessionState.get());
        String query = "testQuery";
        LinkedList<URI> list = new LinkedList<URI>();
        LinkedList<String> addList = new LinkedList<String>();
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar1.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar2.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar5.jar"));
        Collections.sort(list);
        Mockito.when((Object)ss.resolveAndDownload(query, false)).thenReturn(list);
        for (int i = 0; i < 10; ++i) {
            addList.add(query);
        }
        ss.add_resources(this.t, addList);
        Set dependencies = ss.list_resource(this.t, null);
        LinkedList<URI> actual = new LinkedList<URI>();
        for (String dependency : dependencies) {
            actual.add(TestAddResource.createURI(dependency));
        }
        Collections.sort(actual);
        Assert.assertEquals(list, actual);
        ss.close();
    }

    @Test
    public void testUnion() throws URISyntaxException, IOException {
        HiveConf conf = new HiveConf();
        SessionState.start((HiveConf)conf);
        SessionState ss = (SessionState)Mockito.spy((Object)SessionState.get());
        SessionState.ResourceType t = SessionState.ResourceType.JAR;
        String query1 = "testQuery1";
        String query2 = "testQuery2";
        LinkedList<String> addList = new LinkedList<String>();
        LinkedList<URI> list1 = new LinkedList<URI>();
        LinkedList<URI> list2 = new LinkedList<URI>();
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar1.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar2.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar5.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        Mockito.when((Object)ss.resolveAndDownload(query1, false)).thenReturn(list1);
        Mockito.when((Object)ss.resolveAndDownload(query2, false)).thenReturn(list2);
        addList.add(query1);
        addList.add(query2);
        ss.add_resources(t, addList);
        Set dependencies = ss.list_resource(t, null);
        LinkedList<URI> actual = new LinkedList<URI>();
        for (String dependency : dependencies) {
            actual.add(TestAddResource.createURI(dependency));
        }
        List expected = this.union(list1, list2);
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
        ss.close();
    }

    private static URI createURI(String path) throws URISyntaxException {
        return new URI(path);
    }

    @Test
    public void testDeleteJar() throws URISyntaxException, IOException {
        SessionState.start((HiveConf)this.conf);
        SessionState ss = (SessionState)Mockito.spy((Object)SessionState.get());
        String query1 = "testQuery1";
        String query2 = "testQuery2";
        LinkedList<URI> list1 = new LinkedList<URI>();
        LinkedList<URI> list2 = new LinkedList<URI>();
        LinkedList<String> addList = new LinkedList<String>();
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar1.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar2.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar5.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        Collections.sort(list1);
        Collections.sort(list2);
        Mockito.when((Object)ss.resolveAndDownload(query1, false)).thenReturn(list1);
        Mockito.when((Object)ss.resolveAndDownload(query2, false)).thenReturn(list2);
        addList.add(query1);
        addList.add(query2);
        ss.add_resources(this.t, addList);
        LinkedList<String> deleteList = new LinkedList<String>();
        deleteList.add(((URI)list1.get(0)).toString());
        ss.delete_resources(this.t, deleteList);
        Set dependencies = ss.list_resource(this.t, null);
        LinkedList<URI> actual = new LinkedList<URI>();
        for (String dependency : dependencies) {
            actual.add(TestAddResource.createURI(dependency));
        }
        LinkedList<URI> expected = list2;
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
        deleteList.clear();
        deleteList.add(((URI)list2.get(0)).toString());
        ss.delete_resources(this.t, deleteList);
        dependencies = ss.list_resource(this.t, null);
        Assert.assertEquals((Object)dependencies.isEmpty(), (Object)true);
        ss.close();
    }

    @Test
    public void testDeleteJarMultiple() throws URISyntaxException, IOException {
        SessionState.start((HiveConf)this.conf);
        SessionState ss = (SessionState)Mockito.spy((Object)SessionState.get());
        String query1 = "testQuery1";
        String query2 = "testQuery2";
        String query3 = "testQuery3";
        LinkedList<URI> list1 = new LinkedList<URI>();
        LinkedList<URI> list2 = new LinkedList<URI>();
        LinkedList<URI> list3 = new LinkedList<URI>();
        LinkedList<String> addList = new LinkedList<String>();
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar1.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar2.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list1.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar5.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar3.jar"));
        list2.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list3.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar4.jar"));
        list3.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar2.jar"));
        list3.add(TestAddResource.createURI(TEST_JAR_DIR + "testjar5.jar"));
        Collections.sort(list1);
        Collections.sort(list2);
        Collections.sort(list3);
        Mockito.when((Object)ss.resolveAndDownload(query1, false)).thenReturn(list1);
        Mockito.when((Object)ss.resolveAndDownload(query2, false)).thenReturn(list2);
        Mockito.when((Object)ss.resolveAndDownload(query3, false)).thenReturn(list3);
        addList.add(query1);
        addList.add(query2);
        addList.add(query3);
        ss.add_resources(this.t, addList);
        LinkedList<String> deleteList = new LinkedList<String>();
        deleteList.add(((URI)list1.get(0)).toString());
        ss.delete_resources(this.t, deleteList);
        Set dependencies = ss.list_resource(this.t, null);
        LinkedList<URI> actual = new LinkedList<URI>();
        for (String dependency : dependencies) {
            actual.add(TestAddResource.createURI(dependency));
        }
        List expected = this.union(list2, list3);
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
        actual.clear();
        expected.clear();
        deleteList.clear();
        deleteList.add(((URI)list2.get(0)).toString());
        ss.delete_resources(this.t, deleteList);
        dependencies = ss.list_resource(this.t, null);
        actual = new LinkedList();
        for (String dependency : dependencies) {
            actual.add(TestAddResource.createURI(dependency));
        }
        expected = new LinkedList(list3);
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
        actual.clear();
        expected.clear();
        deleteList.clear();
        deleteList.add(((URI)list3.get(0)).toString());
        ss.delete_resources(this.t, deleteList);
        dependencies = ss.list_resource(this.t, null);
        Assert.assertEquals((Object)dependencies.isEmpty(), (Object)true);
        ss.close();
    }

    @After
    public void tearDown() {
        for (int i = 1; i <= 5; ++i) {
            String dataFile = TEST_JAR_DIR + "testjar" + i + ".jar";
            File f = new File(dataFile);
            if (f.delete()) continue;
            throw new RuntimeException("Could not delete the data file");
        }
    }

    private <T> List<T> union(List<T> list1, List<T> list2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(list1);
        set.addAll(list2);
        return new LinkedList(set);
    }
}

