/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.sql.Timestamp;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorDay;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorHour;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMinute;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMonth;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorQuarter;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorSecond;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorWeek;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorYear;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.junit.Test;

public class TestUDFDateFormatGranularity
extends TestCase {
    @Test
    public void testTimestampToTimestampWithGranularity() throws Exception {
        TimestampWritable t = new TimestampWritable(new Timestamp(494243222000L));
        UDFDateFloorYear g = new UDFDateFloorYear();
        TimestampWritable i1 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)473414400000L, (long)i1.getTimestamp().getTime());
        g = new UDFDateFloorQuarter();
        TimestampWritable i2 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)489049200000L, (long)i2.getTimestamp().getTime());
        g = new UDFDateFloorMonth();
        TimestampWritable i3 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)491727600000L, (long)i3.getTimestamp().getTime());
        g = new UDFDateFloorWeek();
        TimestampWritable i4 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)493887600000L, (long)i4.getTimestamp().getTime());
        g = new UDFDateFloorDay();
        TimestampWritable i5 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)494233200000L, (long)i5.getTimestamp().getTime());
        g = new UDFDateFloorHour();
        TimestampWritable i6 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)494240400000L, (long)i6.getTimestamp().getTime());
        g = new UDFDateFloorMinute();
        TimestampWritable i7 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)494243220000L, (long)i7.getTimestamp().getTime());
        g = new UDFDateFloorSecond();
        TimestampWritable i8 = g.evaluate(t);
        TestUDFDateFormatGranularity.assertEquals((long)494243222000L, (long)i8.getTimestamp().getTime());
    }
}

