/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInternalInterval;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFInternalInterval {
    @Test
    public void testDayInterval() throws Exception {
        try (GenericUDFInternalInterval udf = new GenericUDFInternalInterval();){
            ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(787)), PrimitiveObjectInspectorFactory.writableStringObjectInspector};
            GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4)), new GenericUDF.DeferredJavaObject((Object)new Text("8"))};
            PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
            Assert.assertEquals((Object)TypeInfoFactory.intervalDayTimeTypeInfo, (Object)oi.getTypeInfo());
            HiveIntervalDayTimeWritable res = (HiveIntervalDayTimeWritable)udf.evaluate(args);
            Assert.assertEquals((long)8L, (long)res.getHiveIntervalDayTime().getDays());
        }
    }

    @Test
    public void testDayIntervalConstant() throws Exception {
        try (GenericUDFInternalInterval udf = new GenericUDFInternalInterval();){
            ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(787)), PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(3))};
            PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
            Assert.assertEquals((Object)TypeInfoFactory.intervalDayTimeTypeInfo, (Object)oi.getTypeInfo());
            ConstantObjectInspector coi = (ConstantObjectInspector)oi;
            HiveIntervalDayTimeWritable res = (HiveIntervalDayTimeWritable)coi.getWritableConstantValue();
            Assert.assertEquals((long)3L, (long)res.getHiveIntervalDayTime().getDays());
        }
    }

    @Test(expected=UDFArgumentException.class)
    public void testDoubleArgumentIsNotSupported() throws Exception {
        try (GenericUDFInternalInterval udf = new GenericUDFInternalInterval();){
            ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(787)), PrimitiveObjectInspectorFactory.writableDoubleObjectInspector};
            udf.initialize(inputOIs);
        }
    }

    @Test(expected=UDFArgumentException.class)
    public void testInvalidString() throws Exception {
        try (GenericUDFInternalInterval udf = new GenericUDFInternalInterval();){
            ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(787)), PrimitiveObjectInspectorFactory.writableStringObjectInspector};
            GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4)), new GenericUDF.DeferredJavaObject((Object)new Text("invalid"))};
            PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
            Assert.assertEquals((Object)TypeInfoFactory.intervalDayTimeTypeInfo, (Object)oi.getTypeInfo());
            udf.evaluate(args);
        }
    }

    @Test
    public void testNullBypass() throws Exception {
        try (GenericUDFInternalInterval udf = new GenericUDFInternalInterval();){
            ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(787)), PrimitiveObjectInspectorFactory.writableStringObjectInspector};
            GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new ByteWritable(4)), new GenericUDF.DeferredJavaObject(null)};
            PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
            Assert.assertEquals((Object)TypeInfoFactory.intervalDayTimeTypeInfo, (Object)oi.getTypeInfo());
            HiveIntervalDayTimeWritable res = (HiveIntervalDayTimeWritable)udf.evaluate(args);
            Assert.assertEquals(null, (Object)res);
        }
    }
}

