/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.junit.Assert;
import org.junit.Test;

public class TestDateTimeMath {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampIntervalYearMonthArithmetic() throws Exception {
        char plus = '+';
        char minus = '-';
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", plus, "0-0", "2001-01-01 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.456", plus, "1-1", "2002-02-01 01:02:03.456");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.456", plus, "10-0", "2011-01-01 01:02:03.456");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.456", plus, "0-11", "2001-12-01 01:02:03.456");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-03-01 01:02:03.500", plus, "1-11", "2003-02-01 01:02:03.500");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.500", plus, "-1-1", "1999-12-01 01:02:03.500");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.500", plus, "-0-0", "2001-01-01 01:02:03.500");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.123456789", plus, "-0-0", "2001-01-01 01:02:03.123456789");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", minus, "0-0", "2001-01-01 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", minus, "10-0", "1991-01-01 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", minus, "-10-0", "2011-01-01 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", minus, "8-2", "1992-11-01 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", minus, "-8-2", "2009-03-01 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03.123456789", minus, "8-2", "1992-11-01 01:02:03.123456789");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic(null, plus, "1-1", null);
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", plus, null, null);
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic(null, minus, "1-1", null);
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", minus, null, null);
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-28 01:02:03", plus, "0-1", "2001-02-28 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-29 01:02:03", plus, "0-1", "2001-02-28 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-30 01:02:03", plus, "0-1", "2001-02-28 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-31 01:02:03", plus, "0-1", "2001-02-28 01:02:03");
        TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-02-28 01:02:03", plus, "0-1", "2001-03-28 01:02:03");
        TimeZone originalTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
            TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", plus, "0-6", "2001-07-01 02:02:03");
            TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-07-01 01:02:03", plus, "0-6", "2002-01-01 00:02:03");
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-01-01 01:02:03", plus, "0-6", "2001-07-01 01:02:03");
            TestDateTimeMath.checkTimestampIntervalYearMonthArithmetic("2001-07-01 01:02:03", plus, "0-6", "2002-01-01 01:02:03");
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    @Test
    public void testDateIntervalYearMonthArithmetic() throws Exception {
        char plus = '+';
        char minus = '-';
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", plus, "0-0", "2001-01-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", plus, "0-1", "2001-02-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", plus, "0-6", "2001-07-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", plus, "1-0", "2002-01-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", plus, "1-1", "2002-02-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-10-10", plus, "1-6", "2003-04-10");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2003-04-10", plus, "-1-6", "2001-10-10");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", minus, "0-0", "2001-01-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", minus, "0-1", "2000-12-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", minus, "1-0", "2000-01-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-01", minus, "1-1", "1999-12-01");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-10-10", minus, "1-6", "2000-04-10");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2003-04-10", minus, "-1-6", "2004-10-10");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-28", plus, "0-1", "2001-02-28");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-29", plus, "0-1", "2001-02-28");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-30", plus, "0-1", "2001-02-28");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-31", plus, "0-1", "2001-02-28");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-01-31", plus, "0-2", "2001-03-31");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2001-02-28", plus, "0-1", "2001-03-28");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2004-01-28", plus, "0-1", "2004-02-28");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2004-01-29", plus, "0-1", "2004-02-29");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2004-01-30", plus, "0-1", "2004-02-29");
        TestDateTimeMath.checkDateIntervalDayTimeArithmetic("2004-01-31", plus, "0-1", "2004-02-29");
    }

    @Test
    public void testIntervalYearMonthArithmetic() throws Exception {
        char plus = '+';
        char minus = '-';
        TestDateTimeMath.checkIntervalYearMonthArithmetic("0-0", plus, "0-0", "0-0");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("0-0", plus, "4-5", "4-5");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("4-5", plus, "0-0", "4-5");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("0-0", plus, "1-1", "1-1");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("1-1", plus, "0-0", "1-1");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("0-0", minus, "0-0", "0-0");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("0-0", minus, "1-0", "-1-0");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("1-2", minus, "1-1", "0-1");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("0-0", minus, "1-1", "-1-1");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("-1-1", minus, "1-1", "-2-2");
        TestDateTimeMath.checkIntervalYearMonthArithmetic("-1-1", minus, "-1-1", "0-0");
        TestDateTimeMath.checkIntervalYearMonthArithmetic(null, plus, "1-1", null);
        TestDateTimeMath.checkIntervalYearMonthArithmetic("1-1", plus, null, null);
        TestDateTimeMath.checkIntervalYearMonthArithmetic(null, minus, "1-1", null);
        TestDateTimeMath.checkIntervalYearMonthArithmetic("1-1", minus, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampIntervalDayTimeArithmetic() throws Exception {
        char plus = '+';
        char minus = '-';
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03", plus, "1 1:1:1", "2001-01-02 02:03:04");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.456", plus, "1 1:1:1", "2001-01-02 02:03:04.456");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.456", plus, "1 1:1:1.555", "2001-01-02 02:03:05.011");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03", plus, "1 1:1:1.555555555", "2001-01-02 02:03:04.555555555");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.456", plus, "1 1:1:1.555555555", "2001-01-02 02:03:05.011555555");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.500", plus, "1 1:1:1.499", "2001-01-02 02:03:04.999");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.500", plus, "1 1:1:1.500", "2001-01-02 02:03:05.0");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.500", plus, "1 1:1:1.501", "2001-01-02 02:03:05.001");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.500000000", plus, "1 1:1:1.4999999999", "2001-01-02 02:03:04.999999999");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.500000000", plus, "1 1:1:1.500", "2001-01-02 02:03:05.0");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03.500000000", plus, "1 1:1:1.500000001", "2001-01-02 02:03:05.000000001");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03", minus, "0 01:02:03", "2001-01-01 00:00:00");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03", minus, "0 0:0:0", "2001-01-01 01:02:03");
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic(null, plus, "1 1:1:1.555555555", null);
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03", plus, null, null);
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic(null, minus, "1 1:1:1.555555555", null);
        TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2001-01-01 01:02:03", minus, null, null);
        TimeZone originalTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 01:59:58", plus, "0 0:0:01", "2015-03-08 01:59:59");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 01:59:59", plus, "0 0:0:01", "2015-03-08 03:00:00");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 03:00:00", minus, "0 0:0:01", "2015-03-08 01:59:59");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 01:59:59.995", plus, "0 0:0:0.005", "2015-03-08 03:00:00");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 01:59:59.995", plus, "0 0:0:0.0051", "2015-03-08 03:00:00.0001");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 03:00:00", minus, "0 0:0:0.005", "2015-03-08 01:59:59.995");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-11-01 01:59:58", plus, "0 0:0:01", "2015-11-01 01:59:59");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-11-01 01:59:59", plus, "0 0:0:01", "2015-11-01 02:00:00");
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 01:59:58", plus, "0 0:0:01", "2015-03-08 01:59:59");
            TestDateTimeMath.checkTsIntervalDayTimeArithmetic("2015-03-08 01:59:59", plus, "0 0:0:01", "2015-03-08 02:00:00");
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    @Test
    public void testIntervalDayTimeArithmetic() throws Exception {
        char plus = '+';
        char minus = '-';
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0", plus, "0 0:0:0", "0 0:0:0");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 01:02:03", plus, "6 0:0:0.0001", "6 01:02:03.0001");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("6 0:0:0.0001", plus, "0 01:02:03", "6 01:02:03.0001");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 01:02:03", plus, "1 10:10:10.0001", "1 11:12:13.0001");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("1 10:10:10.0001", plus, "0 01:02:03", "1 11:12:13.0001");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0.900000000", plus, "0 0:0:0.099999999", "0 0:0:0.999999999");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0.900000001", plus, "0 0:0:0.099999999", "0 0:0:1");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0.900000002", plus, "0 0:0:0.099999999", "0 0:0:1.000000001");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0", minus, "0 0:0:0", "0 0:0:0");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0", minus, "0 0:0:0.123", "-0 0:0:0.123");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("3 4:5:6.789", minus, "1 1:1:1.111", "2 3:4:5.678");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("0 0:0:0.0", minus, "1 1:1:1.111", "-1 1:1:1.111");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("-1 1:1:1.222", minus, "1 1:1:1.111", "-2 2:2:2.333");
        TestDateTimeMath.checkIntervalDayTimeArithmetic("-1 1:1:1.111", minus, "-1 1:1:1.111", "0 0:0:0");
        TestDateTimeMath.checkIntervalDayTimeArithmetic(null, plus, "1 1:1:1.111", null);
        TestDateTimeMath.checkIntervalDayTimeArithmetic("1 1:1:1.111", plus, null, null);
        TestDateTimeMath.checkIntervalDayTimeArithmetic(null, minus, "1 1:1:1.111", null);
        TestDateTimeMath.checkIntervalDayTimeArithmetic("1 1:1:1.111", minus, null, null);
    }

    @Test
    public void testTimestampSubtraction() throws Exception {
        TestDateTimeMath.checkTsArithmetic("2001-01-01 00:00:00", "2001-01-01 00:00:00", "0 0:0:0");
        TestDateTimeMath.checkTsArithmetic("2002-02-02 01:01:01", "2001-01-01 00:00:00", "397 1:1:1");
        TestDateTimeMath.checkTsArithmetic("2001-01-01 00:00:00", "2002-02-02 01:01:01", "-397 1:1:1");
        TestDateTimeMath.checkTsArithmetic("2015-01-01 00:00:00", "2014-12-31 00:00:00", "1 0:0:0");
        TestDateTimeMath.checkTsArithmetic("2014-12-31 00:00:00", "2015-01-01 00:00:00", "-1 0:0:0");
        TestDateTimeMath.checkTsArithmetic("2015-01-01 00:00:00", "2014-12-31 23:59:59", "0 0:0:01");
        TestDateTimeMath.checkTsArithmetic("2014-12-31 23:59:59", "2015-01-01 00:00:00", "-0 0:0:01");
        TestDateTimeMath.checkTsArithmetic("2015-01-01 00:00:00", "2014-12-31 23:59:59.9999", "0 0:0:00.0001");
        TestDateTimeMath.checkTsArithmetic("2014-12-31 23:59:59.9999", "2015-01-01 00:00:00", "-0 0:0:00.0001");
        TestDateTimeMath.checkTsArithmetic("2015-01-01 00:00:00", "2014-12-31 11:12:13.000000001", "0 12:47:46.999999999");
        TestDateTimeMath.checkTsArithmetic("2014-12-31 11:12:13.000000001", "2015-01-01 00:00:00", "-0 12:47:46.999999999");
        TimeZone originalTz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
            TestDateTimeMath.checkTsArithmetic("1999-12-15 00:00:00", "1999-09-15 00:00:00", "91 1:0:0");
            TestDateTimeMath.checkTsArithmetic("1999-09-15 00:00:00", "1999-12-15 00:00:00", "-91 1:0:0");
            TestDateTimeMath.checkTsArithmetic("1999-12-15 00:00:00", "1995-09-15 00:00:00", "1552 1:0:0");
            TestDateTimeMath.checkTsArithmetic("1995-09-15 00:00:00", "1999-12-15 00:00:00", "-1552 1:0:0");
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            TestDateTimeMath.checkTsArithmetic("1999-12-15 00:00:00", "1999-09-15 00:00:00", "91 0:0:0");
            TestDateTimeMath.checkTsArithmetic("1999-09-15 00:00:00", "1999-12-15 00:00:00", "-91 0:0:0");
            TestDateTimeMath.checkTsArithmetic("1999-12-15 00:00:00", "1995-09-15 00:00:00", "1552 0:0:0");
            TestDateTimeMath.checkTsArithmetic("1995-09-15 00:00:00", "1999-12-15 00:00:00", "-1552 0:0:0");
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    private static void checkTimestampIntervalYearMonthArithmetic(String left, char operationType, String right, String expected) throws Exception {
        Timestamp leftTs = null;
        if (left != null) {
            leftTs = Timestamp.valueOf(left);
        }
        HiveIntervalYearMonth rightInterval = null;
        if (right != null) {
            rightInterval = HiveIntervalYearMonth.valueOf((String)right);
        }
        Timestamp expectedResult = null;
        if (expected != null) {
            expectedResult = Timestamp.valueOf(expected);
        }
        Timestamp testResult = null;
        DateTimeMath dtm = new DateTimeMath();
        switch (operationType) {
            case '-': {
                testResult = dtm.subtract(leftTs, rightInterval);
                break;
            }
            case '+': {
                testResult = dtm.add(leftTs, rightInterval);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation " + operationType);
            }
        }
        Assert.assertEquals((String)String.format("%s %s %s", leftTs, Character.valueOf(operationType), rightInterval), (Object)expectedResult, (Object)testResult);
    }

    private static void checkDateIntervalDayTimeArithmetic(String left, char operationType, String right, String expected) throws Exception {
        Date leftDt = null;
        if (left != null) {
            leftDt = Date.valueOf(left);
        }
        HiveIntervalYearMonth rightInterval = null;
        if (right != null) {
            rightInterval = HiveIntervalYearMonth.valueOf((String)right);
        }
        Date expectedResult = null;
        if (expected != null) {
            expectedResult = Date.valueOf(expected);
        }
        Date testResult = null;
        DateTimeMath dtm = new DateTimeMath();
        switch (operationType) {
            case '-': {
                testResult = dtm.subtract(leftDt, rightInterval);
                break;
            }
            case '+': {
                testResult = dtm.add(leftDt, rightInterval);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation " + operationType);
            }
        }
        Assert.assertEquals((String)String.format("%s %s %s", leftDt, Character.valueOf(operationType), rightInterval), (Object)expectedResult, (Object)testResult);
    }

    private static void checkIntervalYearMonthArithmetic(String left, char operationType, String right, String expected) throws Exception {
        HiveIntervalYearMonth leftInterval = left == null ? null : HiveIntervalYearMonth.valueOf((String)left);
        HiveIntervalYearMonth rightInterval = right == null ? null : HiveIntervalYearMonth.valueOf((String)right);
        HiveIntervalYearMonth expectedResult = expected == null ? null : HiveIntervalYearMonth.valueOf((String)expected);
        HiveIntervalYearMonth testResult = null;
        DateTimeMath dtm = new DateTimeMath();
        switch (operationType) {
            case '-': {
                testResult = dtm.subtract(leftInterval, rightInterval);
                break;
            }
            case '+': {
                testResult = dtm.add(leftInterval, rightInterval);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation " + operationType);
            }
        }
        Assert.assertEquals((String)String.format("%s %s %s", leftInterval, Character.valueOf(operationType), rightInterval), (Object)expectedResult, (Object)testResult);
    }

    private static void checkTsIntervalDayTimeArithmetic(String left, char operationType, String right, String expected) throws Exception {
        Timestamp leftTs = null;
        if (left != null) {
            leftTs = Timestamp.valueOf(left);
        }
        HiveIntervalDayTime rightInterval = right == null ? null : HiveIntervalDayTime.valueOf((String)right);
        Timestamp expectedResult = null;
        if (expected != null) {
            expectedResult = Timestamp.valueOf(expected);
        }
        Timestamp testResult = null;
        DateTimeMath dtm = new DateTimeMath();
        switch (operationType) {
            case '-': {
                testResult = dtm.subtract(leftTs, rightInterval);
                break;
            }
            case '+': {
                testResult = dtm.add(leftTs, rightInterval);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation " + operationType);
            }
        }
        Assert.assertEquals((String)String.format("%s %s %s", leftTs, Character.valueOf(operationType), rightInterval), (Object)expectedResult, (Object)testResult);
    }

    private static void checkIntervalDayTimeArithmetic(String left, char operationType, String right, String expected) throws Exception {
        HiveIntervalDayTime leftInterval = left == null ? null : HiveIntervalDayTime.valueOf((String)left);
        HiveIntervalDayTime rightInterval = right == null ? null : HiveIntervalDayTime.valueOf((String)right);
        HiveIntervalDayTime expectedResult = expected == null ? null : HiveIntervalDayTime.valueOf((String)expected);
        HiveIntervalDayTime testResult = null;
        DateTimeMath dtm = new DateTimeMath();
        switch (operationType) {
            case '-': {
                testResult = dtm.subtract(leftInterval, rightInterval);
                break;
            }
            case '+': {
                testResult = dtm.add(leftInterval, rightInterval);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation " + operationType);
            }
        }
        Assert.assertEquals((String)String.format("%s %s %s", leftInterval, Character.valueOf(operationType), rightInterval), (Object)expectedResult, (Object)testResult);
    }

    private static void checkTsArithmetic(String left, String right, String expected) throws Exception {
        Timestamp leftTs = null;
        if (left != null) {
            leftTs = Timestamp.valueOf(left);
        }
        Timestamp rightTs = null;
        if (left != null) {
            rightTs = Timestamp.valueOf(right);
        }
        HiveIntervalDayTime expectedResult = null;
        if (expected != null) {
            expectedResult = HiveIntervalDayTime.valueOf((String)expected);
        }
        DateTimeMath dtm = new DateTimeMath();
        HiveIntervalDayTime testResult = dtm.subtract(leftTs, rightTs);
        Assert.assertEquals((String)String.format("%s - %s", leftTs, rightTs), (Object)expectedResult, (Object)testResult);
    }
}

