/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

class SqlTimestampAddFunction
extends SqlFunction {
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = new SqlReturnTypeInference(){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            TimeUnit unit = (TimeUnit)((Object)opBinding.getOperandLiteralValue(0));
            switch (unit) {
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case MILLISECOND: 
                case MICROSECOND: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.TIMESTAMP), opBinding.getOperandType(1).isNullable() || opBinding.getOperandType(2).isNullable());
                }
            }
            return opBinding.getOperandType(2);
        }
    };

    SqlTimestampAddFunction() {
        super("TIMESTAMPADD", SqlKind.TIMESTAMP_ADD, RETURN_TYPE_INFERENCE, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
    }
}

