/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.calcite.rel.RelNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ExpressionWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeSubQueryDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCheckProcFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(TypeCheckProcFactory.class.getName());

    protected TypeCheckProcFactory() {
    }

    public static ExprNodeDesc processGByExpr(Node nd, Object procCtx) throws SemanticException {
        ASTNode expr = (ASTNode)nd;
        TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
        if (!ctx.isUseCaching() && ctx.getOuterRR() == null) {
            return null;
        }
        RowResolver input = ctx.getInputRR();
        ExprNodeColumnDesc desc = null;
        if (ctx == null || input == null || !ctx.getAllowGBExprElimination()) {
            return null;
        }
        ColumnInfo colInfo = input.getExpression(expr);
        RowResolver outerRR = ctx.getOuterRR();
        if (colInfo == null && outerRR != null) {
            colInfo = outerRR.getExpression(expr);
        }
        if (colInfo != null) {
            desc = new ExprNodeColumnDesc(colInfo);
            ASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                ctx.getUnparseTranslator().addCopyTranslation(expr, source);
            }
            return desc;
        }
        return desc;
    }

    public static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        return TypeCheckProcFactory.genExprNode(expr, tcCtx, new TypeCheckProcFactory());
    }

    protected static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx, TypeCheckProcFactory tf) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "825%"), tf.getNullExprProcessor());
        opRules.put(new RuleRegExp("R2", "340%|25%|341%"), tf.getNumExprProcessor());
        opRules.put(new RuleRegExp("R3", "24%|352%|702%|939%|%|140%|51%|322%|142%|35%|178%|278%|110%|945%"), tf.getStrExprProcessor());
        opRules.put(new RuleRegExp("R4", "295%|117%"), tf.getBoolExprProcessor());
        opRules.put(new RuleRegExp("R5", "723%|984%"), tf.getDateTimeExprProcessor());
        opRules.put(new RuleRegExp("R6", "796%|789%|794%|792%|787%|790%|791%|793%"), tf.getIntervalExprProcessor());
        opRules.put(new RuleRegExp("R7", "973%"), tf.getColumnExprProcessor());
        opRules.put(new RuleRegExp("R8", "942%"), tf.getSubQueryExprProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(tf.getDefaultExprProcessor(), opRules, tcCtx);
        ExpressionWalker ogw = new ExpressionWalker(disp);
        ArrayList<Node> topNodes = Lists.newArrayList(expr);
        LinkedHashMap<Node, Object> nodeOutputs = new LinkedHashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        return TypeCheckProcFactory.convert(nodeOutputs);
    }

    private static Map<ASTNode, ExprNodeDesc> convert(Map<Node, Object> outputs) {
        LinkedHashMap<ASTNode, ExprNodeDesc> converted = new LinkedHashMap<ASTNode, ExprNodeDesc>();
        for (Map.Entry<Node, Object> entry : outputs.entrySet()) {
            if (entry.getKey() instanceof ASTNode && (entry.getValue() == null || entry.getValue() instanceof ExprNodeDesc)) {
                converted.put((ASTNode)entry.getKey(), (ExprNodeDesc)entry.getValue());
                continue;
            }
            LOG.warn("Invalid type entry " + entry);
        }
        return converted;
    }

    public NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    public NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    public StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    public BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    public IntervalExprProcessor getIntervalExprProcessor() {
        return new IntervalExprProcessor();
    }

    public DateTimeExprProcessor getDateTimeExprProcessor() {
        return new DateTimeExprProcessor();
    }

    private static ExprNodeDesc toExprNodeDesc(ColumnInfo colInfo) {
        ObjectInspector inspector = colInfo.getObjectInspector();
        if (inspector instanceof ConstantObjectInspector && inspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
            Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
            return new ExprNodeConstantDesc(colInfo.getType(), poi.getPrimitiveJavaObject(constant));
        }
        ExprNodeColumnDesc column = new ExprNodeColumnDesc(colInfo);
        column.setSkewedCol(colInfo.isSkewedCol());
        return column;
    }

    public ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    public DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public SubQueryExprProcessor getSubQueryExprProcessor() {
        return new SubQueryExprProcessor();
    }

    public static class SubQueryExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode sqNode = (ASTNode)expr.getParent().getChild(1);
            if (!ctx.getallowSubQueryExpr()) {
                throw new CalciteSubquerySemanticException(SemanticAnalyzer.generateErrorMessage(sqNode, ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Currently SubQuery expressions are only allowed as Where and Having Clause predicates")));
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            assert (((ArrayList)expr.getChildren()).size() == 3 || ((ArrayList)expr.getChildren()).size() == 2);
            assert (expr.getChild(0).getType() == 943);
            ASTNode subqueryOp = (ASTNode)expr.getChild(0);
            boolean isIN = subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 142 || subqueryOp.getChild(0).getType() == 945);
            boolean isEXISTS = subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 110 || subqueryOp.getChild(0).getType() == 944);
            boolean isScalar = subqueryOp.getChildCount() == 0;
            Map<ASTNode, RelNode> subqueryToRelNode = ctx.getSubqueryToRelNode();
            if (subqueryToRelNode == null) {
                throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(" Currently SubQuery expressions are only allowed as Where and Having Clause predicates"));
            }
            RelNode subqueryRel = subqueryToRelNode.get(expr);
            if (isEXISTS) {
                return new ExprNodeSubQueryDesc(TypeInfoFactory.booleanTypeInfo, subqueryRel, ExprNodeSubQueryDesc.SubqueryType.EXISTS);
            }
            if (isIN) {
                assert (nodeOutputs[2] != null);
                ExprNodeDesc lhs = (ExprNodeDesc)nodeOutputs[2];
                return new ExprNodeSubQueryDesc(TypeInfoFactory.booleanTypeInfo, subqueryRel, ExprNodeSubQueryDesc.SubqueryType.IN, lhs);
            }
            if (isScalar) {
                if (subqueryRel.getRowType().getFieldCount() != 1) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("More than one column expression in subquery"));
                }
                TypeInfo subExprType = TypeConverter.convert(subqueryRel.getRowType().getFieldList().get(0).getType());
                return new ExprNodeSubQueryDesc(subExprType, subqueryRel, ExprNodeSubQueryDesc.SubqueryType.SCALAR);
            }
            ctx.setError(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(sqNode, "Currently only IN & EXISTS SubQuery expressions are allowed"), sqNode);
            return null;
        }
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        static HashMap<Integer, String> specialUnaryOperatorTextHashMap = new HashMap();
        static HashMap<Integer, String> specialFunctionTextHashMap;
        static HashMap<Integer, String> conversionFunctionTextHashMap;
        static HashSet<Integer> windowingTokens;

        protected static boolean isRedundantConversionFunction(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children) {
            if (!isFunction) {
                return false;
            }
            if (children.size() != 1) {
                return false;
            }
            String funcText = conversionFunctionTextHashMap.get(((ASTNode)expr.getChild(0)).getType());
            if (funcText == null) {
                return false;
            }
            return ((PrimitiveTypeInfo)children.get(0).getTypeInfo()).getTypeName().equalsIgnoreCase(funcText);
        }

        public static String getFunctionText(ASTNode expr, boolean isFunction) {
            String funcText = null;
            if (!isFunction) {
                if (expr.getChildCount() == 1) {
                    funcText = specialUnaryOperatorTextHashMap.get(expr.getType());
                }
                if (funcText == null) {
                    funcText = expr.getText();
                }
            } else {
                assert (expr.getChildCount() >= 1);
                int funcType = ((ASTNode)expr.getChild(0)).getType();
                funcText = specialFunctionTextHashMap.get(funcType);
                if (funcText == null) {
                    funcText = conversionFunctionTextHashMap.get(funcType);
                }
                if (funcText == null) {
                    funcText = ((ASTNode)expr.getChild(0)).getText();
                }
            }
            return BaseSemanticAnalyzer.unescapeIdentifier(funcText);
        }

        static ExprNodeDesc getFuncExprNodeDescWithUdfData(String udfName, TypeInfo typeInfo, ExprNodeDesc ... children) throws UDFArgumentException {
            FunctionInfo fi;
            try {
                fi = FunctionRegistry.getFunctionInfo(udfName);
            }
            catch (SemanticException e) {
                throw new UDFArgumentException(e);
            }
            if (fi == null) {
                throw new UDFArgumentException(udfName + " not found.");
            }
            GenericUDF genericUDF = fi.getGenericUDF();
            if (genericUDF == null) {
                throw new UDFArgumentException(udfName + " is an aggregation function or a table function.");
            }
            if (typeInfo != null && genericUDF instanceof SettableUDF) {
                ((SettableUDF)((Object)genericUDF)).setTypeInfo(typeInfo);
            }
            ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.length);
            childrenList.addAll(Arrays.asList(children));
            return ExprNodeGenericFuncDesc.newInstance(genericUDF, childrenList);
        }

        public static ExprNodeDesc getFuncExprNodeDesc(String udfName, ExprNodeDesc ... children) throws UDFArgumentException {
            return DefaultExprProcessor.getFuncExprNodeDescWithUdfData(udfName, null, children);
        }

        protected void validateUDF(ASTNode expr, boolean isFunction, TypeCheckCtx ctx, FunctionInfo fi, List<ExprNodeDesc> children, GenericUDF genericUDF) throws SemanticException {
            if (fi.getGenericUDTF() != null) {
                throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
            }
            if (fi.getGenericUDAFResolver() != null) {
                if (isFunction) {
                    throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg((ASTNode)expr.getChild(0)));
                }
                throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg(expr));
            }
            if (!ctx.getAllowStatefulFunctions() && genericUDF != null && FunctionRegistry.isStateful(genericUDF)) {
                throw new SemanticException(ErrorMsg.UDF_STATEFUL_INVALID_LOCATION.getMsg());
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ExprNodeDesc getXpathOrFuncExprNodeDesc(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children, TypeCheckCtx ctx) throws SemanticException, UDFArgumentException {
            void var6_38;
            void var6_36;
            if (DefaultExprProcessor.isRedundantConversionFunction(expr, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = DefaultExprProcessor.getFunctionText(expr, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (children.get(1) instanceof ExprNodeConstantDesc);
                ExprNodeDesc object = children.get(0);
                ExprNodeConstantDesc fieldName = (ExprNodeConstantDesc)children.get(1);
                assert (fieldName.getValue() instanceof String);
                String fieldNameString = (String)fieldName.getValue();
                TypeInfo objectTypeInfo = object.getTypeInfo();
                boolean bl = isList = object.getTypeInfo().getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(ErrorMsg.INVALID_DOT.getMsg(expr));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo(t);
                }
                ExprNodeFieldDesc exprNodeFieldDesc = new ExprNodeFieldDesc(t, children.get(0), fieldNameString, isList);
            } else if (funcText.equals("[")) {
                if (!ctx.getallowIndexExpr()) {
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                }
                assert (children.size() == 2);
                TypeInfo myt = children.get(0).getTypeInfo();
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!TypeInfoUtils.implicitConvertible(children.get(1).getTypeInfo(), TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_ARRAYINDEX_TYPE.getMsg()));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(ErrorMsg.NON_COLLECTION_TYPE.getMsg(expr, myt.getTypeName()));
                    if (!TypeInfoUtils.implicitConvertible(children.get(1).getTypeInfo(), ((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(ErrorMsg.INVALID_MAPINDEX_TYPE.getMsg(expr));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                }
            } else {
                ExprNodeDesc constantExpr;
                void var6_34;
                FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcText);
                if (fi == null) {
                    if (!isFunction) throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg((ASTNode)expr.getChild(0)));
                }
                GenericUDF genericUDF = fi.getGenericUDF();
                if (!fi.isNative()) {
                    ctx.getUnparseTranslator().addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (isFunction) {
                    ASTNode funcNameNode = (ASTNode)expr.getChild(0);
                    switch (funcNameNode.getType()) {
                        case 701: {
                            CharTypeInfo charTypeInfo = ParseUtils.getCharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(charTypeInfo);
                            break;
                        }
                        case 1009: {
                            VarcharTypeInfo varcharTypeInfo = ParseUtils.getVarcharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(varcharTypeInfo);
                            break;
                        }
                        case 727: {
                            DecimalTypeInfo decTypeInfo = ParseUtils.getDecimalTypeTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(decTypeInfo);
                            break;
                        }
                    }
                }
                this.validateUDF(expr, isFunction, ctx, fi, children, genericUDF);
                if (genericUDF instanceof GenericUDFBaseCompare && children.size() == 2 && (children.get(0) instanceof ExprNodeConstantDesc && children.get(1) instanceof ExprNodeColumnDesc || children.get(0) instanceof ExprNodeColumnDesc && children.get(1) instanceof ExprNodeConstantDesc)) {
                    PrimitiveTypeInfo colTypeInfo;
                    String constType;
                    int constIdx;
                    block55: {
                        constIdx = children.get(0) instanceof ExprNodeConstantDesc ? 0 : 1;
                        constType = children.get(constIdx).getTypeString().toLowerCase();
                        String columnType = children.get(1 - constIdx).getTypeString().toLowerCase();
                        colTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo(columnType);
                        Object constVal = ((ExprNodeConstantDesc)children.get(constIdx)).getValue();
                        try {
                            if (PrimitiveObjectInspectorUtils.intTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, new ExprNodeConstantDesc(new Integer(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.longTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, new ExprNodeConstantDesc(new Long(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, new ExprNodeConstantDesc(new Double(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, new ExprNodeConstantDesc(new Float(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.byteTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, new ExprNodeConstantDesc(new Byte(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.shortTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, new ExprNodeConstantDesc(new Short(constVal.toString())));
                            }
                        }
                        catch (NumberFormatException nfe) {
                            LOG.trace("Failed to narrow type of constant", nfe);
                            if (!(genericUDF instanceof GenericUDFOPEqual) || NumberUtils.isNumber(constVal.toString())) break block55;
                            return new ExprNodeConstantDesc(false);
                        }
                    }
                    if (constType.equalsIgnoreCase("string") && colTypeInfo instanceof CharTypeInfo) {
                        Object originalValue = ((ExprNodeConstantDesc)children.get(constIdx)).getValue();
                        String constValue = originalValue.toString();
                        int length = TypeInfoUtils.getCharacterLengthForType(colTypeInfo);
                        HiveChar newValue = new HiveChar(constValue, length);
                        children.set(constIdx, new ExprNodeConstantDesc(colTypeInfo, newValue));
                    }
                }
                if (genericUDF instanceof GenericUDFOPOr) {
                    ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.size());
                    for (ExprNodeDesc child : children) {
                        if (FunctionRegistry.isOpOr(child)) {
                            childrenList.addAll(child.getChildren());
                            continue;
                        }
                        childrenList.add(child);
                    }
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, childrenList);
                } else if (genericUDF instanceof GenericUDFOPAnd) {
                    ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.size());
                    for (ExprNodeDesc child : children) {
                        if (FunctionRegistry.isOpAnd(child)) {
                            childrenList.addAll(child.getChildren());
                            continue;
                        }
                        childrenList.add(child);
                    }
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, childrenList);
                } else if (ctx.isFoldExpr() && this.canConvertIntoNvl(genericUDF, children)) {
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(new GenericUDFNvl(), Lists.newArrayList(children.get(0), new ExprNodeConstantDesc(false)));
                    if (Boolean.FALSE.equals(((ExprNodeConstantDesc)children.get(1)).getValue())) {
                        ExprNodeGenericFuncDesc exprNodeGenericFuncDesc2 = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPNot(), Lists.newArrayList(exprNodeGenericFuncDesc));
                    }
                } else {
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, children);
                }
                if (ctx.isFoldExpr() && var6_34 instanceof ExprNodeGenericFuncDesc && FunctionRegistry.isDeterministic(genericUDF) && ExprNodeDescUtils.isAllConstants(children) && (constantExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)var6_34)) != null) {
                    ExprNodeDesc exprNodeDesc = constantExpr;
                }
            }
            if (FunctionRegistry.isOpPositive((ExprNodeDesc)var6_36)) {
                assert (var6_36.getChildren().size() == 1);
                ExprNodeDesc exprNodeDesc = var6_36.getChildren().get(0);
            }
            assert (var6_38 != null);
            return var6_38;
        }

        private boolean canConvertIntoNvl(GenericUDF genericUDF, ArrayList<ExprNodeDesc> children) {
            if (genericUDF instanceof GenericUDFWhen && children.size() == 3 && children.get(1) instanceof ExprNodeConstantDesc && children.get(2) instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constThen = (ExprNodeConstantDesc)children.get(1);
                ExprNodeConstantDesc constElse = (ExprNodeConstantDesc)children.get(2);
                Object thenVal = constThen.getValue();
                Object elseVal = constElse.getValue();
                if (thenVal instanceof Boolean && elseVal instanceof Boolean) {
                    return true;
                }
            }
            return false;
        }

        private boolean isDescendant(Node ans, Node des) {
            if (ans.getChildren() == null) {
                return false;
            }
            for (Node node : ans.getChildren()) {
                if (node == des) {
                    return true;
                }
                if (!this.isDescendant(node, des)) continue;
                return true;
            }
            return false;
        }

        protected ExprNodeDesc processQualifiedColRef(TypeCheckCtx ctx, ASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String colName;
            RowResolver input = ctx.getInputRR();
            String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            if (nodeOutputs[1] instanceof ExprNodeConstantDesc) {
                colName = ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString();
            } else if (nodeOutputs[1] instanceof ExprNodeColumnDesc) {
                colName = ((ExprNodeColumnDesc)nodeOutputs[1]).getColumn();
            } else {
                throw new SemanticException("Unexpected ExprNode : " + nodeOutputs[1]);
            }
            ColumnInfo colInfo = input.get(tableAlias, colName);
            if (colInfo == null && ctx.getOuterRR() != null) {
                RowResolver outerRR = ctx.getOuterRR();
                colInfo = outerRR.get(tableAlias, colName);
            }
            if (colInfo == null) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(1)), expr);
                return null;
            }
            return TypeCheckProcFactory.toExprNodeDesc(colInfo);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean isFunction;
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                if (this.isDescendant(nd, ctx.getErrorSrcNode())) {
                    ctx.setError(null, null);
                }
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            if (windowingTokens.contains(expr.getType())) {
                if (!ctx.getallowWindowing()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_FUNCTION.getMsg("Windowing is not supported in the context")));
                }
                return null;
            }
            if (expr.getType() == 943 || expr.getType() == 876) {
                return null;
            }
            if (expr.getType() == 976) {
                return null;
            }
            if (expr.getType() == 651) {
                if (!ctx.getallowAllColRef()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg("All column reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                ExprNodeColumnListDesc columnList = new ExprNodeColumnListDesc();
                assert (expr.getChildCount() <= 1);
                if (expr.getChildCount() == 1) {
                    ASTNode child = (ASTNode)expr.getChild(0);
                    assert (child.getType() == 976);
                    assert (child.getChildCount() == 1);
                    String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    LinkedHashMap<String, ColumnInfo> columns = input.getFieldMap(tableAlias);
                    if (columns == null) {
                        throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(child));
                    }
                    for (Map.Entry colMap : ((HashMap)columns).entrySet()) {
                        ColumnInfo colInfo = (ColumnInfo)colMap.getValue();
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                } else {
                    for (ColumnInfo colInfo : input.getColumnInfos()) {
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                }
                return columnList;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 973 && nodeOutputs[0] == null) {
                return this.processQualifiedColRef(ctx, expr, nodeOutputs);
            }
            if (conversionFunctionTextHashMap.keySet().contains(expr.getType()) || specialFunctionTextHashMap.keySet().contains(expr.getType()) || expr.getToken().getType() == 12 || expr.getToken().getType() == 11) {
                return null;
            }
            boolean bl = isFunction = expr.getType() == 763 || expr.getType() == 765 || expr.getType() == 764;
            if (!ctx.getAllowDistinctFunctions() && expr.getType() == 764) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.DISTINCT_NOT_SUPPORTED.getMsg()));
            }
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                if (nodeOutputs[ci] instanceof ExprNodeColumnListDesc) {
                    children.addAll(((ExprNodeColumnListDesc)nodeOutputs[ci]).getChildren());
                    continue;
                }
                children.add((ExprNodeDesc)nodeOutputs[ci]);
            }
            if (expr.getType() == 765) {
                if (!ctx.getallowFunctionStar()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg(".* reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                for (ColumnInfo colInfo : input.getColumnInfos()) {
                    if (colInfo.getIsVirtualCol()) continue;
                    children.add(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                }
            }
            if (children.contains(null)) {
                List<String> possibleColumnNames = this.getReferenceableColumnAliases(ctx);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, ", "));
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(0), reason), expr);
                return null;
            }
            try {
                return this.getXpathOrFuncExprNodeDesc(expr, isFunction, children, ctx);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_TYPE.getMsg(expr.getChild(childrenBegin + e.getArgumentId()), e.getMessage()), e);
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_LENGTH.getMsg(expr, e.getMessage()), e);
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT.getMsg(expr, e.getMessage()), e);
            }
        }

        protected List<String> getReferenceableColumnAliases(TypeCheckCtx ctx) {
            return ctx.getInputRR().getReferenceableColumnAliases(null, -1);
        }

        static {
            specialUnaryOperatorTextHashMap.put(342, "positive");
            specialUnaryOperatorTextHashMap.put(337, "negative");
            specialFunctionTextHashMap = new HashMap();
            specialFunctionTextHashMap.put(798, "isnull");
            specialFunctionTextHashMap.put(797, "isnotnull");
            conversionFunctionTextHashMap = new HashMap();
            conversionFunctionTextHashMap.put(698, "boolean");
            conversionFunctionTextHashMap.put(985, "tinyint");
            conversionFunctionTextHashMap.put(933, "smallint");
            conversionFunctionTextHashMap.put(784, "int");
            conversionFunctionTextHashMap.put(695, "bigint");
            conversionFunctionTextHashMap.put(759, "float");
            conversionFunctionTextHashMap.put(739, "double");
            conversionFunctionTextHashMap.put(938, "string");
            conversionFunctionTextHashMap.put(701, "char");
            conversionFunctionTextHashMap.put(1009, "varchar");
            conversionFunctionTextHashMap.put(696, "binary");
            conversionFunctionTextHashMap.put(722, "date");
            conversionFunctionTextHashMap.put(983, "timestamp");
            conversionFunctionTextHashMap.put(795, "interval_year_month");
            conversionFunctionTextHashMap.put(788, "interval_day_time");
            conversionFunctionTextHashMap.put(727, "decimal");
            windowingTokens = new HashSet();
            windowingTokens.add(208);
            windowingTokens.add(853);
            windowingTokens.add(738);
            windowingTokens.add(934);
            windowingTokens.add(703);
            windowingTokens.add(1016);
            windowingTokens.add(1015);
            windowingTokens.add(1017);
            windowingTokens.add(298);
            windowingTokens.add(217);
            windowingTokens.add(125);
            windowingTokens.add(73);
            windowingTokens.add(978);
            windowingTokens.add(979);
            windowingTokens.add(826);
            windowingTokens.add(827);
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
            RowResolver input = ctx.getInputRR();
            if (expr.getType() != 973) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean isTableAlias = input.hasTableAlias(tableOrCol);
            ColumnInfo colInfo = input.get(null, tableOrCol);
            if (ctx.getOuterRR() != null && colInfo == null && !isTableAlias) {
                RowResolver outerRR = ctx.getOuterRR();
                isTableAlias = outerRR.hasTableAlias(tableOrCol);
                colInfo = outerRR.get(null, tableOrCol);
            }
            if (isTableAlias) {
                if (colInfo != null) {
                    if (parent != null && parent.getType() == 16) {
                        return null;
                    }
                    return TypeCheckProcFactory.toExprNodeDesc(colInfo);
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    ASTNode exprNode = expr;
                    if (!stack.empty()) {
                        ASTNode tmp = (ASTNode)stack.pop();
                        if (!stack.empty()) {
                            exprNode = (ASTNode)stack.peek();
                        }
                        stack.push(tmp);
                    }
                    ctx.setError(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(exprNode), expr);
                    return null;
                }
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(tableOrCol, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, ", "));
                ctx.setError(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(expr.getChild(0), reason), expr);
                LOG.debug(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString());
                return null;
            }
            return TypeCheckProcFactory.toExprNodeDesc(colInfo);
        }
    }

    public static class IntervalExprProcessor
    implements NodeProcessor {
        private static final BigDecimal NANOS_PER_SEC_BD = new BigDecimal(1000000000);

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String intervalString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                switch (expr.getType()) {
                    case 796: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, HiveIntervalYearMonth.valueOf(intervalString));
                    }
                    case 789: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, HiveIntervalDayTime.valueOf(intervalString));
                    }
                    case 794: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(Integer.parseInt(intervalString), 0));
                    }
                    case 792: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(0, Integer.parseInt(intervalString)));
                    }
                    case 787: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(Integer.parseInt(intervalString), 0, 0, 0, 0));
                    }
                    case 790: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, Integer.parseInt(intervalString), 0, 0, 0));
                    }
                    case 791: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, Integer.parseInt(intervalString), 0, 0));
                    }
                    case 793: {
                        BigDecimal bd = new BigDecimal(intervalString);
                        BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
                        BigDecimal bdNanos = bd.subtract(bdSeconds);
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue()));
                    }
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert interval literal '" + intervalString + "' to interval value.", err);
            }
        }
    }

    public static class DateTimeExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String timeString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                if (expr.getType() == 723) {
                    PrimitiveTypeInfo typeInfo = TypeInfoFactory.dateTypeInfo;
                    return new ExprNodeConstantDesc(typeInfo, Date.valueOf(timeString));
                }
                if (expr.getType() == 984) {
                    return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, Timestamp.valueOf(timeString));
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert time literal '" + timeString + "' to time value.", err);
            }
        }
    }

    public static class BoolExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            Boolean bool = null;
            switch (expr.getToken().getType()) {
                case 295: {
                    bool = Boolean.TRUE;
                    break;
                }
                case 117: {
                    bool = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, bool);
        }
    }

    public static class StrExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String str = null;
            switch (expr.getToken().getType()) {
                case 352: {
                    str = BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 939: {
                    StringBuilder sb = new StringBuilder();
                    for (Node n : expr.getChildren()) {
                        sb.append(BaseSemanticAnalyzer.unescapeSQLString(((ASTNode)n).getText()));
                    }
                    str = sb.toString();
                    break;
                }
                case 702: {
                    str = BaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    break;
                }
                default: {
                    str = BaseSemanticAnalyzer.unescapeIdentifier(expr.getText().toLowerCase());
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str);
        }
    }

    public static class NumExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Number v = null;
            ExprNodeConstantDesc decimalNode = null;
            ASTNode expr = (ASTNode)nd;
            try {
                if (expr.getText().endsWith("L")) {
                    v = Long.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("S")) {
                    v = Short.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("Y")) {
                    v = Byte.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else {
                    if (expr.getText().endsWith("BD")) {
                        String strVal = expr.getText().substring(0, expr.getText().length() - 2);
                        return NumExprProcessor.createDecimal(strVal, false);
                    }
                    if (expr.getText().endsWith("D")) {
                        v = Double.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                    } else {
                        v = Double.valueOf(expr.getText());
                        if (expr.getText() != null && !expr.getText().toLowerCase().contains("e") && (decimalNode = NumExprProcessor.createDecimal(expr.getText(), true)) != null) {
                            v = null;
                        }
                        v = Long.valueOf(expr.getText());
                        v = Integer.valueOf(expr.getText());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (v == null && decimalNode == null) {
                throw new SemanticException(ErrorMsg.INVALID_NUMERICAL_CONSTANT.getMsg(expr));
            }
            return v != null ? new ExprNodeConstantDesc(v) : decimalNode;
        }

        public static ExprNodeConstantDesc createDecimal(String strVal, boolean notNull) {
            HiveDecimal hd = HiveDecimal.create(strVal);
            if (notNull && hd == null) {
                return null;
            }
            int prec = 1;
            int scale = 0;
            if (hd != null) {
                prec = hd.precision();
                scale = hd.scale();
            }
            DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo(prec, scale);
            return new ExprNodeConstantDesc(typeInfo, hd);
        }
    }

    public static class NullExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(NullWritable.class), null);
        }
    }
}

