/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;

public class SubmitWorkInfo
implements Writable {
    private ApplicationId fakeAppId;
    private long creationTime;
    private byte[] vertexSpec;
    private byte[] vertexSpecSignature;
    private Token<JobTokenIdentifier> token;
    private int vertexParallelism;

    public SubmitWorkInfo(ApplicationId fakeAppId, long creationTime, int vertexParallelism, byte[] vertexSpec, byte[] vertexSpecSignature) {
        this.fakeAppId = fakeAppId;
        this.token = this.createJobToken();
        this.creationTime = creationTime;
        this.vertexSpec = vertexSpec;
        this.vertexSpecSignature = vertexSpecSignature;
        this.vertexParallelism = vertexParallelism;
    }

    public SubmitWorkInfo() {
    }

    public ApplicationId getFakeAppId() {
        return this.fakeAppId;
    }

    public String getTokenIdentifier() {
        return this.fakeAppId.toString();
    }

    public Token<JobTokenIdentifier> getToken() {
        return this.token;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.fakeAppId.getClusterTimestamp());
        out.writeInt(this.fakeAppId.getId());
        this.token.write(out);
        out.writeLong(this.creationTime);
        out.writeInt(this.vertexParallelism);
        if (this.vertexSpec != null) {
            out.writeInt(this.vertexSpec.length);
            out.write(this.vertexSpec);
        } else {
            out.writeInt(0);
        }
        if (this.vertexSpecSignature != null) {
            out.writeInt(this.vertexSpecSignature.length);
            out.write(this.vertexSpecSignature);
        } else {
            out.writeInt(0);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int vertexSpecSignBytes;
        long appIdTs = in.readLong();
        int appIdId = in.readInt();
        this.fakeAppId = ApplicationId.newInstance((long)appIdTs, (int)appIdId);
        this.token = new Token();
        this.token.readFields(in);
        this.creationTime = in.readLong();
        this.vertexParallelism = in.readInt();
        int vertexSpecBytes = in.readInt();
        if (vertexSpecBytes > 0) {
            this.vertexSpec = new byte[vertexSpecBytes];
            in.readFully(this.vertexSpec);
        }
        if ((vertexSpecSignBytes = in.readInt()) > 0) {
            this.vertexSpecSignature = new byte[vertexSpecSignBytes];
            in.readFully(this.vertexSpecSignature);
        }
    }

    public static byte[] toBytes(SubmitWorkInfo submitWorkInfo) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        submitWorkInfo.write((DataOutput)dob);
        return dob.getData();
    }

    public static SubmitWorkInfo fromBytes(byte[] submitWorkInfoBytes) throws IOException {
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(submitWorkInfoBytes, 0, submitWorkInfoBytes.length);
        SubmitWorkInfo submitWorkInfo = new SubmitWorkInfo();
        submitWorkInfo.readFields((DataInput)dib);
        return submitWorkInfo;
    }

    private Token<JobTokenIdentifier> createJobToken() {
        String tokenIdentifier = this.fakeAppId.toString();
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(tokenIdentifier));
        Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)new JobTokenSecretManager());
        sessionToken.setService(identifier.getJobId());
        return sessionToken;
    }

    public byte[] getVertexBinary() {
        return this.vertexSpec;
    }

    public byte[] getVertexSignature() {
        return this.vertexSpecSignature;
    }

    public int getVertexParallelism() {
        return this.vertexParallelism;
    }
}

