/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.AggAddContext;
import org.apache.calcite.adapter.enumerable.AggContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggResetContext;
import org.apache.calcite.adapter.enumerable.AggResultContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.StrictAggImplementor;
import org.apache.calcite.adapter.enumerable.StrictWinAggImplementor;
import org.apache.calcite.adapter.enumerable.WinAggAddContext;
import org.apache.calcite.adapter.enumerable.WinAggContext;
import org.apache.calcite.adapter.enumerable.WinAggImplementor;
import org.apache.calcite.adapter.enumerable.WinAggResultContext;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.OptimizeVisitor;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ImplementableAggFunction;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.hive.com.google.common.base.Supplier;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.Maps;

public class RexImpTable {
    public static final ConstantExpression NULL_EXPR = Expressions.constant(null);
    public static final ConstantExpression FALSE_EXPR = Expressions.constant(false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant(true);
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, "FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, "TRUE");
    private final Map<SqlOperator, CallImplementor> map = new HashMap<SqlOperator, CallImplementor>();
    private final Map<SqlAggFunction, Supplier<? extends AggImplementor>> aggMap = Maps.newHashMap();
    private final Map<SqlAggFunction, Supplier<? extends WinAggImplementor>> winAggMap = Maps.newHashMap();
    public static final RexImpTable INSTANCE = new RexImpTable();

    RexImpTable() {
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROW, BuiltInMethod.ARRAY.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltInMethod.UPPER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltInMethod.LOWER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltInMethod.INITCAP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltInMethod.SUBSTRING.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)OracleSqlOperatorTable.TRANSLATE3, BuiltInMethod.TRANSLATE3.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CONCAT, BuiltInMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltInMethod.OVERLAY.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltInMethod.POSITION.method, NullPolicy.STRICT);
        TrimImplementor trimImplementor = new TrimImplementor();
        this.defineImplementor(SqlStdOperatorTable.TRIM, NullPolicy.STRICT, trimImplementor, false);
        this.defineBinary(SqlStdOperatorTable.AND, ExpressionType.AndAlso, NullPolicy.AND, null);
        this.defineBinary(SqlStdOperatorTable.OR, ExpressionType.OrElse, NullPolicy.OR, null);
        this.defineUnary(SqlStdOperatorTable.NOT, ExpressionType.Not, NullPolicy.NOT);
        this.defineBinary(SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
        this.defineBinary(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
        this.defineBinary(SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
        this.defineBinary(SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
        this.defineBinary(SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
        this.defineBinary(SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
        this.defineBinary(SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
        this.defineBinary(SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineBinary(SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineUnary(SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT);
        this.defineUnary(SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, "mod", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, "exp", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, "power", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LN, "ln", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOG10, "log10", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, "abs", NullPolicy.STRICT);
        this.defineImplementor(SqlStdOperatorTable.DATETIME_PLUS, NullPolicy.STRICT, new DatetimeArithmeticImplementor(), false);
        this.defineImplementor(SqlStdOperatorTable.MINUS_DATE, NullPolicy.STRICT, new DatetimeArithmeticImplementor(), false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, BuiltInMethod.UNIX_DATE_EXTRACT.method, NullPolicy.STRICT);
        this.defineImplementor(SqlStdOperatorTable.FLOOR, NullPolicy.STRICT, new FloorImplementor(BuiltInMethod.FLOOR.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_FLOOR.method, BuiltInMethod.UNIX_DATE_FLOOR.method), false);
        this.defineImplementor(SqlStdOperatorTable.CEIL, NullPolicy.STRICT, new FloorImplementor(BuiltInMethod.CEIL.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_CEIL.method, BuiltInMethod.UNIX_DATE_CEIL.method), false);
        this.map.put(SqlStdOperatorTable.IS_NULL, new IsXxxImplementor(null, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_NULL, new IsXxxImplementor(null, true));
        this.map.put(SqlStdOperatorTable.IS_TRUE, new IsXxxImplementor(true, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_TRUE, new IsXxxImplementor(true, true));
        this.map.put(SqlStdOperatorTable.IS_FALSE, new IsXxxImplementor(false, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_FALSE, new IsXxxImplementor(false, true));
        MethodImplementor likeImplementor = new MethodImplementor(BuiltInMethod.LIKE.method);
        this.defineImplementor(SqlStdOperatorTable.LIKE, NullPolicy.STRICT, likeImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_LIKE, NullPolicy.STRICT, NotImplementor.of(likeImplementor), false);
        MethodImplementor similarImplementor = new MethodImplementor(BuiltInMethod.SIMILAR.method);
        this.defineImplementor(SqlStdOperatorTable.SIMILAR_TO, NullPolicy.STRICT, similarImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_SIMILAR_TO, NullPolicy.STRICT, NotImplementor.of(similarImplementor), false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CARDINALITY, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SLICE, BuiltInMethod.SLICE.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ELEMENT, BuiltInMethod.ELEMENT.method, NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.CASE, new CaseImplementor());
        this.map.put(SqlStdOperatorTable.CAST, new CastOptimizedImplementor());
        this.defineImplementor(SqlStdOperatorTable.REINTERPRET, NullPolicy.STRICT, new ReinterpretImplementor(), false);
        ValueConstructorImplementor value = new ValueConstructorImplementor();
        this.map.put(SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ITEM, new ItemImplementor());
        this.map.put(SqlStdOperatorTable.DEFAULT, new CallImplementor(){

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                return Expressions.constant(null);
            }
        });
        this.defineImplementor(SqlStdOperatorTable.CURRENT_VALUE, NullPolicy.STRICT, new SequenceImplementor(BuiltInMethod.SEQUENCE_CURRENT_VALUE.method), false);
        this.defineImplementor(SqlStdOperatorTable.NEXT_VALUE, NullPolicy.STRICT, new SequenceImplementor(BuiltInMethod.SEQUENCE_NEXT_VALUE.method), false);
        SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
        this.map.put(SqlStdOperatorTable.USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SESSION_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SYSTEM_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_PATH, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_ROLE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
        this.aggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM0, this.constructorSupplier(SumImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM, this.constructorSupplier(SumImplementor.class));
        Supplier<MinMaxImplementor> minMax = this.constructorSupplier(MinMaxImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.MIN, minMax);
        this.aggMap.put(SqlStdOperatorTable.MAX, minMax);
        this.aggMap.put(SqlStdOperatorTable.SINGLE_VALUE, this.constructorSupplier(SingleValueImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.COLLECT, this.constructorSupplier(CollectImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.RANK, this.constructorSupplier(RankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.DENSE_RANK, this.constructorSupplier(DenseRankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.ROW_NUMBER, this.constructorSupplier(RowNumberImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.FIRST_VALUE, this.constructorSupplier(FirstValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAST_VALUE, this.constructorSupplier(LastValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LEAD, this.constructorSupplier(LeadImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAG, this.constructorSupplier(LagImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.NTILE, this.constructorSupplier(NtileImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountWinImplementor.class));
    }

    private <T> Supplier<T> constructorSupplier(Class<T> klass) {
        Constructor<T> constructor;
        try {
            constructor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(klass + " should implement zero arguments constructor");
        }
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
                }
            }
        };
    }

    private void defineImplementor(SqlOperator operator, NullPolicy nullPolicy, NotNullImplementor implementor, boolean harmonize) {
        CallImplementor callImplementor = RexImpTable.createImplementor(implementor, nullPolicy, harmonize);
        this.map.put(operator, callImplementor);
    }

    private static RexCall call2(boolean harmonize, RexToLixTranslator translator, RexCall call) {
        if (!harmonize) {
            return call;
        }
        List<RexNode> operands2 = RexImpTable.harmonize(translator, call.getOperands());
        if (operands2.equals(call.getOperands())) {
            return call;
        }
        return call.clone(call.getType(), operands2);
    }

    public static CallImplementor createImplementor(final NotNullImplementor implementor, final NullPolicy nullPolicy, final boolean harmonize) {
        switch (nullPolicy) {
            case ANY: 
            case STRICT: {
                return new CallImplementor(){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        return RexImpTable.implementNullSemantics0(translator, call, nullAs, nullPolicy, harmonize, implementor);
                    }
                };
            }
            case AND: {
                return new CallImplementor(){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        assert (call.getOperator() == SqlStdOperatorTable.AND) : "AND null semantics is supported only for AND operator. Actual operator is " + String.valueOf(call.getOperator());
                        RexCall call2 = RexImpTable.call2(false, translator, call);
                        switch (nullAs) {
                            case NOT_POSSIBLE: 
                            case TRUE: 
                            case FALSE: {
                                List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs);
                                return Expressions.foldAnd(expressions);
                            }
                            case NULL: 
                            case IS_NULL: 
                            case IS_NOT_NULL: {
                                List<Expression> nullAsTrue = translator.translateList(call2.getOperands(), NullAs.TRUE);
                                List<Expression> nullAsIsNull = translator.translateList(call2.getOperands(), NullAs.IS_NULL);
                                UnaryExpression hasFalse = Expressions.not(Expressions.foldAnd(nullAsTrue));
                                Expression hasNull = Expressions.foldOr(nullAsIsNull);
                                Expression result = nullAs.handle(Expressions.condition(hasFalse, BOXED_FALSE_EXPR, Expressions.condition(hasNull, NULL_EXPR, BOXED_TRUE_EXPR)));
                                return result;
                            }
                        }
                        throw new IllegalArgumentException("Unknown nullAs when implementing AND: " + (Object)((Object)nullAs));
                    }
                };
            }
            case OR: {
                return new CallImplementor(){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        assert (call.getOperator() == SqlStdOperatorTable.OR) : "OR null semantics is supported only for OR operator. Actual operator is " + String.valueOf(call.getOperator());
                        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
                        switch (nullAs) {
                            case NOT_POSSIBLE: 
                            case TRUE: 
                            case FALSE: {
                                List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs);
                                return Expressions.foldOr(expressions);
                            }
                            case NULL: 
                            case IS_NULL: 
                            case IS_NOT_NULL: {
                                List<Expression> nullAsFalse = translator.translateList(call2.getOperands(), NullAs.FALSE);
                                List<Expression> nullAsIsNull = translator.translateList(call2.getOperands(), NullAs.IS_NULL);
                                Expression hasTrue = Expressions.foldOr(nullAsFalse);
                                Expression hasNull = Expressions.foldOr(nullAsIsNull);
                                Expression result = nullAs.handle(Expressions.condition(hasTrue, BOXED_TRUE_EXPR, Expressions.condition(hasNull, NULL_EXPR, BOXED_FALSE_EXPR)));
                                return result;
                            }
                        }
                        throw new IllegalArgumentException("Unknown nullAs when implementing OR: " + (Object)((Object)nullAs));
                    }
                };
            }
            case NOT: {
                return new CallImplementor(){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        switch (nullAs) {
                            case NULL: {
                                return Expressions.call(BuiltInMethod.NOT.method, translator.translateList(call.getOperands(), nullAs));
                            }
                        }
                        return Expressions.not(translator.translate(call.getOperands().get(0), this.negate(nullAs)));
                    }

                    private NullAs negate(NullAs nullAs) {
                        switch (nullAs) {
                            case FALSE: {
                                return NullAs.TRUE;
                            }
                            case TRUE: {
                                return NullAs.FALSE;
                            }
                        }
                        return nullAs;
                    }
                };
            }
            case NONE: {
                return new CallImplementor(){

                    @Override
                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(false, translator, call);
                        return RexImpTable.implementCall(translator, call2, implementor, nullAs);
                    }
                };
            }
        }
        throw new AssertionError((Object)nullPolicy);
    }

    private void defineMethod(SqlOperator operator, String functionName, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodNameImplementor(functionName), false);
    }

    private void defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodImplementor(method), false);
    }

    private void defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new UnaryImplementor(expressionType), false);
    }

    private void defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.defineImplementor(operator, nullPolicy, new BinaryImplementor(expressionType, backupMethodName), true);
    }

    public CallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            Function udf = ((SqlUserDefinedFunction)operator).getFunction();
            if (!(udf instanceof ImplementableFunction)) {
                throw new IllegalStateException("User defined function " + operator + " must implement ImplementableFunction");
            }
            return ((ImplementableFunction)udf).getImplementor();
        }
        return this.map.get(operator);
    }

    public AggImplementor get(SqlAggFunction aggregation, boolean forWindowAggregate) {
        Supplier<? extends WinAggImplementor> winAgg;
        if (aggregation instanceof SqlUserDefinedAggFunction) {
            SqlUserDefinedAggFunction udaf = (SqlUserDefinedAggFunction)aggregation;
            if (!(udaf.function instanceof ImplementableAggFunction)) {
                throw new IllegalStateException("User defined aggregation " + aggregation + " must implement ImplementableAggFunction");
            }
            return ((ImplementableAggFunction)udaf.function).getImplementor(forWindowAggregate);
        }
        if (forWindowAggregate && (winAgg = this.winAggMap.get(aggregation)) != null) {
            return winAgg.get();
        }
        Supplier<? extends AggImplementor> aggSupplier = this.aggMap.get(aggregation);
        if (aggSupplier == null) {
            return null;
        }
        return aggSupplier.get();
    }

    static Expression maybeNegate(boolean negate, Expression expression) {
        if (!negate) {
            return expression;
        }
        return Expressions.not(expression);
    }

    static Expression optimize(Expression expression) {
        return expression.accept(new OptimizeVisitor());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is(operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition(Expressions.equal(operand, NULL_EXPR), NULL_EXPR, expression));
    }

    private static boolean nullable(RexCall call, int i) {
        return call.getOperands().get(i).getType().isNullable();
    }

    private static List<RexNode> harmonize(RexToLixTranslator translator, List<RexNode> operands) {
        int nullCount = 0;
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
        for (RexNode operand : operands) {
            RelDataType type = operand.getType();
            type = RexImpTable.toSql(typeFactory, type);
            if (translator.isNullable(operand)) {
                ++nullCount;
            } else {
                type = typeFactory.createTypeWithNullability(type, false);
            }
            types.add(type);
        }
        if (RexImpTable.allSame(types)) {
            return operands;
        }
        RelDataType type = typeFactory.leastRestrictive(types);
        if (type == null) {
            return operands;
        }
        assert (nullCount > 0 == type.isNullable());
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (RexNode operand : operands) {
            list.add(translator.builder.ensureType(type, operand, false));
        }
        return list;
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != null && typeName != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    private static Expression implementNullSemantics0(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, boolean harmonize, NotNullImplementor implementor) {
        switch (nullAs) {
            case IS_NOT_NULL: {
                if (nullPolicy != NullPolicy.STRICT) break;
                return Expressions.foldAnd(translator.translateList(call.getOperands(), nullAs));
            }
            case IS_NULL: {
                if (nullPolicy != NullPolicy.STRICT) break;
                return Expressions.foldOr(translator.translateList(call.getOperands(), nullAs));
            }
        }
        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
        try {
            return RexImpTable.implementNullSemantics(translator, call2, nullAs, nullPolicy, implementor);
        }
        catch (RexToLixTranslator.AlwaysNull e) {
            switch (nullAs) {
                case NOT_POSSIBLE: {
                    throw e;
                }
                case FALSE: {
                    return FALSE_EXPR;
                }
                case TRUE: {
                    return TRUE_EXPR;
                }
            }
            return NULL_EXPR;
        }
    }

    private static Expression implementNullSemantics(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, NotNullImplementor implementor) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        switch (nullAs) {
            case NULL: {
                for (Ord<RexNode> operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                Expression box = Expressions.box(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return RexImpTable.optimize(Expressions.condition(Expressions.foldOr(list), Types.castIfNecessary(box.getType(), NULL_EXPR), box));
            }
            case FALSE: {
                for (Ord<RexNode> operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NOT_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                list.add(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return Expressions.foldAnd(list);
            }
            case TRUE: {
                for (Ord<RexNode> operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                list.add(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return Expressions.foldOr(list);
            }
            case NOT_POSSIBLE: {
                HashMap<RexNode, Boolean> nullable = new HashMap<RexNode, Boolean>();
                if (nullPolicy == NullPolicy.STRICT) {
                    for (RexNode arg : call.getOperands()) {
                        if (!translator.isNullable(arg) || nullable.containsKey(arg)) continue;
                        nullable.put(arg, false);
                    }
                }
                nullable.put(call, false);
                translator = translator.setNullable(nullable);
            }
        }
        return RexImpTable.implementCall(translator, call, implementor, nullAs);
    }

    private static Expression implementCall(RexToLixTranslator translator, RexCall call, NotNullImplementor implementor, NullAs nullAs) {
        List<Expression> translatedOperands = translator.translateList(call.getOperands());
        Expression result = implementor.implement(translator, call, translatedOperands);
        return nullAs.handle(result);
    }

    static Expression getDefaultValue(Type type) {
        if (Primitive.is(type)) {
            Primitive p = Primitive.of(type);
            return Expressions.constant(p.defaultValue, type);
        }
        return Expressions.constant(null, type);
    }

    public static Expression multiplyDivide(Expression e, BigDecimal multiplier, BigDecimal divider) {
        if (multiplier.equals(BigDecimal.ONE)) {
            if (divider.equals(BigDecimal.ONE)) {
                return e;
            }
            return Expressions.divide(e, Expressions.constant(divider.intValueExact()));
        }
        BigDecimal x = multiplier.divide(divider, 7);
        switch (x.compareTo(BigDecimal.ONE)) {
            case 0: {
                return e;
            }
            case 1: {
                return Expressions.multiply(e, Expressions.constant(x.intValueExact()));
            }
            case -1: {
                return RexImpTable.multiplyDivide(e, BigDecimal.ONE, x);
            }
        }
        throw new AssertionError();
    }

    private static class DatetimeArithmeticImplementor
    implements NotNullImplementor {
        private DatetimeArithmeticImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            RexNode operand0 = call.getOperands().get(0);
            Expression trop0 = translatedOperands.get(0);
            SqlTypeName typeName1 = call.getOperands().get(1).getType().getSqlTypeName();
            Expression trop1 = translatedOperands.get(1);
            SqlTypeName typeName = call.getType().getSqlTypeName();
            block0 : switch (operand0.getType().getSqlTypeName()) {
                case DATE: {
                    switch (typeName) {
                        case TIMESTAMP: {
                            trop0 = Expressions.convert_(Expressions.multiply(trop0, Expressions.constant(86400000L)), Long.TYPE);
                            break block0;
                        }
                    }
                    switch (typeName1) {
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            trop1 = Expressions.convert_(Expressions.divide(trop1, Expressions.constant(86400000L)), Integer.TYPE);
                        }
                    }
                    break;
                }
                case TIME: {
                    trop1 = Expressions.convert_(trop1, Integer.TYPE);
                }
            }
            switch (typeName1) {
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    switch (call.getKind()) {
                        case MINUS: {
                            trop1 = Expressions.negate(trop1);
                        }
                    }
                    return Expressions.call(BuiltInMethod.ADD_MONTHS.method, trop0, trop1);
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    switch (call.getKind()) {
                        case MINUS: {
                            return Expressions.subtract(trop0, trop1);
                        }
                    }
                    return Expressions.add(trop0, trop1);
                }
            }
            switch (call.getKind()) {
                case MINUS: {
                    switch (typeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: {
                            return Expressions.call(BuiltInMethod.SUBTRACT_MONTHS.method, trop0, trop1);
                        }
                    }
                    TimeUnit fromUnit = typeName1 == SqlTypeName.DATE ? TimeUnit.DAY : TimeUnit.MILLISECOND;
                    TimeUnit toUnit = TimeUnit.MILLISECOND;
                    return RexImpTable.multiplyDivide(Expressions.convert_(Expressions.subtract(trop0, trop1), Long.TYPE), fromUnit.multiplier, toUnit.multiplier);
                }
            }
            return Expressions.add(trop0, trop1);
        }
    }

    private static class NotImplementor
    implements NotNullImplementor {
        private final NotNullImplementor implementor;

        public NotImplementor(NotNullImplementor implementor) {
            this.implementor = implementor;
        }

        private static NotNullImplementor of(NotNullImplementor implementor) {
            return new NotImplementor(implementor);
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression expression = this.implementor.implement(translator, call, translatedOperands);
            return Expressions.not(expression);
        }
    }

    private static class IsXxxImplementor
    implements CallImplementor {
        private final Boolean seek;
        private final boolean negate;

        public IsXxxImplementor(Boolean seek, boolean negate) {
            this.seek = seek;
            this.negate = negate;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            List<RexNode> operands = call.getOperands();
            assert (operands.size() == 1);
            if (this.seek == null) {
                return translator.translate(operands.get(0), this.negate ? NullAs.IS_NOT_NULL : NullAs.IS_NULL);
            }
            return RexImpTable.maybeNegate(this.negate == this.seek, translator.translate(operands.get(0), this.seek != false ? NullAs.FALSE : NullAs.TRUE));
        }
    }

    private static class SystemFunctionImplementor
    implements CallImplementor {
        private SystemFunctionImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            switch (nullAs) {
                case IS_NULL: {
                    return Expressions.constant(false);
                }
                case IS_NOT_NULL: {
                    return Expressions.constant(true);
                }
            }
            SqlOperator op = call.getOperator();
            Expression root = translator.getRoot();
            if (op == SqlStdOperatorTable.CURRENT_USER || op == SqlStdOperatorTable.SESSION_USER || op == SqlStdOperatorTable.USER) {
                return Expressions.constant("sa");
            }
            if (op == SqlStdOperatorTable.SYSTEM_USER) {
                return Expressions.constant(System.getProperty("user.name"));
            }
            if (op == SqlStdOperatorTable.CURRENT_PATH || op == SqlStdOperatorTable.CURRENT_ROLE) {
                return Expressions.constant("");
            }
            if (op == SqlStdOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call(BuiltInMethod.CURRENT_TIMESTAMP.method, root);
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call(BuiltInMethod.CURRENT_TIME.method, root);
            }
            if (op == SqlStdOperatorTable.CURRENT_DATE) {
                return Expressions.call(BuiltInMethod.CURRENT_DATE.method, root);
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call(BuiltInMethod.LOCAL_TIMESTAMP.method, root);
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call(BuiltInMethod.LOCAL_TIME.method, root);
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    private static class ItemImplementor
    implements CallImplementor {
        private ItemImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            MethodImplementor implementor = this.getImplementor(call.getOperands().get(0).getType().getSqlTypeName());
            NullPolicy nullPolicy = NullPolicy.ANY;
            return RexImpTable.implementNullSemantics0(translator, call, nullAs, nullPolicy, false, implementor);
        }

        private MethodImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case ARRAY: {
                    return new MethodImplementor(BuiltInMethod.ARRAY_ITEM.method);
                }
                case MAP: {
                    return new MethodImplementor(BuiltInMethod.MAP_ITEM.method);
                }
            }
            return new MethodImplementor(BuiltInMethod.ANY_ITEM.method);
        }
    }

    private static class ValueConstructorImplementor
    implements CallImplementor {
        private ValueConstructorImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return translator.translateConstructor(call.getOperands(), call.getOperator().getKind());
        }
    }

    private static class ReinterpretImplementor
    implements NotNullImplementor {
        private ReinterpretImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            return translatedOperands.get(0);
        }
    }

    private static class CastImplementor
    implements NotNullImplementor {
        private CastImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            RelDataType sourceType = call.getOperands().get(0).getType();
            boolean nullable = translator.isNullable(call) && sourceType.isNullable() && !Primitive.is(translatedOperands.get(0).getType());
            RelDataType targetType = translator.nullifyType(call.getType(), nullable);
            return translator.translateCast(sourceType, targetType, translatedOperands.get(0));
        }
    }

    private static class CastOptimizedImplementor
    implements CallImplementor {
        private final CallImplementor accurate = RexImpTable.createImplementor(new CastImplementor(), NullPolicy.STRICT, false);

        private CastOptimizedImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            RexNode arg = call.getOperands().get(0);
            if (call.getType().equals(arg.getType())) {
                return translator.translate(arg, nullAs);
            }
            if (SqlTypeUtil.equalSansNullability(translator.typeFactory, call.getType(), arg.getType()) && nullAs == NullAs.NULL && translator.deref(arg) instanceof RexLiteral) {
                return RexToLixTranslator.translateLiteral((RexLiteral)translator.deref(arg), call.getType(), translator.typeFactory, nullAs);
            }
            return this.accurate.implement(translator, call, nullAs);
        }
    }

    private static class CaseImplementor
    implements CallImplementor {
        private CaseImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return this.implementRecurse(translator, call, nullAs, 0);
        }

        private Expression implementRecurse(RexToLixTranslator translator, RexCall call, NullAs nullAs, int i) {
            Expression ifFalse;
            Expression ifTrue;
            List<RexNode> operands = call.getOperands();
            if (i == operands.size() - 1) {
                return translator.translate(translator.builder.ensureType(call.getType(), operands.get(i), false), nullAs);
            }
            try {
                ifTrue = translator.translate(translator.builder.ensureType(call.getType(), operands.get(i + 1), false), nullAs);
            }
            catch (RexToLixTranslator.AlwaysNull e) {
                ifTrue = null;
            }
            try {
                ifFalse = this.implementRecurse(translator, call, nullAs, i + 2);
            }
            catch (RexToLixTranslator.AlwaysNull e) {
                if (ifTrue == null) {
                    throw RexToLixTranslator.AlwaysNull.INSTANCE;
                }
                ifFalse = null;
            }
            Expression test = translator.translate(operands.get(i), NullAs.FALSE);
            return ifTrue == null || ifFalse == null ? Util.first(ifTrue, ifFalse) : Expressions.condition(test, ifTrue, ifFalse);
        }
    }

    private static class UnaryImplementor
    implements NotNullImplementor {
        private final ExpressionType expressionType;

        UnaryImplementor(ExpressionType expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.makeUnary(this.expressionType, translatedOperands.get(0));
        }
    }

    private static class BinaryImplementor
    implements NotNullImplementor {
        private static final List<Primitive> COMP_OP_TYPES = ImmutableList.of(Primitive.BYTE, Primitive.CHAR, Primitive.SHORT, Primitive.INT, Primitive.LONG, Primitive.FLOAT, Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = ImmutableList.of(SqlStdOperatorTable.LESS_THAN, SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlStdOperatorTable.GREATER_THAN, SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(ExpressionType expressionType, String backupMethodName) {
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            if (this.backupMethodName != null) {
                Primitive primitive = Primitive.ofBoxOr(expressions.get(0).getType());
                SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
                if (primitive == null || expressions.get(1).getType() == BigDecimal.class || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains((Object)primitive)) {
                    return Expressions.call(SqlFunctions.class, this.backupMethodName, expressions);
                }
            }
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            return Types.castIfNecessary(returnType, Expressions.makeBinary(this.expressionType, expressions.get(0), expressions.get(1)));
        }
    }

    private static class MethodNameImplementor
    implements NotNullImplementor {
        protected final String methodName;

        MethodNameImplementor(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(SqlFunctions.class, this.methodName, translatedOperands);
        }
    }

    private static class SequenceImplementor
    extends MethodImplementor {
        SequenceImplementor(Method method) {
            super(method);
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (translatedOperands.size() == 1);
            ConstantExpression x = (ConstantExpression)translatedOperands.get(0);
            List<String> names = Util.stringToList((String)x.value);
            Prepare.PreparingTable table = Prepare.CatalogReader.THREAD_LOCAL.get().getTable(names);
            System.out.println("Now, do something with table " + table);
            return super.implement(translator, call, translatedOperands);
        }
    }

    private static class MethodImplementor
    implements NotNullImplementor {
        protected final Method method;

        MethodImplementor(Method method) {
            this.method = method;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            MethodCallExpression expression = Modifier.isStatic(this.method.getModifiers()) ? Expressions.call(this.method, translatedOperands) : Expressions.call(translatedOperands.get(0), this.method, Util.skip(translatedOperands, 1));
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            return Types.castIfNecessary(returnType, expression);
        }
    }

    private static class FloorImplementor
    extends MethodNameImplementor {
        final Method timestampMethod;
        final Method dateMethod;

        FloorImplementor(String methodName, Method timestampMethod, Method dateMethod) {
            super(methodName);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            switch (call.getOperands().size()) {
                case 1: {
                    switch (call.getType().getSqlTypeName()) {
                        case BIGINT: 
                        case INTEGER: 
                        case SMALLINT: 
                        case TINYINT: {
                            return translatedOperands.get(0);
                        }
                    }
                    return super.implement(translator, call, translatedOperands);
                }
                case 2: {
                    Method floorMethod;
                    Class<Number> type;
                    switch (call.getType().getSqlTypeName()) {
                        case TIMESTAMP: {
                            type = Long.TYPE;
                            floorMethod = this.timestampMethod;
                            break;
                        }
                        default: {
                            type = Integer.TYPE;
                            floorMethod = this.dateMethod;
                        }
                    }
                    ConstantExpression tur = (ConstantExpression)translatedOperands.get(1);
                    TimeUnitRange timeUnitRange = (TimeUnitRange)((Object)tur.value);
                    switch (timeUnitRange) {
                        case YEAR: 
                        case MONTH: {
                            return Expressions.call(floorMethod, tur, this.call(translatedOperands, type, TimeUnit.DAY));
                        }
                    }
                    return this.call(translatedOperands, type, timeUnitRange.startUnit);
                }
            }
            throw new AssertionError();
        }

        private Expression call(List<Expression> translatedOperands, Type type, TimeUnit timeUnit) {
            return Expressions.call(SqlFunctions.class, this.methodName, new Expression[]{Types.castIfNecessary(type, translatedOperands.get(0)), Types.castIfNecessary(type, Expressions.constant(timeUnit.multiplier))});
        }
    }

    private static class TrimImplementor
    implements NotNullImplementor {
        private TrimImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Object value = ((ConstantExpression)translatedOperands.get((int)0)).value;
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)((Object)value);
            return Expressions.call(BuiltInMethod.TRIM.method, Expressions.constant(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING), Expressions.constant(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING), translatedOperands.get(1), translatedOperands.get(2));
        }
    }

    static class RowNumberImplementor
    extends StrictWinAggImplementor {
        RowNumberImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            return Collections.emptyList();
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add(Expressions.subtract(result.index(), result.startIndex()), Expressions.constant(1));
        }
    }

    static class NtileImplementor
    implements WinAggImplementor {
        NtileImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            Expression tiles = winResult.rowTranslator(winResult.index()).translate(rexArgs.get(0), Integer.TYPE);
            BinaryExpression ntile = Expressions.add(Expressions.constant(1), Expressions.divide(Expressions.multiply(tiles, Expressions.subtract(winResult.index(), winResult.startIndex())), winResult.getPartitionRowCount()));
            return ntile;
        }
    }

    public static class LagImplementor
    extends LeadLagImplementor {
        protected LagImplementor() {
            super(false);
        }
    }

    public static class LeadImplementor
    extends LeadLagImplementor {
        protected LeadImplementor() {
            super(true);
        }
    }

    static class LeadLagImplementor
    implements WinAggImplementor {
        private final boolean isLead;

        protected LeadLagImplementor(boolean isLead) {
            this.isLead = isLead;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            ParameterExpression res = Expressions.parameter(0, info.returnType(), result.currentBlock().newName(this.isLead ? "lead" : "lag"));
            RexToLixTranslator currentRowTranslator = winResult.rowTranslator(winResult.computeIndex(Expressions.constant(0), WinAggImplementor.SeekType.SET));
            Expression offset = rexArgs.size() >= 2 ? currentRowTranslator.translate(rexArgs.get(1), Integer.TYPE) : Expressions.constant(1);
            if (!this.isLead) {
                offset = Expressions.negate(offset);
            }
            Expression dstIndex = winResult.computeIndex(offset, WinAggImplementor.SeekType.SET);
            Expression rowInRange = winResult.rowInPartition(dstIndex);
            BlockBuilder thenBlock = result.nestBlock();
            Expression lagResult = winResult.rowTranslator(dstIndex).translate(rexArgs.get(0), res.type);
            thenBlock.add(Expressions.statement(Expressions.assign(res, lagResult)));
            result.exitBlock();
            BlockStatement thenBranch = thenBlock.toBlock();
            Expression defaultValue = rexArgs.size() == 3 ? currentRowTranslator.translate(rexArgs.get(2), res.type) : RexImpTable.getDefaultValue(res.type);
            result.currentBlock().add(Expressions.declare(0, res, null));
            result.currentBlock().add(Expressions.ifThenElse(rowInRange, (Node)thenBranch, (Node)Expressions.statement(Expressions.assign(res, defaultValue))));
            return res;
        }
    }

    static class LastValueImplementor
    extends FirstLastValueImplementor {
        protected LastValueImplementor() {
            super(WinAggImplementor.SeekType.END);
        }
    }

    static class FirstValueImplementor
    extends FirstLastValueImplementor {
        protected FirstValueImplementor() {
            super(WinAggImplementor.SeekType.START);
        }
    }

    static class FirstLastValueImplementor
    implements WinAggImplementor {
        private final WinAggImplementor.SeekType seekType;

        protected FirstLastValueImplementor(WinAggImplementor.SeekType seekType) {
            this.seekType = seekType;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return true;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            return Expressions.condition(winResult.hasRows(), winResult.rowTranslator(winResult.computeIndex(Expressions.constant(0), this.seekType)).translate(winResult.rexArguments().get(0), info.returnType()), RexImpTable.getDefaultValue(info.returnType()));
        }
    }

    static class DenseRankImplementor
    extends RankImplementor {
        DenseRankImplementor() {
        }

        @Override
        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            return Expressions.add(acc, Expressions.constant(1));
        }
    }

    static class RankImplementor
    extends StrictWinAggImplementor {
        RankImplementor() {
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            Expression acc = add.accumulator().get(0);
            BlockBuilder builder = add.nestBlock();
            add.currentBlock().add(Expressions.ifThen(Expressions.lessThan(add.compareRows(Expressions.subtract(add.currentPosition(), Expressions.constant(1)), add.currentPosition()), Expressions.constant(0)), Expressions.statement(Expressions.assign(acc, this.computeNewRank(acc, add)))));
            add.exitBlock();
            add.currentBlock().add(Expressions.ifThen(Expressions.greaterThan(add.currentPosition(), add.startIndex()), builder.toBlock()));
        }

        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            Expression pos = add.currentPosition();
            if (!add.startIndex().equals(Expressions.constant(0))) {
                pos = Expressions.subtract(pos, add.startIndex());
            }
            return pos;
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add(super.implementNotNullResult(info, result), Expressions.constant(1));
        }
    }

    public static class UserDefinedAggReflectiveImplementor
    extends StrictAggImplementor {
        private final AggregateFunctionImpl afi;

        public UserDefinedAggReflectiveImplementor(AggregateFunctionImpl afi) {
            this.afi = afi;
        }

        @Override
        public List<Type> getNotNullState(AggContext info) {
            if (this.afi.isStatic) {
                return Collections.singletonList(this.afi.accumulatorType);
            }
            return Arrays.asList(this.afi.accumulatorType, this.afi.declaringClass);
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            if (!this.afi.isStatic) {
                reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(1), Expressions.new_(this.afi.declaringClass))));
            }
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(0), Expressions.call(this.afi.isStatic ? null : acc.get(1), this.afi.initMethod, new Expression[0]))));
        }

        @Override
        protected void implementNotNullAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            List<Expression> aggArgs = add.arguments();
            ArrayList<Expression> args = new ArrayList<Expression>(aggArgs.size() + 1);
            args.add(acc.get(0));
            args.addAll(aggArgs);
            add.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(0), Expressions.call(this.afi.isStatic ? null : acc.get(1), this.afi.addMethod, args))));
        }

        @Override
        protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
            List<Expression> acc = result.accumulator();
            return Expressions.call(this.afi.isStatic ? null : acc.get(1), this.afi.resultMethod, acc.get(0));
        }
    }

    static class CollectImplementor
    extends StrictAggImplementor {
        CollectImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), Expressions.new_(ArrayList.class))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement(Expressions.call(add.accumulator().get(0), BuiltInMethod.COLLECTION_ADD.method, add.arguments().get(0))));
        }
    }

    static class SingleValueImplementor
    implements AggImplementor {
        SingleValueImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Arrays.asList(Boolean.TYPE, info.returnType());
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(0), Expressions.constant(false))));
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(1), RexImpTable.getDefaultValue(acc.get(1).getType()))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            Expression flag = acc.get(0);
            add.currentBlock().add(Expressions.ifThen(flag, Expressions.throw_(Expressions.new_(IllegalStateException.class, new Expression[]{Expressions.constant("more than one value in agg " + info.aggregation())}))));
            add.currentBlock().add(Expressions.statement(Expressions.assign(flag, Expressions.constant(true))));
            add.currentBlock().add(Expressions.statement(Expressions.assign(acc.get(1), add.arguments().get(0))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return RexToLixTranslator.convert(result.accumulator().get(1), info.returnType());
        }
    }

    static class MinMaxImplementor
    extends StrictAggImplementor {
        MinMaxImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            boolean isMin;
            Expression acc = reset.accumulator().get(0);
            Primitive p = Primitive.of(acc.getType());
            boolean bl = isMin = SqlStdOperatorTable.MIN == info.aggregation();
            Object inf = p == null ? null : (isMin ? p.max : p.min);
            reset.currentBlock().add(Expressions.statement(Expressions.assign(acc, Expressions.constant(inf, acc.getType()))));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            SqlAggFunction aggregation;
            Expression acc = add.accumulator().get(0);
            Expression arg = add.arguments().get(0);
            Method method = ((aggregation = info.aggregation()) == SqlStdOperatorTable.MIN ? BuiltInMethod.LESSER : BuiltInMethod.GREATER).method;
            MethodCallExpression next = Expressions.call(method.getDeclaringClass(), method.getName(), acc, Expressions.unbox(arg));
            this.accAdvance(add, acc, next);
        }
    }

    static class SumImplementor
    extends StrictAggImplementor {
        SumImplementor() {
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            ConstantExpression start = info.returnType() == BigDecimal.class ? Expressions.constant(BigDecimal.ZERO) : Expressions.constant(0);
            reset.currentBlock().add(Expressions.statement(Expressions.assign(reset.accumulator().get(0), start)));
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression acc = add.accumulator().get(0);
            Expression next = info.returnType() == BigDecimal.class ? Expressions.call(acc, "add", add.arguments().get(0)) : Expressions.add(acc, Types.castIfNecessary(acc.type, add.arguments().get(0)));
            this.accAdvance(add, acc, next);
        }

        @Override
        public Expression implementNotNullResult(AggContext info, AggResultContext result) {
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountWinImplementor
    extends StrictWinAggImplementor {
        boolean justFrameRowCount;

        CountWinImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            boolean hasNullable = false;
            for (RelDataType relDataType : info.parameterRelTypes()) {
                if (!relDataType.isNullable()) continue;
                hasNullable = true;
                break;
            }
            if (!hasNullable) {
                this.justFrameRowCount = true;
                return Collections.emptyList();
            }
            return super.getNotNullState(info);
        }

        @Override
        public void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            if (this.justFrameRowCount) {
                return;
            }
            add.currentBlock().add(Expressions.statement(Expressions.postIncrementAssign(add.accumulator().get(0))));
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            if (this.justFrameRowCount) {
                return result.getFrameRowCount();
            }
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountImplementor
    extends StrictAggImplementor {
        CountImplementor() {
        }

        @Override
        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement(Expressions.postIncrementAssign(add.accumulator().get(0))));
        }
    }

    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor(x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NOT_POSSIBLE: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return RexToLixTranslator.convert(x, Primitive.ofBox((Type)x.getType()).primitiveClass);
                        }
                    }
                }
            }
            switch (this) {
                case NOT_POSSIBLE: 
                case NULL: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call(BuiltInMethod.IS_TRUE.method, x);
                }
                case TRUE: {
                    return Expressions.call(BuiltInMethod.IS_NOT_FALSE.method, x);
                }
                case IS_NULL: {
                    return Expressions.equal(x, NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual(x, NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }
}

