/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;

public class AcidEventListener
extends MetaStoreEventListener {
    private TxnStore txnHandler;
    private Configuration conf;

    public AcidEventListener(Configuration configuration) {
        super(configuration);
        this.conf = configuration;
    }

    @Override
    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        this.txnHandler = this.getTxnHandler();
        this.txnHandler.cleanupRecords(HiveObjectType.DATABASE, dbEvent.getDatabase(), null, null);
    }

    @Override
    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (TxnUtils.isTransactionalTable(tableEvent.getTable())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.TABLE, null, tableEvent.getTable(), null);
        }
    }

    @Override
    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        if (TxnUtils.isTransactionalTable(partitionEvent.getTable())) {
            this.txnHandler = this.getTxnHandler();
            this.txnHandler.cleanupRecords(HiveObjectType.PARTITION, null, partitionEvent.getTable(), partitionEvent.getPartitionIterator());
        }
    }

    private TxnStore getTxnHandler() {
        boolean hackOn = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST);
        String origTxnMgr = null;
        boolean origConcurrency = false;
        if (hackOn) {
            origTxnMgr = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.HIVE_TXN_MANAGER);
            origConcurrency = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        }
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
        if (hackOn) {
            MetastoreConf.setVar(this.conf, MetastoreConf.ConfVars.HIVE_TXN_MANAGER, origTxnMgr);
            MetastoreConf.setBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, origConcurrency);
        }
        return this.txnHandler;
    }
}

