/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AddForeignKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddNotNullConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AddPrimaryKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AddUniqueConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterISchemaEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.CreateCatalogEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateISchemaEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropCatalogEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropISchemaEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;

@InterfaceAudience.Private
public class MetaStoreListenerNotifier {
    private static Map<EventMessage.EventType, EventNotifier> notificationEvents = Maps.newHashMap(ImmutableMap.builder().put(EventMessage.EventType.CREATE_DATABASE, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateDatabase((CreateDatabaseEvent)event);
        }
    }).put(EventMessage.EventType.DROP_DATABASE, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropDatabase((DropDatabaseEvent)event);
        }
    }).put(EventMessage.EventType.CREATE_TABLE, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateTable((CreateTableEvent)event);
        }
    }).put(EventMessage.EventType.DROP_TABLE, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropTable((DropTableEvent)event);
        }
    }).put(EventMessage.EventType.ADD_PARTITION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddPartition((AddPartitionEvent)event);
        }
    }).put(EventMessage.EventType.DROP_PARTITION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropPartition((DropPartitionEvent)event);
        }
    }).put(EventMessage.EventType.ALTER_DATABASE, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterDatabase((AlterDatabaseEvent)event);
        }
    }).put(EventMessage.EventType.ALTER_TABLE, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterTable((AlterTableEvent)event);
        }
    }).put(EventMessage.EventType.ALTER_PARTITION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterPartition((AlterPartitionEvent)event);
        }
    }).put(EventMessage.EventType.INSERT, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onInsert((InsertEvent)event);
        }
    }).put(EventMessage.EventType.CREATE_FUNCTION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateFunction((CreateFunctionEvent)event);
        }
    }).put(EventMessage.EventType.DROP_FUNCTION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropFunction((DropFunctionEvent)event);
        }
    }).put(EventMessage.EventType.ADD_PRIMARYKEY, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddPrimaryKey((AddPrimaryKeyEvent)event);
        }
    }).put(EventMessage.EventType.ADD_FOREIGNKEY, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddForeignKey((AddForeignKeyEvent)event);
        }
    }).put(EventMessage.EventType.ADD_UNIQUECONSTRAINT, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddUniqueConstraint((AddUniqueConstraintEvent)event);
        }
    }).put(EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddNotNullConstraint((AddNotNullConstraintEvent)event);
        }
    }).put(EventMessage.EventType.CREATE_ISCHEMA, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onCreateISchema((CreateISchemaEvent)event);
        }
    }).put(EventMessage.EventType.ALTER_ISCHEMA, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterISchema((AlterISchemaEvent)event);
        }
    }).put(EventMessage.EventType.DROP_ISCHEMA, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropISchema((DropISchemaEvent)event);
        }
    }).put(EventMessage.EventType.ADD_SCHEMA_VERSION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAddSchemaVersion((AddSchemaVersionEvent)event);
        }
    }).put(EventMessage.EventType.ALTER_SCHEMA_VERSION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onAlterSchemaVersion((AlterSchemaVersionEvent)event);
        }
    }).put(EventMessage.EventType.DROP_SCHEMA_VERSION, new EventNotifier(){

        @Override
        public void notify(MetaStoreEventListener listener, ListenerEvent event) throws MetaException {
            listener.onDropSchemaVersion((DropSchemaVersionEvent)event);
        }
    }).put(EventMessage.EventType.CREATE_CATALOG, (EventNotifier)(listener, event) -> listener.onCreateCatalog((CreateCatalogEvent)event)).put(EventMessage.EventType.DROP_CATALOG, (EventNotifier)(listener, event) -> listener.onDropCatalog((DropCatalogEvent)event)).put(EventMessage.EventType.OPEN_TXN, (EventNotifier)(listener, event) -> listener.onOpenTxn((OpenTxnEvent)event, null, null)).put(EventMessage.EventType.COMMIT_TXN, (EventNotifier)(listener, event) -> listener.onCommitTxn((CommitTxnEvent)event, null, null)).put(EventMessage.EventType.ABORT_TXN, (EventNotifier)(listener, event) -> listener.onAbortTxn((AbortTxnEvent)event, null, null)).put(EventMessage.EventType.ALLOC_WRITE_ID, (EventNotifier)(listener, event) -> listener.onAllocWriteId((AllocWriteIdEvent)event, null, null)).build());
    private static Map<EventMessage.EventType, TxnEventNotifier> txnNotificationEvents = Maps.newHashMap(ImmutableMap.builder().put(EventMessage.EventType.OPEN_TXN, (listener, event, dbConn, sqlGenerator) -> listener.onOpenTxn((OpenTxnEvent)event, dbConn, sqlGenerator)).put(EventMessage.EventType.COMMIT_TXN, (listener, event, dbConn, sqlGenerator) -> listener.onCommitTxn((CommitTxnEvent)event, dbConn, sqlGenerator)).put(EventMessage.EventType.ABORT_TXN, (listener, event, dbConn, sqlGenerator) -> listener.onAbortTxn((AbortTxnEvent)event, dbConn, sqlGenerator)).put(EventMessage.EventType.ALLOC_WRITE_ID, (listener, event, dbConn, sqlGenerator) -> listener.onAllocWriteId((AllocWriteIdEvent)event, dbConn, sqlGenerator)).build());

    public static Map<String, String> notifyEvent(List<? extends MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event) throws MetaException {
        Preconditions.checkNotNull(listeners, "Listeners must not be null.");
        Preconditions.checkNotNull(event, "The event must not be null.");
        for (MetaStoreEventListener metaStoreEventListener : listeners) {
            notificationEvents.get((Object)eventType).notify(metaStoreEventListener, event);
        }
        return event.getParameters();
    }

    public static Map<String, String> notifyEventWithDirectSql(List<? extends MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        Preconditions.checkNotNull(listeners, "Listeners must not be null.");
        Preconditions.checkNotNull(event, "The event must not be null.");
        for (MetaStoreEventListener metaStoreEventListener : listeners) {
            txnNotificationEvents.get((Object)eventType).notify(metaStoreEventListener, event, dbConn, sqlGenerator);
        }
        return event.getParameters();
    }

    public static Map<String, String> notifyEvent(List<? extends MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event, EnvironmentContext environmentContext) throws MetaException {
        Preconditions.checkNotNull(event, "The event must not be null.");
        event.setEnvironmentContext(environmentContext);
        return MetaStoreListenerNotifier.notifyEvent(listeners, eventType, event);
    }

    public static Map<String, String> notifyEvent(List<? extends MetaStoreEventListener> listeners, EventMessage.EventType eventType, ListenerEvent event, EnvironmentContext environmentContext, Map<String, String> parameters, RawStore ms) throws MetaException {
        Preconditions.checkNotNull(event, "The event must not be null.");
        event.putParameters(parameters);
        if (ms != null) {
            event.putParameter("HIVE_METASTORE_TRANSACTION_ACTIVE", Boolean.toString(ms.isActiveTransaction()));
        }
        return MetaStoreListenerNotifier.notifyEvent(listeners, eventType, event, environmentContext);
    }

    private static interface TxnEventNotifier {
        public void notify(MetaStoreEventListener var1, ListenerEvent var2, Connection var3, SQLGenerator var4) throws MetaException;
    }

    private static interface EventNotifier {
        public void notify(MetaStoreEventListener var1, ListenerEvent var2) throws MetaException;
    }
}

