/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class FSTableEvent
implements TableEvent {
    private final Path fromPath;
    private final MetaData metadata;

    FSTableEvent(HiveConf hiveConf, String metadataDir) {
        try {
            URI fromURI = EximUtil.getValidatedURI(hiveConf, PlanUtils.stripQuotes(metadataDir));
            this.fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
            FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)hiveConf);
            this.metadata = EximUtil.readMetaData(fs, new Path(this.fromPath, "_metadata"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean shouldNotReplicate() {
        ReplicationSpec spec = this.metadata.getReplicationSpec();
        return spec.isNoop() || !spec.isInReplicationScope();
    }

    @Override
    public Path metadataPath() {
        return this.fromPath;
    }

    @Override
    public ImportTableDesc tableDesc(String dbName) throws SemanticException {
        try {
            Table table = new Table(this.metadata.getTable());
            ImportTableDesc tableDesc = new ImportTableDesc(StringUtils.isBlank(dbName) ? table.getDbName() : dbName, table);
            tableDesc.setReplicationSpec(this.metadata.getReplicationSpec());
            return tableDesc;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public List<AddPartitionDesc> partitionDescriptions(ImportTableDesc tblDesc) throws SemanticException {
        ArrayList<AddPartitionDesc> descs = new ArrayList<AddPartitionDesc>();
        for (Partition partition : this.metadata.getPartitions()) {
            AddPartitionDesc partsDesc = this.partitionDesc(this.fromPath, tblDesc, partition);
            descs.add(partsDesc);
        }
        return descs;
    }

    @Override
    public List<String> partitions(ImportTableDesc tblDesc) throws SemanticException {
        ArrayList<String> partitions = new ArrayList<String>();
        try {
            for (Partition partition : this.metadata.getPartitions()) {
                String partName = Warehouse.makePartName(tblDesc.getPartCols(), partition.getValues());
                partitions.add(partName);
            }
        }
        catch (MetaException e) {
            throw new SemanticException(e);
        }
        return partitions;
    }

    private AddPartitionDesc partitionDesc(Path fromPath, ImportTableDesc tblDesc, Partition partition) throws SemanticException {
        try {
            AddPartitionDesc partsDesc = new AddPartitionDesc(tblDesc.getDatabaseName(), tblDesc.getTableName(), EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues()), partition.getSd().getLocation(), partition.getParameters());
            AddPartitionDesc.OnePartitionDesc partDesc = partsDesc.getPartition(0);
            partDesc.setInputFormat(partition.getSd().getInputFormat());
            partDesc.setOutputFormat(partition.getSd().getOutputFormat());
            partDesc.setNumBuckets(partition.getSd().getNumBuckets());
            partDesc.setCols(partition.getSd().getCols());
            partDesc.setSerializationLib(partition.getSd().getSerdeInfo().getSerializationLib());
            partDesc.setSerdeParams(partition.getSd().getSerdeInfo().getParameters());
            partDesc.setBucketCols(partition.getSd().getBucketCols());
            partDesc.setSortCols(partition.getSd().getSortCols());
            partDesc.setLocation(new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), partition.getValues())).toString());
            partsDesc.setReplicationSpec(this.metadata.getReplicationSpec());
            return partsDesc;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    @Override
    public ReplicationSpec replicationSpec() {
        return this.metadata.getReplicationSpec();
    }

    @Override
    public BootstrapEvent.EventType eventType() {
        return BootstrapEvent.EventType.Table;
    }
}

