/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.PathUtils;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.LoadMultiFilesDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTable {
    private static final Logger LOG = LoggerFactory.getLogger(LoadTable.class);
    private final Context context;
    private final ReplLogger replLogger;
    private final TableContext tableContext;
    private final TaskTracker tracker;
    private final TableEvent event;

    public LoadTable(TableEvent event, Context context, ReplLogger replLogger, TableContext tableContext, TaskTracker limiter) throws SemanticException, IOException {
        this.event = event;
        this.context = context;
        this.replLogger = replLogger;
        this.tableContext = tableContext;
        this.tracker = new TaskTracker(limiter);
    }

    private void createTableReplLogTask(String tableName, TableType tableType) throws SemanticException {
        ReplStateLogWork replLogWork = new ReplStateLogWork(this.replLogger, tableName, tableType);
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork);
        DAGTraversal.traverse(this.tracker.tasks(), new AddDependencyToLeaves(replLogTask));
        if (this.tracker.tasks().isEmpty()) {
            this.tracker.addTask(replLogTask);
        } else {
            DAGTraversal.traverse(this.tracker.tasks(), new AddDependencyToLeaves(replLogTask));
            ArrayList<Task<? extends Serializable>> visited = new ArrayList<Task<? extends Serializable>>();
            this.tracker.updateTaskCount(replLogTask, visited);
        }
    }

    public TaskTracker tasks() throws SemanticException {
        try {
            if (this.event.shouldNotReplicate()) {
                return this.tracker;
            }
            String dbName = this.tableContext.dbNameToLoadIn;
            ImportTableDesc tableDesc = this.tableContext.overrideProperties(this.event.tableDesc(dbName));
            Table table = ImportSemanticAnalyzer.tableIfExists(tableDesc, this.context.hiveDb);
            ReplicationSpec replicationSpec = this.event.replicationSpec();
            Database parentDb = this.context.hiveDb.getDatabase(tableDesc.getDatabaseName());
            if (parentDb == null && !this.tableContext.waitOnPrecursor()) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(tableDesc.getDatabaseName()));
            }
            if (table == null ? parentDb != null && !replicationSpec.allowReplacementInto(parentDb.getParameters()) : !replicationSpec.allowReplacementInto(table.getParameters())) {
                return this.tracker;
            }
            if (tableDesc.getLocation() == null) {
                tableDesc.setLocation(this.location(tableDesc, parentDb));
            }
            if (table == null) {
                this.newTableTasks(tableDesc);
            } else {
                this.existingTableTasks(tableDesc, table, replicationSpec);
            }
            if (!ImportSemanticAnalyzer.isPartitioned(tableDesc)) {
                this.createTableReplLogTask(tableDesc.getTableName(), tableDesc.tableType());
            }
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void existingTableTasks(ImportTableDesc tblDesc, Table table, ReplicationSpec replicationSpec) {
        if (!table.isPartitioned()) {
            LOG.debug("table non-partitioned");
            if (!replicationSpec.allowReplacementInto(table.getParameters())) {
                return;
            }
            Task<? extends Serializable> alterTableTask = this.alterTableTask(tblDesc, replicationSpec);
            if (replicationSpec.isMetadataOnly()) {
                this.tracker.addTask(alterTableTask);
            } else {
                Task<?> loadTableTask = this.loadTableTask(table, replicationSpec, table.getDataLocation(), this.event.metadataPath());
                alterTableTask.addDependentTask(loadTableTask);
                this.tracker.addTask(alterTableTask);
            }
        }
    }

    private void newTableTasks(ImportTableDesc tblDesc) throws Exception {
        Table table = tblDesc.toTable(this.context.hiveConf);
        Task<? extends Serializable> createTableTask = tblDesc.getCreateTableTask(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), this.context.hiveConf);
        if (this.event.replicationSpec().isMetadataOnly()) {
            this.tracker.addTask(createTableTask);
            return;
        }
        Task<? extends Serializable> parentTask = createTableTask;
        if (this.event.replicationSpec().isTransactionalTableDump()) {
            List<String> partNames = ImportSemanticAnalyzer.isPartitioned(tblDesc) ? this.event.partitions(tblDesc) : null;
            ReplTxnWork replTxnWork = new ReplTxnWork(tblDesc.getDatabaseName(), tblDesc.getTableName(), partNames, this.event.replicationSpec().getValidWriteIdList(), ReplTxnWork.OperationType.REPL_WRITEID_STATE);
            Task<ReplTxnWork> replTxnTask = TaskFactory.get(replTxnWork, this.context.hiveConf);
            createTableTask.addDependentTask(replTxnTask);
            parentTask = replTxnTask;
        }
        if (!ImportSemanticAnalyzer.isPartitioned(tblDesc)) {
            LOG.debug("adding dependent ReplTxnTask/CopyWork/MoveWork for table");
            Task<?> loadTableTask = this.loadTableTask(table, this.event.replicationSpec(), new Path(tblDesc.getLocation()), this.event.metadataPath());
            parentTask.addDependentTask(loadTableTask);
        }
        this.tracker.addTask(createTableTask);
    }

    private String location(ImportTableDesc tblDesc, Database parentDb) throws MetaException, SemanticException {
        if (!this.tableContext.waitOnPrecursor()) {
            return this.context.warehouse.getDefaultTablePath(parentDb, tblDesc.getTableName()).toString();
        }
        Path tablePath = new Path(this.context.warehouse.getDefaultDatabasePath(tblDesc.getDatabaseName()), MetaStoreUtils.encodeTableName(tblDesc.getTableName().toLowerCase()));
        return this.context.warehouse.getDnsPath(tablePath).toString();
    }

    private Task<?> loadTableTask(Table table, ReplicationSpec replicationSpec, Path tgtPath, Path fromURI) {
        Path dataPath = new Path(fromURI, "data");
        Path tmpPath = PathUtils.getExternalTmpPath(tgtPath, this.context.pathInfo);
        Task<?> copyTask = ReplCopyTask.getLoadCopyTask(replicationSpec, dataPath, tmpPath, this.context.hiveConf);
        MoveWork moveWork = new MoveWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), null, null, false);
        if (AcidUtils.isTransactionalTable(table)) {
            LoadMultiFilesDesc loadFilesWork = new LoadMultiFilesDesc(Collections.singletonList(tmpPath), Collections.singletonList(tgtPath), true, null, null);
            moveWork.setMultiFilesDesc(loadFilesWork);
        } else {
            LoadTableDesc loadTableWork = new LoadTableDesc(tmpPath, Utilities.getTableDesc(table), new TreeMap<String, String>(), replicationSpec.isReplace() ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.OVERWRITE_EXISTING, (Long)0L);
            moveWork.setLoadTableWork(loadTableWork);
        }
        Task<MoveWork> loadTableTask = TaskFactory.get(moveWork, this.context.hiveConf);
        copyTask.addDependentTask(loadTableTask);
        return copyTask;
    }

    private Task<? extends Serializable> alterTableTask(ImportTableDesc tableDesc, ReplicationSpec replicationSpec) {
        tableDesc.setReplaceMode(true);
        if (replicationSpec != null && replicationSpec.isInReplicationScope()) {
            tableDesc.setReplicationSpec(replicationSpec);
        }
        return tableDesc.getCreateTableTask(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), this.context.hiveConf);
    }
}

